//Función incial se llama una vez cargado el modulo acá se asignan los eventos iniciales
function implementsInit() {
    let refreshlist = () => {
        //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
        let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        if (selpag != null) selpag.removeAttribute("selected");
        listAPI();
    }
    //EVENTO REFRESCAR TABLA EN EL AL HACER BUSQUEDA CON ENTER
    document.getElementById("searchTbl").addEventListener("keyup", function (e) {
        if (this.value != "") this.value = fieldFormat(this.value, "search");
        //Si le da al enter, refrescamos el listadol.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            refreshlist();
        }
    });

    //EVENTO REFRESCAR TABLA EN EL AL HACER FILTRO DE LA TABLA POR STATUS Y GENERO
    document.getElementById("modulesFilt").addEventListener("change", refreshlist);
    document.getElementById("usersFilt").addEventListener("change", refreshlist);
    let refreshlistdates = async (ele) => {
        let error = false;
        //Aplicamos algunas validaciones adicionales para las fechas
        let from = document.getElementById("fromFilt");
        let to = document.getElementById("toFilt");
        if (from.value !== "") {
            to.setAttribute("min", from.value);
            to.setAttribute("max", dateForInpt(new Date()));
            //Como el from tiene valor validamos que no exceda al ahora
            let fromdate = new Date(from.value.split("-"));
            if (fromdate.getTime() > (new Date()).getTime()) {
                errInpt(from.getAttribute("id"), "Fecha desde inválida", 6000);
                error = true;
            }
            await validDateRange(from.value).then().catch(() => {
                errInpt(from.getAttribute("id"), "Fecha desde inválida", 6000);
                error = true;
            });
        } else {
            to.setAttribute("min", dateForInpt(globmindate));
        }
        if (to.value !== "") {
            from.setAttribute("max", to.value);
            let todate = new Date(to.value.split("-"));
            if (todate.getTime() > (new Date()).getTime()) {
                errInpt(to.getAttribute("id"), "Fecha hasta inválida", 6000);
                error = true;
            }
            await validDateRange(to.value).then().catch(() => {
                errInpt(from.getAttribute("id"), "Fecha hasta inválida", 6000);
                error = true;
            });
        } else {
            from.setAttribute("max", dateForInpt(new Date()));
        }
        if (to.value != "" && from.value != "") {
            //Fechas
            let fromdate = new Date(from.value.split("-"));
            let todate = new Date(to.value.split("-"));
            if (fromdate.getTime() > todate.getTime()) {
                errInpt(ele.getAttribute("id"), "Rango de fechas inválido", 6000);
                error = true;
            }
        }

        if (error) {
            listDraw({
                numofrecords: 0,
                records: []
            });
            return;
        } else {
            errBlank(to.getAttribute("id"));
            errBlank(from.getAttribute("id"));

        }

        //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
        let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        if (selpag != null) selpag.removeAttribute("selected");
        listAPI();
    }
    document.getElementById("toFilt").addEventListener("change", function () { refreshlistdates(this) });
    document.getElementById("toFilt").setAttribute("min", dateForInpt(globmindate));
    document.getElementById("toFilt").setAttribute("max", dateForInpt(new Date()));
    document.getElementById("fromFilt").addEventListener("change", function () { refreshlistdates(this) });
    document.getElementById("fromFilt").setAttribute("min", dateForInpt(globmindate));
    document.getElementById("fromFilt").setAttribute("max", dateForInpt(new Date()));

    //INICIALIZAMOS LOS EVENTOS DE ORDENAMIENTO, CON ESTE FORMATO SE PUEDEN PASAR PARAMETROS A LA FUNCIÓN
    initOrders(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    //IINICIALIZAMOS LOS EVENTOS DE LAS FLECHAS DEL PAGINADO SI EXISTE
    initPagsEvent(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    //Lamamos el servicio que carga el listado
    listAPI();
    //Cargamos los modulos
    listModulesAPI();
    //Cargamos los usuarios
    listUsersAPI();
}
//Función para llamar al sevicio de la lista
function listAPI() {
    var par = {};
    par.filter = document.getElementById("searchTbl").value;
    let order = document.querySelector(".pgSctTbl").querySelector(".orderCol[selected]");
    par.order = (order == null || order == undefined) ? -1 : order.getAttribute("colval");
    let actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
    par.module = document.getElementById("modulesFilt").value;
    par.user = document.getElementById("usersFilt").value;
    par.from = document.getElementById("fromFilt").value;
    par.to = document.getElementById("toFilt").value;
    par.offset = (actpage != null) ? (actpage.innerHTML * 10) - 10 : 0;
    par.numofrec = 10;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos y se setean los privilegios correctamente pintamos la tabla
                listDraw(data);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Si no tiene privilegios se muestra el mensaje de error
                errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "security/audit/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Función para pintar la respuesta de la lista en la tabla - requiere modelo base en html
function listDraw(rsp) {
    let tbl = document.getElementById("pgTbl").querySelector("tbody");
    let list = rsp.records;
    let ele = tbl.children[0].cloneNode(true);
    if (list.length > 0) {
        tbl.innerHTML = "";
        for (var i = 0; i < list.length; i++) {
            var clone = ele.cloneNode(true);
            clone.style.display = "";

            var data = list[i];

            var celda = clone.children[0];
            celda.innerText = data.module;

            var celda = clone.children[1];
            celda.innerText = data.date.formatted;

            var celda = clone.children[2];
            celda.innerText = data.dsc;

            var celda = clone.children[3];
            celda.innerText = data.user.name;

            tbl.appendChild(clone);

        }
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        tbl.innerHTML = "";
        tbl.appendChild(clone);
    }
    //SE PINTA EL PAGINADO LUEGO DE PINTAR LA TABLA
    var actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
    actpage = (actpage != null && actpage != undefined) ? (actpage.innerHTML) : 1;
    drawPags(document.querySelector(".pgSctTbl"), rsp.numofrecords, 10, actpage, listAPI);
    
}
//Se requiere invocar el listado de modulos
function listModulesAPI() {
    var par = {};
    par.filter = "";
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                drawSelect(data.records, document.getElementById("modulesFilt"), 'name', 'name', 'Todos los modulos', '');
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Mostramos el error en el filtro y manejamos para mostrarlo en el popup del update
                errInpt("modulesFilt", "No tiene privilegios para ver los modulos", 0);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "security/audit/modules", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Función para llamar al sevicio de la lista
function listUsersAPI() {
    var par = {};
    par.filter = "";
    par.order = 2;
    par.offset = 0;
    par.numofrec = 999999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                drawSelect(data.records, document.getElementById("usersFilt"), 'email', 'name', 'Todos los usuarios', '');
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                errInpt("usersFilt", "No tiene privilegios para visualizar los usuarios", 0);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "users/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Llamada inicial
document.addEventListener("DOMContentLoaded", function () {
    implementsInit();
});