//Función incial se llama una vez cargado el modulo acá se asignan los eventos iniciales
function implementsInit() {
    //Evento mostrar popup de insertar usuario
    document.querySelector(".addBtn").addEventListener("click", function () {
        //Validamos si tiene el privilegio de aadir o no para "inhabilitar el boton"
        let btnsave = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        if (btnsave.getAttribute("add") == "inactive") btnsave.setAttribute("inactive", "");
        else btnsave.removeAttribute("inactive");

        //Blanquemoas la data y el id cuando entramos por añadir
        document.getElementById("popupUpdFrm").querySelector(".saveBtn").removeAttribute("upid");
        blankForm("popupUpdFrm", ["input", "select", ".popupDateLbl", ".errmsgSct"]);
        editableForm("popupUpdFrm", true, ["input", "select"]);
        //Se asigna el titulo y se muestra el formulario
        document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Crear Implementos";
        showPopup("popupUpdFrm");
    });

    let refreshlist = () => {
        //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
        let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        if (selpag != null) selpag.removeAttribute("selected");
        listAPI();
    }
    //EVENTO REFRESCAR TABLA EN EL AL HACER BUSQUEDA CON ENTER
    document.getElementById("searchTbl").addEventListener("keyup", function (e) {
        if (this.value != "") this.value = fieldFormat(this.value, "search");
        //Si le da al enter, refrescamos el listadol.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            refreshlist();
        }
    });

    //EVENTO REFRESCAR TABLA EN EL AL HACER FILTRO DE LA TABLA POR STATUS Y GENERO
    document.getElementById("statusTbl").addEventListener("change", refreshlist);
    document.getElementById("implementTbl").addEventListener("change", refreshlist);

    //EVENTOS A CAMPOS DEL FORMULARIO DE USUARIO CREAR / MODIFICAR
    //Creo esta función porque la repito en todos los campos que no guardan el update
    let validkeyup = (ele, event, fmt = "", focus) => {
        if (ele.value != "") {
            errBlank(ele.getAttribute("id"));
            if (fmt != "") ele.value = fieldFormat(ele.value, fmt);
        }
        //Si le da al enter, focus en email.  
        if (event.key != null && (event.key).toLowerCase() == 'enter') {
            document.getElementById(focus).focus();
        }
    }

    //Asignamos evento al introducir texto al campo name formulari
    document.getElementById("updName").addEventListener("keyup", function (e) {
        validkeyup(this, e, 'name', 'updAbbr');
    });

    //Asignamos evento al introducir texto al campo abbr formulari
    document.getElementById("updAbbr").addEventListener("keyup", function (e) {
        if (this.value != "") {
            errBlank(this.getAttribute("id"));
            this.value = fieldFormat(limitSize(this.value, 2), 'abbr');
        }
        //Enter en status y que esté activo el wait, guardamos
        var wait = document.getElementById("waitScreen");
        if (e.key != null && (e.key).toLowerCase() == 'enter' && wait == null) {
            //Si no tiene el atributo inactivo se intenta guardar
            let btn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
            if (btn.getAttribute("inactive") != null && btn.getAttribute("inactive") != undefined) {
                errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
            } else {
                updateAPI((btn.getAttribute("upid") != undefined && btn.getAttribute("upid") != null) ? btn.getAttribute("upid") : 0);
            }
        }
    });

    //Asignamos al enter en el status
    document.getElementById("updStatus").addEventListener("keyup", function (e) {
        //Enter en status y que esté activo el wait, guardamos
        var wait = document.getElementById("waitScreen");
        if (e.key != null && (e.key).toLowerCase() == 'enter' && wait == null) {
            //Si no tiene el atributo inactivo se intenta guardar
            let btn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
            if (btn.getAttribute("inactive") != null && btn.getAttribute("inactive") != undefined) {
                errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
            } else {
                updateAPI((btn.getAttribute("upid") != undefined && btn.getAttribute("upid") != null) ? btn.getAttribute("upid") : 0);
            }
        }
    });

    //-------//

    //EVENTOS DE BOTONES GUARDAR Y CANCELAR
    //Popup "CREAR/EDITAR"
    let usrpop = document.getElementById("popupUpdFrm");
    //Evento al guardar el crear/editar el
    usrpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            updateAPI((this.getAttribute("upid") != undefined && this.getAttribute("upid") != null) ? this.getAttribute("upid") : 0);
        }
    });
    //Evento cancela popup crear/editar
    usrpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    //Popup "ELIMINAR usuario"
    let delpop = document.getElementById("popupDelFrm");
    //Evento al guardar el crear/editar el usuario
    delpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            deleteAPI(this.getAttribute("delid"));
        }
    });
    //Evento cancela popup 
    delpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    //INICIALIZAMOS LOS EVENTOS DE ORDENAMIENTO, CON ESTE FORMATO SE PUEDEN PASAR PARAMETROS A LA FUNCIÓN
    initOrders(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    //IINICIALIZAMOS LOS EVENTOS DE LAS FLECHAS DEL PAGINADO SI EXISTE
    initPagsEvent(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    //Lamamos el servicio que carga el listado
    listAPI();
}
//Función para llamar al sevicio de la lista
function listAPI() {
    var par = {};
    par.filter = document.getElementById("searchTbl").value;
    let order = document.querySelector(".pgSctTbl").querySelector(".orderCol[selected]");
    par.order = (order == null || order == undefined) ? -1 : order.getAttribute("colval");
    let actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
    par.statusid = document.getElementById("statusTbl").value;
    par.typeid = document.getElementById("implementTbl").value;
    par.offset = (actpage != null) ? (actpage.innerHTML * 10) - 10 : 0;
    par.numofrec = 10;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Validamos los privilegios
                await privValidations(data.privileges);
                //Si obtenemos y se setean los privilegios correctamente pintamos la tabla
                listDraw(data, data.privileges);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Si no tiene privilegios se muestra el mensaje de error
                errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "races/implements/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Función para pintar la respuesta de la lista en la tabla - requiere modelo base en html
function listDraw(rsp, privileges) {
    let tbl = document.getElementById("pgTbl").querySelector("tbody");
    let list = rsp.records;
    let ele = tbl.children[0].cloneNode(true);
    if (list.length > 0) {
        tbl.innerHTML = "";
        for (var i = 0; i < list.length; i++) {
            var clone = ele.cloneNode(true);
            clone.style.display = "";

            var data = list[i];
            //Evento del readonly al row
            clone.setAttribute("itemid", data.id);
            clone.addEventListener("click", function () {
                blankForm("popupUpdFrm", ["input", "select", ".popupDateLbl"]);
                //Cargamos el entry
                entryAPI(this.getAttribute("itemid")).then(async (rsp) => {
                    //Desactivamos los campos
                    editableForm("popupUpdFrm", false, ["input", "select"]);
                    await setFrm(rsp.entry);
                    document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Implementos";
                    showPopup("popupUpdFrm");
                });
            });

            var celda = clone.children[0];
            celda.innerText = data.type.name;

            var celda = clone.children[1];
            celda.innerText = data.name;

            var celda = clone.children[2];
            celda.innerText = data.abbr;

            var celda = clone.children[3];
            celda.innerText = data.status.name;

            var celda = clone.children[4].firstElementChild;
            //Atributos para eventos de los botones
            celda.setAttribute("itemid", data.id);
            celda.setAttribute("itemlbl", data.type.name + " - " + data.name);

            //Editar Btn
            if (privileges.update) {
                celda.children[0].addEventListener("click", function (e) {
                    e.stopPropagation();
                    //Cargamos el entry
                    entryAPI(this.parentElement.getAttribute("itemid")).then(async (rsp) => {
                        //Validamos los privilegios
                        await privValidations(rsp.privileges);
                        //Validamos antes si tiene el privilegio y desactivamos el boton si no
                        let btnsave = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
                        if (btnsave.getAttribute("edit") == "inactive") btnsave.setAttribute("inactive", "");
                        else btnsave.removeAttribute("inactive");
                        //Blanqueamos los errores antes de abrir
                        blankForm("popupUpdFrm", ["input", "select", ".popupDateLbl", ".errmsgSct"]);

                        editableForm("popupUpdFrm", true, ["input", "select"]);
                        //Si obtenemos una respuesta exitosa del servicio en este caso seteamos el formulario de edición
                        await setFrm(rsp.entry);
                        //Una vez que se cargó la data mostramos el poup
                        document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Editar Implementos";
                        showPopup("popupUpdFrm");


                    });
                });
            } else {
                celda.children[0].setAttribute("disabled","");
            }
            //Eliminar Btn
            if (privileges.delete) {
                celda.children[1].addEventListener("click", function (e) {
                    e.stopPropagation();
                    //Se muestra el popup de confirmación
                    let usr = this.parentElement.getAttribute("itemlbl");
                    document.querySelector(".poupDelItemLbl").innerText = usr;
                    //Asignamos el id que va a ser eliminado al boton guardar de la confirmación del delete
                    let delpop = document.getElementById("popupDelFrm");
                    delpop.querySelector(".saveBtn").setAttribute("delid", this.parentElement.getAttribute("itemid"));
                    //Mostramos el popup de confirmación
                    showPopup("popupDelFrm");
                });
            } else {
                celda.children[1].setAttribute("disabled","");
            }

            tbl.appendChild(clone);

        }
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        tbl.innerHTML = "";
        tbl.appendChild(clone);
    }
    //SE PINTA EL PAGINADO LUEGO DE PINTAR LA TABLA
    var actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
    actpage = (actpage != null && actpage != undefined) ? (actpage.innerHTML) : 1;
    drawPags(document.querySelector(".pgSctTbl"), rsp.numofrecords, 10, actpage, listAPI);
    
}
//Función para llamar el servicio que inserta o modifica un usuario.
function updateAPI(id) {
    let validationpars = [
        {
            "key": "name",
            "id": "updName",
            "msg": "Introduzca un nombre válido"
        },
        {
            "key": "abbr",
            "id": "updAbbr",
            "msg": "Introduzca una abreviatura válida"
        },
        {
            "key": "typeid",
            "id": "updImptype",
            "msg": "Introduzca un tipo válido"
        },
    ]

    var par = {};
    par.id = id;
    par.name = document.getElementById("updName").value;
    par.abbr = document.getElementById("updAbbr").value;
    par.typeid = document.getElementById("updImptype").value;
    par.statusid = (document.getElementById("updStatus").checked) ? 1 : 0;
    par.sessionid = localStorage.getItem("sessionid");

    //Hacemos las validaciones
    var haserror = false;
    //Cómo son muchos campos simplificamos con un arreglo que contiene los campos a verificar
    validationpars.forEach((e) => {
        //Que el nombre no esté vacío
        if (!(par[e.key] !== undefined && par[e.key] !== null && par[e.key] !== "")) {
            errInpt(e.id, e.msg, 6000);
            haserror = true;
        }
    });

    //Si tiene errores detenemos la llamada al servicio
    if (haserror) return;
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.id != null && data.id != undefined) {
                    //Llevaos el ordenamiento por "id" y cargamos el listado
                    resetOrder(document.querySelector(".pgSctTbl")).then(() => { listAPI(); });
                    //Como definimos función flecha podemos leer los parametros para determinar si era nuevo y mostrar mensaje exitoso correcto
                    successMsgShow((par.id == 0) ? "Implemento creado con éxito" : "Implemento modificado con éxito");
                }
                //Cerramos el popup
                closePopups();
                break;
            case 400:
                data = JSON.parse(rsp.response);
                errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), data.msg, 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Error de privilegios - prohibido
                errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
                break;
            case 409:
                errInpt("updName", "", 6000);
                errInpt("updAbbr", "", 6000);
                errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "Ya existe este Implemento", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "races/implements/update", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Función para llamar el servicio de eliminar, se ejecuta al confirmar el boton
function deleteAPI(id) {
    var par = {};
    par.id = id;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.id != null && data.id != undefined) {
                    listAPI();
                    //Mostramos mensaje de eliminado con éxito
                    successMsgShow("Implemento eliminado con éxito");
                }
                //Cerramos el popup
                closePopups();
                break;
            case 204:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Registro no encontrado", 6000);
                break;
            case 304:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Existen dependencias que no permiten ejecutar esta acción", 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Error de privilegios - prohibido
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "races/implements/delete", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) })
}
//Función retorna la inforación detallada del usuario
function entryAPI(id) {
    return new Promise((resolve, reject) => {
        var par = {};
        par.id = id;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("GET", "races/implements/entry", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para rellenar el formulario de edición
function setFrm(rsp) {
    return new Promise((resolve, reject) => {
        document.getElementById("updName").value = rsp.name;
        document.getElementById("updStatus").checked = (rsp.status.id == 1) ? true : false;
        document.getElementById("updAbbr").value = rsp.abbr;
        document.getElementById("updImptype").value = rsp.type.id;
        document.getElementById("popupUpdFrm").querySelector(".saveBtn").setAttribute("upid", rsp.id);
        document.getElementById("creationLbl").innerText = "Creado: " + rsp.created.formatted;
        if (rsp.created.date != rsp.modified.date)
            document.getElementById("updatedLbl").innerText = "Modificado: " + rsp.modified.formatted;
        else
            document.getElementById("updatedLbl").innerText = "";
        setTimeout(function () { resolve("cargado") }, 100);
    });
}
//Se realizan las validaciones de privilegios de front, se inactivan y muestran los mensajes correspondientes
function privValidations(rsp) {
    return new Promise((resolve, reject) => {
        //ELIMINAR
        let popupdelBtn = document.getElementById("popupDelFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupdelBtn) {
            if (!rsp.delete) {
                popupdelBtn.setAttribute("inactive", "");
            } else {
                popupdelBtn.removeAttribute("inactive");
            }
        }

        //EDITAR
        let popupeditBtn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupeditBtn) {
            if (!rsp.update) {
                popupeditBtn.setAttribute("edit", "inactive");
            } else {
                popupeditBtn.removeAttribute("edit");
            }
        }

        //CREAR
        let popupaddBtn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupaddBtn) {
            if (!rsp.create) {
                popupaddBtn.setAttribute("add", "inactive");
            } else {
                popupaddBtn.removeAttribute("add");
            }
        }
        let tbladdBtn = document.querySelector(".addBtn");
        if (tbladdBtn) {
            if (!rsp.create) {
                tbladdBtn.setAttribute("disabled", "");
            } else {
                tbladdBtn.removeAttribute("disabled");
            }
        }
        resolve();
    });

}
//Llamada inicial
document.addEventListener("DOMContentLoaded", function () {
    implementsInit();
});