//Funcion para abrir, cerrar formularios del login
function handlerForm(id) {
    return new Promise((resolve, bad) => {
        //Se cierran todos quitando la clase del "opacity"
        var forms = document.getElementsByClassName("centerFrm");
        for (var i = 0; i < forms.length; i++) {
            forms[i].classList.remove("actvFrm");
        }
        setTimeout(() => {
            //Luego de oculta la visibilidad
            for (var i = 0; i < forms.length; i++) {
                forms[i].style.visibility = "";
            }
            //Activamos solo el que se va a mostrar
            var activo = document.getElementById(id).parentElement;
            activo.style.visibility = "visible";
            activo.classList.add("actvFrm");
            //Retornamos la promesa cómo resuelta
            resolve("abierto" + id);
        }, 300, forms)
    });

}

//Funcion para asignar eventos por cada form
//LOGIN
function initLogin() {
    //Asignamos el evento de mostrar el formulario de recuperar clave
    document.getElementById("btnLogFgt").addEventListener("click", async function () {
        //Abrimos el formulario de forgot
        await handlerForm("forgotFrm");
        //Esperamos a que se muestre el otro popup para blanquear el anterior para que no se vea el blanqueo
        blankForm("loginFrm", ['input']);
    });
    //Asignamos el evento para intentar el login
    document.getElementById("btnLog").addEventListener("click", function () {
        loginAPI();
    });
    //Asignamos evento al introducir texto al campo usr formulario de login
    document.getElementById("usrFrm").addEventListener("keyup", function (e) {
        //Validamos que tenga formato de email
        if (this.value != "" && !hasFormat(this.value, 'email')) {
            errInpt("usrFrm", "Formato de correo inválido", 0);
        } else {
            errBlank("usrFrm");
        }
        //Si le da al enter, focus en pasword. Lo hago así porque dice quel keycode is deprecated 
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            document.getElementById("pwdFrm").focus();
        }
    });
    //Asignamos al enter en el password para hacer el submit
    document.getElementById("pwdFrm").addEventListener("keyup", function (e) {
        //Si le da al enter, login.
        //Validamos tambien que no esté el waitscreen activo
        var wait = document.getElementById("waitScreen");
        if (e.key != null && (e.key).toLowerCase() == 'enter' && wait == null) {
            loginAPI();
        }
    });
}
//Función que realiza el intento de login, llama al servicio y determina que hacer según la respuesta
function loginAPI() {
    var par = {};
    //Definimos los valores para los parametros
    var usr = (document.getElementById("usrFrm").value);
    var pwd = (document.getElementById("pwdFrm").value);
    //Validaciones locales antes de enviar
    var haserror = false;
    //que no esté vacío y sea un correo
    if (!(usr !== undefined && usr !== null && usr !== "")) {
        errInpt("usrFrm", "Introduzca un correo válido", 6000);
        haserror = true;
    } else if (!hasFormat(usr, 'email')) {
        errInpt("usrFrm", "Formato de correo inválido", 6000);
        haserror = true;
    }
    //Que la clave no esté vacía
    if (!(pwd !== undefined && pwd !== null && pwd !== "")) {
        errInpt("pwdFrm", "Introduzca una contraseña válida", 6000);
        haserror = true;
    }
    //Si tiene errores detenemos la llamada al servicio
    if (haserror) return;

    //Si pasa las validaciones asignamos los parametros
    par.usr = usr;
    par.pwd = MD5(pwd);
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si todo está ok se guardan los valores de la sesión y se va al dashboard
                localStorage.setItem("sessionid", data.sessionid);
                localStorage.setItem("validthru", data.validthru);
                localStorage.setItem("name", data.name);
                //Redireccionamos al dashboard
                gotoPage('home', '', {});
                break;
            default:
                data = JSON.parse(rsp.response);
                errInpt("usrFrm", "", 6000);
                errInpt("pwdFrm", data.msg, 6000);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "security/login", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}

//FORGOT (Olvidó contraseña)
function initForgot() {
    //Asignamos el evento de continuar (llama al servicio que envía el correo)
    document.getElementById("btnFgt").addEventListener("click", function () {
        forgotAPI();
    });
    //Asignamos evento al introducir texto al campo usr formulario de cambio de clave
    document.getElementById("usrFgtFrm").addEventListener("keyup", function (e) {
        //Validamos que tenga formato de email
        if (this.value != "" && !hasFormat(this.value, 'email')) {
            errInpt("usrFgtFrm", "Formato de correo inválido", 0);
        } else {
            errBlank("usrFgtFrm");
        }
        //Si le da al enter, focus en pasword. Lo hago así porque dice quel keycode is deprecated 
        //Validamos tambien que no esté el waitscreen activo
        var wait = document.getElementById("waitScreen");
        if (e.key != null && (e.key).toLowerCase() == 'enter' && wait == null) {
            forgotAPI();
        }
    });
    //Asignamos el evento cancelar y volver al login
    document.getElementById("btnFgtBack").addEventListener("click", async function () {
        //Abrimos el formulario de forgot
        await handlerForm("loginFrm");
        //Blanqueamos el formulario de forgot una vez que salimos de este y nos regresamos al login o continuamos
        blankForm("forgotFrm", ['input']);
    });
    //Asignamos el evento regresar al login desde el mensaje de confirmación de envío de correo exitoso
    document.getElementById("btnFgtCnf").addEventListener("click", function () {
        handlerForm("loginFrm");
    });
    //Esto lo que hace es que si estamos en la vista de confirmación de recuperación de contraseña y el usuario le da "enter" sea cómo un continuar
    //Se aplica window ya que no hay campos de texto en la vista
    window.addEventListener("keyup", function (e) {
        //Validamos que nuestra vista activa es la de la confirmación del olvidar contraseña, permitimos el enter para continuar
        if (this.document.getElementById("forgotCnfFrm").parentElement.classList.contains("actvFrm")) {
            //Validamos tambien que no esté el waitscreen activo
            var wait = document.getElementById("waitScreen");
            if (e.key != null && (e.key).toLowerCase() == 'enter' && wait == null) {
                handlerForm("loginFrm");
            }
        }
    });
}
//Funcion que invoca al servicio de solicitar cambio de clave
function forgotAPI() {
    var par = {};
    //Definimos los valores para los parametros
    var usr = document.getElementById("usrFgtFrm").value;
    //Validaciones locales antes de enviar
    if (!(usr !== undefined && usr !== null && usr !== "")) {
        errInpt("usrFgtFrm", "Introduzca un correo válido", 6000);
        return;
    } else if (!hasFormat(usr, 'email')) {
        errInpt("usrFgtFrm", "Formato de correo inválido", 6000);
        return;
    }
    par.email = usr;
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Mostramos la confirmación del correo enviado
                await handlerForm("forgotCnfFrm");
                //Esperamos a que se abra el otro popup para que no se vea el blanqueo
                blankForm("forgotFrm", ['input']);
                break;
            case 401:
                data = JSON.parse(rsp.response);
                errInpt("usrFgtFrm", data.msg, 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "security/forgot", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}

//RECOVER (Cambio de contraseña) 
function initRecover() {
    const pwderrormsg = "La clave debe tener un mínimo de 8 caracteres, solo letras, números o caracteres especiales (._-#$)";

    //Asignamos el evento de continuar (llama al servicio que envía el correo)
    document.getElementById("btnRecv").addEventListener("click", function () {
        recoverAPI();
    });
    //Asignamos evento al introducir texto al campo usr formulario de login
    document.getElementById("rcvpwdFrm").addEventListener("keyup", function (e) {
        if (!hasFormat(this.value, 'password')) {
            errInpt("rcvpwdFrm", pwderrormsg, 0);
            return;
        } else {
            errBlank("rcvpwdFrm");
        }

        //Si le da al enter, focus en confirmación.
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            //Validamos que tenga formato de password
            if (this.value != "" && hasFormat(this.value, 'password')) {
                errBlank("rcvpwdFrm");
                document.getElementById("rcvpwdCnfFrm").focus();
            }
        }
    });
    //Asignamos al enter en el password para hacer el submit
    document.getElementById("rcvpwdCnfFrm").addEventListener("keyup", function (e) {
        if (!hasFormat(this.value, 'password')) {
            errInpt("rcvpwdCnfFrm", pwderrormsg, 0);
            return;
        } else {
            errBlank("rcvpwdCnfFrm");
        }
        var wait = document.getElementById("waitScreen");
        //Si le da al enter, focus en confirmación.
        if (e.key != null && (e.key).toLowerCase() == 'enter' && wait == null) {
            //Validamos que tenga formato de password
            if (this.value != "" && hasFormat(this.value, 'password')) {
                errBlank("rcvpwdCnfFrm");
                recoverAPI();
            }
        }

    });

}
//Se llama al servicio y se confirma el cambio de clave
function recoverAPI() {
    const pwderrormsg = "La clave debe tener un mínimo de 8 caracteres, solo letras, números o caracteres especiales (._-#$)";
    var par = {};
    //Dfinimos los valores de los parametros
    var pwd = document.getElementById("rcvpwdFrm").value;
    var pwd2 = document.getElementById("rcvpwdCnfFrm").value;
    //Validaciones locales antes de enviar
    var haserror = false;
    //que no esté vacío y sea un correo
    if (!(pwd !== undefined && pwd !== null && pwd !== "")) {
        errInpt("rcvpwdFrm", "Introduzca una contraseña", 6000);
        haserror = true;
    }
    if (!hasFormat(pwd, 'password')) {
        errInpt("rcvpwdFrm", pwderrormsg, 6000);
        haserror = true;
    }
    if (!(pwd2 !== undefined && pwd2 !== null && pwd2 !== "")) {
        errInpt("rcvpwdCnfFrm", "Confirme su contraseña", 6000);
        haserror = true;
    }
    if (!hasFormat(pwd2, 'password')) {
        errInpt("rcvpwdCnfFrm", pwderrormsg, 6000);
        haserror = true;
    }
    //Si no coinciden las claves y no está ninguna vacía
    if (pwd != pwd2 && !haserror) {
        errInpt("rcvpwdFrm", "", 6000);
        errInpt("rcvpwdCnfFrm", "No coinciden las contraseñas", 6000);
        haserror = true;
    }
    //Si tiene error detenmos la llamada al servicio
    if (haserror) return;
    //Asignamos los parametros
    par.hash = getParameterByName("hash");
    par.pwd = MD5(pwd);
    //Función si todo sale ok
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                // Reemplazar los parámetros visibles en la URL
                var newUrl = (window.location.href).replace(/(\?|\&).+$/, '');
                newUrl = newUrl + "?id=login";
                // Agregar la nueva URL al historial del navegador
                window.history.pushState({ path: newUrl }, '', newUrl);//Quitamos los parametros y mostramos la url
                //Mostramos el popup de login nuevamente
                await handlerForm("loginFrm");
                //Esperamos a que se muestre el otro popup para blanquear el anterior para que no se vea el blanqueo
                blankForm("recoverFrm", ['input']);
                break;
            case 401:
                data = JSON.parse(rsp.response);
                errInpt("rcvpwdFrm", "", 6000);
                errInpt("rcvpwdCnfFrm", data.msg, 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    callWS("POST", "security/recover", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}

//Llamada inicial
document.addEventListener("DOMContentLoaded", async function () {
    //Si determinamos que el enlace apunta a la recuperación de clave mostramos este
    var actvfrm = "loginFrm";
    if (getParameterByName('sid') != null && getParameterByName('sid') == 'recoverpwd') {
        actvfrm = 'recoverFrm';
        //Si es el formulario de recuperación buscamos el email que "recupera la clave" en los parámetros
        document.getElementById("rcvUsrLbl").innerText = getParameterByName('email');
    };
    //Al iniciar mostramos el formulario de login
    handlerForm(actvfrm).then(() => {
        //inicializamos los eventos de los formularios una vez se carga el primero
        initLogin();
        initForgot();
        initRecover();
        //Asignamos el evento a los iconos de "ver password" de todos los formularios
        document.querySelectorAll(".readPwd").forEach((e) => {
            e.addEventListener("click", function () {
                let inpt = e.previousElementSibling;
                let ic = this.firstElementChild;
                //Validamos que exista el inpt al que hace referencia el "ver contraseña"
                if (inpt != null) {
                    if (inpt.getAttribute("type") == 'password') {
                        inpt.setAttribute("type", "text");
                        ic.classList.remove("fa-eye");
                        ic.classList.add("fa-eye-slash");
                    } else {
                        inpt.setAttribute("type", "password");
                        ic.classList.remove("fa-eye-slash");
                        ic.classList.add("fa-eye");
                    }
                }
            });
        });
        //Si la primera carga estamos tenemos activo el formulario de login/recover hacemos focus donde corresponda
        setTimeout(function () {
            let actv = document.querySelector(".actvFrm").firstElementChild;
            if (actv.getAttribute("id") == 'loginFrm') {
                document.getElementById("usrFrm").focus();
            } else if (actv.getAttribute("id") == 'recoverFrm') {
                document.getElementById("rcvpwdFrm").focus();
            }
        }, 300);

    });
});