<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));
    
    // parametros obligatorios
    $parmsob = array("userid","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $userid = intval($_REQUEST["userid"]);
    
    isSessionValid($db, $sessionid);
    
    if (!tienePrivilegio($db, $sessionid, 100))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    $sql =  "SELECT     P.id, P.grp, P.dsc, IF(UP.privilegeid IS NULL, 0, 1) access, P.crud " .
            "FROM       privileges P " .
            "LEFT JOIN  (SELECT * FROM userprivileges WHERE userid = '" . $userid . "') UP " .
            "ON         P.id = UP.privilegeid " .
            "ORDER BY   P.grp, P.dsc";
    if (!$rs = $db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $groups = array();
    $actgrp = "";
    while ($row = $rs->fetch_assoc()){
        if ($actgrp != $row["grp"]){
            if ($actgrp != ""){
                $groups[] = array("name"=>$actgrp, "privileges"=>$privs, "crud"=>$crud);
            }
            $actgrp = $row["grp"];
            $privs = array();
            $crud = (boolean) $row["crud"]!=0;
        }
        $privs[] = array("id"=>(integer) $row["id"],
                         "dsc"=>$row["dsc"],
                        "access"=>(boolean) $row["access"]==1);

    }
    if ($actgrp != ""){
        $groups[] = array("name"=>$actgrp, "privileges"=>$privs, "crud"=>$crud);
    }

    header("HTTP/1.1 200");
    echo (json_encode($groups));
    die();
?>