<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../settings/dbconn.php");
    include("../../settings/utils.php");
    
    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("hash", "pwd");
    if (!parametrosValidos($_REQUEST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    $hash = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["hash"]);
    $pwd = preg_replace("/[^a-zA-Z0-9_$\-\#.]+/", "", $_REQUEST["pwd"]);

    // se crea un sessionid reconocido para efectos de la auditoria
    $sessid = randomString(32);
    
    $sql =  "UPDATE users " .
            "SET    pwd = '" . $pwd . "', ".
            "       hashrecover = NULL, ".
            "       sessionid = '" . $sessid . "' " . 
            "WHERE  hashrecover='".$hash."'";

    if (!$db->query($sql)){
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));        
    }
   
    if ($db->affected_rows == 0){
        setAudit($db, "Seguridad", "", "Intento fallido de resuperacion de clave con hash " . $hash);
        badEnd("401", array("msg"=>"Hash incorrecto"));        
    }
    $out = new stdClass;
    $out->msg = "Password cambiado satisfactoriamente";

    setAudit($db, "Seguridad", $sessid, "Recuperación de clave exitoso hash: " . $hash);

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
