<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../settings/dbconn.php");
    include("../../settings/utils.php");
    //require '../../hooks/PHPMailer5/PHPMailerAutoload.php';
    require_once ('../../hooks/PHPMailer-6.9.1/src/PHPMailer.php');
    require_once ('../../hooks/PHPMailer-6.9.1/src/SMTP.php');
    require_once ('../../hooks/PHPMailer-6.9.1/src/Exception.php');

    date_default_timezone_set('Etc/UTC');

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("email");
    if (!parametrosValidos($_REQUEST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos 
    $email = preg_replace("/[^a-zA-Z0-9@.]+/", "", $_REQUEST["email"]);
    $hash = randomString(128);
    
    // se crea un sessionid reconocido para efectos de la auditoria
    $sessid = randomString(32);

    // se genera el hash que servirá para la validar la recuperación
    $sql =  "UPDATE users " .
            "SET    hashrecover = '".$hash."', ".
            "       sessionid = '".$sessid."' ".
            "WHERE  UPPER(usr)='".strtoupper($email)."' ";
    //ejecutamos el sql        
    if (!$db->query($sql)){
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    //revisamos la respuesta del query y verificamos si fue ejecutada correctamente 
    if ($db->affected_rows == 0){
        setAudit($db, "Seguridad", "", "Se intentó recuperar una clave con un email inválido: " . $email);
        badEnd("401", array("msg"=>"No tenemos ningún usuario registrado con ese email"));
    }
    
    // Conseguir el nombre del usuario
    $sql =  "SELECT name, status " .
            "FROM   users " .
            "WHERE  sessionid='".$sessid."' ";
    //ejecutamos el sql        
    if (!$rs = $db->query($sql)){
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    $username = "--";
    if ($row = $rs->fetch_assoc()){
        $username = $row["name"];
        if ($row["status"] != "1"){
            setAudit($db, "Seguridad", "", "Se intentó recuperar una clave con un usuario desactivado: " . $email);
            badEnd("401", array("msg"=>"El usuario correspondiente al correo indicado está inactivado"));
        }
    }    
    $subject = "Recuperación de clave de Hípicas";
    
    $body = 
        "<html>" .
        "<head>" .
        "<title></title>" .
        "</head>" .
        "<body style='font-family:sans-serif'>" .
        "<div style='padding:20px;width:100%;background-color:gray'>" .
        "<div style='padding:10px;background-color:white;max-width:600px;width:95%;margin-left:auto;margin-right:auto;border-radius:4px'>" .
        "<div style='display:table;border-spacing:30px;width:95%;margin-left:auto;margin-right:auto'>" .
        "<div style='display:table-row'>" .
        //"<div style='display:table-cell'><img src='".file_get_contents('logobase64.txt', __DIR__)."' /></div>" .
        "<div style='display:table-cell;text-align:center'><img style='max-width:50%' src='".$homeurl."/img/logo.png' /></div>" .
        "</div>" .
        "<div style='display:table-row'>" .
        "<div style='text-align:center;display:table-cell;font-size:200%;font-weight:bold'>" .
        "<br/>Recuperaci&oacute;n de Clave<br/>&nbsp;" .
        "</div>" .
        "</div>" .
        "<div style='display:table-row'>" .
        "<div style='display:table-cell;font-size:120%;text-align:center'>Hola <b>".$username."</b>, para recuperar tu clave debes hacer click en el bot&oacute;n indicado m&aacute;s abajo</div>" .
        "</div>" .
        "<div style='display:table-row'>" .
        "<div style='display:table-cell'>" .
        "<a href='".$homeurl . "?id=login&sid=recoverpwd&hash=".$hash."&email=".$email."'>" .
        "<div style='font-weight:bold;margin-left:auto;margin-right:auto;border-radius:12px;cursor: pointer;margin-top: 50px;margin-bottom: 50px;color: white;line-height: 50px;text-align:center;background-color: #0092D5;height: 50px;width: 320px;border: none;transition: all ease 300ms;'>RECUPERAR</div>" .
        "</a>" .
        "</div>" .
        "</div>" .
        "<div style='display:table-row'>" .
        "<div style='display:table-cell'>Gracias de antemano<br />" .
        "Gaceta Hípica</div>" .
        "</div>" .
        "</div>" .
        "</div>" .
        "</div>" .
        "</body>" .
        "</html>";

    
    $altbody = "Hola ".$username.", para recuperar su clave diríjase a la dirección indicada a continuación:\n\n".
            $homeurl . "?id=login&sid=recoverpwd&hash=".$hash."&email=".$email."\n\n".
            "Gracias de antemano\n" .
            "Equipo de CompraTuRepuesto";
    //enviarCorreoSMTP($fromeMail, $email, $subject, $message,"");        
    enviarCorreo("no-responder@correo.com", $email, $subject, $body, $altbody);

    //mostramos los datos recibidos
    $out = new stdClass;
    $out->email = $email;

    setAudit($db, "Seguridad", $sessid, "Se envió la recuperación de clave al email: " . $email);

    //lanzamos un codigo que todo salio bien
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>