<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("order", "offset", "numofrec", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $orderpar = intval($_REQUEST["order"]);
    $offset = intval($_REQUEST["offset"]);
    $numofrec = intval($_REQUEST["numofrec"]);

    // parametros opcionales
    $filtro = "";
    if (isset($_REQUEST["filter"])){
        $filtro = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["filter"]);
    }
    $module = "";
    if (isset($_REQUEST["module"])){
        $module = preg_replace("/[^a-zA-Z0-9 .,áéíóúñüÁÉÍÓÚñü]+/", "", $_REQUEST["module"]);
    }
    $user = "";
    if (isset($_REQUEST["user"])){
        $user = preg_replace("/[^a-zA-Z0-9@.]+/", "", $_REQUEST["user"]);
    }
    $from = "";
    if (isset($_REQUEST["from"])){
        $from = preg_replace("/[^0-9-]+/", "", $_REQUEST["from"]);
    }
    $to = "";
    if (isset($_REQUEST["to"])){
        $to = preg_replace("/[^0-9-]+/", "", $_REQUEST["to"]);
    }

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 110, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    // busqueda
    $filter = "";
    if (strlen($filtro) > 0){
        $filter .= "(";
        $filter .= "     A.dsc like '%" . $filtro . "%' ";
        $filter .= ")";
    }
    // filtro de modulo
    if ($module != ""){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " A.module = '" . $module . "' ";
    }
    // filtro de usuario
    if ($user != ""){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " A.userref = '" . $user . "'";
    }
    // filtro de from
    if ($from != ""){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " A.datecreated >= '" . $from . " 00:00:00'";
    }
    // filtro de to
    if ($to != ""){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " A.datecreated <= '" . $to . " 23:59:59'";
    }
    if (strlen($filter) > 0){
        $filter = " WHERE " . $filter;
    }

    // orden
    $order = "";
    switch (abs($orderpar)){
        case 1:
            $order = " A.datecreated ";
            break;
        case 2:
            $order = " A.module ";
            break;
        case 3:
            $order = " A.dsc ";
            break;
        case 4:
            $order = " IFNULL(U.name, A.userref) ";
            break;
    }
    if (strlen($order) > 0){
        if ($orderpar < 0)
            $order = str_replace(",", " DESC,", $order) . " DESC ";
        $order = " ORDER BY " . $order;
    }

    $sql =  "SELECT     A.datecreated, A.module, A.dsc, A.userref, IFNULL(U.name, A.userref) userrefname, " .
            "           DATE_FORMAT(A.datecreated, '%d/%m/%Y %h:%i %p') datecreatedfmt " .
            "FROM       audit A " .
            "LEFT JOIN  users U " .
            "ON         A.userref = U.usr " .
            $filter .
            $order;

    // calcular numero de registros
    if (!$rs = $db->query("SELECT COUNT(*) cnt FROM (" . $sql . ") A "))
        badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
    $row = $rs->fetch_assoc();
    $out = new stdClass;
    //$out->sql = $sql;
    $out->numofrecords = (integer) $row["cnt"];
    // limitar número de
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $offset . "," . $numofrec;
    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>2, "msg"=>$db->error));

    $out->records = array();
    while ($row = $rs->fetch_assoc()){
        $records = new stdClass;
        $records->date = new stdClass;
        $records->date->date = $row["datecreated"];
        $records->date->formatted = $row["datecreatedfmt"];
        $records->module = $row["module"];
        $records->dsc = $row["dsc"];
        $records->user = new stdClass;
        $records->user->usr = $row["userref"];
        $records->user->name = $row["userrefname"];

        $out->records[] = $records;
    }

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
?>