<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));
    
    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios id,sessionid"));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
        
    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 633))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    // validar que exista
    $sql =  "SELECT  COUNT(*) cnt " .
            "FROM    traqueos " .
            "WHERE   id=" . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    $row = $rs->fetch_assoc();
    if ($row["cnt"]<=0)
        badEnd("204", array("msg"=>"Traqueo no encontrado"));

    //Preparando la salida
    $out = new StdClass;
    $out->id = $id;

    $sql =  "DELETE " .
            "FROM    traqueos " .
            "WHERE   id=" . $id;
    if (!$db->query($sql))
        if ($db->errno == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar el registro"));
        else
            badEnd("500", array("msg"=>$db->error));
    if ($db->affected_rows > 0){
        $out->id = $id;
    }else{
        badEnd("204", array("msg"=>"No se consiguió borrar el registro"));
    }

    setAudit($db, "Traqueos", $sessionid, "Se eliminó el Traqueo \'" . $id . "\'");

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
