<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("id", "racecourseid", "sessionid", "number", "date");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $number = preg_replace("/[^0-9]+/", "", $_REQUEST["number"]);
    $date = preg_replace("/[^0-9\-]+/", "", $_REQUEST["date"]);
    $racecourseid = intval($_REQUEST["racecourseid"]);

    isSessionValid($db, $sessionid);

    if ($id==0){    // incluir registro
        if (!tienePrivilegio($db, $sessionid, 612, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));

        $sql =  "SELECT MAX(date) maxdate FROM reunions WHERE racecourseid=" . $racecourseid . " AND id<>" . $id;
        if (!$rs = $db->query($sql))
            badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
        if ($row = $rs->fetch_assoc())
            if ($row["maxdate"] > $date)
                badEnd("400", array("msg"=>"La fecha es menor a una fecha ya registrada. Fecha Registrada: " . $row["maxdate"] . " - Fecha recibida: " . $date));
                
        $sql =  "INSERT INTO reunions " .
                "       (racecourseid, number, date) " .
                "VALUES (" .
                "        '" . $racecourseid . "'," .
                "        '" . $number . "', " .
                "        '" . $date . "' " .
                "        )";
        if (!$db->query($sql)){
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("msg"=>$db->error));
            }
        }

        $id = $db->insert_id;
        
        setAudit($db, "Reuniones", $sessionid, "Se incluyó la reunión \'" . $number . "\' (" . $id . ")");
    }else{          // modificar registro
        if (!tienePrivilegio($db, $sessionid, 611, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "UPDATE reunions " .
                "SET    racecourseid = '" . $racecourseid . "'," .
                "       number = '" . $number . "', " .
                "       date = '" . $date . "' " .
                "WHERE  id=" . $id;
        if (!$db->query($sql))
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
            }
            
        setAudit($db, "Reuniones", $sessionid, "Se actualizó la reunión \'" . $number . "\' (" . $id . ")");

    }

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>