<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("id","retirementid","arrivalposition","weight","jockeyweight","jockeyid","stumbleid","finishtime","pos400",
                    "pos800","bodiesid","dividends","sessionid");
        if (!parametrosValidos($_REQUEST, $parmsob))
            badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $arrivalposition = intval($_REQUEST["arrivalposition"]);
    $weight = floatval($_REQUEST["weight"]);
    $retirementid = intval($_REQUEST["retirementid"]);
    $finishtime = floatval($_REQUEST["finishtime"]);
    $dividends = floatval($_REQUEST["dividends"]);
    $stumbleid = intval($_REQUEST["stumbleid"]);
    $jockeyid = intval($_REQUEST["jockeyid"]);
    $bodiesid = intval($_REQUEST["bodiesid"]);
    $pos400 = intval($_REQUEST["pos400"]);
    $pos800 = intval($_REQUEST["pos800"]);
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $jockeyweight = preg_replace("/[^0-9 \.\-\+]+/", "", $_REQUEST["jockeyweight"]);

    if ($retirementid == 0){
        $retrep = " NULL ";
    }else{
        $retrep = "'" . $retirementid . "'";
    }
    if ($stumbleid == 0){
        $sturep = " NULL ";
    }else{
        $sturep = "'" . $stumbleid . "'";
    }
    if ($bodiesid == 0){
        $bdyrep = " NULL ";
    }else{
        $bdyrep = "'" . $bodiesid . "'";
    }

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 621, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
        
    $sql =  "UPDATE racers " .
            "SET    retirementid = " . $retrep . ", " .
            "       arrivalposition = '" . $arrivalposition . "', " .
            "       jockeyid = '" . $jockeyid . "', " .
            "       jockeyweight = '" . $jockeyweight . "', " .
            "       weight = '" . $weight . "', " .
            "       finishtime = '" . $finishtime . "', " .
            "       dividends = '" . $dividends . "', " .
            "       stumbleid = " . $sturep . ", " .
            "       bodiesid = " . $bdyrep . ", " .
            "       pos400 = '" . $pos400 . "', " .
            "       pos800 = '" . $pos800 . "' " .
            "WHERE  id=" . $id;
    if (!$db->query($sql))
        if ($db->errno == 1062){
            badEnd("409", array("msg"=>"Registro Duplicado"));
        }else{
            badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
        }

    $sql =  "SELECT     R.number horsenumber, RA.number racenumber " .
            "FROM       racers R " .
            "INNER JOIN races RA " . 
            "ON         R.raceid=RA.id " . 
            "WHERE      R.id=" . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    setAudit($db, "Carreras", $sessionid, "Se actualizó el final del ejemplar \'" . $row["horsenumber"] . "\' de la carrera (" . $row["racenumber"] . ")");

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>