<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("reunionid", "order", "offset", "numofrec", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $reunionid = intval($_REQUEST["reunionid"]);
    $orderpar = intval($_REQUEST["order"]);
    $offset = intval($_REQUEST["offset"]);
    $numofrec = intval($_REQUEST["numofrec"]);

    $userid = isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 810, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));

    // cargar acceso a revistas
    $magazineids = "";
    $sql = "select magazineids FROM users WHERE id=" . $userid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if ($row = $rs->fetch_assoc())
        $magazineids = nvl($row["magazineids"], '');

    if ($magazineids == "") $magazineids = "0";
    
    // parametros opcionales
    $datefrom = "";
    if (isset($_REQUEST["datefrom"])){
        $datefrom = preg_replace("/[^0-9\-]+/", "", $_REQUEST["datefrom"]);
    }
    $dateto = "";
    if (isset($_REQUEST["dateto"])){
        $dateto = preg_replace("/[^0-9\-]+/", "", $_REQUEST["dateto"]);
    }

    // filtroe
    $filter =   " R.reunionid=" . $reunionid . " " . 
                " AND R.status > 0 ";
    // filtro de fecha desde
    if ($datefrom != ""){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " T.date >= '" . $datefrom . "'";
    }
    // filtro de fecha hasta
    if ($dateto != ""){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " T.date <= '" . $dateto . "'";
    }


    if (strlen($filter) > 0){
        $filter = " WHERE " . $filter;
    }

    // orden
    $order = "";
    switch (abs($orderpar)){
        case 1:
            $order = " R.ord ";
            break;
        case 2:
            $order = " R.number ";
            break;
    }
    if (strlen($order) > 0){
        if ($orderpar < 0)
            $order = str_replace(", ", " DESC,", $order) . " DESC ";
        $order = " ORDER BY " . $order;
    }

    $sql =  "SELECT     R.id, R.ord, R.number, R.call, R.time, R.serie, R.mainprice, R.valid, R.racetypeid, " .
            "           IF(R.status=0,'Abierta',IF(R.status=1,'Procesada','Cerrada')) statusdsc, " .
            "           REPLACE(REPLACE(DATE_FORMAT(R.time, '%h:%i%p'), 'AM', 'am'), 'PM', 'pm') timefmt, " .
            "           D.id distanceid, D.dsc distancedsc, R.status, R.mainpricecurr, R.extrapricecurr " .
            "FROM       races R " .
            "INNER JOIN racetypes T " .
            "ON         R.racetypeid = T.id " . 
            "INNER JOIN distances D " .
            "ON         R.distanceid = D.id " . 
            $filter .
            $order;
    // calcular numero de registros
    if (!$rs = $db->query("SELECT COUNT(*) cnt FROM (" . $sql . ") A "))
        badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
    $row = $rs->fetch_assoc();
    $out = new stdClass;
    $out->numofrecords = (integer) $row["cnt"];

    // limitar número de
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $offset . "," . $numofrec;
    if (!$rs = $db->query($sql))
        badEnd("500", array("msg"=>$db->error));

    $orderdsc = array("1ra", "2da", "3ra", "4ta", "5ta", "6ta", "7ma", "8va", "9na", "10ma", "11va", "12va", "13va", "14va", "15va");

    $out->records = array();
    while ($row = $rs->fetch_assoc()){
        $records = new stdClass;
        $records->raceid = (integer) $row["id"];
        $records->status = new stdClass;
        $records->status->id = (integer) $row["status"];
        $records->status->name = $row["statusdsc"];
        $records->raceid = (integer) $row["id"];
        $records->order = new stdClass;
        $records->order->id = (integer) $row["ord"];
        $records->order->name = $orderdsc[$records->order->id-1];
        $records->number = (integer) $row["number"];
        $records->isvalid = (integer) $row["valid"];

        // armar revistas
        $sql2 = "SELECT     M.id magid, M.dsc magdsc, IFNULL(F.top3, '') top3, IFNULL(F.top6, '') top6 " . 
                "FROM       magazines M " . 
                "LEFT JOIN  (SELECT * FROM forecasts WHERE raceid=" . $records->raceid . ") F " . 
                "ON         M.id = F.magazineid " .
                "WHERE      M.id IN (" . $magazineids . ") " . 
                "ORDER BY   M.dsc ";
        if (!$rs2 = $db->query($sql2))
            badEnd("500", array("sql"=>$sql2,"msg"=>$db->error));
        $magazines = array();
        while ($row2 = $rs2->fetch_assoc()){
            $magazine = new stdClass;
            $magazine->id = (integer) $row2["magid"];
            $magazine->name = $row2["magdsc"];
            $magazine->top3 = $row2["top3"];
            $magazine->top4 = $row2["top6"];

            $magazines[] = $magazine;
        }
        $records->magazines = $magazines;

        $out->records[] = $records;
    }
    $access = array();
    $access["update"] =  tienePrivilegio($db, $sessionid, 810);
    $access["read"] =    tienePrivilegio($db, $sessionid, 811);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>