<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga con GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));

    // parametros obligatorios
    $parmsob = array("raceid","magazineid","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $id = (integer) $_REQUEST["raceid"];
    $magazineid = (integer) $_REQUEST["magazineid"];
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 810, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
        $sql =  "SELECT     R.id, R.ord, R.number, R.call, R.time, R.serie, R.mainprice, R.valid, R.racetypeid, " .
                "           REPLACE(REPLACE(DATE_FORMAT(R.time, '%h:%i%p'), 'AM', 'am'), 'PM', 'pm') timefmt, " .
                "           RE.id reuid, RE.number reunumber, IFNULL(F.racers, '') racers, " .
                "           RE.date reudate, DATE_FORMAT(RE.date, '%d/%m/%Y') reudatefmt, DAYOFWEEK(RE.date) reudow, " .
                "           IF(IFNULL(RA.stcnt, 0)=0, 'Abierta', IF(IFNULL(RA.stcnt, 0)=IFNULL(RA.racescnt, 0)*2, 'Cerrada', 'Procesada')) reustatus, " .
                "           C.id racecourseid, C.dsc racecoursename, C.abbr racecourseabbr, " .
                "           D.id distanceid, D.dsc distancedsc, R.status, R.mainpricecurr, R.extrapricecurr, " .
                "           R.extraprice, R.conditionid1, R.conditionid2, R.conditiondsc, " .
                "           R.firstplace, R.secondplace, R.thirdplace, R.fourthplace, R.fifthplace, " .
                "           T.dsc racetypedsc, R.bets, R.finishtime, R.times400, R.betprices, " .
                "           IFNULL(RT.id, 0) racecoursetypeid, IFNULL(RT.dsc, '') racecoursetypedsc, " .
                "           R.createdat created, DATE_FORMAT(R.createdat, '%d/%m/%Y %h:%i %p') createdfmt, " .
                "           R.modifiedat modified, DATE_FORMAT(R.modifiedat, '%d/%m/%Y %h:%i %p') modifiedfmt " .
                "FROM       races R " .
                "LEFT JOIN  (SELECT * FROM forecasts WHERE magazineid=" . $magazineid . ") F " . 
                "ON         R.id = F.raceid " . 
                "INNER JOIN reunions RE " .
                "ON         R.reunionid = RE.id " .
                "LEFT JOIN  (SELECT reunionid, COUNT(*) racescnt, SUM(status) stcnt FROM races GROUP BY reunionid) RA " . 
                "ON         RE.id = RA.reunionid " . 
                "INNER JOIN racecourses C " .
                "ON         RE.racecourseid=C.id " . 
                "INNER JOIN racetypes T " .
                "ON         R.racetypeid = T.id " . 
                "INNER JOIN distances D " .
                "ON         R.distanceid = D.id " . 
                "LEFT JOIN  racecoursetypes RT " .
                "ON         R.racecoursetypeid = RT.id " . 
                "WHERE      R.id=" . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    $orderdsc = array("Primera", "Segunda", "Tercera", "Cuarta", "Quinta", 
                        "Sexta", "Séptima", "Octava", "Novena", "Décima", 
                        "Onceava", "Doceava", "Treceava", "Catorceava", "Quinceava");
    $dow = array("Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado");

    $out = new stdClass;
    if ($row = $rs->fetch_assoc()){
        $reuniondate = $row["reudate"];
        $entry = new stdClass;
        $entry->reunion = new stdClass;
        $entry->reunion->id = (integer) $row["reuid"];
        $entry->reunion->number = $row["reunumber"];
        $entry->reunion->racecourse = new stdClass;
        $entry->reunion->racecourse->id = (integer) $row["racecourseid"];
        $entry->reunion->racecourse->name = $row["racecoursename"];
        $entry->reunion->racecourse->abbr = $row["racecourseabbr"];
        $entry->reunion->date = new stdClass;
        $entry->reunion->date->date = $row["reudate"];
        $entry->reunion->date->formatted = $row["reudatefmt"];
        $entry->reunion->date->dayofweek = $dow[(integer)$row["reudow"]-1];
        $entry->reunion->status = new stdClass;
        $entry->reunion->status->id = (integer) 0;
        $entry->reunion->status->formatted = $row["reustatus"];
        $entry->race = new stdClass;
        $entry->race->order = new stdClass;
        $entry->race->order->id = (integer) $row["ord"];
        $entry->race->order->name = $orderdsc[$entry->race->order->id-1] . " Carrera";
        $entry->race->number = $row["number"];
        $entry->race->valid = $row["valid"];
        $entry->race->distance = new stdClass;
        $entry->race->distance->id = (integer) $row["distanceid"];
        $entry->race->distance->name = $row["distancedsc"];
        
        // buscar record
        $sql2 =     "SELECT     jockeyname, jockeyweight, date, basetime, " . 
                    "           DATE_FORMAT(date, '%d/%m/%Y') datefmt " .
                    "FROM       records_hipdst " . 
                    "WHERE      racecourseid=" . $entry->reunion->racecourse->id . " " . 
                    "AND        distanceid=" . $entry->race->distance->id . " " . 
                    "AND        deleted IS NULL ";
        if (!$rs2 = $db->query($sql2))
            badEnd("500", array("sql"=>$sql2, "msg"=>$db->error));
        $entry->record = new stdClass;
        if ($row2 = $rs2->fetch_assoc()){
            $entry->record->jockey = new stdClass;
            $entry->record->jockey->id = 0;
            $entry->record->jockey->name = $row2["jockeyname"];
            $entry->record->jockey->weight = $row2["jockeyweight"];
            $entry->record->date = new stdClass;
            $entry->record->date->date = $row2["date"];
            $entry->record->date->formatted = $row2["datefmt"];
            $entry->record->time = $row2["basetime"];
        }else{
            $entry->record->jockey = new stdClass;
            $entry->record->jockey->id = 0;
            $entry->record->jockey->name = "----";
            $entry->record->jockey->weight = "----";
            $entry->record->date = new stdClass;
            $entry->record->date->date = "2024-01-01";
            $entry->record->date->formatted = "--/--/--";
            $entry->record->time = "--";
        }

        // CABALLOS
        if ($row["racers"] == ""){
            $racers = array();
            $sql2 = "SELECT     id, number, position, arrivalposition " .
                    "FROM       racers " . 
                    "WHERE      raceid=" . $id . " " . 
                    "ORDER BY   number";
            if (!$rs2 = $db->query($sql2))
                badEnd("500", array("sql"=>$sql2, "msg"=>$db->error));
            while ($row2 = $rs2->fetch_assoc()){
                $racer = new stdClass;
                $racer->id = (integer) $row2["id"];
                $racer->number = (integer) $row2["number"];
                $racer->position = (integer) $row2["position"];
                $racer->arrivalposition = (integer) $row2["arrivalposition"];
                $racer->forecast = 0;
                $racer->comment = "";

                $racers[] = $racer;
            }
        }else{
            $racers = (array) json_decode($row["racers"]);
        }
        $racersfmt = array();
        foreach($racers as $racer){
            $sql2 = "SELECT     R.id, R.number, R.jockeyweight, " . 
                    "           H.id horseid, H.dsc horsename, H.obs, H.gender, TIMESTAMPDIFF(YEAR, H.birthdate, CURDATE()) as age, " . 
                    "           F.abbr fur, " . 
                    "           J.id jockeyid, CONCAT(J.names, ' ', J.lastnames) jockeyname, J.abbr jockeyabbr, " . 
                    "           T.id trainnerid, CONCAT(T.names, ' ', T.lastnames) trainnername, T.abbr trainnerabbr " . 
                    "FROM       racers R " . 
                    "INNER JOIN horses H " . 
                    "ON         R.horseid=H.id " . 
                    "INNER JOIN furs F " . 
                    "ON         H.furid = F.id " .
                    "INNER JOIN jockeys J " . 
                    "ON         R.jockeyid=J.id " . 
                    "INNER JOIN trainers T " . 
                    "ON         R.trainerid=T.id " . 
                    "WHERE      R.id=" . $racer->id;
            if (!$rs2 = $db->query($sql2))
                badEnd("500", array("sql"=>$sql2, "msg"=>$db->error));
            if (!$row2 = $rs2->fetch_assoc()){
                badEnd("500", array("sql"=>$sql2, "msg"=>"No se consiguió el corredor " . $racer->id));
            }

            // calcular historia del caballo
            $sql3 = "SELECT     RE.date, DATE_FORMAT(RE.date, '%d-%m-%y') datefmt, " .
                    "           C.id racecourseid, C.dsc racecoursename, C.abbr racecourseabbr, " .
                    "           RA.number racenumber, RA.serie, " .
                    "           R.weight, R.position, R.pos400, R.pos800, R.dividends, R.finishtime, " . 
                    "           IFNULL(R.arrivalposition,0) arrivalposition, IFNULL(R.jockeyweight,0) jockeyweight, " .
                    "           D.id distanceid, D.dsc distancename, " . 
                    "           R.jockeyid, CONCAT(J.names, ' ', J.lastnames) jockeydsc, J.abbr jockeyabbr, " .
                    "           IFNULL(B.id,'') bodiesid, IFNULL(B.dsc,'') bodiesdsc, IFNULL(B.abbr,'') bodiesabbr, IFNULL(B.value,'') bodiesvalue, " .
                    "           IFNULL(R.horseid, 0) winnerid, IFNULL(H.dsc, '') winnerdsc, IFNULL(RR.finishtime, 0) winnertime, " .
                    "           IFNULL(RC.horsenmbr, 0) horsenumber " .
                    "FROM       racers R " .
                    "INNER JOIN races RA " . 
                    "ON         R.raceid = RA.id " . 
                    "INNER JOIN reunions RE " . 
                    "ON         RA.reunionid = RE.id " . 
                    "INNER JOIN racecourses C " .
                    "ON         RE.racecourseid = C.id " . 
                    "INNER JOIN distances D " . 
                    "ON         RA.distanceid = D.id " . 
                    "INNER JOIN jockeys J " .
                    "ON         R.jockeyid = J.id " . 
                    "LEFT JOIN  bodies B " .
                    "ON         R.bodiesid = B.id " .
                    "LEFT JOIN  (" .
                    "            SELECT			RA.raceid, MIN(RA.horseid) horseid, Ra.finishtime " .
                    "            FROM			racers RA  " .
                    "            INNER JOIN		( " .
                    "            SELECT			R.raceid, MIN(R.finishtime) finishtime " .
                    "            FROM			racers R  " .
                    "            INNER JOIN		races RR " .
                    "            ON              R.raceid = RR.id " .
                    "            WHERE			RR.status>1 " .
                    "            AND			R.retirementid IS NULL " .
                    "            GROUP BY		R.raceid " .
                    "                            ) RR " .
                    "            ON				RA.raceid=RR.raceid " .
                    "            AND				RA.finishtime=RR.finishtime " .
                    "            GROUP BY		RA.raceid,RA.finishtime " .
                    "           ) RR " . 
                    "ON         R.raceid = RR.raceid " . 
                    "LEFT JOIN  horses H " .
                    "ON         RR.horseid = H.id " . 
                    "LEFT JOIN  ( " .
                    "           SELECT      raceid, COUNT(*) horsenmbr " .
                    "           FROM        racers " .
                    "           GROUP BY    raceid " .
                    "           ) RC " .
                    "ON         R.raceid = RC.raceid " . 
                    "WHERE      R.horseid = " . $row2["horseid"] . " " . 
                    "AND        RA.id <> " . $row["id"] . " " .
                    "AND        RA.status = 2 " .
                    "ORDER BY   RE.date DESC " . 
                    "LIMIT      4";
            // Se sustituye por una vista que hace lo mismo
            $sql3 = "SELECT     * " . 
                    "FROM       wrk_horsehistory " . 
                    "WHERE      horseid = " . $row2["horseid"] . " " . 
                    "AND        raceid <> " . $row["id"] . " " .
                    "AND        date < '" . $reuniondate . "' " . 
                    "ORDER BY   date DESC " .
                    "LIMIT 4";
            if (!$rs3 = $db->query($sql3))
                badEnd("500", array("sql"=>$sql3, "msg"=>$db->error));
            $records = array();
            while ($row3 = $rs3->fetch_assoc()){
                $record = new stdClass;
                $record->date = new stdClass;
                $record->date->date = $row3["date"];
                $record->date->formatted = $row3["datefmt"];
                $record->racecourse = new stdClass;
                $record->racecourse->id = (integer) $row3["racecourseid"];
                $record->racecourse->name = $row3["racecoursename"];
                $record->racecourse->abbr = $row3["racecourseabbr"];
                $record->racenumber = new stdClass;
                $record->racenumber->number = (integer) $row3["racenumber"];
                $record->racenumber->formatted = str_pad($record->racenumber->number, 3, '0', STR_PAD_LEFT);
                $record->weight = new stdClass;
                $record->weight->number = (float) $row3["weight"];
                $record->weight->formatted = number_format($record->weight->number, 0, ",", ".");
                $record->distance = new stdClass;
                $record->distance->id = (integer) $row3["distanceid"];
                $record->distance->name = $row3["distancename"];
                $record->position = (integer) $row3["position"];
                $record->pos400 = new stdClass;
                $record->pos400->number = (float) $row3["pos400"];
                $record->pos400->formatted = number_format($record->pos400->number, 2, ",", ".");
                $record->pos800 = new stdClass;
                $record->pos800->number = (float) $row3["pos800"];
                $record->pos800->formatted = number_format($record->pos800->number, 2, ",", ".");
                $record->arrivalposition = (integer) $row3["arrivalposition"];
                $record->jockey = new stdClass;
                $record->jockey->id = (integer) $row3["jockeyid"];
                $record->jockey->name = $row3["jockeydsc"];
                $record->jockey->abbr = $row3["jockeyabbr"];
                $record->jockey->weight = $row3["jockeyweight"];
                $record->dividends = new stdClass;
                $record->dividends->number = (float) $row3["dividends"];
                $record->dividends->formatted = number_format($record->dividends->number, 2, ",", ".");
                $record->winner = new stdClass;
                $record->winner->id = (integer) $row3["winnerid"];
                $record->winner->name = $row3["winnerdsc"];
                $record->winner->time = new stdClass;
                $record->winner->time->number = (float) $row3["winnertime"]; 
                $record->winner->time->formatted = number_format($record->winner->time->number, 2, ",", ".");
                $record->bodies = new stdClass;
                $record->bodies->id = (integer) $row3["bodiesid"];
                $record->bodies->name = $row3["bodiesdsc"];
                $record->bodies->abbr = $row3["bodiesabbr"];
                $record->bodies->value = (float) $row3["bodiesvalue"];
                $record->serie = $row3["serie"];
                $record->finishtime = new stdClass;
                $record->finishtime->number = (float) $row3["finishtime"]; 
                $record->finishtime->formatted = number_format($record->finishtime->number, 2, ",", ".");
                $record->numberofhorses = (integer) $row3["horsenumber"];

                $records[] = $record;
            }


            // fin calculo de historia

            $racersfmt[] = array(
                                    "id"=>$racer->id,
                                    "number"=>$racer->number,
                                    "horse"=>array( "id"=>(integer)$row2["horseid"],
                                                    "name"=>$row2["horsename"],
                                                    "obs"=>$row2["obs"],
                                                    "gender"=>$row2["gender"],
                                                    "age"=>(integer)$row2["age"],
                                                    "fur"=>$row2["fur"]
                                    ),
                                    "jockey"=>array("id"=>(integer)$row2["jockeyid"],
                                                    "name"=>$row2["jockeyname"],
                                                    "abbr"=>$row2["jockeyabbr"],
                                                    "weight"=>$row2["jockeyweight"]
                                    ),
                                    "trainner"=>array("id"=>(integer)$row2["trainnerid"],
                                                    "name"=>$row2["trainnername"],
                                                    "abbr"=>$row2["trainnerabbr"]
                                    ),
                                    "forecast"=>$racer->forecast,
                                    "comment"=>$racer->comment,
                                    "arrivalposition"=>$racer->arrivalposition,
                                    "records"=>$records
                                );
            

        }
        $entry->racers = $racersfmt;

        $entry->created = new stdClass;
        $entry->created->date = $row["created"];
        $entry->created->formatted = $row["createdfmt"];
        $entry->modified = new stdClass;
        $entry->modified->date = $row["modified"];
        $entry->modified->formatted = $row["modifiedfmt"];
    }else{
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }

    $out->entry = $entry;

    $access = array();
    $access["update"] =  tienePrivilegio($db, $sessionid, 810);
    $access["read"] =    tienePrivilegio($db, $sessionid, 811);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>