<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("id", "sessionid", "name", "abbr", "statusid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $dsc = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["name"]);
    $abbr = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["abbr"]);
    $statusid = intval($_REQUEST["statusid"]);

    if($statusid!=0 && $statusid!=1)
        badEnd("400", array("msg"=>"El parámetro statusid puede ser 0 o 1"));

    isSessionValid($db, $sessionid);

    if ($id==0){    // incluir registro
        if (!tienePrivilegio($db, $sessionid, 572, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        // validación de campos únicos para evitar el salto del autoincement XP
        $sql =  "SELECT id " .
                "FROM   retirements " . 
                "WHERE  abbr='" . $abbr . "' " .
                "OR     dsc='" . $dsc . "' ";
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        if ($row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Registro Duplicado"));
            
        $sql =  "INSERT INTO retirements " .
                "       (dsc, abbr, status) " .
                "VALUES (" .
                "        '" . $dsc . "'," .
                "        '" . $abbr . "'," .
                "        '" . $statusid . "' " .
                "        )";
        if (!$db->query($sql)){
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("msg"=>$db->error));
            }
        }

        $id = $db->insert_id;

        $dsc = substr($dsc, 0, 20);
        if (strlen($dsc) == 20)
            $dsc = substr($dsc, 0, 17) . "...";
        
        setAudit($db, "Motivos de Retiro", $sessionid, "Se incluyó el motivo \'" . $dsc . "\' (" . $id . ")");
    }else{          // modificar registro
        if (!tienePrivilegio($db, $sessionid, 571, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "UPDATE retirements " .
                "SET    dsc = '" . $dsc . "'," .
                "       abbr = '" . $abbr . "', " .
                "       status = '" . $statusid . "' " .
                "WHERE  id=" . $id;
        if (!$db->query($sql))
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
            }
            
        $dsc = substr($dsc, 0, 20);
        if (strlen($dsc) == 20)
            $dsc = substr($dsc, 0, 17) . "...";

        setAudit($db, "Motivos de Retiro", $sessionid, "Se actualizó el motivo \'" . $dsc . "\' (" . $id . ")");
    }

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>