<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("id", "sessionid", "name", "abbr", "typeid", "statusid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $name = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["name"]);
    $abbr = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["abbr"]);
    $typeid = preg_replace("/[^IM]+/", "", $_REQUEST["typeid"]);
    $statusid = intval($_REQUEST["statusid"]);

    if($statusid!=0 && $statusid!=1)
        badEnd("400", array("msg"=>"El parámetro statusid puede ser 0 o 1"));
    if($typeid!="M" && $typeid!="I")
        badEnd("400", array("msg"=>"El parámetro typeid puede ser 'I' o 'M'"));

    isSessionValid($db, $sessionid);

    if ($id==0){    // incluir registro
        if (!tienePrivilegio($db, $sessionid, 512, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "INSERT INTO implements " .
                "       (dsc, abbr, type, status) " .
                "VALUES (" .
                "        '" . $name . "'," .
                "        '" . $abbr . "'," .
                "        '" . $typeid . "', " .
                "        '" . $statusid . "' " .
                "        )";
        if (!$db->query($sql)){
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("msg"=>$db->error));
            }
        }

        $id = $db->insert_id;
        
        setAudit($db, "Implementos", $sessionid, "Se incluyó el implemento \'" . $name . "\' (" . $id . ")");
    }else{          // modificar registro
        if (!tienePrivilegio($db, $sessionid, 511, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "UPDATE implements " .
                "SET    dsc = '" . $name . "'," .
                "       abbr = '" . $abbr . "', " .
                "       type = '" . $typeid . "', " .
                "       status = '" . $statusid . "' " .
                "WHERE  id=" . $id;
        if (!$db->query($sql))
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
            }
            
        setAudit($db, "Implementos", $sessionid, "Se actualizó el implemento \'" . $name . "\' (" . $id . ")");

    }

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>