<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("id", "code", "sessionid", "dsc", "abbr", "typeid", "horsetypeid", "serie", "statusid", "category");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $category = intval($_REQUEST["category"]);
    $code = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["code"]);
    $dsc = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["dsc"]);
    $abbr = preg_replace("/[^a-zA-Z0-9 .\-+*áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["abbr"]);
    $serie = trim($_REQUEST["serie"]);
    if ($serie != "_")
        $serie = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["serie"]);
    $typeid = preg_replace("/[^12]+/", "", $_REQUEST["typeid"]);
    $horsetypeid = (integer) $_REQUEST["horsetypeid"];
    $statusid = intval($_REQUEST["statusid"]);

    if($statusid!=0 && $statusid!=1)
        badEnd("400", array("msg"=>"El parámetro statusid puede ser 0 o 1"));
    if($typeid!=1 && $typeid!=2)
        badEnd("400", array("msg"=>"El parámetro typeid puede ser 1 o 2"));
    if($typeid==1 && $serie=="_")
        badEnd("400", array("msg"=>"La serie no puede estar en blanco para el tipo de condicion 1"));
    if($serie=="_")
        $serie = "";

    isSessionValid($db, $sessionid);

    if ($id==0){    // incluir registro
        if (!tienePrivilegio($db, $sessionid, 522, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "INSERT INTO conditions " .
                "       (dsc, code, abbr, typeid, horsetypeid, serie, status, cat) " .
                "VALUES (" .
                "        '" . $dsc . "'," .
                "        '" . $code . "'," .
                "        '" . $abbr . "'," .
                "        '" . $typeid . "', " .
                "        '" . $horsetypeid . "'," .
                "        '" . $serie . "'," .
                "        '" . $statusid . "', " .
                "        '" . $category . "' " .
                "        )";
        if (!$db->query($sql)){
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("msg"=>$db->error));
            }
        }

        $id = $db->insert_id;

        $dsc = substr($dsc, 0, 20);
        if (strlen($dsc) == 20)
            $dsc = substr($dsc, 0, 17) . "...";
        
        setAudit($db, "Condiciones", $sessionid, "Se incluyó la condición \'" . $dsc . "\' (" . $id . ")");
    }else{          // modificar registro
        if (!tienePrivilegio($db, $sessionid, 521, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "UPDATE conditions " .
                "SET    dsc = '" . $dsc . "'," .
                "       code = '" . $code . "', " .
                "       abbr = '" . $abbr . "', " .
                "       typeid = '" . $typeid . "', " .
                "       horsetypeid = '" . $horsetypeid . "', " .
                "       serie = '" . $serie . "', " .
                "       cat = '" . $category . "', " .
                "       status = '" . $statusid . "' " .
                "WHERE  id=" . $id;
        if (!$db->query($sql))
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
            }
            
        $dsc = substr($dsc, 0, 20);
        if (strlen($dsc) == 20)
            $dsc = substr($dsc, 0, 17) . "...";

        setAudit($db, "Condiciones", $sessionid, "Se actualizó la condición \'" . $dsc . "\' (" . $id . ")");

    }

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>