<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga con GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));

    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $id = (integer) $_REQUEST["id"];
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 560, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
        $sql =  "SELECT     B.id, B.dsc, B.abbr, B.value, B.status, " . 
                "           B.createdat created, DATE_FORMAT(B.createdat, '%d/%m/%Y %h:%i %p') createdfmt, " .
                "           B.modifiedat modified, DATE_FORMAT(B.modifiedat, '%d/%m/%Y %h:%i %p') modifiedfmt " .
                "FROM       bodies B " .
                "WHERE      B.id=  " . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    $out = new stdClass;
    if ($row = $rs->fetch_assoc()){
        $entry = new stdClass;
        $entry->id = (integer) $row["id"];
        $entry->name = $row["dsc"];
        $entry->abbr = $row["abbr"];
        $entry->value = new stdClass;
        $entry->value->number = (float) $row["value"];
        $entry->value->formatted = number_format($entry->value->number, 4, ",", ".");
        $entry->status = new stdClass;
        $entry->status->id = (integer) $row["status"];
        $entry->status->name = $entry->status->id==0 ? "Inactivo" : "Activo";
        $entry->created = new stdClass;
        $entry->created->date = $row["created"];
        $entry->created->formatted = $row["createdfmt"];
        $entry->modified = new stdClass;
        $entry->modified->date = $row["modified"];
        $entry->modified->formatted = $row["modifiedfmt"];
    }else{
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }

    $out->entry = $entry;

    $access = array();
    $access["create"] = tienePrivilegio($db, $sessionid, 562);
    $access["delete"] = tienePrivilegio($db, $sessionid, 563);
    $access["update"] = tienePrivilegio($db, $sessionid, 561);
    $access["read"] =   tienePrivilegio($db, $sessionid, 560);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>