<?php
    require '../../../hooks/autoload.php';
    use \PhpOffice\PhpWord\PhpWord;
    use \PhpOffice\PhpWord\SimpleType\Border;

    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));
    // parametros obligatorios
    $parmsob = array("reunionid", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $reunionid = intval($_REQUEST["reunionid"]);

    $outputformat = "docx";
    if (isset($_REQUEST["format"]))
        $outputformat = preg_replace("/[^docxpf]+/", "", strtolower($_REQUEST["format"]));
    if ($outputformat != "docx" && $outputformat != "pdf" )
        badEnd("500", array("msg"=>"Los formatos validos son 'pdf' y 'docx"));

    isSessionValid($db, $sessionid);

    // conseguir fecha e hipodromo de la reunión
    $sql =  "SELECT 	YEAR(R.date) year, R.number, LPAD(MIN(R.number), 3, '0') num, R.date, R.racecourseid, H.abbr rcabbr, H.abbr racecourseabbr, H.dsc, DAYOFWEEK(R.date) dow " . 
            "FROM 		reunions R  " . 
            "INNER JOIN racecourses H  " . 
            "ON         R.racecourseid = H.id  " . 
            "WHERE      R.id = " . $reunionid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $dow = ["D", "L", "M", "X", "J", "V", "S"];
    $year = $row["year"];
    $dayletter = $dow[$row["dow"]-1];
    $racecourse = $row["dsc"];
    $reunionnumber = $row["number"];
    $racecourseabbr = $row["racecourseabbr"];
    $rcabbr = $row["rcabbr"];

    //obtener primera carrera de la reunión para efectos del nombre
    $filename = "G" . $rcabbr . "RG" . $row["num"] . "." . $outputformat;
    
    $cyan = "00AEEF";

    $sql =  "SELECT	    RE.number reunionnumber, T.dsc racecoursetype, " .
            "           DAYOFWEEK(RE.date) dow, " .
            "           DAY(RE.date) day, " .
            "           MONTH(RE.date) month, " .
            "           YEAR(RE.date) year, " .
            "           RA.number racenumber, 0 variante, " .
            "           DI.dsc distance, " .
            "           MAX(IF(R.arrivalposition=1, CONCAT(R.position, '-', UPPER(H.dsc), ' (', B.abbr, 'c.)\t', R.jockeyweight), '')) PRIMERO, " .
            "           MAX(IF(R.arrivalposition=2, CONCAT(UPPER(H.dsc), ' (', B.abbr, 'c.)\t', R.jockeyweight), '')) SEGUNDO, " .
            "           MAX(IF(R.arrivalposition=3, CONCAT(UPPER(H.dsc), ' (', B.abbr, 'c.)\t', R.jockeyweight), '')) TERCERO, " .
            "           MAX(IF(R.arrivalposition=4, CONCAT(UPPER(H.dsc), ' (', B.abbr, 'c.)\t', R.jockeyweight), '')) CUARTO, " .
            "           MAX(IF(R.arrivalposition=5, CONCAT(UPPER(H.dsc), ' (', B.abbr, 'c.)\t', R.jockeyweight), '')) QUINTO, " .
            "           IFNULL(RA.times400, '{\"distances\":[{\"400\":0},{\"800\":0}],\"finalsprint\":0}') times400, " .
            "           IFNULL(RA.finishtime,0) finishtime, " .
            "           RA.serie " .
            "FROM		reunions RE  " .
            "INNER JOIN races RA  " .
            "ON			RE.id=RA.reunionid " .
            "INNER JOIN racecoursetypes T " . 
            "ON         RA.racecoursetypeid=T.id " . 
            "INNER JOIN distances DI  " .
            "ON			RA.distanceid=DI.id " .
            "INNER JOIN racers R  " .
            "ON			RA.id=R.raceid " .
            "INNER JOIN horses H  " .
            "ON			R.horseid=H.id " .
            "INNER JOIN bodies B  " .
            "ON			R.bodiesid=B.id " .
            "WHERE		RE.number BETWEEN " . $reunionnumber-5 . " AND " . $reunionnumber-1 . " " .
            "AND		YEAR(RE.date) = '" . $year . "' " .
            "AND		R.arrivalposition BETWEEN 1 AND 5 " .
            "GROUP BY   RE.number, T.dsc, " .
            "           RE.date, " .
            "           RA.number, " .
            "           DI.dsc, " .
            "           RA.times400, " .
            "           IFNULL(RA.finishtime,0), " .
            "           RA.serie " .
            "ORDER BY	RA.number";

    // calcular primera y ultima carrera
    $sql2 =     "SELECT     MIN(A.racenumber) minracenumber, MAX(A.racenumber) maxracenumber " . 
                "FROM       (" . $sql . ") A";
    if (!$rs2 = $db->query($sql2))
        badEnd("500", array("sql"=>$sql2, "msg"=>$db->error));
    $minracenumber = "--";
    $maxracenumber = "--";
    if ($row = $rs2->fetch_assoc()){
        $minracenumber = $row["minracenumber"];
        $maxracenumber = $row["maxracenumber"];
    }

    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    // Creating the new document...
    $phpWord = new PhpWord();

    $pulgada = 1440;
    $height = 8.07*$pulgada;  // 1440 twip = 1 pulgada
    $width = 5.32*$pulgada;
    $top = 0;
    $bottom = 0;
    $left = 0;
    $right = 0;
    $columnspaces = 0;
    $blank = chr(194) . chr(160);

    $section = $phpWord->addSection([
        "marginTop"=>$top,
        "marginBottom"=>$bottom,
        "marginLeft"=>$left,
        "marginRight"=>$right,
        "pageSizeH"=>$height,
        "pageSizeW"=>$width,
        "breakType"=>"continuous"
    ]);

    // TITULO
        $table = $section->addTable([
            "width" => $width,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "cellSpacing" => $columnspaces,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
        ]);
        $table->addRow();
        $cell = $table->addCell($width/3,[
                            "borderSize" => 0,
                            "borderStyle" => Border::NONE,
                            "bgColor" => "CECECE",
                            "valign" => "center"
                            ]
                );
        $cell->addText("Retrospecto General",[
            "name"=>"Univers 65",
            "size"=>10,
            "allCaps"=>false,
            "bold"=>false,
            "color"=>"000000"
        ],[
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT, 
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);

        $cell = $table->addCell($width/3,[
                            "borderSize" => 0,
                            "borderStyle" => Border::NONE,
                            "bgColor" => "CECECE",
                            "valign" => "center"
                            ]
                );
        $cell->addText("Carreras " . 
                        $racecourseabbr . "-" . $minracenumber . " - " . 
                        $racecourseabbr . "-" . $maxracenumber,[
            "name"=>"Univers 55",
            "scale"=>100,
            "size"=>9,
            "allCaps"=>false,
            "bold"=>false,
            "color"=>"000000"
        ],[
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER, 
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);

        $cell = $table->addCell($width/3,[
                            "borderSize" => 0,
                            "borderStyle" => Border::NONE,
                            "bgColor" => "CECECE",
                            "valign" => "center"
                            ]
                );
        $cell->addText($racecourse,[
            "name"=>"Univers 65",
            //"scale"=>120,
            "size"=>10,
            "allCaps"=>true,
            "bold"=>false,
            "color"=>"000000"
        ],[
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT, 
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);
    // FIN TITULO

    // HEADERS
        $columnspaces = 10;
        $table = $section->addTable([
            "width" => $width,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "cellSpacing" => $columnspaces,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
        ]);
        $table->addRow();
        
        $colwidth = ($width/7)*0.6;
        $cell = $table->addCell($colwidth,[
                            "borderSize" => 1,
                            "borderColor" => "000000",
                            "valign" => "center"
                            ]
                );
        $cell->addText("N°\tDist",[
            "name"=>"Univers 55",
            "scale"=>100,
            "size"=>4,
            "allCaps"=>false,
            "bold"=>false,
            "color"=>"000000"
        ],[
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT, 
            "spaceBefore"=>0,
            "spaceAfter"=>0,
            "tabs" => [
                new \PhpOffice\PhpWord\Style\Tab('left', ($colwidth-($columnspaces/2))/2)
            ]
        ]);

        $titulo = ["PRIMERO", "SEGUNDO", "TERCERO", "CUARTO", "QUINTO"];
        for ($i=0; $i<5; $i++){
            $colwidth = $width/7;
            $cell = $table->addCell($colwidth,[
                                "borderSize" => 1,
                                "borderColor" => "000000",
                                "valign" => "center"
                                ]
                    );
            $cell->addText($titulo[$i],[
                "name"=>"Univers 55",
                "scale"=>100,
                "size"=>4,
                "allCaps"=>false,
                "bold"=>false,
                "color"=>"000000"
            ],[
                "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER, 
                "spaceBefore"=>0,
                "spaceAfter"=>0,
            ]);
        }

        $colwidth = ($width/7)*1.4;
        $cell = $table->addCell($colwidth,[
                            "borderSize" => 1,
                            "borderColor" => "000000",
                            "valign" => "center"
                            ]
                );
        $cell->addText("PARCIALES\tREM\tTPO\tSerie",[
            "name"=>"Univers 55",
            "scale"=>100,
            "size"=>4,
            "allCaps"=>false,
            "bold"=>false,
            "color"=>"000000"
        ],[
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT, 
            "spaceBefore"=>0,
            "spaceAfter"=>0,
            "tabs" => [
                //new \PhpOffice\PhpWord\Style\Tab('left', $colwidth/5),
                new \PhpOffice\PhpWord\Style\Tab('left', $colwidth/5*2),
                new \PhpOffice\PhpWord\Style\Tab('left', $colwidth/5*3),
                new \PhpOffice\PhpWord\Style\Tab('left', $colwidth/5*4),
            ]
        ]);
    // FIN HEADERS

    // DETALLES
        $actualreunion = "0";
        while ($row = $rs->fetch_assoc()){
            // TITULOS DE CARRERA
            if ($actualreunion != $row["reunionnumber"]){
                if ($actualreunion != "0"){
                    // Espacio antes del titulo
                    $table->addRow();
                    $cell = $table->addCell($colwidth,[
                        "gridSpan" => 7,
                        "borderSize" => 0,
                        "borderStyle" => Border::NONE,
                        "valign" => "center"
                        ]
                    );
                    $cell->addText($blank,
                    ["size"=>5],["spaceBefore"=>0,"spaceAfter"=>0]);
                }
                
                $actualreunion = $row["reunionnumber"];
                // calculate date
                $dow = ["DOMINGO", "LUNES", "MARTES", "MIÉRCOLES", "JUEVES", "VIERNES", "SÁBADO"];
                $monthname = ["ENERO", "FEBRERO", "MARZO", "ABRIL", "MAYO", "JUNIO", "JULIO", "AGOSTO", "SEPTIEMBRE", "OCTUBRE", "NOVIEMBRE", "DICIEMBRE"];
                $fulldate = $dow[$row["dow"]-1] . ", " . $row["day"] . " DE " . $monthname[$row["month"]-1] . " DE " . $row["year"]; 
                $columnspaces = 0;
                $indent = 20;
                $table = $section->addTable([
                    "width" => $width,
                    "borderSize" => 0,
                    "borderStyle" => Border::NONE,
                    "cellSpacing" => $columnspaces,
                    "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
                ]);
                $table->addRow();
                
                $colwidth = $width;
                $cell = $table->addCell($colwidth,[
                                    "borderSize" => 8,
                                    "borderColor" => "000000",
                                    "valign" => "center"
                                    ]
                        );
                $cell->addText($actualreunion . "° DIA DE CARRERAS" . 
                                "\tPISTA " . mb_strtoupper($row["racecoursetype"]) . " (Variante " . $row["variante"] . ")" . 
                                "\t" . $fulldate
                ,[
                    "name"=>"Times New Roman",
                    "scale"=>100,
                    "size"=>5,
                    "allCaps"=>false,
                    "bold"=>false,
                    "color"=>$cyan
                ],[
                    "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT, 
                    'indentation' => ['left' => $indent],
                    "spaceBefore"=>0,
                    "spaceAfter"=>0,
                    "tabs" => [
                        new \PhpOffice\PhpWord\Style\Tab('left', $colwidth/4),
                        new \PhpOffice\PhpWord\Style\Tab('right', $colwidth-$indent*2-8)
                    ]
                ]);

                // Espacio después del titulo
                $table->addRow();
                $cell = $table->addCell($colwidth,[
                    "gridSpan" => 7,
                    "borderSize" => 0,
                    "borderStyle" => Border::NONE,
                    "valign" => "center"
                    ]
                );
                $cell->addText($blank,
                ["size"=>5],["spaceBefore"=>0,"spaceAfter"=>0]);
          }
          // DETALLES
            $columnspaces = 0;
            $table = $section->addTable([
                "width" => $width,
                "borderSize" => 0,
                "borderStyle" => Border::NONE,
                "cellSpacing" => $columnspaces,
                "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            ]);
            $table->addRow();
            
            $colwidth = ($width/7)*0.6;
            $cell = $table->addCell($colwidth,[
                                "borderSize" => 0,
                                "borderStyle" => Border::NONE,
                                "valign" => "center"
                                ]
                    );
            $cell->addText($racecourseabbr . $row["racenumber"] . "\t" . $row["distance"],[
                //"name"=>"Univers 47 Condensed Light",
                "name"=>"Univers 55",
                "scale"=>65,
                "spacing"=>-8,
                //"size"=>3.5,
                "size"=>6,
                "allCaps"=>false,
                "bold"=>false,
                "color"=>"000000"
            ],[
                "spacing" => -0,
                "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT, 
                "spaceBefore"=>0,
                "spaceAfter"=>0,
                "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('left', (($colwidth-($columnspaces/2))/2))
                ]
            ]);

            $titulo = ["PRIMERO", "SEGUNDO", "TERCERO", "CUARTO", "QUINTO"];
            for ($i=0; $i<5; $i++){
                $colwidth = $width/7; // XXX
                $cell = $table->addCell($colwidth,[
                                    "borderLeftSize" => 0,
                                    "borderLeftStyle" => Border::NONE,
                                    "borderTopSize" => 0,
                                    "borderTopStyle" => Border::NONE,
                                    "borderBottomSize" => 0,
                                    "borderBottomStyle" => Border::NONE,
                                    "borderRightSize" => 4,
                                    "valign" => "center"
                                    ]
                        );
                $print = $row[$titulo[$i]] == "" ? "--" : $row[$titulo[$i]];
                $cell->addText($print,[
                    //"name"=>"Univers 47 Condensed Light",
                    "name"=>"Univers 55",
                    "scale"=>65,
                    "spacing"=>-8,
                    "size"=>6,
                    "allCaps"=>false,
                    "bold"=>false,
                    "color"=>"000000"
                ],[
                    "spacing" => -0,
                    "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT, 
                    "spaceBefore"=>0,
                    "spaceAfter"=>0,
                    "tabs" => [
                        new \PhpOffice\PhpWord\Style\Tab('right', ($colwidth-($columnspaces*4))-30)
                    ]
                ]);
            }

            $colwidth = ($width/7)*1.4;
            $dsp = 128;
            $cell = $table->addCell($colwidth,[
                                "borderSize" => 0,
                                "borderStyle" => Border::NONE,
                                "valign" => "center"
                                ]
                    );
            $times = json_decode($row["times400"]);

            $cell->addText(
                        "\t" . number_format($times->distances[0]->{400}*1, 1, ",") .
                        "\t" . number_format($times->distances[1]->{800}*1, 1, ",") .
                        "\t" . number_format($times->finalsprint*1, 1, ",") .
                        "\t" . number_format($row["finishtime"]*1, 1, ",") .
                        "\t" . $row["serie"]
                ,[
                //"name"=>"Univers 47 Condensed Light",
                "name"=>"Univers 55",
                "scale"=>65,
                "spacing"=>-8,
                "size"=>6,
                "allCaps"=>false,
                "bold"=>false,
                "color"=>"000000"
                ],[
                "spacing" => -0,
                "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT, 
                "spaceBefore"=>0,
                "spaceAfter"=>0,
                "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('right', $colwidth/5-$dsp),
                    new \PhpOffice\PhpWord\Style\Tab('right', $colwidth/5*2-$dsp),
                    new \PhpOffice\PhpWord\Style\Tab('right', $colwidth/5*3-$dsp),
                    new \PhpOffice\PhpWord\Style\Tab('right', $colwidth/5*4-$dsp),
                    new \PhpOffice\PhpWord\Style\Tab('right', $colwidth-$dsp/2),
                ]
            ]);
          // FIN DETALLES
        }
    // FIN DETALLES

    switch ($outputformat){
        case "pdf":
            $domPdfPath = realpath(__DIR__ . '/../../../hooks/Dompdf/Dompdf');
            \PhpOffice\PhpWord\Settings::setPdfRendererPath($domPdfPath);
            \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
            
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord , 'PDF');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        case "docx":
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        default:
            die ("FORMATO DE SALIDA INVALIDO");
    }

    header("Content-Disposition: attachment; filename=" . $filename);
    readfile($temp_file); // or echo file_get_contents($temp_file);
    unlink($temp_file);
?>