<?php
    require '../../../hooks/autoload.php';
    use \PhpOffice\PhpWord\PhpWord;
    use \PhpOffice\PhpWord\SimpleType\Border;

    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));
    // parametros obligatorios
    $parmsob = array("reunionid", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $reunionid = intval($_REQUEST["reunionid"]);

    $outputformat = "docx";
    if (isset($_REQUEST["format"]))
        $outputformat = preg_replace("/[^docxpf]+/", "", strtolower($_REQUEST["format"]));
    if ($outputformat != "docx" && $outputformat != "pdf" )
        badEnd("500", array("msg"=>"Los formatos validos son 'pdf' y 'docx"));

    isSessionValid($db, $sessionid);

    $pulgada = 1440;
    $height = 8.00*$pulgada;  // 1440 twip = 1 pulgada
    $width = 5.32*$pulgada;
    $top = 0;
    $bottom = 0;
    $left = 0;
    $right = 0;

    // conseguir hipodromo actual
    $sql = "SELECT racecourseid, YEAR(date) year FROM reunions WHERE id=" . $reunionid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $racecourseid = $row["racecourseid"];
    $actualyear = $row["year"];

    // conseguir fecha e hipodromo de la reunión anterior
    $sql =  "SELECT 	R.id reunionid, R.date, R.racecourseid, H.dsc, DAYOFWEEK(R.date) dow, " .
            "           DATE_FORMAT(R.date, '%d-%m-%y') datefmt, RA.minrace, RA.maxrace, H.abbr rcabbr " .
            "FROM 		(SELECT reunionid, MAX(number) maxrace, MIN(number) minrace FROM races GROUP BY reunionid) RA " .
            "INNER JOIN reunions R " .
            "ON         RA.reunionid = R.id " .
            "INNER JOIN racecourses H " .
            "ON         R.racecourseid = H.id " .
            "WHERE      R.id = " .
            "          (SELECT  MAX(id) maxid " . 
            "           FROM    reunions " . 
            "           WHERE   id<" . $reunionid . " " . 
            "           AND     racecourseid = " . $racecourseid .
            "          ) ";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if ($row = $rs->fetch_assoc()){
        //badEnd("409", array("msg"=>"La reunión anterior no tiene carreras registradas o no existe"));
        $racecourse = $row["dsc"];
        $rcabbr = $row["rcabbr"];
        $reunionid = $row["reunionid"];
        $dowreunion = $row["dow"];
        $datereunion = $row["datefmt"];
        $minrace = $row["minrace"];
        $maxrace = $row["maxrace"];

        //obtener primera carrera de la reunión para efectos del nombre
        $sql =  "SELECT LPAD(MIN(number), 3, '0') num FROM races WHERE reunionid=" . $reunionid;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if (!$row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Reunion no encontrada"));
        $filename = "G" . $rcabbr . "RS" . $row["num"] . "." . $outputformat;

        $sql =  "SELECT		RA.id raceid, RA.number racenumber, D.dsc distance, R.finishtime, " .
                "           RA.racetypeid, RT.dsc racetype, RA.valid, RA.serie, RA.mainprice, H.id horseid, IF(R.stumbleid IS NULL, '', T.abbr) trop, IFNULL(R.retirementid, '') ret, " .
                "           R.arrivalposition, H.dsc horsename, B.abbr bodies, R.jockeyweight, " .
                "           J.abbr jockeyname, R.pos400, R.pos800, R.position, R.dividends, ROUND(R.speedr,2) speedr, " . 
                "           IFNULL(RA.betprices, '') betprices, IFNULL(RA.times400,'') times400, IFNULL(implementstypeM, '') meds, IFNULL(implementstypeI, '') imps,  " . 
                "           H.fathername, H.mothername, S.dsc stud, F.abbr furabbr, H.gender, " . 
                "           TR.abbr trainername, HA.dsc haras " . 
                "FROM		racers R " .
                "INNER JOIN jockeys J " . 
                "ON         R.jockeyid=J.id " . 
                "INNER JOIN trainers TR " . 
                "ON         R.trainerid=TR.id " . 
                "INNER JOIN horses H " . 
                "ON         R.horseid=H.id " . 
                "INNER JOIN furs F " . 
                "ON         H.furid=F.id " . 
                "INNER JOIN haras HA " . 
                "ON         H.harasid=HA.id " . 
                "INNER JOIN	races RA " .
                "ON			R.raceid=RA.id " .
                "INNER JOIN	racetypes RT " .
                "ON			RA.racetypeid=RT.id " .
                "INNER JOIN bodies B " . 
                "ON         R.bodiesid=B.id " . 
                "INNER JOIN distances D " . 
                "ON         RA.distanceid=D.id " . 
                "INNER JOIN studs S " . 
                "ON         R.studid=S.id " . 
                "LEFT JOIN  stumbles T " . 
                "ON         R.stumbleid=T.id " . 
                "WHERE 		RA.reunionid=" . $reunionid . " " . 
                "ORDER BY	RA.number, IF(R.arrivalposition=0, IF(R.retirementid IS NOT NULL, 99, 98), R.arrivalposition)";
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

        $ordinal = ["1a.", "2a.", "3a.", "4a.", "5a.", "6a.", "7a.", "8a.", 
                    "9a.", "10a.", "11a.", "12a.", "13a.", "14a.", "15a.", "16a."];
        $dow = ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"];

        // Creating the new document...
        $phpWord = new PhpWord();

        $columnspaces = 0;
        $widthcarrera = ($width/2)-40;

        // colores
        $cyan = "00AEEF";
        $cyanlight = "C1EFFF";
        $bgGray = "CECECE";

        $blank = chr(194) . chr(160);

        // anchura de las columnas
        $C1 =  $widthcarrera * 0.06;
        $C2 =  $widthcarrera * 0.05;
        $C3 =  $widthcarrera * 0.24;
        $C4 =  $widthcarrera * 0.07;
        $C5 =  $widthcarrera * 0.04;
        $C6 =  $widthcarrera * 0.17;
        $C7 =  $widthcarrera * 0.06;
        $C8 =  $widthcarrera * 0.06;
        $C9 =  $widthcarrera * 0.07;
        $C10 = $widthcarrera * 0.10;
        $C11 = $widthcarrera * 0.07;

        // ESTILOS
        // Celdas
        $headerCellStyle = [
            //"gridSpan" => 2,
            "bgColor"=>$bgGray,
            "valign" => "center",
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
        ];
        $raceTopCellStyle = [
            "gridSpan" => 11,
            "valign" => "center",
            "borderTopSize" => 4,
            "borderBottomSize" => 0,
            "borderBottomStyle" => Border::NONE,
            "borderLeftSize" => 0,
            "borderLeftStyle" => Border::NONE,
            "borderRightSize" => 0,
            "borderRightStyle" => Border::NONE,
        ];
        $raceCellStyle = [
            "gridSpan" => 11,
            "valign" => "center",
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
        ];
        $raceHdrCellStyle = [
            "valign" => "center",
            "borderLeftSize" => 0,
            "borderLeftStyle" => Border::NONE,
            "borderRightSize" => 0,
            "borderRightStyle" => Border::NONE,
            "borderTopSize" => 4,
            "borderBottomSize" => 4,
        ];
        $raceDetCellStyle = [
            "valign" => "center",
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
        ];
        // Tablas
        $headerTableStyle = "headerTableStyle";
        $phpWord->addTableStyle($headerTableStyle,[
                "width" => $width,
                "borderSize" => 0,
                "borderStyle" => Border::NONE,
                "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
                "cellMargin" => 0,
                "cellSpacing" => 0,
            ],$headerCellStyle,$headerCellStyle);
        $raceTableStyle = "raceTableStyle";
        $phpWord->addTableStyle($raceTableStyle,[
                "width" => $widthcarrera,
                "borderSize" => 0,
                "borderStyle" => Border::NONE,
                "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
                "cellMargin" => 0,
                "cellSpacing" => 0,
            ],$raceCellStyle,$raceCellStyle);
        // Textos
        $mainHeaderText = "mainHeaderText";
        $phpWord->addFontStyle($mainHeaderText, [
            //"name"=>"Univers 75 Black",
            //"size"=>10,
            "name"=>"Univers 65",
            "size"=>11,
            //"scale" => 80,
            //"spacing"=>-15,
            "allCaps"=>true,
            "bold"=>false,
            "color"=>$cyan,
        ]);
        $mainHeaderPar = "mainHeaderPar";
        $phpWord->addParagraphStyle($mainHeaderPar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
            "spacing" =>1,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
            "tabs" => [
                new \PhpOffice\PhpWord\Style\Tab('left', 40),
                new \PhpOffice\PhpWord\Style\Tab('center', $width/2),
                new \PhpOffice\PhpWord\Style\Tab('right', $widthcarrera-40)
            ]
        ]);
        $raceHeaderText = "raceHeaderText";
        $phpWord->addFontStyle($raceHeaderText, [
            //"name"=>"Univers 67 Condensed Bold",
            //"size"=>8,
            "name"=>"Univers 65",
            "size"=>7,
            "scale" => 100,
            "spacing"=>-5,
            "allCaps"=>false,
            "bold"=>false,
            "color"=>"000000",
        ]);
        $raceHeaderPar = "raceHeaderPar";
        $phpWord->addParagraphStyle($raceHeaderPar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
            "spacing" =>0,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);
        $validRaceHeaderText = "validRaceHeaderText";
        $phpWord->addFontStyle($validRaceHeaderText, [
            "name"=>"Univers 75 Black",
            "size"=>6,
            "scale" => 120,
            "spacing"=>-5,
            "allCaps"=>false,
            "bold"=>false,
            "color"=>"000000",
        ]);
        $validRaceHeaderPar = "validRaceHeaderPar";
        $phpWord->addParagraphStyle($validRaceHeaderPar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
            "spacing" =>-20,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);
        $raceDataHeaderText = "raceDataHeaderText";
        $phpWord->addFontStyle($raceDataHeaderText, [
            "name"=>"Univers 65",
            "size"=>5,
            //"spacing"=>-10,
            "allCaps"=>false,
            "bold"=>false,
            "color"=>"000000",
        ]);
        $raceDataHeaderPar = "raceDataHeaderPar";
        $phpWord->addParagraphStyle($raceDataHeaderPar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
            "spacing" =>0,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);
        $raceHdrText = "raceHdrText";
        $phpWord->addFontStyle($raceHdrText, [
            "name"=>"Univers 65",
            "size"=>5,
            //"scale" => 90,
            //"spacing"=>-5,
            "allCaps"=>false,
            "bold"=>false,
            "color"=>"000000",
        ]);
        $raceDetText = "raceDetText";
        $phpWord->addFontStyle($raceDetText, [
            "name"=>"Univers 55",
            "size"=>4.95,
            "scale" =>100,
            "spacing"=>-10,
            "allCaps"=>false,
            "bold"=>false,
            "color"=>"000000",
        ]);
        $raceDetCtrPar = "raceDetCtrPar";
        $spacing = -30;
        $phpWord->addParagraphStyle($raceDetCtrPar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
            "spacing" =>$spacing,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);
        $raceDetLftPar = "raceDetLftPar";
        $phpWord->addParagraphStyle($raceDetLftPar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
            "spacing" =>$spacing,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);
        $raceDetRhtPar = "raceDetRhtPar";
        $phpWord->addParagraphStyle($raceDetRhtPar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT,
            "spacing" =>$spacing,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);
        $raceHdrCtrPar = "raceHdrCtrPar";
        $phpWord->addParagraphStyle($raceHdrCtrPar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
            "spacing" =>0,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);
        $raceHdrLftPar = "raceHdrLftPar";
        $phpWord->addParagraphStyle($raceHdrLftPar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
            "spacing" =>-5,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);
        $raceHdrRhtPar = "raceHdrRhtPar";
        $phpWord->addParagraphStyle($raceHdrRhtPar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT,
            "spacing" =>0,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);


        $detailFirstColText = "detailFirstColText";
        $phpWord->addFontStyle($detailFirstColText, [
            "name"=>"Helvetica",
            "size"=>12,
            "scale" => 80,
            "spacing"=>-15,
            "allCaps"=>false,
            "bold"=>false,
            "color"=>"000000",
        ]);
        $detailFirstColPar = "detailFirstColPar";
        $phpWord->addParagraphStyle($detailFirstColPar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
            "spacing" =>1,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);
        $detailHiddenText = "detailHiddenText";
        $phpWord->addFontStyle($detailHiddenText, [
            "name"=>"Arial",
            "size"=>1,
            "spacing"=>-10,
            "bold"=>false,
            "color"=>"FFFFFF",
        ]);
        $detailHiddenPar = "detailHiddenPar";
        $phpWord->addParagraphStyle($detailHiddenPar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
            "spacing" =>-10,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);
        $detailColText = "detailColText";
        $phpWord->addFontStyle($detailColText, [
            "name"=>"Univers 55",
            "size"=>5,
            "scale" => 80,
            "spacing"=>-10,
            "allCaps"=>true,
            "bold"=>false,
            "color"=>"000000",
        ]);
        $detailColWinnerText = "detailColWinnerText";
        $phpWord->addFontStyle($detailColWinnerText, [
            "name"=>"Univers 55",
            "size"=>5,
            "scale" => 80,
            "spacing"=>-10,
            "allCaps"=>true,
            "bold"=>true,
            "color"=>"000000",
        ]);
        $detailColPar = "detailColPar";
        $phpWord->addParagraphStyle($detailColPar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
            "spacing" =>-20,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
            "tabs" => [
                new \PhpOffice\PhpWord\Style\Tab('right', $widthcarrera-40)
            ]
        ]);
        $detailColFirstPar = "detailColFirstPar";
        $phpWord->addParagraphStyle($detailColFirstPar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
            "spacing" =>-20,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
            "tabs" => [
                new \PhpOffice\PhpWord\Style\Tab('center', $widthcarrera/4),
                new \PhpOffice\PhpWord\Style\Tab('center', $widthcarrera/2),
                new \PhpOffice\PhpWord\Style\Tab('center', $widthcarrera/4*3),
                new \PhpOffice\PhpWord\Style\Tab('right', $widthcarrera-40)
            ]
        ]);
        $detailColLastPar = "detailColLastPar";
        $phpWord->addParagraphStyle($detailColLastPar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
            "spacing" =>-20,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
            "tabs" => [
                //new \PhpOffice\PhpWord\Style\Tab('left', $widthcarrera/8*3),
                new \PhpOffice\PhpWord\Style\Tab('right', $widthcarrera-40)
            ]
        ]);
        $detailColWinnerPar = "detailColWinnerPar";
        $phpWord->addParagraphStyle($detailColWinnerPar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
            "spacing" =>-20,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
            "tabs" => [
                new \PhpOffice\PhpWord\Style\Tab('left', $widthcarrera/8),
                new \PhpOffice\PhpWord\Style\Tab('right', $widthcarrera-40),
            ]
        ]);
        $detailColHorseText = "detailColHorseText";
        $phpWord->addFontStyle($detailColHorseText, [
            "name"=>"Univers 75 Black",
            "size"=>10,
            "scale" => 120,
            "spacing"=>-10,
            "allCaps"=>true,
            "bold"=>true,
            "color"=>"000000",
        ]);
        $detailColHorsePar = "detailColHorsePar";
        $phpWord->addParagraphStyle($detailColHorsePar, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT,
            "spacing" =>1,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);

        // Página
        $head = $height; //*0.01995;
        $det = $height; //-$head;
        $section = $phpWord->addSection([
            "marginTop"=>$top,
            "marginBottom"=>$bottom,
            "marginLeft"=>$left,
            "marginRight"=>$right,
            "pageSizeH"=>$head,
            "pageSizeW"=>$width,
            "breakType"=>"continuous"
        ]);

        // Header
        $headertab = $section->addTable([$headerTableStyle]);
        $headertab->addRow();
        $cell = $headertab->addCell($width, $headerCellStyle);
        $cell->addText("\t" . $racecourse . "\tResultados del " . $dow[$dowreunion-1] . "  " . $datereunion . "\t(" . $minrace . " - " . $maxrace . ")",
                $mainHeaderText, $mainHeaderPar);

        $section = $phpWord->addSection([
            "colsNum"=>2,
            "colsSpace"=>0,
            "marginTop"=>$top,
            "marginBottom"=>$bottom,
            "marginLeft"=>$left,
            "marginRight"=>$right,
            "pageSizeH"=>$det,
            "pageSizeW"=>$width,
            "breakType"=>"continuous"
        ]);
        

        $actualrace = 0;
        $racecnt = 0;
        $distanceant = 0;
        $times400s = "";
        $lines = 0;
        while ($row = $rs->fetch_assoc()){
            if ($actualrace != $row["raceid"]){
                if ($actualrace != 0){
                    // imprimir lineas en blanco hasta llegar a 14 carreras
                    for ($i=14-$lines; $i>0; $i--){
                        $racetab->addRow();
                        $cell = $racetab->addCell($C1, $raceCellStyle);
                        $cell->addText($blank, $raceDetText, $raceDetLftPar);
                    }
                    // imprimir en el pie 
                    if ($addtitrow1){
                        $racetab->addRow();
                        $cell = $racetab->addCell($C1, $raceCellStyle);
                        $cell->addText($blank
                                    ,$validRaceHeaderText, $validRaceHeaderPar);
                    }
                    if ($addtitrow2){
                        $racetab->addRow();
                        $cell = $racetab->addCell($C1, $raceCellStyle);
                        $cell->addText($blank
                                    ,$validRaceHeaderText, $validRaceHeaderPar);
                    }
                    $timesdsc = "";
                    $finalsprint = "";
                    $lastdistance = 0;
                    if ($times400s!=""){
                        $times400 =  json_decode($times400s);
                        foreach ($times400->distances as $distance){
                            if ((array_keys((array)$distance)[0]*1) < ($distanceant)){
                                $timesdsc .= array_keys((array)$distance)[0] . " en " . array_values((array)$distance)[0] . "   -   ";
                                $lastdistance = array_keys((array)$distance)[0] * 1;
                            }
                        }
                        $timesdsc = substr($timesdsc, 0, -3);
                        $finalsprint = $times400->finalsprint;
                    }

                    // calcular distancia del sprint
                    $sprintdistance = $distanceant - $lastdistance;

                    // Pie de la tabla
                    $racetab->addRow();
                    $cell = $racetab->addCell($C1, $raceCellStyle);
                    //$cell->addText(chr(194) . chr(160), $raceDetText, $raceHdrLftPar);
                    $cell->addText("Tiempos parciales: " . $timesdsc, $raceDetText, $raceDetLftPar);
                    $cell->addText("Remate de los últimos " . $sprintdistance . " metros: " . $finalsprint, $raceDetText, $raceDetLftPar);
                    $cell->addText("Ganador: " . $winner . ":" . $blank . $blank . $gender . $blank . $fur . " a. " . $father . " - " . $mother, $raceDetText, $raceDetLftPar);
                    $cell->addText("Propietario: Stud \"" . clnprn($stud) . "\". Preparador: " . $trainername, $raceDetText, $raceDetLftPar);
                    $cell->addText("Procedencia: Haras " . clnprn($haras), $raceDetText, $raceDetLftPar);
                    $cell->addText("Dividendos: " . $winner . " G - " . $mainprice . " P - " . $place1 . $blank . $blank . $blank . $blank . $second . " P - " . $place2, $raceDetText, $raceDetLftPar);
                    $betsrowsprinted = 0;
                    for ($i=0; $i<count($bets); $i++){
                        if (count($bets)<=2 || $i == count($bets)-1){
                            if ($betsrowsprinted < 2)   // evitar más de dos lineas de jugadas
                                $cell->addText($bets[$i], $raceDetText, $raceDetLftPar);
                            $betsrowsprinted++;
                        }else{
                            if ($betsrowsprinted < 2)   // evitar más de dos lineas de jugadas
                                $cell->addText($bets[$i] . "   " . $bets[$i+1], $raceDetText, $raceDetLftPar);
                            $betsrowsprinted++;
                            $i++;
                        }
                    }
                    // completar lineas de jugadas en caso de que haya de menos
                    for ($i=0; $i<2-$betsrowsprinted; $i++)
                        $cell->addText($blank, $raceDetText, $raceDetLftPar);
                }


                $lines = 0;
                $addtitrow1 = false;
                $addtitrow2 = false;
                $actualrace = $row["raceid"]*1;
                $distanceant = $row["distance"]*1;
                $winner = mb_strtoupper($row["horsename"]);
                $fur = $row["furabbr"];
                $gender = $row["gender"];
                $second = "";
                $father = $row["fathername"];
                $mother = $row["mothername"];
                $trainername = $row["trainername"];
                $stud = $row["stud"];
                $haras = $row["haras"];
                $meds = "";
                if ($row["meds"] != ""){
                    foreach(json_decode($row["meds"]) as $med)
                        $meds .= $med->abbr . ".";
                }
                $imps = "";
                if ($row["imps"] != ""){
                    foreach(json_decode($row["imps"]) as $imp)
                        $imps .= $imp->abbr . ".";
                }
                $bets = array();
                $mainprice = "-";
                $place1 = "-";
                $place2 = "-";
                if ($row["betprices"] != ""){
                    foreach(json_decode($row["betprices"]) as $bet){
                        if ($bet->id == 1)  // main price
                            $mainprice = $bet->prices[0];
                        if ($bet->id == 2){  // place1 y place2
                            $place1 = $bet->prices[0]*1;
                            $place2 = $bet->prices[1]*1;
                        }
                        if ($bet->id > 2){
                            $hrss = "";
                            foreach($bet->horses as $hrs){
                                $hrss .= $hrs . "-";
                            }
                            if (strlen($hrss)>0)
                                $hrss = substr($hrss, 0, -1);
                            if ($bet->prices[0]!="0")
                                $bets[] = $bet->name . ": " . $hrss . " Bs. " . ($bet->prices[0]);
                            else
                                $bets[] = $bet->name . ": " . $hrss . " Bs. " . "No hubo";
                        }

                    }
                }
                if ($row["times400"] != "")
                    $times400s =  $row["times400"];


                $racecnt++;

                // tabla de la carrera
                $racetab = $section->addTable([$raceTableStyle]);
                // encabezado de la carrera
                $racetab->addRow();
                $cell = $racetab->addCell($widthcarrera, $raceTopCellStyle);
                $cell->addText("(" . $row["racenumber"] . ") " . $dow[$dowreunion-1] . 
                                " - " . $ordinal[$racecnt-1] . " Carrera - " . 
                                $row["distance"] . " metros - Tiempo: " . 
                                $row["finishtime"]
                                ,$raceHeaderText, $raceHeaderPar);
                
                if ($row["racetypeid"] != "-1"){
                    $cell->addText($row["racetype"]
                                ,$validRaceHeaderText, $validRaceHeaderPar);
                    $addtitrow1 = false;
                }else{
                    $addtitrow1 = true;
                }
                if ($row["valid"] != "0"){
                    $cell->addText($row["valid"] . "a. VALIDA para el 5 y 6 "
                                ,$validRaceHeaderText, $validRaceHeaderPar);
                    $addtitrow2 = false;
                }else{
                    $addtitrow2 = true;
                }


                // datos de la carrera
                $racetab->addRow();
                $cell = $racetab->addCell($widthcarrera, $raceCellStyle);
                $cell->addText("Serie: " . $row["serie"] . "  Premios: Bs. " . number_format($row["mainprice"], 2, ",", ".")
                                ,$raceDataHeaderText, $raceDataHeaderPar);

                // cabeceras de la carrers
                $racetab->addRow();
                $cell = $racetab->addCell($C1, $raceHdrCellStyle);
                $cell->addText("C.A.", $raceHdrText, $raceHdrCtrPar);
                $cell = $racetab->addCell($C2, $raceHdrCellStyle);
                $cell->addText("Ll.", $raceHdrText, $raceHdrCtrPar);
                $cell = $racetab->addCell($C3, $raceHdrCellStyle);
                $cell->addText("Ejemplar", $raceHdrText, $raceHdrLftPar);
                $cell = $racetab->addCell($C4, $raceHdrCellStyle);
                $cell->addText("Cps", $raceHdrText, $raceHdrLftPar);
                $cell = $racetab->addCell($C5, $raceHdrCellStyle);
                $cell->addText("Ks.", $raceHdrText, $raceHdrLftPar);
                $cell = $racetab->addCell($C6, $raceHdrCellStyle);
                $cell->addText("Jinete, Pts", $raceHdrText, $raceHdrLftPar);
                $cell = $racetab->addCell($C7, $raceHdrCellStyle);
                $cell->addText("400", $raceHdrText, $raceHdrCtrPar);
                $cell = $racetab->addCell($C8, $raceHdrCellStyle);
                $cell->addText("800", $raceHdrText, $raceHdrCtrPar);
                $cell = $racetab->addCell($C9, $raceHdrCellStyle);
                $cell->addText("PP.", $raceHdrText, $raceHdrCtrPar);
                $cell = $racetab->addCell($C10, $raceHdrCellStyle);
                $cell->addText("Div.", $raceHdrText, $raceHdrRhtPar);
                $cell = $racetab->addCell($C11, $raceHdrCellStyle);
                $cell->addText("TTC", $raceHdrText, $raceHdrRhtPar);
        
            }
            if ($row["arrivalposition"] == 2)
                $second = mb_strtoupper($row["horsename"]);

            // calcular carrera anterior //XXX
            $sql =  "SELECT      R.horseid, MAX(RA.number) lastrace " . 
                    "FROM        racers R " . 
                    "INNER JOIN  races RA " . 
                    "ON          R.raceid=RA.id " . 
                    "INNER JOIN  reunions RE " . 
                    "ON          RA.reunionid = RE.id " . 
                    "WHERE       RA.id<" . $row["raceid"] . " " .
                    "AND         R.horseid=" . $row["horseid"] . " " .
                    "AND         YEAR(RE.date) = '" . $actualyear . "' " . 
                    "GROUP BY    R.horseid ";
            if (!$rs2 = $db->query($sql))
                badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
            if ($row2 = $rs2->fetch_assoc())
                $lastrace = $row2["lastrace"];
            else
                $lastrace = "---";

            // detalles
            $lines++;
            $racetab->addRow();
            if ($row["arrivalposition"] == 0 && $row["ret"] != ""){
                $cell = $racetab->addCell($C1, $raceCellStyle);
                $cell->addText($row["horsename"] . " Ret.-", $raceDetText, $raceDetLftPar);
            }else{
                $cell = $racetab->addCell($C1, $raceDetCellStyle);
                $cell->addText($lastrace, $raceDetText, $raceDetCtrPar);
                $cell = $racetab->addCell($C2, $raceDetCellStyle);
                $cell->addText($row["arrivalposition"], $raceDetText, $raceDetCtrPar);
                $cell = $racetab->addCell($C3, $raceDetCellStyle);
                $cell->addText(mb_strtoupper($row["horsename"]), $raceDetText, $raceDetLftPar);
                $cell = $racetab->addCell($C4, $raceDetCellStyle);
                if ($row["trop"] == "")
                    if ($row["bodies"] == "")
                        $cell->addText($blank, $raceDetText, $raceDetLftPar);
                    else
                        $cell->addText($row["bodies"], $raceDetText, $raceDetLftPar);
                else
                    $cell->addText($row["trop"], $raceDetText, $raceDetLftPar);
                $cell = $racetab->addCell($C5, $raceDetCellStyle);
                $cell->addText($row["jockeyweight"], $raceDetText, $raceDetLftPar);
                $cell = $racetab->addCell($C6, $raceDetCellStyle);
                $cell->addText($row["jockeyname"], $raceDetText, $raceDetLftPar);
                $cell = $racetab->addCell($C7, $raceDetCellStyle);
                $cell->addText($row["pos400"], $raceDetText, $raceDetCtrPar);
                $cell = $racetab->addCell($C8, $raceDetCellStyle);
                $cell->addText($row["pos800"], $raceDetText, $raceDetCtrPar);
                $cell = $racetab->addCell($C9, $raceDetCellStyle);
                $cell->addText($row["position"], $raceDetText, $raceDetCtrPar);
                $cell = $racetab->addCell($C10, $raceDetCellStyle);
                $cell->addText(number_format($row["dividends"], 2, ",", ""), $raceDetText, $raceDetRhtPar);
                $cell = $racetab->addCell($C11, $raceDetCellStyle);
                $cell->addText($row["speedr"] . $blank, $raceDetText, $raceDetRhtPar);
            }

        }
        if ($actualrace != 0){
            // imprimir lineas en blanco hasta llegar a 14 carreras
            for ($i=14-$lines; $i>0; $i--){
                $racetab->addRow();
                $cell = $racetab->addCell($C1, $raceCellStyle);
                $cell->addText($blank, $raceDetText, $raceDetLftPar);
            }
            // imprimir en el pie 
            if ($addtitrow1){
                $racetab->addRow();
                $cell = $racetab->addCell($C1, $raceCellStyle);
                $cell->addText($blank
                            ,$validRaceHeaderText, $validRaceHeaderPar);
            }
            if ($addtitrow2){
                $racetab->addRow();
                $cell = $racetab->addCell($C1, $raceCellStyle);
                $cell->addText($blank
                            ,$validRaceHeaderText, $validRaceHeaderPar);
            }
            $timesdsc = "";
            $finalsprint = "";
            $lastdistance = 0;
            if ($times400s!=""){
                $times400 =  json_decode($times400s);
                foreach ($times400->distances as $distance){
                    if ((array_keys((array)$distance)[0]*1) < ($distanceant)){
                        $timesdsc .= array_keys((array)$distance)[0] . " en " . array_values((array)$distance)[0] . " - ";
                        $lastdistance = array_keys((array)$distance)[0] * 1;
                    }
                }
                $timesdsc = substr($timesdsc, 0, -3);
                $finalsprint = $times400->finalsprint;
            }

            // calcular distancia del sprint
            $sprintdistance = $distanceant - $lastdistance;

            // Pie de la tabla
            $racetab->addRow();
            $cell = $racetab->addCell($C1, $raceCellStyle);
            //$cell->addText(chr(194) . chr(160), $raceDetText, $raceHdrLftPar);
            $cell->addText("Tiempos parciales: " . $timesdsc, $raceDetText, $raceDetLftPar);
            $cell->addText("Remate de los últimos " . $sprintdistance . " metros: " . $finalsprint, $raceDetText, $raceDetLftPar);
            $cell->addText("Ganador: " . $winner . ":" . $imps . " " . $gender . " " . $fur . " a. " . $father . " - " . $mother, $raceDetText, $raceDetLftPar);
            $cell->addText("Propietario: Stud \"" . clnprn($stud) . "\". Preparador: " . $trainername, $raceDetText, $raceDetLftPar);
            $cell->addText("Procedencia: Haras " . clnprn($haras), $raceDetText, $raceDetLftPar);
            $cell->addText("Dividendos: " . $winner . " G - " . $mainprice . " P - " . $place1 . $blank . $blank . $second . " P - " . $place2, $raceDetText, $raceDetLftPar);
            $betsrowsprinted = 0;
            for ($i=0; $i<count($bets); $i++){
                if (count($bets)<=2 || $i == count($bets)-1){
                    if ($betsrowsprinted < 2)   // evitar más de dos lineas de jugadas
                        $cell->addText($bets[$i], $raceDetText, $raceDetLftPar);
                    $betsrowsprinted++;
                }else{
                    if ($betsrowsprinted < 2)   // evitar más de dos lineas de jugadas
                        $cell->addText($bets[$i] . "   " . $bets[$i+1], $raceDetText, $raceDetLftPar);
                    $betsrowsprinted++;
                    $i++;
                }
            }
            // completar lineas de jugadas en caso de que haya de menos
            for ($i=0; $i<2-$betsrowsprinted; $i++)
                $cell->addText($blank, $raceDetText, $raceDetLftPar);
        }
    }else{
        $filename = "ERROR" . "." . $outputformat;
        // Creating the new document...
        $phpWord = new PhpWord();

        $section = $phpWord->addSection([
            "marginTop"=>$top,
            "marginBottom"=>$bottom,
            "marginLeft"=>$left,
            "marginRight"=>$right,
            "pageSizeH"=>$height,
            "pageSizeW"=>$width,
            "breakType"=>"continuous"
        ]);

        $section->addText("La reunión anterior no tiene carreras registradas o no existe");
    }

    switch ($outputformat){
        case "pdf":
            $domPdfPath = realpath(__DIR__ . '/../../../hooks/Dompdf/Dompdf');
            \PhpOffice\PhpWord\Settings::setPdfRendererPath($domPdfPath);
            \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
            \PhpOffice\PhpWord\Settings::setPdfRendererOptions([
                'font' => 'Helvetica',
            ]);
            
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord , 'PDF');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        case "docx":
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        default:
            die ("FORMATO DE SALIDA INVALIDO");
    }
    header("Content-Disposition: attachment; filename=" . $filename);
    readfile($temp_file); // or echo file_get_contents($temp_file);
    unlink($temp_file);


    function clnprn($valor){
        return (trim(preg_replace("/[^a-zA-Z0-9 \"\'.,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", str_replace("&", "y", $valor))));
    }
?>