<?php
    use \PhpOffice\PhpWord\PhpWord;
    use \PhpOffice\PhpWord\SimpleType\Border;
    use \PhpOffice\PhpWord\Style\Font;
//error_reporting(E_ALL);
//ini_set('display_errors', 1);
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    require '../../../hooks/autoload.php';
    
    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));
    // parametros obligatorios
    $parmsob = array("reunionid", "magazineid", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $reunionid = intval($_REQUEST["reunionid"]);
    $magazineid = intval($_REQUEST["magazineid"]);

    // parametros opcionales
    $outputformat = "docx";
    if (isset($_REQUEST["format"]))
        $outputformat = preg_replace("/[^docxpf]+/", "", strtolower($_REQUEST["format"]));
    if ($outputformat != "docx" && $outputformat != "pdf" )
        badEnd("500", array("msg"=>"Los formatos validos son 'pdf' y 'docx"));
    $racefilter = "";
    if (isset($_REQUEST["raceidfrom"]) && isset($_REQUEST["raceidto"])){
        $raceidfrom = intval($_REQUEST["raceidfrom"]);
        $raceidto = intval($_REQUEST["raceidto"]);
        $sql = "SELECT number FROM races WHERE id=" . $raceidfrom;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if (!$row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Reunion desde no encontrada"));
        $racenumberfrom = $row["number"];
        $sql = "SELECT number FROM races WHERE id=" . $raceidto;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if (!$row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Reunion hasts no encontrada"));
        $racenumberto = $row["number"];
        $racefilter = " AND RA.number BETWEEN '" . $racenumberfrom . "' AND '" . $racenumberto . "' ";
    }

    isSessionValid($db, $sessionid);

    // conseguir fecha e hipodromo de la reunión
    $sql =  "SELECT 	R.date, R.racecourseid, H.dsc, H.abbr rcabbr " .
            "FROM 		reunions R " .
            "INNER JOIN racecourses H " .
            "ON         R.racecourseid = H.id " .
            "WHERE      R.id = " . $reunionid . " ";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $date = $row["date"];
    $racecourseid = $row["racecourseid"];
    $racecourse = $row["dsc"];
    $rcabbr = $row["rcabbr"];

    //obtener primera carrera de la reunión para efectos del nombre
    $sql =  "SELECT LPAD(MIN(number), 3, '0') num FROM races WHERE valid=0 AND reunionid=" . $reunionid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $filename = "G" . $rcabbr  . "C" . $row["num"] . "." . $outputformat;

    // Armar arreglo con jugadas de pool de 4 y loto hipico
    $sql =  "SELECT     number, JSON_EXTRACT(RA.bets, '$[*].id') bet " .
            "FROM       races RA " . 
            "WHERE      RA.reunionid = " . $reunionid . " " . 
            "ORDER BY   RA.number";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    $doblep = array();
    $pool4 = array();
    $lotohip = array();
    $tripleap = array();
    $cntdbl = 0;
    $cntp4 = 0;
    $cntlh = 0;
    $cntta = 0;
    while ($row = $rs->fetch_assoc()){
        // se busca 6 que es el id de dobleperfecta
        if (strpos(preg_replace("/[^1234567890,]+/", "", $row["bet"]), "6"))
            if ($cntdbl<2)
                $cntdbl++;
            else
                $cntdbl = 1;
        else
            $cntdbl=0;
        $doblep[$row["number"]] = $cntdbl;
        // se busca 7 que es el id de pool de 4
        if (strpos(preg_replace("/[^1234567890,]+/", "", $row["bet"]), "7"))
            if ($cntp4<4)
                $cntp4++;
            else
                $cntp4 = 1;
        else
            $cntp4=0;
        $pool4[$row["number"]] = $cntp4;
        // se busca 8 que es el id de loto hipico
        if (strpos(preg_replace("/[^1234567890,]+/", "", $row["bet"]), "8"))
            if ($cntlh<2)
                $cntlh++;
            else
                $cntlh = 1;
        else
            $cntlh=0;
        $lotohip[$row["number"]] = $cntlh;
        // se busca 9 que es el id de triple apuesta
        if (strpos(preg_replace("/[^1234567890,]+/", "", $row["bet"]), "9"))
            if ($cntta<2)
                $cntta++;
            else
                $cntta = 1;
        else
            $cntta=0;
        $tripleap[$row["number"]] = $cntta;
    }
        

    $datefrom = date('Y-m-d', strtotime('first day of January '. date('Y', strtotime($date)) ));
    // calcular inicio del cuatrimestre
    $actualmonth = intval(date('m', strtotime($date)));
    if ($actualmonth <= 4)
        $datefrom4 = "01";
    else if ($actualmonth <= 8)
        $datefrom4 = "05";
    else if ($actualmonth <= 12)
        $datefrom4 = "09";
    $datefrom4 = date('Y', strtotime($date)) . "-" . $datefrom4 . "-01";
    // SOlo para Caracas
    if ($racecourseid == 2)
        $datefrom = $datefrom4;
    $dateto =   date('Y-m-d', strtotime('-1 day', strtotime($date)));
    $sql =  "SELECT     C.id horseid, R.id racerid, H.dsc racecourse, RA.extraprice, CU1.symbol pricecurr, CU2.symbol extrapricecurr, DATE_FORMAT(RE.date, '%d/%m/%y') fecha, " .
            "           H.id racecourseid, RA.id raceid, RA.ord raceord, RA.number racenumber, RA.mainprice, RA.firstplace, RA.secondplace, RA.thirdplace, RA.fourthplace, RA.fifthplace, " .
            "           R.number horsenumber, R.position horseposition, C.gender, FU.abbr furabbr, FLOOR(DATEDIFF(RE.date, C.birthdate)/365.25) age, R.jockeyweight, RA.valid, " .
            "           RE.date reuniondate, D.id distid, D.dsc distancia, RT.id racetypeid, RT.dsc racetypedsc, " .
            "           REPLACE(LOWER(DATE_FORMAT(RA.time, '%h:%i %p')),'m','.m.') hora, DAYOFWEEK(RE.date) dow, " .
            "           CO1.dsc condicion1, CO2.dsc condicion2, RA.conditiondsc, " .
            "           RH.horsename recordhorse, RH.jockeyname recordjockey, RH.jockeyweight recordweight, RH.basetime recordtime,  " .
            "           DATE_FORMAT(RH.date, '%d/%m/%y') recorddate, " .
            "           S.dsc studname, S.abbr studabbr, " .
            "           C.obs horseobs, C.dsc horsename, C.mothergfname horsegfather, C.fathername horsefather, C.mothername horsemother, DATE_FORMAT(C.birthdate, '%d/%m/%y') horsebirth, " .
            "           J.abbr jockeyname, T.abbr trainername, ROUND(IF(SJ.jockeytotal<>0, SJ.jockeyfirst/SJ.jockeytotal*100,0),0) xx, ROUND(SJ.rend,0) jockeyef, " . 
            "           ROUND(IF(ST.trainertotal<>0, ST.trainerfirst/ST.trainertotal*100,0),0) xxx, ROUND(ST.rend,0) traineref, " . 
            "           IFNULL(R.implementstypeM, '') medicaments, IFNULL(R.implementstypeI,'') implements, " .
            "           IFNULL(F.racers,'') forecastracers, F.top3, F.top6, " .
            //"           SH.pricebs, SH.totalraces, SH.firstplace totalwin, SH.totalracesyear, SH.firstplaceyear totalwinyear, " .
            "           SA.harasname, SA.pricesbs harasbs " .
            "FROM       racers R  " .
            "INNER JOIN races RA  " .
            "ON         R.raceid=RA.id " .
            "INNER JOIN racetypes RT " . 
            "ON         RA.racetypeid=RT.id " .
            "INNER JOIN reunions RE  " .
            "ON         RA.reunionid=RE.id " .
            "INNER JOIN racecourses H  " .
            "ON         RE.racecourseid=H.id " .
            "INNER JOIN conditions CO1 " .
            "ON         RA.conditionid1=CO1.id " .
            "INNER JOIN conditions CO2 " .
            "ON         RA.conditionid2=CO2.id " .
            "INNER JOIN distances D  " .
            "ON         RA.distanceid=D.id " .
            "LEFT JOIN	(SELECT * FROM records_hipdst WHERE deleted IS NULL) RH " .
            "ON			RE.racecourseid=RH.racecourseid " .
            "AND		RA.distanceid=RH.distanceid " .
            "LEFT JOIN  (SELECT * FROM forecasts WHERE magazineid=" . $magazineid . ") F " .
            "ON         RA.id=F.raceid " .
            "INNER JOIN studs S  " .
            "ON			R.studid=S.id " .
            "INNER JOIN horses C  " .
            "ON			R.horseid=C.id " .
            "INNER JOIN furs FU " . 
            "ON         C.furid=FU.id " .
            "INNER JOIN stats_haras SA " .
            "ON         C.harasid=SA.harasid " .
            "INNER JOIN jockeys J  " .
            "ON			R.jockeyid=J.id " .
            "INNER JOIN	trainers T  " .
            "ON			R.trainerid=T.id " .
            "INNER JOIN currencies CU1 " .
            "ON         RA.mainpricecurr=CU1.code " .
            "INNER JOIN currencies CU2 " .
            "ON         RA.extrapricecurr=CU2.code " .
            //"LEFT JOIN  ( " .
            //"            SELECT		horseid, SUM(firstplace) firstplace, SUM(totalraces) totalraces,  " .
            //"                       SUM(firstplaceyear) firstplaceyear, SUM(totalracesyear) totalracesyear, SUM(pricesbs) pricebs  " .
            //"            FROM		(SELECT H.* FROM (select @df:='" . $datefrom . "' f, @dt:='" . $dateto . "' t) a, stats_horses H) H " .
            //"            GROUP BY   horseid " .
            //"           )  SH " .
            //"ON         R.horseid = SH.horseid " .
//            "AND        RE.racecourseid = SH.racecourseid " .
//            "AND        RA.distanceid = SH.distanceid " .
            "LEFT JOIN  (SELECT J.jockeyid, J.racecourseid, J.totalraces jockeytotal, J.firstplace jockeyfirst, J.rend FROM (select @df:='" . $datefrom . "' f, @dt:='" . $dateto . "' t) a, stats_jockeys J) SJ " . 
            "ON         R.jockeyid=SJ.jockeyid " . 
            "AND        RE.racecourseid=SJ.racecourseid " .
            "LEFT JOIN  (SELECT T.trainerid, T.racecourseid, T.totalraces trainertotal, T.firstplace trainerfirst, T.rend FROM (select @df:='" . $datefrom . "' f, @dt:='" . $dateto . "' t) a, stats_trainers T) ST " . 
            "ON         R.trainerid=ST.trainerid " . 
            "AND        RE.racecourseid=ST.racecourseid " .
            "WHERE      RE.id=" . $reunionid . " " .
            "AND        RA.valid=0 " .
            $racefilter .
            //"AND        RE.number=49 " .
            "ORDER BY   RA.ord, R.number";
//die($sql);
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    $phpWord = new PhpWord();

    // medidas
    $pulgada = 1440;
    $height = 8.07*$pulgada;  // 1440 twip = 1 pulgada
    $width = 5.32*$pulgada;
    $top = 0;
    $bottom = 0;
    $left = 0;
    $right = 0;
    $columnspaces = 0;
    $blank = chr(194) . chr(160);

    $widthmidleft = ($width/2)*0.20;
    $widthmidright = ($width/2)*0.15;

    // colores
    $cyan = "00AEEF";
    $cyanlight = "C1EFFF";
    $bgGray = "CECECE";

    // Ancho de las columnas
    $C1 = 0.04;
    $C2 = 0.23;
    $C3 = 0.09;
    $C4 = 0.03;
    $C5 = 0.04;
    $C6 = 0.03;
    $C7 = 0.04;
    $C8 = 0.04;
    $C9 = 0.02;
    $C10 = 0.03;
    $C11 = 0.03;
    $C12 = 0.11;
    $C13 = 0.10;
    $C14 = 0.03;
    $C15 = 0.03;
    $C16 = 0.03;
    $C17 = 0.03;
    $C18 = 0.03;
    $C19 = 0.02;
    $anchoHistoria = $width*($C5+$C6+$C7+$C8+$C9+$C10+$C11+$C12+$C13+$C14+$C15+$C16+$C17+$C18+$C19);

    // ESTILOS
    // Estilos de celdas
    $headerCellStyle = [
        "bgColor"=>$bgGray,
        "valign" => "bottom",
        "borderRightSize" => 4,
        "borderRightColor" => "444444",
        "borderTopSize" => 0,
        "borderBottomSize" => 0,
        "borderLeftSize" => 0,
        "borderTopStyle" => Border::NONE,
        "borderBottomStyle" => Border::NONE,
        "borderLeftStyle" => Border::NONE,
    ];

    $betsAreaCellStyle = [
        "bgColor"=>$cyan,
        "valign" => "bottom",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $betsAltAreaCellStyle = [
        "bgColor"=>$cyanlight,
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];


    $detailCellStyle = [
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    $detailSpan12CellStyle = [
        "gridSpan"=> 12,
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    $detailSpan2CellStyle = [
        "gridSpan"=>2,
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    $statsAreaCellStyle = [
        "valign" => "bottom",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    $detailCellSpanStyle = [
        "gridSpan" => 15,
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    $statsTitCellStyle = [
        "bgColor" => $cyanlight,
        "gridSpan" => 8,
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $statsHdrCellStyle = [
        "bgColor" => $bgGray,
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $statsDetCellStyle = [
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $statsDetLeftBrdCellStyle = [
        "valign" => "center",
        "borderLeftColor" => $bgGray,
        "borderLeftSize" => 8,
        "borderTopSize" => 0,
        "borderBottomSize" => 0,
        "borderRightSize" => 0,
        "borderTopStyle" => Border::NONE,
        "borderBottomStyle" => Border::NONE,
        "borderRightStyle" => Border::NONE,
    ];

    $detailCellStyleBlue = [
        "bgColor" => $cyanlight,
        "valign" => "center",
        "borderBottomSize" => 5,
        "borderTopSize" => 0,
        "borderRightSize" => 0,
        "borderLeftSize" => 0,
        "borderTopStyle" => Border::NONE,
        "borderRightStyle" => Border::NONE,
        "borderLeftStyle" => Border::NONE,
    ];
    $detailCellStyleBtnBrd = [
        "valign" => "center",
        "borderBottomSize" => 5,
        "borderTopSize" => 0,
        "borderLeftSize" => 0,
        "borderRightSize" => 0,
        "borderTopStyle" => Border::NONE,
        "borderLeftStyle" => Border::NONE,
        "borderRightStyle" => Border::NONE,
    ];
    $detailCellStyleBtnRghBrd = [
        "valign" => "center",
        "borderBottomSize" => 5,
        "borderTopSize" => 0,
        "borderLeftSize" => 0,
        "borderRightSize" => 5,
        "borderTopStyle" => Border::NONE,
        "borderLeftStyle" => Border::NONE,
    ];
    $detailCellSpanStyleBtnBrd = [
        "gridSpan" => 15,
        "valign" => "center",
        "borderBottomSize" => 5,
        "borderTopSize" => 0,
        "borderLeftSize" => 0,
        "borderRightSize" => 0,
        "borderTopStyle" => Border::NONE,
        "borderLeftStyle" => Border::NONE,
        "borderRightStyle" => Border::NONE,
    ];
    $detailCellSpanStyle = [
        "gridSpan" => 15,
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $defaultCellStyle = [
        "borderSize" => 0,
        "borderStyle" => Border::NONE
    ];
    $sloganCellStyle = [
        "valign" => "center",
        "bgColor" => $cyan,
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    // Estilos de Tablas
    $defaultTableFullWidthStyle = "defaultTableFullWidthStyle";
    $phpWord->addTableStyle($defaultTableFullWidthStyle,[
            "width" => $width,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
        ], $defaultCellStyle, $defaultCellStyle);
    $defaultTableHalfWidthStyle = "defaultTableHalfWidthStyle";
    $phpWord->addTableStyle($defaultTableHalfWidthStyle,[
            "width" => $width/2,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin"=>0,
            "cellSpacing" => 0,
    ], $defaultCellStyle, $defaultCellStyle);

    $betsLeftTableStyle = "betsLeftTableStyle";
    $phpWord->addTableStyle($betsLeftTableStyle,[
            "width" => $widthmidleft,
            "bgColor"=>$cyan,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
    ], $betsAreaCellStyle, $betsAreaCellStyle);
    $betsRightTableStyle = "betsRightTableStyle";
    $phpWord->addTableStyle($betsRightTableStyle,[
            "width" => $widthmidright,
            "bgColor"=>$cyan,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
    ], $betsAreaCellStyle, $betsAreaCellStyle);
    $betsAltTableStyle = "betsAltTableStyle";
    $phpWord->addTableStyle($betsAltTableStyle,[
            "width" => $widthmidright,
            "bgColor"=>$cyanlight,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
    ], $betsAltAreaCellStyle, $betsAltAreaCellStyle);

    $defaultTableHstWidthStyle = "defaultTableHstWidthStyle";
    $phpWord->addTableStyle($defaultTableHstWidthStyle,[
            "width" => $anchoHistoria,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin"=>0,
            "cellSpacing" => 0,
    ], $defaultCellStyle, $defaultCellStyle);
    $statsTableStyle = "statsTableStyle";
    $phpWord->addTableStyle($statsTableStyle,[
            "width" => $width/2*0.68,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
        ], $statsTitCellStyle, $statsTitCellStyle);



    // cintillo superior de premio en dolares
    $initialBannerText = "initialBannerText";
    $phpWord->addFontStyle($initialBannerText, [
        "name"=>"Univers 75 Black",
        "size"=>14,
        "italic"=>true,
        "bold"=>false,
        "color"=>"FFFFFF",
        "bgColor"=>$cyan
    ]);
    $initialBannerPar = "initialBannerPar";
    $phpWord->addParagraphStyle($initialBannerPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "shading"=>["fill"=>$cyan],
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // Clásico
    $classicText = "classicText";
    $phpWord->addFontStyle($classicText, [
        "name"=>"Univers 65 Bold",
        "size"=>10,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $classicPar = "classicPar";
    $phpWord->addParagraphStyle($classicPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>20,
        "spaceAfter"=>20,
    ]);
    // Jugadas Se usa para la válida
    $bets1Text = "bets1Text";
    $phpWord->addFontStyle($bets1Text, [
        "name"=>"Univers 65",
        "size"=>50,
        "spacing"=>-30,
        "scale"=>60,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"FFFFFF"
    ]);
    $bets1Par = "bets1Par";
    $phpWord->addParagraphStyle($bets1Par, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-60,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // se usa para el nombre del 5y6 en la valida
    $bets1AltText = "bets1AltText";
    $phpWord->addFontStyle($bets1AltText, [
        "name"=>"Univers 65",
        "size"=>40,
        "spacing"=>0,
        "scale"=>60,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $bets1AltPar = "bets1AltPar";
    $phpWord->addParagraphStyle($bets1AltPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-50,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $bets2AltText = "bets2AltText";
    $phpWord->addFontStyle($bets2AltText, [
        "name"=>"Univers 65",
        "size"=>12,
        "spacing"=>-5,
        "scale"=>60,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $bets2AltPar = "bets2AltPar";
    $phpWord->addParagraphStyle($bets2AltPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-60,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $bets1smlText = "bets1smlText";
    $phpWord->addFontStyle($bets1smlText, [
        "name"=>"Univers 65",
        "size"=>15,
        "spacing"=>-5,
        "scale"=>60,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"FFFFFF"
    ]);
    $validFillText = "validFillText";
    $phpWord->addFontStyle($validFillText, [
        "name"=>"Univers 65",
        "size"=>3,
        "spacing"=>0,
        "scale"=>0,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"FFFFFF"
    ]);
    $betssml1Par = "betssml1Par";
    $phpWord->addParagraphStyle($betssml1Par, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-60,
        "spaceBefore"=>0,
        "spaceAfter"=>20,
    ]);
    $bets2smlText = "bets2smlText";
    $phpWord->addFontStyle($bets2smlText, [
        "name"=>"Univers 65",
        "size"=>10,
        "spacing"=>-10,
        "scale"=>60,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"FFFFFF"
    ]);
    $betssml2Par = "betssml2Par";
    $phpWord->addParagraphStyle($betssml2Par, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-20,
        "spaceBefore"=>40,
        "spaceAfter"=>40,
    ]);
    // nombre del hipodromo
    $racecourseText = "racecourseText";
    $phpWord->addFontStyle($racecourseText, [
        "name"=>"Univers 65",
        "scale"=>120,
        "size"=>8,
        "allCaps"=>false,
        "bold"=>true,
        "color"=>"000000"
    ]);
    $racecoursePar = "racecoursePar";
    $phpWord->addParagraphStyle($racecoursePar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('left', 200)
        ]
    ]);
    // fecha y hora de la carrera
    $dateText = "dateText";
    $phpWord->addFontStyle($dateText, [
        "name"=>"Univers Extra Black",
        "size"=>8,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
        "scale" => 150
    ]);
    $datePar = "datePar";
    $phpWord->addParagraphStyle($datePar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('right', $width/2)
        ]
    ]);
    // tablas de yuntas y los mejores
    $separadorText = "separadorText";
    $phpWord->addFontStyle($separadorText, [
        "name"=>"Univers 55",
        "size"=>3,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $separadorPar = "separadorPar";
    $phpWord->addParagraphStyle($separadorPar, [
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
    ]);
    $recordsTitText = "recordsTitText";
    $phpWord->addFontStyle($recordsTitText, [
        "name"=>"Univers 65",
        "scale"=>120,
        "size"=>6,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $recordsTitPar = "recordsTitPar";
    $phpWord->addParagraphStyle($recordsTitPar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
    ]);
    $recordsHdrLeftText = "recordsHdrLeftText";
    $phpWord->addFontStyle($recordsHdrLeftText, [
        "name"=>"Univers 65",
        "scale"=>80,
        "size"=>6,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $recordsHdrLeftPar = "recordsHdrLeftPar";
    $phpWord->addParagraphStyle($recordsHdrLeftPar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
    ]);
    $recordsHdrText = "recordsHdrText";
    $phpWord->addFontStyle($recordsHdrText, [
        "name"=>"Univers 65",
        "scale"=>60,
        "size"=>6,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $recordsHdrPar = "recordsHdrPar";
    $phpWord->addParagraphStyle($recordsHdrPar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
    ]);
    $recordsDetLeftText = "recordsDetLeftText";
    $phpWord->addFontStyle($recordsDetLeftText, [
        "name"=>"Univers 55",
        "scale"=>75,
        "size"=>6,
        "spacing" => -10,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $recordsDetLeftPar = "recordsDetLeftPar";
    $phpWord->addParagraphStyle($recordsDetLeftPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $recordsDetText = "recordsDetText";
    $phpWord->addFontStyle($recordsDetText, [
        "name"=>"Univers 55",
        "scale"=>80,
        "size"=>6,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $recordsDetPar = "recordsDetPar";
    $phpWord->addParagraphStyle($recordsDetPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);

    // numero de carrera y dia de la semana
    $raceNmbrText = "raceNmbrText";
    $phpWord->addFontStyle($raceNmbrText, [
        "name"=>"Univers 65",
        "scale"=>80,
        "size"=>14,
        "allCaps"=>false,
        "bold"=>true,
        "color"=>"FFFFFF"
    ]);
    $raceNmbrPar = "raceNmbrPar";
    $phpWord->addParagraphStyle($raceNmbrPar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('left', 60),
                    new \PhpOffice\PhpWord\Style\Tab('right', ($width/2)-60)
        ],
        "shading"=>["fill"=>$cyan],
    ]);
    // condiciones linea uno
    $conditions1Text = "conditions1Text";
    $phpWord->addFontStyle($conditions1Text, [
        "name"=>"Univers 65",
        "size"=>7,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $conditions1Par = "conditions1Par";
    $phpWord->addParagraphStyle($conditions1Par, [
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('left', 60),
                    new \PhpOffice\PhpWord\Style\Tab('right', $width/2-60)
        ],
        "spacing"=>0,
    ]);
    // condiciones linea dos
    $conditions2Text = "conditions2Text";
    $phpWord->addFontStyle($conditions2Text, [
        "name"=>"Univers 55",
        "scale"=>70,
        "size"=>6,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $conditions2Par = "conditions2Par";
    $phpWord->addParagraphStyle($conditions2Par, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spaceBefore"=>20,
        "spaceAfter"=>40,
        "spacing"=>-60,
    ]);
    // premios
    $pricesText = "pricesText";
    $phpWord->addFontStyle($pricesText, [
        "name"=>"Univers 55",
        "size"=>5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $pricesPar = "pricesPar";
    $phpWord->addParagraphStyle($pricesPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "spacing"=>-40,
    ]);
    // distancia
    $distanceText = "distanceText";
    $phpWord->addFontStyle($distanceText, [
        "name"=>"Univers Extra Black",
        "scale"=>70,
        "size"=>12.4,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $distancePar = "distancePar";
    $phpWord->addParagraphStyle($distancePar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "spacing"=>-50,
    ]);
    // record
    $recordText = "recordText";
    $phpWord->addFontStyle($recordText, [
        "name"=>"Univers 65",
        "scale"=>80,
        "size"=>6.25,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $recordPar = "recordPar";
    $phpWord->addParagraphStyle($recordPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-10,
        "spaceBefore"=>0,
        "spaceAfter"=>40,
    ]);
    // DETALLE
    // header
    $headerText = "headerText";
    $phpWord->addFontStyle($headerText, [
        "name"=>"Univers 55",
        "scale"=>80,
        "size"=>4.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $headerPar = "headerPar";
    $phpWord->addParagraphStyle($headerPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $headerLeftPar = "headerLeftPar";
    $phpWord->addParagraphStyle($headerLeftPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $headerRightPar = "headerRightPar";
    $phpWord->addParagraphStyle($headerRightPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // header2
    $header2Text = "header2Text";
    $phpWord->addFontStyle($header2Text, [
        "name"=>"Helvetica",
        "size"=>4.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);

    // Horse Number
    $horseNumberText = "horseNumberText";
    $phpWord->addFontStyle($horseNumberText, [
        "name"=>"Univers 65",
        "scale"=>50,
        "spacing"=>0.5,
        "size"=>22,
        "allCaps"=>false,
        "bold"=>true,
        "color"=>"000000"
    ]);
    $horseNumberPar = "horseNumberPar";
    $phpWord->addParagraphStyle($horseNumberPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0.5,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // Horse Details
    $horsedetailsText = "horsedetailsText";
    $phpWord->addFontStyle($horsedetailsText, [
        "name"=>"Univers 55",
        "scale" => 70,
        "spacing" => -5,
        "size"=>6,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $horsedetailsPar = "horsedetailsPar";
    $phpWord->addParagraphStyle($horsedetailsPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('right', $width*$C2-80)
        ],
        "spacing" => -55,
    ]);
    // horse name
    $horsenameText = "horsenameText";
    $phpWord->addFontStyle($horsenameText, [
        "name"=>"Univers 65",
        "scale" => 90,
        "spacing" => -15,
        "size"=>9,
        "allCaps"=>true,
        "bold"=>true,
        "color"=>"000000"
    ]);
    $horsenamePar = "horsenamePar";
    $phpWord->addParagraphStyle($horsenamePar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        //"spacingLineRule"=>\PhpOffice\PhpWord\SimpleType\LineSpacingRule::AT_LEAST,
        "spacing"=>-50,
    ]);
    // jockey name
    $jockeynameText = "jockeynameText";
    $phpWord->addFontStyle($jockeynameText, [
        "name"=>"Univers 65",
        "scale" => 80,
        "spacing" => -5,
        "size"=>5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $jockeynamePar = "jockeynamePar";
    $phpWord->addParagraphStyle($jockeynamePar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // jockey weight
    $jockeyweightText = "jockeyweightText";
    $phpWord->addFontStyle($jockeyweightText, [
        "name"=>"Univers 65",
        "size"=>7.5,
        "allCaps"=>false,
        "bold"=>true,
        "color"=>"000000"
    ]);
    $jockeyweightPar = "jockeyweightPar";
    $phpWord->addParagraphStyle($jockeyweightPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0.8,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // implements
    $implementsText = "implementsText";
    $phpWord->addFontStyle($implementsText, [
        "name"=>"Univers 55",
        "scale" => 90,
        "spacing" => 0.8,
        "size"=>5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $implementsPar = "implementsPar";
    $phpWord->addParagraphStyle($implementsPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // trainer
    $trainerText = "trainerText";
    $phpWord->addFontStyle($trainerText, [
        "name"=>"Univers 55",
        "scale" => 80,
        "spacing" => -5,
        "size"=>5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $trainerPar = "trainerPar";
    $phpWord->addParagraphStyle($trainerPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>10,
        "spaceAfter"=>0,
    ]);
    // position
    $positionText = "positionText";
    $phpWord->addFontStyle($positionText, [
        //"name"=>"Univers LT 45 Light",
        "name"=>"Univers 65 Bold",
        "scale"=>80,
        "spacing"=>0.6,
        "size"=>10,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $positionPar = "positionPar";
    $phpWord->addParagraphStyle($positionPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // history data
    $historyText = "historyText";
    $phpWord->addFontStyle($historyText, [
        "name"=>"Univers 55",
        "size"=>6.5,
        "scale" => 60,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $historyArrivalPText = "historyArrivalPText";
    $phpWord->addFontStyle($historyArrivalPText, [
        "name"=>"Univers 65",
        "size"=>6.5,
        "scale" => 60,
        "allCaps"=>false,
        "bold"=>true,
        "color"=>"000000"
    ]);
    $historyBoldText = "historyBoldText";
    $phpWord->addFontStyle($historyBoldText, [
        "name"=>"Univers 65",
        "size"=>6.5,
        "scale" => 60,
        "allCaps"=>false,
        "bold"=>true,
        "color"=>"000000"
    ]);
    $historyPar = "historyPar";
    $phpWord->addParagraphStyle($historyPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-20,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $historyLeftPar = "historyLeftPar";
    $phpWord->addParagraphStyle($historyLeftPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>-20,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $historySpanLeftPar = "historySpanLeftPar";
    $phpWord->addParagraphStyle($historySpanLeftPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>-20,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('right', ($width*$C12+$width*$C13)-60)
        ],
    ]);
    $historyRightPar = "historyRightPar";
    $phpWord->addParagraphStyle($historyRightPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT,
        "spacing"=>-20,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // additional data
    $addDataText = "addDataText";
    $phpWord->addFontStyle($addDataText, [
        "name"=>"Univers 65",
        "size"=>5.5,
        "allCaps"=>false,
        "bold"=>true,
        "color"=>"000000"
    ]);
    $addDataPar = "addDataPar";
    $phpWord->addParagraphStyle($addDataPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('right', $anchoHistoria-20)
        ],
    ]);
    // footer slogan
    $footSloganDataText = "footSloganDataText";
    $phpWord->addFontStyle($footSloganDataText, [
        "name"=>"Univers 75 Black",
        "size"=>15,
        "scale" => 60,
        "spacing"=>-15,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"FFFFFF",
    ]);
    $footPoolDe4Text = "footPoolDe4Text";
    $phpWord->addFontStyle($footPoolDe4Text, [
        "name"=>"Univers 75 Black",
        "size"=>15,
        "scale" => 60,
        "spacing"=>-5,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"FFFFFF",
    ]);
    $footSloganDataPar = "footSloganDataPar";
    $phpWord->addParagraphStyle($footSloganDataPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);

    $footFavDataText = "footFavDataText";
    $phpWord->addFontStyle($footFavDataText, [
        "name"=>"Univers 55",
        //"scale" => 90,
        "spacing" => -5,
        "size"=>7,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>$cyan,
    ]);
    $footFavDataPar = "footFavDataPar";
    $phpWord->addParagraphStyle($footFavDataPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('left', ($width/7*5)*0.1),
            new \PhpOffice\PhpWord\Style\Tab('left', ($width/7*5)*0.65),
        ],
    ]);
    $footFavNamText = "footFavNamText";
    $phpWord->addFontStyle($footFavNamText, [
        "name"=>"Univers 65",
        "scale"=>95,
        "size"=>9.36,
        "spacing"=>-10,
        "allCaps"=>true,
        "bold"=>true,
        "color"=>"000000",
    ]);
    $footFavNamPar = "footFavNamPar";
    $phpWord->addParagraphStyle($footFavNamPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('left', ($width/7*5)*0.1),
            new \PhpOffice\PhpWord\Style\Tab('left', ($width/7*5)*0.7),
        ],
    ]);

    $ordinal = ["Primera", "Segunda", "Tercera", "Cuarta", "Quinta", "Sexta", "Séptima", "Octava", "Novena", "Décima", "Undécima", "Duodécima", "Décimatercera", "Décimacuarta"];
    $dow = ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"];
    $top3 = "";
    $actualrace = "";
    $validcnt = 0;
    $ttcarr = [];
    while ($row = $rs->fetch_assoc()){
        if ($row["racenumber"] != $actualrace){
            $validcnt++;
            if ($actualrace != ""){

                $foottable = $section->addTable([$defaultTableFullWidthStyle]);
                $foottable->addRow();
                $cell = $foottable->addCell($width/7*2, $sloganCellStyle);
                if ($pool4[$actualrace] == "0")
                    $cell->addText("Suerte y... Gaceta Hípica",
                                    $footSloganDataText,
                                    $footSloganDataPar
                    );
                else
                    $cell->addText($pool4[$actualrace] . "ª Pool de 4",
                                    $footPoolDe4Text,
                                    $footSloganDataPar
                    );
                $cell = $foottable->addCell($width/7*5);
                arsort($ttcarr);
                $srtop5 = "";
                $keys = array_keys($ttcarr);
                for($i = 0; $i < 5; $i++)
                    $srtop5 .= $keys[$i] . "-";
                $cell->addText("\tNuestros Favoritos: " . $top3 .
                                "\tPor Rating:  " . substr($srtop5, 0, -1),
                                $footFavDataText,
                                $footFavDataPar
                );
                $cell->addText("\t" . $forecastarrdsc[0] . " - " . $forecastarrdsc[1] . " - " . $forecastarrdsc[2],
                                $footFavNamText,
                                $footFavNamPar
                );
            }

            $actualrace = $row["racenumber"];

            $section = $phpWord->addSection([
                "marginTop"=>$top,
                "marginBottom"=>$bottom,
                "marginLeft"=>$left,
                "marginRight"=>$right,
                "pageSizeH"=>$height,
                "pageSizeW"=>$width,
            ]);

            $forecastarrdsc = ["","",""];

            // PREMIO ESPECIAL
            if ($row["extraprice"] != 0){
                $maintable = $section->addTable([$defaultTableFullWidthStyle]);
                $maintable->addRow();
                $cell = $maintable->addCell($width);

                $cell->addText("Premiación Especial Adicional: " . number_format($row["extraprice"], 2, ",", ".") . " " . $row["extrapricecurr"],
                                $initialBannerText,
                                $initialBannerPar
                );
            }
            // Clasico
            if ($row["racetypeid"] != -1){
                $maintable = $section->addTable([$defaultTableFullWidthStyle]);
                $maintable->addRow();
                $cell = $maintable->addCell($width);
                $cell->addText($row["racetypedsc"],
                                $classicText,
                                $classicPar
                );
            }

            // ENCABEZADO DE DOS COLUMNAS
            $headertable = $section->addTable([$defaultTableFullWidthStyle]);
            $headertable->addRow();
                // contenido izquierda
                $cell = $headertable->addCell($width/2, $statsAreaCellStyle);
                    $cell->addText("\t" . $row["racecourse"], $racecourseText, $racecoursePar);
                    $cell->addText($row["fecha"] . "\t" . "Hora: " . $row["hora"], $dateText, $datePar);

                    $cell->addText("\t" . $ordinal[$row["raceord"]-1] . " Carrera\t" . $dow[$row["dow"]-1] . $blank, $raceNmbrText, $raceNmbrPar);

                    $cell->addText("\t(" . $row["racenumber"] . ") " . mb_strtoupper($row["condicion2"]) . "\t" . "Premios: " . $row["pricecurr"] . ". " . number_format($row["mainprice"],2, ",", ".") . $blank,
                            $conditions1Text, $conditions1Par);

                    $cell->addText(str_replace(" (", "<w:br/>(", $row["conditiondsc"]), $conditions2Text, $conditions2Par);
                    // agregar una línea en blanco si las condiciones son cortitas
                    if (strlen($row["conditiondsc"]) < 70 && !strpos(" (", $row["conditiondsc"]))
                        $cell->addText($blank, $conditions2Text, $conditions2Par);

                    $cell->addText( $row["pricecurr"] . ". " . number_format($row["mainprice"]*$row["firstplace"]/100, 2, ",", ".") . " al 1°, " .
                                    $row["pricecurr"] . ". " . number_format($row["mainprice"]*$row["secondplace"]/100, 2, ",", ".") . " al 2°, " .
                                    $row["pricecurr"] . ". " . number_format($row["mainprice"]*$row["thirdplace"]/100, 2, ",", ".") . " al 3°, "
                            , $pricesText, $pricesPar);
                    $cell->addText( $row["pricecurr"] . ". " . number_format($row["mainprice"]*$row["fourthplace"]/100, 2, ",", ".") . " al 4°, " .
                                    $row["pricecurr"] . ". " . number_format($row["mainprice"]*$row["fifthplace"]/100, 2, ",", ".") . " al 5°"
                            , $pricesText, $pricesPar);

                    $cell->addText( "DISTANCIA: " . $row["distancia"] . " METROS"
                            , $distanceText, $distancePar);
                    $cell->addText( "RECORD: " . mb_strtoupper($row["recordhorse"]) . " - " .
                                    $row["recordjockey"] . " - Ks." . $row["recordweight"] . " - " .
                                    $row["recordtime"] . " - " . $row["recorddate"]
                            , $recordText, $recordPar);

                // contenido medio iz
                $cell = $headertable->addCell($widthmidleft, $statsAreaCellStyle);
                    // incluir jugada de loto hipico 
                    if ($lotohip[$actualrace] != 0){
                        $bettab = $cell->addTable([$betsLeftTableStyle]);
                        $bettab->addRow(1470);
                        $betcell = $bettab->addCell($widthmidleft, $betsAreaCellStyle);
                        $betcell->addText($lotohip[$actualrace] . "ª", $bets1Text, $bets1Par);
                        $betcell->addText("LOTO HIPICO", $bets1smlText, $betssml1Par);
                    }
                // contenido medio der
                $cell = $headertable->addCell($widthmidright, $statsAreaCellStyle);
                if ($tripleap[$actualrace] != 0){
                    $bettab = $cell->addTable([$betsRightTableStyle]);
                    $bettab->addRow(1470);
                    $betcell = $bettab->addCell($widthmidright, $betsAreaCellStyle);
                    $betcell->addText("TRIPLE APUESTA", $bets2smlText, $betssml2Par);
                    $betcell->addText($validcnt . "-" . $validcnt+1 . "-" . $validcnt+2 . "<w:br />", $bets2smlText, $betssml2Par);
                //} else if ($doblep[$actualrace] != 0) {
                //    $bettab = $cell->addTable([$betsAltTableStyle]);
                //    $bettab->addRow(1400);
                //    $betcell = $bettab->addCell($widthmidright, $betsAltAreaCellStyle);
                //    $betcell->addText($doblep[$actualrace], $bets1AltText, $bets1AltPar);
                //    $betcell->addText("Doble Perfecta", $bets2AltText, $bets2AltPar);
                }

                // contenido derecha
                $statscell = $headertable->addCell($width/2*0.66, $statsAreaCellStyle);
                // YUNTA JINETE
                $datefrom = date('Y-m-d', strtotime('first day of January '. date('Y', strtotime($date)) ));
                $dateto =   date('Y-m-d', strtotime('-1 day', strtotime($date)));
                $sql2 =     "SELECT     H.id, H.dsc horsename, SY.totalraces, R.jockeyid, R.trainerid, " . 
                            "           SY.firstplace, SY.secondplace, SY.thirdplace, SY.nowinplace, 0 sg, " .
                            "           ROUND(SY.efectiveness*100,0) efectiveness, " .
                            "           SY.lastwinrace, SY.lastwinracenmbr, R.jockeyid, R.trainerid " .
                            "FROM       racers R  " . 
                            "INNER JOIN horses H   " . 
                            "ON         R.horseid=H.id  " . 
                            "INNER JOIN races RA   " . 
                            "ON         R.raceid=RA.id  " . 
                            "INNER JOIN (SELECT Y.* FROM (select @df:='" . $datefrom . "' f, @dt:='" . $dateto . "' t) a, stats_yuntas Y) SY   " . 
                            "ON         R.jockeyid=SY.jockeyid  " . 
                            "AND        R.trainerid=SY.trainerid  " . 
                            "WHERE      RA.id = " . $row["raceid"] . " " .
                            "AND        SY.campaing = CHAR(ASCII('G'))  " . 
                            "ORDER BY   SY.efectiveness DESC, SY.secondplace DESC, " . 
                            "           SY.thirdplace DESC, SY.totalraces DESC";
                if (!$rs2 = $db->query($sql2))
                    badEnd("500", array("sql"=>$sql2, "msg"=>$db->error));
                // CREAR TABLA DE YUNTA
                $yuntatable = $statscell->addTable([$statsTableStyle]);
                // titulo
                $yuntatable->addRow();
                $tabwidth = $width/2*0.68;
                $cell = $yuntatable->addCell($tabwidth, $statsTitCellStyle);
                $cell->addText("Yunta Jinete / Entrenador / " . date('Y', strtotime($row["reuniondate"])),
                                $recordsTitText, $recordsTitPar);
                $reuniondate = $row["reuniondate"];
                // header
                $yuntatable->addRow();
                $cell = $yuntatable->addCell($tabwidth*0.36, $statsHdrCellStyle);
                $cell->addText("Ejemplar",
                                $recordsHdrLeftText, $recordsHdrLeftPar);
                $cell = $yuntatable->addCell($tabwidth*0.08, $statsHdrCellStyle);
                $cell->addText("T.A.",
                                $recordsHdrText, $recordsHdrPar);
                $cell = $yuntatable->addCell($tabwidth*0.08, $statsHdrCellStyle);
                $cell->addText("1°",
                                $recordsHdrText, $recordsHdrPar);
                $cell = $yuntatable->addCell($tabwidth*0.08, $statsHdrCellStyle);
                $cell->addText("2°",
                                $recordsHdrText, $recordsHdrPar);
                $cell = $yuntatable->addCell($tabwidth*0.08, $statsHdrCellStyle);
                $cell->addText("3°",
                                $recordsHdrText, $recordsHdrPar);
                $cell = $yuntatable->addCell($tabwidth*0.08, $statsHdrCellStyle);
                $cell->addText("N.F.",
                                $recordsHdrText, $recordsHdrPar);
                $cell = $yuntatable->addCell($tabwidth*0.08, $statsHdrCellStyle);
                $cell->addText("S.G.",
                                $recordsHdrText, $recordsHdrPar);
                $cell = $yuntatable->addCell($tabwidth*0.08, $statsHdrCellStyle);
                $cell->addText("Efect",
                                    $recordsHdrText, $recordsHdrPar);

                // detalles
                for ($i=0; $i<3; $i++){
                    if ($row2 = $rs2->fetch_assoc()){
                        $yuntatable->addRow();
                        $cell = $yuntatable->addCell($tabwidth*0.36, $statsDetCellStyle);
                        $cell->addText($row2["horsename"],
                                        $recordsDetLeftText, $recordsDetLeftPar);
                        $cell = $yuntatable->addCell($tabwidth*0.08, $statsDetLeftBrdCellStyle);
                        $cell->addText($row2["totalraces"],
                                        $recordsDetText, $recordsDetPar);
                        $cell = $yuntatable->addCell($tabwidth*0.08, $statsDetCellStyle);
                        $cell->addText($row2["firstplace"],
                                        $recordsDetText, $recordsDetPar);
                        $cell = $yuntatable->addCell($tabwidth*0.08, $statsDetLeftBrdCellStyle);
                        $cell->addText($row2["secondplace"],
                                        $recordsDetText, $recordsDetPar);
                        $cell = $yuntatable->addCell($tabwidth*0.08, $statsDetCellStyle);
                        $cell->addText($row2["thirdplace"],
                                        $recordsDetText, $recordsDetPar);
                        $cell = $yuntatable->addCell($tabwidth*0.08, $statsDetCellStyle);
                        $cell->addText($row2["nowinplace"],
                                        $recordsDetText, $recordsDetPar);
                        $cell = $yuntatable->addCell($tabwidth*0.08, $statsDetCellStyle);
                        if ($row2["lastwinrace"] == "1900-01-01"){
                            $sg = $blank;
                        }else{
                            // calcular actuaciones sin ganar
                            $sql3 = "SELECT     COUNT(*) cnt " .
                                    "FROM       racers R  " .
                                    "INNER JOIN races RA  " .
                                    "ON	        R.raceid=RA.id " .
                                    "INNER JOIN reunions RE  " .
                                    "ON	        RA.reunionid=RE.id " .
                                    "WHERE 	    R.jockeyid=" . $row2["jockeyid"] . " " . 
                                    "AND        R.trainerid=" . $row2["trainerid"] . " " . 
                                    "AND        R.arrivalposition > 1 " .
                                    "AND        RE.date >= '" . $row2["lastwinrace"] . "' " .
                                    "AND        RA.number > '" . $row2["lastwinracenmbr"] . "' " .
                                    "AND        RE.date < '" . $date . "'";
                            if (!$rs3 = $db->query($sql3))
                                badEnd("500", array("sql"=>$sql3, "msg"=>$db->error));
                            if (!$row3 = $rs3->fetch_assoc())
                                badEnd("500", array("sql"=>$sql3, "msg"=>"Ocurrio un error"));
                            $sg = $row3["cnt"];
                        }
                        $cell->addText($sg,
                                        $recordsDetText, $recordsDetPar);
                        $cell = $yuntatable->addCell($tabwidth*0.08, $statsDetLeftBrdCellStyle);
                        $cell->addText(number_format($row2["efectiveness"],0) ."%",
                                        $recordsDetText, $recordsDetPar);
                    }
                }
                $statscell->addText($blank, $separadorText, $separadorPar);

                // DISTANCIA
                $datefrom = '1900-01-01';
                $dateto =   date('Y-m-d', strtotime('-1 day', strtotime($date)));
                $sql2 =     "SELECT      H.id, H.dsc horsename, SUM(SH.totalraces) totalraces, " . 
                            "            SUM(SH.firstplace) firstplace, SUM(SH.secondplace) secondplace, " . 
                            "            SUM(SH.thirdplace) thirdplace, SUM(SH.noplace) noplace, " . 
                            "            MAX(SH.firstplacedate) firstplacedate, RA.distanceid distid, " . 
                            "            ROUND(IF(SUM(SH.totalraces)<>0,SUM(SH.firstplace)/SUM(SH.totalraces),0)*100,0) efectiveness " . 
                            "FROM        racers R " . 
                            "INNER JOIN  horses H  " . 
                            "ON          R.horseid=H.id " . 
                            "INNER JOIN  races RA  " . 
                            "ON          R.raceid=RA.id " . 
                            "INNER JOIN  reunions RE  " . 
                            "ON          RA.reunionid=RE.id " . 
                            "INNER JOIN  (SELECT H.* FROM (select @df:='".$datefrom."' f, @dt:='".$dateto."' t) a, stats_horses H) SH  " . 
                            "ON          R.horseid=SH.horseid " . 
                            "AND         RA.distanceid=SH.distanceid " . 
                            "WHERE       RA.id = " . $row["raceid"] . " " .
                            "GROUP BY	 H.id, H.dsc " . 
                            "ORDER BY	 IF(SUM(SH.totalraces)<>0,SUM(SH.firstplace)/SUM(SH.totalraces),0) DESC,  " . 
			                "            SUM(SH.secondplace) DESC, SUM(SH.thirdplace) DESC, SUM(SH.totalraces) DESC";
                if (!$rs2 = $db->query($sql2))
                    badEnd("500", array("sql"=>$sql2, "msg"=>$db->error));
                // CREAR TABLA DE DISTANCIA
                $yuntatable = $statscell->addTable([$statsTableStyle]);
                // titulo
                $yuntatable->addRow();
                $tabwidth = $width/2*0.68;
                $cell = $yuntatable->addCell($tabwidth, $statsTitCellStyle);
                $cell->addText("Los Mejores en la Distancia",
                                $recordsTitText, $recordsTitPar);
                // header
                $yuntatable->addRow();
                $cell = $yuntatable->addCell($tabwidth*0.36, $statsHdrCellStyle);
                $cell->addText("Ejemplar",
                                $recordsHdrLeftText, $recordsHdrLeftPar);
                $cell = $yuntatable->addCell($tabwidth*0.08, $statsHdrCellStyle);
                $cell->addText("T.A.",
                                $recordsHdrText, $recordsHdrPar);
                $cell = $yuntatable->addCell($tabwidth*0.08, $statsHdrCellStyle);
                $cell->addText("1°",
                                $recordsHdrText, $recordsHdrPar);
                $cell = $yuntatable->addCell($tabwidth*0.08, $statsHdrCellStyle);
                $cell->addText("2°",
                                $recordsHdrText, $recordsHdrPar);
                $cell = $yuntatable->addCell($tabwidth*0.08, $statsHdrCellStyle);
                $cell->addText("3°",
                                $recordsHdrText, $recordsHdrPar);
                $cell = $yuntatable->addCell($tabwidth*0.08, $statsHdrCellStyle);
                $cell->addText("N.F.",
                                $recordsHdrText, $recordsHdrPar);
                $cell = $yuntatable->addCell($tabwidth*0.08, $statsHdrCellStyle);
                $cell->addText("S.G.",
                                $recordsHdrText, $recordsHdrPar);
                $cell = $yuntatable->addCell($tabwidth*0.08, $statsHdrCellStyle);
                $cell->addText("Efect",
                                    $recordsHdrText, $recordsHdrPar);
                // detalles
                for ($i=0; $i<3; $i++){
                    if ($row2 = $rs2->fetch_assoc()){
                        $yuntatable->addRow();
                        $cell = $yuntatable->addCell($tabwidth*0.36, $statsDetCellStyle);
                        $cell->addText($row2["horsename"],
                                        $recordsDetLeftText, $recordsDetLeftPar);
                        $cell = $yuntatable->addCell($tabwidth*0.08, $statsDetLeftBrdCellStyle);
                        $cell->addText($row2["totalraces"],
                                        $recordsDetText, $recordsDetPar);
                        $cell = $yuntatable->addCell($tabwidth*0.08, $statsDetCellStyle);
                        $cell->addText($row2["firstplace"],
                                        $recordsDetText, $recordsDetPar);
                        $cell = $yuntatable->addCell($tabwidth*0.08, $statsDetLeftBrdCellStyle);
                        $cell->addText($row2["secondplace"],
                                        $recordsDetText, $recordsDetPar);
                        $cell = $yuntatable->addCell($tabwidth*0.08, $statsDetCellStyle);
                        $cell->addText($row2["thirdplace"],
                                        $recordsDetText, $recordsDetPar);
                        $cell = $yuntatable->addCell($tabwidth*0.08, $statsDetCellStyle);
                        $cell->addText($row2["noplace"],
                                        $recordsDetText, $recordsDetPar);
                        $cell = $yuntatable->addCell($tabwidth*0.08, $statsDetCellStyle);
                        if ($row2["firstplacedate"] == "1900-01-01"){
                            $sg = $blank;
                        }else{
                            // calcular actuaciones sin ganar
                            $sql3 = "SELECT     COUNT(*) cnt " .
                                    "FROM       racers R  " .
                                    "INNER JOIN races RA  " .
                                    "ON	        R.raceid=RA.id " .
                                    "INNER JOIN reunions RE  " .
                                    "ON	        RA.reunionid=RE.id " .
                                    "WHERE 	    R.horseid=" . $row2["id"] . " " . 
                                    "AND        RA.distanceid=" . $row2["distid"] . " " . 
                                    "AND        RE.date > '" . $row2["firstplacedate"] . "' " .
                                    "AND        RE.date < '" . $date . "'";
                            if (!$rs3 = $db->query($sql3))
                                badEnd("500", array("sql"=>$sql3, "msg"=>$db->error));
                            if (!$row3 = $rs3->fetch_assoc())
                                badEnd("500", array("sql"=>$sql3, "msg"=>"Ocurrio un error"));
                            $sg = $row3["cnt"];
                        }
                        $cell->addText($sg,
                                        $recordsDetText, $recordsDetPar);
                        $cell = $yuntatable->addCell($tabwidth*0.08, $statsDetLeftBrdCellStyle);
                        $cell->addText(number_format($row2["efectiveness"],0) ."%",
                                        $recordsDetText, $recordsDetPar);
                    }
                }
                $statscell->addText($blank, $separadorText, $separadorPar);

            // ENCABEZADO DEL DETALLE
            $detailtable = $section->addTable([$defaultTableFullWidthStyle]);
                $detailtable->addRow();
                $cell = $detailtable->addCell($width*$C1, $headerCellStyle);
                $cell->addText( "N°", $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C2, $headerCellStyle);
                $cell->addText( "Propietario, Divisa, Ejemplar, Sexo, Pelaje, Edad, Padres y Origen"
                        , $header2Text, $headerPar);

                $cell = $detailtable->addCell($width*$C3, $headerCellStyle);
                $cell->addText( "Jinete, Ks, Imple-<w:br/>mentos, Prep."
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C4, $headerCellStyle);
                $cell->addText( "PP"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C5, $headerCellStyle);
                $cell->addText( "Fecha"
                        , $headerText, $headerLeftPar);
                $cell = $detailtable->addCell($width*$C6, $headerCellStyle);
                $cell->addText( "Carr. ant"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C7, $headerCellStyle);
                $cell->addText( "Peso Ejem"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C8, $headerCellStyle);
                $cell->addText( "Dtcia"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C9, $headerCellStyle);
                $cell->addText( "PP"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C10, $headerCellStyle);
                $cell->addText( "1000 300m"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C11, $headerCellStyle);
                $cell->addText( "Lleg"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C12, $headerCellStyle);
                $cell->addText( "Ks Jinete Divid"
                        , $headerText, $headerLeftPar);

                $cell = $detailtable->addCell($width*$C13, $headerCellStyle);
                $cell->addText( "Ganador"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C14, $headerCellStyle);
                $cell->addText( "Cpos"
                        , $headerText, $headerRightPar);

                $cell = $detailtable->addCell($width*$C15, $headerCellStyle);
                $cell->addText( "Serie"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C16, $headerCellStyle);
                $cell->addText( "T.T.C."
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C17, $headerCellStyle);
                $cell->addText( "Tmpo Gndor"
                        , $headerText, $headerLeftPar);

                $cell = $detailtable->addCell($width*$C18, $headerCellStyle);
                $cell->addText( "Tmpo Ejem"
                        , $headerText, $headerLeftPar);

                $cell = $detailtable->addCell($width*$C19, $headerCellStyle);
                $cell->addText( "# Ejs"
                        , $headerText, $headerPar);

            $top3 = $row["top3"];
        }
        // RENGLONES

        // Calcular actuaciones

        // Verificar información de pronósticos
        $racersfc = array();
        if (strlen($row["forecastracers"]))
            $racersfc = json_decode($row["forecastracers"]);

        $proncmt = getHorseForecasts($row["racerid"], $racersfc);
        if ($proncmt->forecast > 0 && $proncmt->forecast <= 3){
            $forecastarrdsc[$proncmt->forecast-1] = $row["horsename"];
        }
        if (strpos('-'.$top3.'-', '-'.trim($row["horsenumber"]).'-')===false)
            $bgstyle = $detailCellStyleBtnBrd;
        else
            $bgstyle = $detailCellStyleBlue;


        $detailtable->addRow();
        $cell = $detailtable->addCell($width*$C1, $bgstyle);
            $cell->addText( $row["horsenumber"]
                    , $horseNumberText, $horseNumberPar);

        $cell = $detailtable->addCell($width*$C2, $detailCellStyleBtnRghBrd);

            $cell->addText( "Stud \"" . clnprn($row["studname"]) . "\" - " . clnprn($row["studabbr"])
                    , $horsedetailsText, $horsedetailsPar);
            $cell->addText( $row["horsename"], $horsenameText, $horsenamePar);
            $cell->addText( $row["gender"] . ".". $row["furabbr"] . "." . $row["age"] . "a " . $row["horsefather"] . " - " . $row["horsemother"]
                    , $horsedetailsText, $horsedetailsPar);
            $cell->addText( "p. " . $row["horsegfather"] . "\t" . $row["horsebirth"]
                    , $horsedetailsText, $horsedetailsPar);

        $cell = $detailtable->addCell($width*$C3, $detailCellStyleBtnBrd);

            $cell->addText( $row["jockeyname"] . " (" . $row["jockeyef"] . ")"
                    , $jockeynameText, $jockeynamePar);
            $cell->addText( $row["jockeyweight"]
                , $jockeyweightText, $jockeyweightPar);
            // medicamentos
            $medicaments = [];
            if (strlen($row["medicaments"]))
                $medicaments = json_decode($row["medicaments"]);
            $meds = "";
            foreach($medicaments as $medicament)
                $meds .= $medicament->abbr . "-";
            if ($meds == "") $meds = "--"; else $meds = substr($meds, 0, -1) ;
            // implementos
            $implements = [];
            if (strlen($row["implements"]))
                $implements = json_decode($row["implements"]);
            $imps = "";
            foreach($implements as $implement)
                $imps .= $implement->abbr . ".";
            if ($imps == "") $imps = "--";
            $cell->addText( $imps
                , $implementsText, $implementsPar);
            $cell->addText( $row["trainername"] . " (" . $row["traineref"] . ")"
                , $trainerText, $trainerPar);

        $cell = $detailtable->addCell($width*$C4, $detailCellStyleBlue);
            $cell->addText( $row["horseposition"]
                , $positionText, $positionPar);

        $cell = $detailtable->addCell($anchoHistoria, $detailCellSpanStyleBtnBrd);

            $htsareatable = $cell->addTable([$defaultTableHstWidthStyle]);
            // historia
            $hsttable = $cell->addTable([$defaultTableHstWidthStyle]);
            $sql3 = "SELECT     * " .
                    "FROM " .
                    "(" .
                    "SELECT     * " .
                    "FROM       wrk_horsehistory " .
                    "WHERE      horseid = " . $row["horseid"] . " " .
                    "AND        raceid <> " . $row["raceid"] . " " .
                    "AND        date < '"   . $row["reuniondate"] . "' " .
                    "ORDER BY   date desc " .
                    "LIMIT 4 " .
                    ") A " .
                    "ORDER BY   date ";
            if (!$rs3 = $db->query($sql3))
                badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

            $lastrun = "";
            $ttc = 0;
            $lastraceid = 0;
            for  ($i=0; $i<4; $i++){
                // no tiene carreras
                if (mysqli_num_rows($rs3) == 0){
                    $hsttable->addRow(-118*4);
                    $cell = $hsttable->addCell($anchoHistoria, $detailCellSpanStyle);
                        $cell->addText(clnprn($row["horseobs"]), $historyText, $historyLeftPar);
                    $i += 1;
                    $i = 4;
                } else
                // lineas en blanco antes
                if ($i < 4 - mysqli_num_rows($rs3)){
                    $hsttable->addRow(-118);
                    $cell = $hsttable->addCell($anchoHistoria, $detailCellSpanStyle);
                        $cell->addText($blank, $historyText, $historyLeftPar);
                    //$i += 1;
                }else{
                    if ($row3 = $rs3->fetch_assoc()){
                        // guardar raceid para luego calcular las diferencias de implementos
                        $lastraceid = $row3["raceid"];
                        // calcular sr para pronosticos
                        $ttc += ($row3["srating"]*1);

                        $hsttable->addRow(-118);
                        $cell = $hsttable->addCell($width*$C5, $detailCellStyle);
                            $cell->addText(date_format(date_create($row3["date"]), 'd-m'), $historyText, $historyLeftPar);
                        $cell = $hsttable->addCell($width*$C6, $detailCellStyle);
                            $cell->addText($row3["racecourseabbr"].$row3["racenumber"], $historyText, $historyPar);
                            if ($row3["retdsc"]==""){
                                $cell = $hsttable->addCell($width*$C7, $detailCellStyle);
                                    $cell->addText($row3["weight"], $historyText, $historyPar);
                                $cell = $hsttable->addCell($width*$C8, $detailCellStyle);
                                    $cell->addText($row3["distancename"], $historyText, $historyPar);
                                $cell = $hsttable->addCell($width*$C9, $detailCellStyle);
                                    $cell->addText($row3["position"], $historyText, $historyPar);
                                $cell = $hsttable->addCell($width*$C10, $detailCellStyle);
                                    $cell->addText($row3["pos800"]."   ".$row3["pos400"], $historyText, $historyPar);
                                $cell = $hsttable->addCell($width*$C11, $detailCellStyle);
                                    $cell->addText($row3["arrivalposition"] . $blank, $historyArrivalPText, $historyPar);
                                $cell = $hsttable->addCell($width*$C12+$width*$C13, $detailSpan2CellStyle);
                                    if ($row3["arrivalposition"] == "1")
                                        $cell->addText($row3["jockeyweight"]." ".$row3["jockeyabbr"].",".number_format($row3["dividends"],2,",","") . "\t2°".norm($row3["seconddsc"]), $historyText, $historySpanLeftPar);
                                    else
                                        $cell->addText($row3["jockeyweight"]." ".$row3["jockeyabbr"].",".number_format($row3["dividends"],2,",","") . "\t".norm($row3["winnerdsc"]), $historyText, $historySpanLeftPar);
                                //$cell = $hsttable->addCell($width*$C13, $detailCellStyle);
                                //    $cell->addText(norm($row3["winnerdsc"]), $historyText, $historyRightPar);
                                $cell = $hsttable->addCell($width*$C14, $detailCellStyle);
                                    $cell->addText($row3["bodiesabbr"] == '' ? $blank : $row3["bodiesabbr"], $historyText, $historyRightPar);
                                $cell = $hsttable->addCell($width*$C15, $detailCellStyle);
                                    $cell->addText(substr($row3["serie"], 0, 6), $historyText, $historyPar);
                                $cell = $hsttable->addCell($width*$C16, $detailCellStyle);
                                    $cell->addText(number_format($row3["srating"],0,",","."), $historyBoldText, $historyPar);
                                $cell = $hsttable->addCell($width*$C17, $detailCellStyle);
                                    $cell->addText(number_format($row3["winnertime"],1,",","."), $historyText, $historyRightPar);
                                $cell = $hsttable->addCell($width*$C18, $detailCellStyle);
                                    if ($row3["arrivalposition"] == "1")
                                        $cell->addText("Ganó", $historyText, $historyRightPar);
                                    else
                                        if ($row3["stumbledsc"] != "")
                                            $cell->addText($row3["stumbledsc"], $historyText, $historyRightPar);
                                        else
                                        $cell->addText(number_format($row3["finishtime"],1,",","."), $historyText, $historyRightPar);
                                $cell = $hsttable->addCell($width*$C19, $detailCellStyle);
                                    $cell->addText($row3["horsenumber"], $historyText, $historyRightPar);
                            }else{  // Retirado
                                $cell = $hsttable->addCell($width*$C7, $detailSpan12CellStyle);
                                    $retword = $row["gender"]=="Y" ? "Retirada" : "Retirado";
                                    $cell->addText($retword . " por " . $row3["retdsc"], $historyText, $historyLeftPar);
                            }
                            $lastrun = $row3["date"];
                    }
                }
            }

            $ttcarr[$row["horsenumber"]] = $ttc;

            $sincorrer = "";

            if ($lastrun != "" && intval((strtotime($reuniondate) - strtotime($lastrun)) / (60 * 60 * 24)) >= 35){
                $sincorrer = intval((strtotime($reuniondate) - strtotime($lastrun)) / (60 * 60 * 24)) . "sc/";
            }

            $sql4 = "SELECT     SUM(IF(R.arrivalposition>0, 1, 0)) cnt, " . 
                    "           SUM(IF(R.arrivalposition=1, 1, 0)) cntwin, " . 
                    "           MAX(IF(R.arrivalposition=1, RE.date, '1900-01-01')) datwin, " . 
                    "           SUM(IF(R.arrivalposition>0 AND YEAR(RE.date)=YEAR('" . $date . "'), 1, 0)) cntyr, " . 
                    "           SUM(IF(R.arrivalposition=1 AND YEAR(RE.date)=YEAR('" . $date . "'), 1, 0)) cntyrwin, " . 
                    "           MAX(IF(R.arrivalposition=1 AND YEAR(RE.date)=YEAR('" . $date . "'), RE.date, '1900-01-01')) datyrwin, " . 
                    "           SUM(IF(R.arrivalposition=1 AND YEAR(RE.date)=YEAR('" . $date . "'), IFNULL(RA.mainprice,0) * IFNULL(RA.firstplace,0) / 100, 0)) prc1, " . 
                    "           SUM(IF(R.arrivalposition=2 AND YEAR(RE.date)=YEAR('" . $date . "'), IFNULL(RA.mainprice,0) * IFNULL(RA.secondplace,0) / 100, 0)) prc2, " . 
                    "           SUM(IF(R.arrivalposition=3 AND YEAR(RE.date)=YEAR('" . $date . "'), IFNULL(RA.mainprice,0) * IFNULL(RA.thirdplace,0) / 100, 0)) prc3, " . 
                    "           SUM(IF(R.arrivalposition=4 AND YEAR(RE.date)=YEAR('" . $date . "'), IFNULL(RA.mainprice,0) * IFNULL(RA.fourthplace,0) / 100, 0)) prc4, " . 
                    "           SUM(IF(R.arrivalposition=5 AND YEAR(RE.date)=YEAR('" . $date . "'), IFNULL(RA.mainprice,0) * IFNULL(RA.fifthplace,0) / 100, 0)) prc5, " . 
                    "           SUM( " . 
                    "               CASE R.arrivalposition " . 
                    "                   WHEN 1 THEN IFNULL(RA.mainprice,0) * IFNULL(RA.firstplace,0) / 100 " . 
                    "                   WHEN 2 THEN IFNULL(RA.mainprice,0) * IFNULL(RA.secondplace,0) / 100 " . 
                    "                   WHEN 3 THEN IFNULL(RA.mainprice,0) * IFNULL(RA.thirdplace,0) / 100 " . 
                    "                   WHEN 4 THEN IFNULL(RA.mainprice,0) * IFNULL(RA.fourthplace,0) / 100 " . 
                    "                   WHEN 5 THEN IFNULL(RA.mainprice,0) * IFNULL(RA.fifthplace,0) / 100 " . 
                    "                   ELSE 0 " . 
                    "               END) pricebsX " . 
                                "FROM       racers R " . 
                    "INNER JOIN races RA " . 
                    "ON         R.raceid=RA.id " . 
                    "INNER JOIN reunions RE " . 
                    "ON         RA.reunionid=RE.id " .
                    "WHERE      R.horseid=" . $row["horseid"] . " " . 
                    "AND        RE.date<'" . $date . "'"; 
            if (!$rs4 = $db->query($sql4))
                badEnd("500", array("sql"=>$sql4, "msg"=>$db->error));
            if (!$row4 = $rs4->fetch_assoc())
                badEnd("500", array("sql"=>$sql4, "msg"=>"ERROR RARO"));

            // calcular días sin ganar general
            if (!isset($row4["datwin"]) || $row4["datwin"] == "1900-01-01"){
                $sg = "-";
            }else{
                // calcular actuaciones sin ganar
                $sql3 = "SELECT     COUNT(*) cnt " .
                        "FROM       racers R  " .
                        "INNER JOIN races RA  " .
                        "ON	        R.raceid=RA.id " .
                        "INNER JOIN reunions RE  " .
                        "ON	        RA.reunionid=RE.id " .
                        "WHERE 	    R.horseid=" . $row["horseid"] . " " . 
                        "AND        RE.date > '" . $row4["datwin"] . "' " .
                        "AND        RE.date < '" . $date . "'";
                if (!$rs3 = $db->query($sql3))
                    badEnd("500", array("log"=>4,"sql"=>$sql3, "msg"=>$db->error));
                if (!$row3 = $rs3->fetch_assoc())
                    badEnd("500", array("sql"=>$sql3, "msg"=>"Ocurrio un error"));
                $sg = $row3["cnt"];
            }
            // calcular días sin ganar este año
            if (!isset($row4["datyrwin"]) || $row4["datyrwin"] == "1900-01-01"){
                $sgyr = "-";
            }else{
                // calcular actuaciones sin ganar
                $sql3 = "SELECT     COUNT(*) cnt " .
                        "FROM       racers R  " .
                        "INNER JOIN races RA  " .
                        "ON	        R.raceid=RA.id " .
                        "INNER JOIN reunions RE  " .
                        "ON	        RA.reunionid=RE.id " .
                        "WHERE 	    R.horseid=" . $row["horseid"] . " " . 
                        "AND        RE.date > '" . $row4["datyrwin"] . "' " .
                        "AND        RE.date < '" . $date . "'";
                if (!$rs3 = $db->query($sql3))
                    badEnd("500", array("log"=>2,"sql"=>$sql3, "msg"=>$db->error));
                if (!$row3 = $rs3->fetch_assoc())
                    badEnd("500", array("sql"=>$sql3, "msg"=>"Ocurrio un error"));
                $sgyr = $row3["cnt"];
            }

            // calcular diferencia de implementos
            if ($lastraceid != 0){
                // bucar implementos de la última carrera
                $sql3 = "SELECT     implementstypeI implements " . 
                        "FROM       races RA " . 
                        "INNER JOIN racers R " . 
                        "ON         RA.id = R.raceid " . 
                        "WHERE      horseid=" . $row["horseid"] . " " . 
                        "AND        RA.id=" . $lastraceid;
                if (!$rs3 = $db->query($sql3))
                    badEnd("500", array("sql"=>$sql3, "msg"=>$db->error));
                if (!$row3 = $rs3->fetch_assoc())
                    badEnd("500", array("sql"=>$sql3, "msg"=>"Ocurrio un error"));
                $lastimplements = json_decode($row3["implements"]);
                // calcular diferencias
                $restar = "";
                foreach($lastimplements as $limp){
                    $found=false;
                    foreach($implements as $imp)
                        if ($limp->abbr == $imp->abbr)
                            $found = true;
                    if (!$found)
                        $restar .= "-" . $limp->abbr;
                }
                $sumar = "";
                foreach($implements as $imp){
                    $found=false;
                    foreach($lastimplements as $limp)
                        if ($limp->abbr == $imp->abbr)
                            $found = true;
                    if (!$found)
                        $sumar .= "+" . $imp->abbr;
                }
            }

            $pricebs = $row4["prc1"] + $row4["prc2"] + $row4["prc3"] + $row4["prc4"] + $row4["prc5"];
            $pricebs = floatval($row4["pricebsX"]);
            $bsstr = "";
            if ($pricebs != 0)
                $bsstr = " " . $row["pricecurr"] . ". " . number_format($pricebs,2,",",".");
            // addional info
            $hsttable->addRow(-118);
            $cell = $hsttable->addCell($anchoHistoria, $detailCellSpanStyle);
                if (mysqli_num_rows($rs3) != 0)
                    $cell->addText( "De " . $row4["cnt"] . "-" . $row4["cntwin"] . "(" . $sg . ")," . 
                                    "De " . $row4["cntyr"] . "-" . $row4["cntyrwin"] . "(" . $sgyr . ") "
                                    . $proncmt->comment . " " . $sumar . $restar . " (" . $meds . ")"
                                    . "\t" . $sincorrer . clnprn($row["harasname"]) . $bsstr
                                , $addDataText, $addDataPar);
                else
                    $cell->addText( $proncmt->comment . " (" . $meds . ")"
                                    . "\t" . $sincorrer . clnprn($row["harasname"])
                                , $addDataText, $addDataPar);


    }
    if ($actualrace != ""){
        $foottable = $section->addTable([$defaultTableFullWidthStyle]);
        $foottable->addRow();
        $cell = $foottable->addCell($width/7*2, $sloganCellStyle);
        if ($pool4[$actualrace] == "0")
            $cell->addText("Suerte y... Gaceta Hípica",
                            $footSloganDataText,
                            $footSloganDataPar
            );
        else
            $cell->addText($pool4[$actualrace] . "ª Pool de 4",
                            $footPoolDe4Text,
                            $footSloganDataPar
            );
        $cell = $foottable->addCell($width/7*5);
        arsort($ttcarr);
        $srtop5 = "";
        $keys = array_keys($ttcarr);
        for($i = 0; $i < 5; $i++)
            $srtop5 .= $keys[$i] . "-";
        $cell->addText("\tNuestros Favoritos: " . $top3 .
                        "\tPor Rating: " . substr($srtop5, 0, -1),
                        $footFavDataText,
                        $footFavDataPar
        );
        $cell->addText("\t" . $forecastarrdsc[0] . " - " . $forecastarrdsc[1] . " - " . $forecastarrdsc[2],
                        $footFavNamText,
                        $footFavNamPar
        );
    }

    switch ($outputformat){
        case "pdf":
            $domPdfPath = realpath(__DIR__ . '/../../../hooks/Dompdf/Dompdf');
            \PhpOffice\PhpWord\Settings::setPdfRendererPath($domPdfPath);
            \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
            
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord , 'PDF');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        case "docx":
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        default:
            die ("FORMATO DE SALIDA INVALIDO");
    }
//die();
    header("Content-Disposition: attachment; filename=" . $filename);
    readfile($temp_file); // or echo file_get_contents($temp_file);
    unlink($temp_file);

    function norm($dsc){
        $out = ucwords(mb_strtolower($dsc, 'UTF-8'));
        $out = str_replace(" De ", " de ", $out);
        $out = str_replace(" La ", " la ", $out);
        $out = str_replace(" El ", " el ", $out);
        $out = str_replace(" En ", " en ", $out);
        return($out);
    }
    function getHorseForecasts($racerid, $json){
        $salida = json_decode(json_encode(["id"=>0, "number"=>0, "arrivalposition"=>0, "forecast"=>0, "comment"=>"--"]));

        if ($json != null){
            foreach($json as $pron){
                if ($pron->id == $racerid){
                    $salida = $pron;
                }
            }
        }
        return($salida);
    }
    function clnprn($valor){
        return (trim(preg_replace("/[^a-zA-Z0-9 \"\'.,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", str_replace("&", "y", $valor))));
    }
?>