<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../settings/dbconn.php");
    include("../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    
    $userid = isSessionValid($db, $sessionid);
    
    function getMenu($db, $userid, $father=0){
        if ($father==0)
            $fatherwhere = " M.father IS NULL ";
        else
            $fatherwhere = " M.father = '". $father. "' ";

        $sql =  "SELECT     M.id, M.dsc, M.imgfont, M.content, IF(P.privilegeid IS NULL, 0, 1) access " .
                "FROM       menus M " . 
                "LEFT JOIN  ( " .
                "            SELECT     P.privilegeid " .
                "            FROM       userprivileges P " .
                "            WHERE      P.userid = " . $userid . 
                "           ) P " .
                "ON         M.privilegeid = P.privilegeid " .
                "WHERE      " . $fatherwhere .
                "ORDER BY   M.orden ";

        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    
        $records = array();
        
        while ($row = $rs->fetch_assoc()){
            $record = new stdClass;
            $record->id=(integer)$row["id"];
            $record->access = (boolean) $row['access']!=0;
            $record->dsc=$row["dsc"];  
            $record->content = $row["content"];
            $record->imgfont = nvl($row["imgfont"], "");
            $record->submenu = getMenu($db, $userid, (integer)$row["id"]);
            
            $records[] = $record;
        }
        
        return($records);
    }

    $out= new stdClass;
    $out->options = getMenu($db, $userid);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
