<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("id", "name", "abbr", "gender", "furid", "birthdate", "harasid", "status", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $name = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["name"]);
    $abbr = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["abbr"]);
    $gender = preg_replace("/[^YC]+/", "", $_REQUEST["gender"]);
    $furid = intval($_REQUEST["furid"]);
    $birthdate = preg_replace("/[^0-9-]+/", "", $_REQUEST["birthdate"]);
    $harasid = intval($_REQUEST["harasid"]);
    $status = intval($_REQUEST["status"]);

    // corregir decodificar apóstrofes y comillas en el nombre
    $name = str_replace("/*.*/", "\'", $name);
    $name = str_replace("/*-*/", "\"", $name);

    // parametros opcionales
    $origin = "NULL";
    if (isset($_REQUEST["origin"])){
        $origin = "'" . preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["origin"]) . "'";
    }
    $obs = "NULL";
    if (isset($_REQUEST["obs"])){
        $obs = "'" . preg_replace("/[^a-zA-Z0-9 \n.,:\-()@$&+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["obs"]) . "'";
        $obs = str_replace("/*.*/", "\'", $obs);
        $obs = str_replace("/*-*/", "\"", $obs);
        $obs = str_replace("/*:*/", "\`", $obs);
        }
    $fatherid = "NULL";
    if (isset($_REQUEST["fatherid"])){
        $fatherid = "'" . intval($_REQUEST["fatherid"]) . "'";
    }
    $fathername = "NULL";
    if (isset($_REQUEST["fathername"])){
        $fathername = "'" . preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["fathername"]) . "'";
        // corregir decodificar apóstrofes y comillas en el nombre
        $fathername = str_replace("/*.*/", "\'", $fathername);
        $fathername = str_replace("/*:*/", "\`", $fathername);
    }
    $fatherobs = "NULL";
    if (isset($_REQUEST["fatherobs"])){
        $fatherobs = "'" . preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["fatherobs"]) . "'";
    }
    $motherid = "NULL";
    if (isset($_REQUEST["motherid"])){
        $motherid = "'" . intval($_REQUEST["motherid"]) . "'";
    }
    $mothername = "NULL";
    if (isset($_REQUEST["mothername"])){
        $mothername = "'" . preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["mothername"]) . "'";
        // corregir decodificar apóstrofes y comillas en el nombre
        $mothername = str_replace("/*.*/", "\'", $mothername);
        $mothername = str_replace("/*:*/", "\`", $mothername);
    }
    $motherobs = "NULL";
    if (isset($_REQUEST["motherobs"])){
        $motherobs = "'" . preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["motherobs"]) . "'";
    }
    $fathergfname = "NULL";
    if (isset($_REQUEST["fathergfname"])){
        $fathergfname = "'" . preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["fathergfname"]) . "'";
        // corregir decodificar apóstrofes y comillas en el nombre
        $fathergfname = str_replace("/*.*/", "\'", $fathergfname);
        $fathergfname = str_replace("/*:*/", "\`", $fathergfname);
    }
    $fathergfobs = "NULL";
    if (isset($_REQUEST["fathergfobs"])){
        $fathergfobs = "'" . preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["fathergfobs"]) . "'";
    }
    $fathergmname = "NULL";
    if (isset($_REQUEST["fathergmname"])){
        $fathergmname = "'" . preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["fathergmname"]) . "'";
        // corregir decodificar apóstrofes y comillas en el nombre
        $fathergmname = str_replace("/*.*/", "\'", $fathergmname);
        $fathergmname = str_replace("/*:*/", "\`", $fathergmname);
    }
    $fathergmobs = "NULL";
    if (isset($_REQUEST["fathergmobs"])){
        $fathergmobs = "'" . preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["fathergmobs"]) . "'";
    }
    $mothergfname = "NULL";
    if (isset($_REQUEST["mothergfname"])){
        $mothergfname = "'" . preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["mothergfname"]) . "'";
        // corregir decodificar apóstrofes y comillas en el nombre
        $mothergfname = str_replace("/*.*/", "\'", $mothergfname);
        $mothergfname = str_replace("/*:*/", "\`", $mothergfname);
    }
    $mothergfobs = "NULL";
    if (isset($_REQUEST["mothergfobs"])){
        $mothergfobs = "'" . preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["mothergfobs"]) . "'";
    }
    $mothergmname = "NULL";
    if (isset($_REQUEST["mothergmname"])){
        $mothergmname = "'" . preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["mothergmname"]) . "'";
        // corregir decodificar apóstrofes y comillas en el nombre
        $mothergmname = str_replace("/*.*/", "\'", $mothergmname);
        $mothergmname = str_replace("/*:*/", "\`", $mothergmname);
    }
    $mothergmobs = "NULL";
    if (isset($_REQUEST["mothergmobs"])){
        $mothergmobs = "'" . preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["mothergmobs"]) . "'";
    }

    if($status!=0 && $status!=1)
        badEnd("400", array("msg"=>"El parámetro status puede ser 0 o 1"));

    isSessionValid($db, $sessionid);

    if ($id==0){    // incluir registro
        if (!tienePrivilegio($db, $sessionid, 462, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));

        // validación de campos únicos para evitar el salto del autoincement XP
        $sql =  "SELECT id " .
                "FROM   horses " . 
                "WHERE  abbr='" . $abbr . "'";
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        if ($row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Registro Duplicado"));
            
        $sql =  "INSERT INTO horses " .
                "       (`dsc`, `abbr`, `gender`, `furid`, `birthdate`, `harasid`, " . 
                "       `origin`, `obs`, `status`, `fatherid`, `fathername`, `motherid`, " . 
                "       `mothername`, `fathergfname`, `fathergmname`, `mothergfname`, `mothergmname`, " .
                "       `fatherobs`, `motherobs`, `fathergfobs`, `fathergmobs`, `mothergfobs`, `mothergmobs`) " .
                "VALUES (" .
                "        '" . $name . "'," .
                "        '" . $abbr . "'," .
                "        '" . $gender . "'," .
                "        '" . $furid . "', " .
                "        '" . $birthdate . "', " .
                "        '" . $harasid . "', " .
                "        " . $origin . ", " .
                "        " . $obs . ", " .
                "        '" . $status . "', " .
                "        " . $fatherid . ", " .
                "        " . $fathername . ", " .
                "        " . $motherid . ", " .
                "        " . $mothername . ", " .
                "        " . $fathergfname . ", " .
                "        " . $fathergmname . ", " .
                "        " . $mothergfname . ", " .
                "        " . $mothergmname . ", " .
                "        " . $fatherobs . ", " .
                "        " . $motherobs . ", " .
                "        " . $fathergfobs . ", " .
                "        " . $fathergmobs . ", " .
                "        " . $mothergfobs . ", " .
                "        " . $mothergmobs . " " .
                "        )";
        if (!$db->query($sql)){
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("msg"=>$db->error));
            }
        }

        $id = $db->insert_id;
        
        setAudit($db, "Ejemplares", $sessionid, "Se incluyó el ejemplar \'" . $name . "\' (" . $id . ")");
    }else{          // modificar registro
        if (!tienePrivilegio($db, $sessionid, 461, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "UPDATE horses " .
                "SET    dsc = '" . $name . "'," .
                "       abbr = '" . $abbr . "'," .
                "       gender = '" . $gender . "'," .
                "       furid = '" . $furid . "', " .
                "       birthdate = '" . $birthdate . "', " .
                "       harasid = '" . $harasid . "', " .
                "       origin = " . $origin . ", " .
                "       obs = " . $obs . ", " .
                "       status = '" . $status . "', " .
                "       fatherid = " . $fatherid . ", " .
                "       fathername = " . $fathername . ", " .
                "       motherid = " . $motherid . ", " .
                "       mothername = " . $mothername . ", " .
                "       fathergfname = " . $fathergfname . ", " .
                "       fathergmname = " . $fathergmname . ", " .
                "       mothergfname = " . $mothergfname . ", " .
                "       mothergmname = " . $mothergmname . ", " .
                "       fatherobs = " . $fatherobs . ", " .
                "       motherobs = " . $motherobs . ", " .
                "       fathergfobs = " . $fathergfobs . ", " .
                "       fathergmobs = " . $fathergmobs . ", " .
                "       mothergfobs = " . $mothergfobs . ", " .
                "       mothergmobs = " . $mothergmobs . " " .
                "WHERE  id=" . $id;
        if (!$db->query($sql))
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
            }
            
        setAudit($db, "Ejemplares", $sessionid, "Se actualizó el ejemplar \'" . $name . "\' (" . $id . ")");

    }

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>