<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("id", "sessionid", "name", "municipalityid", "initialpricesbs", "initialpricesusd", "initialraces", "abbr", "status");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $name = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["name"]);
    $municipalityid = intval($_REQUEST["municipalityid"]);
    $abbr = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["abbr"]);
    $status = intval($_REQUEST["status"]);
    $initialpricesbs = floatval($_REQUEST["initialpricesbs"]);
    $initialpricesusd = floatval($_REQUEST["initialpricesusd"]);
    $initialraces = intval($_REQUEST["initialraces"]);
    $initialwinraces = intval($_REQUEST["initialwinraces"]);

    if($status!=0 && $status!=1)
        badEnd("400", array("msg"=>"El parámetro status puede ser 0 o 1"));

    isSessionValid($db, $sessionid);

    if ($id==0){    // incluir registro
        if (!tienePrivilegio($db, $sessionid, 452, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        // validación de campos únicos para evitar el salto del autoincement XP
        $sql =  "SELECT id " .
                "FROM   haras " . 
                "WHERE  abbr='" . $abbr . "' " . 
                "OR     dsc='" . $name . "'";
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        if ($row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Registro Duplicado"));

        $sql =  "INSERT INTO haras " .
                "       (dsc, municipalityid, abbr, status, initialpricesbs, initialpricesusd, initialraces, initialwinraces) " .
                "VALUES (" .
                "        '" . $name . "'," .
                "        '" . $municipalityid . "'," .
                "        '" . $abbr . "'," .
                "        '" . $status . "', " .
                "        '" . $initialpricesbs . "', " .
                "        '" . $initialpricesusd . "', " .
                "        '" . $initialraces . "', " .
                "        '" . $initialwinraces . "' " .
                "        )";
        if (!$db->query($sql)){
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("msg"=>$db->error));
            }
        }

        $id = $db->insert_id;
        
        setAudit($db, "Haras", $sessionid, "Se incluyó el haras \'" . $name . "\' (" . $id . ")");
    }else{          // modificar registro
        if (!tienePrivilegio($db, $sessionid, 451, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "UPDATE haras " .
                "SET    dsc = '" . $name . "'," .
                "       municipalityid = '" . $municipalityid . "', " .
                "       abbr = '" . $abbr . "', " .
                "       initialpricesbs = '" . $initialpricesbs . "', " .
                "       initialpricesusd = '" . $initialpricesusd . "', " .
                "       initialraces = '" . $initialraces . "', " .
                "       initialwinraces = '" . $initialwinraces . "', " .
                "       status = '" . $status . "' " .
                "WHERE  id=" . $id;
        if (!$db->query($sql))
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
            }
            
        setAudit($db, "Haras", $sessionid, "Se actualizó el Haras \'" . $name . "\' (" . $id . ")");

    }

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>