<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("id", "sessionid", "name", "abbr", "municipalityid", "status");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $name = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["name"]);
    $abbr = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["abbr"]);
    $municipalityid = intval($_REQUEST["municipalityid"]);
    $status = intval($_REQUEST["status"]);

    // parametros opcionales
    $distances = array();
    if (isset($_REQUEST["distancesid"]) && isset($_REQUEST["besttimes"]) && isset($_REQUEST["recorddates"])){
        $distancesid = preg_replace("/[^0-9\-]+/", "", $_REQUEST["distancesid"]);
        $besttimes = preg_replace("/[^0-9\-.]+/", "", $_REQUEST["besttimes"]);
        $recorddates = preg_replace("/[^0-9\-]+/", "", $_REQUEST["recorddates"]);

        $distancesidarr = explode("-",$distancesid);
        $besttimesarr = explode("-",$besttimes);
        $recorddatesarr = explode("-",$recorddates);

        if (count($distancesidarr) != count($besttimesarr) || count($besttimesarr) != count($recorddatesarr))
            badEnd("400", array("msg"=>"Los parámetros distancesid, besttimes y recorddates deben tener el mismo numero de elementos"));

        for ($idx=0; $idx < count($distancesidarr); $idx++){
            $distances[] = array(   "id"=>(integer)$distancesidarr[$idx], 
                                    "besttime"=>$besttimesarr[$idx], 
                                    "recorddate"=>date_format(date_create_from_format ('Ymd',$recorddatesarr[$idx]), 'Y-m-d'));
        }
    }

    if($status!=0 && $status!=1)
        badEnd("400", array("msg"=>"El parámetro status puede ser 0 o 1"));

    isSessionValid($db, $sessionid);

    if ($id==0){    // incluir registro
        if (!tienePrivilegio($db, $sessionid, 322, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "INSERT INTO racecourses " .
                "       (dsc, abbr, municipalityid, status, distances) " .
                "VALUES (" .
                "        '" . $name . "'," .
                "        '" . $abbr . "'," .
                "        '" . $municipalityid . "', " .
                "        '" . $status . "', " .
                "        '" . json_encode($distances) . "' " .
                "        )";
        if (!$db->query($sql)){
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("msg"=>$db->error));
            }
        }

        $id = $db->insert_id;
        
        setAudit($db, "Sedes", $sessionid, "Se incluyó la sede \'" . $name . "\' (" . $id . ")");
    }else{          // modificar registro
        if (!tienePrivilegio($db, $sessionid, 321, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "UPDATE racecourses " .
                "SET    dsc = '" . $name . "'," .
                "       abbr = '" . $abbr . "', " .
                "       municipalityid = '" . $municipalityid . "', " .
                "       status = '" . $status . "', " .
                "       distances = '" . json_encode($distances) . "' " .
                "WHERE  id=" . $id;
        if (!$db->query($sql))
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
            }
            
        setAudit($db, "Sedes", $sessionid, "Se actualizó la sede \'" . $name . "\' (" . $id . ")");

    }

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>