<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("order", "offset", "numofrec", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $orderpar = intval($_REQUEST["order"]);
    $offset = intval($_REQUEST["offset"]);
    $numofrec = intval($_REQUEST["numofrec"]);

    // parametros opcionales
    $filtro = "";
    if (isset($_REQUEST["filter"])){
        $filtro = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["filter"]);
    }
    $statusid = 0;
    if (isset($_REQUEST["statusid"])){
        $statusid = intval($_REQUEST["statusid"]);
    }

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 210, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    // busqueda
    $filter = "";
    if (strlen($filtro) > 0){
        $filter .= "(";
        $filter .= "    dsc like '%" . $filtro . "%' ";
//        $filter .= " OR mun like '%" . $filtro . "%' ";
        $filter .= " OR  IF(status='1', ' Activo', ' Inactivo') like '% " . $filtro . "%' ";
        $filter .= ")";
    }
    // filtro de status
    if ($statusid != 0){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " S.status = " . ($statusid == 1 ? "1" : "0");
    }
    if (strlen($filter) > 0){
        $filter = " WHERE " . $filter;
    }

    // orden
    $order = "";
    switch (abs($orderpar)){
        case 1:
            $order = " id ";
            break;
        case 2:
            $order = " dsc ";
            break;
        case 3:
            $order = " status ";
            break;
    }
    if (strlen($order) > 0){
        if ($orderpar < 0)
            $order = str_replace(",", " DESC,", $order) . " DESC ";
        $order = " ORDER BY " . $order;
    }

    $sql =  "SELECT     S.id, S.dsc, M.mun, S.status " .
            "FROM       states S " .
            "LEFT JOIN  (SELECT stateid, GROUP_CONCAT(dsc) mun FROM municipalities GROUP BY stateid) M " .
            "ON         S.id = M.stateid " . 
            $filter .
            $order;
    // calcular numero de registros
    if (!$rs = $db->query("SELECT COUNT(*) cnt FROM (" . $sql . ") A "))
        badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
    $row = $rs->fetch_assoc();
    $out = new stdClass;
    $out->numofrecords = (integer) $row["cnt"];

    // limitar número de
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $offset . "," . $numofrec;
    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>2, "msg"=>$db->error));

    $out->records = array();
    while ($row = $rs->fetch_assoc()){
        $state = new stdClass;
        $state->id = (integer) $row["id"];
        $state->name = $row["dsc"];
        $state->status = new stdClass;
        $state->status->id = (integer) $row["status"];
        $state->status->name = $state->status->id==0 ? "Inactivo" : "Activo";
        $state->municipalities = $row["mun"];

        $out->records[] = $state;
    }

    $access = array();
    $access["create"] = tienePrivilegio($db, $sessionid, 212);
    $access["delete"] = tienePrivilegio($db, $sessionid, 213);
    $access["update"] = tienePrivilegio($db, $sessionid, 211);
    $access["read"] =   tienePrivilegio($db, $sessionid, 210);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>