//Función incial se llama una vez cargado el modulo acá se asignan los eventos iniciales
async function prognosticationsInit() {

    let refreshlistdates = async (ele) => {
        let error = false;
        //Aplicamos algunas validaciones adicionales para las fechas
        let from = document.getElementById("fromFilt");
        let to = document.getElementById("toFilt");
        if (from.value !== "") {
            to.setAttribute("min", from.value);
            to.setAttribute("max", dateForInpt(new Date()));
            //Como el from tiene valor validamos que no exceda al ahora
            let fromdate = new Date(from.value.split("-"));
            if (fromdate.getTime() > (new Date()).getTime()) {
                errInpt(from.getAttribute("id"), "Fecha desde inválida", 6000);
                error = true;
            }
            await validDateRange(from.value).then().catch(() => {
                errInpt(from.getAttribute("id"), "Fecha desde inválida", 6000);
                error = true;
            });
        } else {
            to.setAttribute("min", dateForInpt(globmindate));
        }
        if (to.value !== "") {
            from.setAttribute("max", to.value);
            let todate = new Date(to.value.split("-"));
            if (todate.getTime() > (new Date()).getTime()) {
                errInpt(to.getAttribute("id"), "Fecha hasta inválida", 6000);
                error = true;
            }
            await validDateRange(to.value).then().catch(() => {
                errInpt(from.getAttribute("id"), "Fecha hasta inválida", 6000);
                error = true;
            });
        } else {
            from.setAttribute("max", dateForInpt(new Date()));
        }
        if (to.value != "" && from.value != "") {
            //Fechas
            let fromdate = new Date(from.value.split("-"));
            let todate = new Date(to.value.split("-"));
            if (fromdate.getTime() > todate.getTime()) {
                errInpt(ele.getAttribute("id"), "Rango de fechas inválido", 6000);
                error = true;
            }
        }

        if (error) {
            listDraw({
                numofrecords: 0,
                records: []
            });
            return;
        } else {
            errBlank(to.getAttribute("id"));
            errBlank(from.getAttribute("id"));

        }

        //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
        let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        if (selpag != null) selpag.removeAttribute("selected");
        listAPI();
    }
    //Eventos rango de rechas
    document.getElementById("toFilt").addEventListener("change", function () { refreshlistdates(this) });
    document.getElementById("toFilt").setAttribute("min", dateForInpt(globmindate));
    document.getElementById("toFilt").setAttribute("max", dateForInpt(new Date()));
    document.getElementById("fromFilt").addEventListener("change", function () { refreshlistdates(this) });
    document.getElementById("fromFilt").setAttribute("min", dateForInpt(globmindate));
    document.getElementById("fromFilt").setAttribute("max", dateForInpt(new Date()));
    //Evento mostrar popup de insertar usuario
    let refreshlist = () => {
        //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
        let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        if (selpag != null) selpag.removeAttribute("selected");
        listAPI();
    }
    //EVENTO REFRESCAR TABLA EN EL AL HACER BUSQUEDA CON ENTER
    document.getElementById("searchTbl").addEventListener("keyup", function (e) {
        if (this.value != "") this.value = fieldFormat(this.value, "search");
        //Si le da al enter, refrescamos el listadol.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            refreshlist();
        }
    });

    //EVENTO REFRESCAR TABLA EN EL AL HACER FILTRO DE LA TABLA POR STATUS Y GENERO
    //document.getElementById("statusTbl").addEventListener("change", refreshlist);
    document.getElementById("racecoursesTbl").addEventListener("change", refreshlist);
    
    //Formulario de crear/modificar evento de pestañas 
    document.querySelectorAll(".frmHeadBox").forEach(e => {
        e.addEventListener("click", function () {
            let cnt = this.parentElement;
            let activo = cnt.parentElement.querySelector(".frmHeadBox[active]");
            if (activo != undefined) {
                activo.removeAttribute("active");
                activo.parentElement.querySelector(".popupFrmCnt").style.height = "";
                activo.querySelector(".frmBoxOpnBtn").innerHTML = '<i class="fa-solid fa-caret-down"></i>';
            }
            cnt.querySelector(".frmHeadBox").setAttribute("active","");
            cnt.querySelector(".popupFrmCnt").style.height = cnt.querySelector(".popupFrmCnt").scrollHeight + "px";                
            this.querySelector(".frmBoxOpnBtn").innerHTML = '<i class="fa-solid fa-caret-up"></i>';
        });
    });
    
    document.getElementById("updMagazines").addEventListener("change", function () {
        entryForecastsAPI(this.getAttribute("raceid")).then((rsp) => {
            setFrm(rsp.entry,this.getAttribute("raceid"));   
        }, (document.getElementById("popupUpdFrm").getAttribute("editable") != '1'));
    });

    //-------//

    //EVENTOS DE BOTONES GUARDAR Y CANCELAR
    //Popup "CREAR/EDITAR"
    let usrpop = document.getElementById("popupUpdFrm");
    //Evento al guardar el crear/editar el
    usrpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            let meetingid = document.getElementById("pgTbl").querySelector(".tbody>div[active]")?.getAttribute("itemid");
            updateForecastsAPI((this.getAttribute("upid") != undefined && this.getAttribute("upid") != null) ? this.getAttribute("upid") : 0);
        }
    });
    //Evento cancela popup crear/editar
    usrpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    document.getElementById("clearHorses").addEventListener("click", function () {
        let pop = document.getElementById("popupUpdFrm");
        Array.from(pop.querySelectorAll(".processCheck")).forEach(e => {
            e.checked = false;
        });
        forecastValidCompare();
    });

    document.getElementById("compareHorses").addEventListener("click", function () {
        let pop = document.getElementById("popupUpdFrm");
        let arrcnts = Array.from(pop.querySelectorAll(".processCheck")).filter(e => e.checked).map(e=>e.parentElement.parentElement.parentElement.parentElement);
        listDrawCompare(arrcnts);
        showPopup("popupCmprFrm");
        
    });


    //Popup "ELIMINAR 
    let delpop = document.getElementById("popupDelFrm");
    //Evento al guardar el crear/editar
    delpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
        }
    });
    //Evento cancela popup 
    delpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    //Popup "COMPARATIVA" 
    let cnfpop = document.getElementById("popupCmprFrm");
    //Evento al guardar el crear/editar
    cnfpop.querySelector(".backBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            Array.from(document.getElementById("popupCmprFrm").querySelectorAll(".trCnt")).forEach(e => {
                let cnt = document.getElementById("popupUpdFrm").querySelector(".trCnt[horsenumber='" + e.getAttribute("horsenumber") + "']");
                cnt.querySelector(".horsePronCnt").setAttribute("fc", e.querySelector(".horsePronCnt").getAttribute("fc"));
                cnt.querySelector(".horsePronCnt").innerText = e.querySelector(".horsePronCnt").innerText;
                cnt.querySelector("textarea[name='updComment']").value = e.querySelector("textarea[name='updComment']").value;
            });
            showPopup("popupUpdFrm");
        }
    });

    //INICIALIZAMOS LOS EVENTOS DE ORDENAMIENTO, CON ESTE FORMATO SE PUEDEN PASAR PARAMETROS A LA FUNCIÓN
    initOrders(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    //IINICIALIZAMOS LOS EVENTOS DE LAS FLECHAS DEL PAGINADO SI EXISTE
    initPagsEvent(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    await listHeadqueartersAPI();

    //Lamamos el servicio que carga el listado
    listAPI();
}
const days = ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"];
/**REUNIONES **/

//Refrescamos las reuniones validando si hay una abierta y manteniendo, esto se hace en segundo plano
async function refreshMeets() {
    let meetingid = document.getElementById("pgTbl").querySelector(".tbody>div[active]").getAttribute("itemid");//Obtenemos la reunión activa
    listAPI().then(() => {
        let exist = document.getElementById("pgTbl").querySelector(".tbody>div[itemid='" + meetingid + "']");
        if (exist != undefined) {
            exist.querySelector(".openRow").dispatchEvent(new Event("click"));
        }
    });
    
}


//Función para llamar al sevicio de la lista
let notupdatedData = {}; //Guardamos la información de los 10 registros visibles localmente en caso de necesitar restaurar una linea "sin cambios"
function listAPI() {
    return new Promise((resolve, reject) => {
        var par = {};
        par.filter = document.getElementById("searchTbl").value;
        let order = document.querySelector(".pgSctTbl").querySelector(".orderCol[selected]");
        par.order = (order == null || order == undefined) ? -1 : order.getAttribute("colval");
        let actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        par.statusid = 4;
        par.racecourseid = document.getElementById("racecoursesTbl").value;
        par.offset = (actpage != null) ? (actpage.innerHTML * 10) - 10 : 0;
        par.numofrec = 10;        
        par.datefrom = document.getElementById("fromFilt").value;
        par.dateto = document.getElementById("toFilt").value;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    notupdatedData = data;
                    //Validamos los privilegios
                    await privValidations(data.privileges);
                    //Si obtenemos y se setean los privilegios correctamente pintamos la tabla
                    listDraw(data, data.privileges);
                    resolve();
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                    reject();
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    reject();
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "records/reunions/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para pintar la respuesta de la lista en la tabla - requiere modelo base en html
function listDraw(rsp, privileges) {
    let tbl = document.getElementById("pgTbl").querySelector(".tbody");
    let list = rsp.records;
    let ele = tbl.querySelector(".tr:not([id='addline'])").parentElement.parentElement.cloneNode(true);
    let notedclass = "noteditable";

    tbl.innerHTML = "";
    //Activamos el add y agregamos/ocultamos el add
    //if(rsp.create)document.querySelector(".addBtn").removeAttribute("disabled");
    //Antes que cualquier cosa insertamos la linea de "agregar"
    var clone = ele.cloneNode(true);        
    clone.style.display = "none";
    clone.removeAttribute("active");
    clone.removeAttribute("itemid");
    /*
    let rowSct = clone.children[0].children[0];
    rowSct.setAttribute("id", "addline");
    //No se puede desplegar hasta que se complete
    rowSct.querySelector(".openRow").style.display = "none";
    //Validación de datos en el campo del "añadir"
    var celda = rowSct.children[1];

    celda.children[0].addEventListener("keyup", function () {
        if (this.value != "") this.value = fieldFormat(this.value, 'intnumber');
    });
    //Los blanqueamos en caso de tener data
    rowSct.querySelectorAll("." + notedclass).forEach(ele => ele.innerHTML = "");
    let btnsecond = rowSct.querySelectorAll(".tblBtns");
    btnsecond[1].querySelectorAll(".tblbtnIc")[0].addEventListener("click", function () {
        //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
        let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        if (selpag != null) selpag.removeAttribute("selected");
        updateAPI(document.getElementById("addline"),0);
    });
    btnsecond[1].querySelectorAll(".tblbtnIc")[1].addEventListener("click", function () {
        document.getElementById("addline").removeAttribute("active");
        document.getElementById("addline").parentElement.parentElement.style.display = "none";
        document.querySelector(".addBtn").removeAttribute("disabled");
    });

    
    var celda = rowSct.children[2];
    celda.children[0].setAttribute("max", dateForInpt(new Date()));

    tbl.appendChild(clone);
    */
    if (list.length > 0) {
        for (var i = 0; i < list.length; i++) {
            
            var clone = ele.cloneNode(true);            
            clone.style.display = "";
            clone.removeAttribute("active");
            clone.querySelector(".openRow").style.display = "";
            clone.querySelector(".openRow").innerHTML = '<i class="fa-regular fa-square-plus"></i>';
            
            let rowSct = clone.children[0].children[0];
            rowSct.removeAttribute("active");

            var data = list[i];
            //Evento del readonly al row
            rowSct.setAttribute("itemid", data.id);
            clone.setAttribute("itemid", data.id);

            var celda = rowSct.children[0].children[0];
            celda.children[0].addEventListener("click", async function () {
                //Elemento activo
                let active = document.getElementById("pgTbl").querySelector(".tbody>div[active]");
                let openrow = this.parentElement.parentElement.parentElement.parentElement.parentElement;
                if (active) {     
                    //Si existe validamos si es el mismo que se clickea
                    if (active.getAttribute("itemid") == openrow.getAttribute("itemid")) {
                        openrow.removeAttribute("active");
                        this.innerHTML = '<i class="fa-regular fa-square-plus"></i>';
                    } else {                        
                        await listForecastAPI(openrow.getAttribute("itemid")).then(function (data) {
                            listDrawForecasts(openrow, data);
                        });
                        //Si no es el mismo cerramos el abierto y mostramos el que se clickea
                        active.removeAttribute("active");
                        active.querySelector(".openRow").innerHTML = '<i class="fa-regular fa-square-plus"></i>';
                        openrow.setAttribute("active", "");                        
                        openrow.querySelector(".scrollTblHide").style.height = (openrow.querySelector(".calledTblSct").offsetHeight + 8) + "px";
                        this.innerHTML = '<i class="fa-regular fa-square-minus"></i>';
                    }
                } else {                    
                    await listForecastAPI(openrow.getAttribute("itemid")).then(function (data) {
                        listDrawForecasts(openrow, data);
                    });
                    //Si no hay ninguno abierto solo abrimos el que se clickea
                    openrow.setAttribute("active", "");
                    openrow.querySelector(".scrollTblHide").style.height = (openrow.querySelector(".calledTblSct").offsetHeight + 8) + "px";
                    this.innerHTML = '<i class="fa-regular fa-square-minus"></i>';
                }        
            });
            celda.children[1].innerText = data.racecourse.name;

            var celda = rowSct.children[1];
            celda.innerText = data.number;    

            var celda = rowSct.children[2];
            celda.innerText = data.date.formatted;

            var celda = rowSct.children[3];
            celda.innerText = data.status.name;

            var celda = rowSct.children[4];
            celda.innerText = data.forecast;
        
            tbl.appendChild(clone);
        }
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        clone.removeAttribute("id");
        tbl.appendChild(clone);
    }
    //SE PINTA EL PAGINADO LUEGO DE PINTAR LA TABLA
    var actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
    actpage = (actpage != null && actpage != undefined) ? (actpage.innerHTML) : 1;
    drawPags(document.querySelector(".pgSctTbl"), rsp.numofrecords, 10, actpage, listAPI);
    
}
//Función para llamar el servicio que inserta o modifica un usuario.
function updateAPI(row,id) {
    let validationpars = [
        {
            "key": "racecourseid",
            "id": row.querySelectorAll(".tblInpt")[0],
            "msg": ""
        },
        {
            "key": "number",
            "id": row.querySelectorAll(".tblInpt")[1],
            "msg": ""
        },
        {
            "key": "date",
            "id": row.querySelectorAll(".tblInpt")[2],
            "msg": ""
        },
    ]

    var par = {};
    par.id = id;
    par.racecourseid = row.querySelectorAll(".tblInpt")[0].value;
    par.number = row.querySelectorAll(".tblInpt")[1].value;
    par.date = row.querySelectorAll(".tblInpt")[2].value;
    par.sessionid = localStorage.getItem("sessionid");

    //Hacemos las validaciones
    var haserror = false;
    //Cómo son muchos campos simplificamos con un arreglo que contiene los campos a verificar
    validationpars.forEach((e) => {
        //Que el nombre no esté vacío
        if (!(par[e.key] !== undefined && par[e.key] !== null && par[e.key] !== "")) {
            errRowInpt(e.id, 6000);
            haserror = true;
        }
    });

    //Si tiene errores detenemos la llamada al servicio
    if (haserror) {
        errTbl(document.querySelector(".tblSct"), "Faltan campos obligatorios", 6000);
        return;
    }
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.id != null && data.id != undefined) {
                    //Llevaos el ordenamiento por "id" y cargamos el listado
                    resetOrder(document.querySelector(".pgSctTbl")).then(() => { listAPI(); });
                    //Como definimos función flecha podemos leer los parametros para determinar si era nuevo y mostrar mensaje exitoso correcto
                    successMsgShow((par.id == 0) ? "Reunión creado con éxito" : "Reunión modificado con éxito");
                }
                //Cerramos el popup
                closePopups();
                break;
            case 400:
                data = JSON.parse(rsp.response);
                errTbl(document.querySelector(".tblSct"), ((data.msg != undefined)?data.msg:"Ocurrió un error al guardar por favor intente de nuevo"), 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Error de privilegios - prohibido
                errTbl(document.querySelector(".tblSct"), "No tiene privilegios para ejecutar esta acción", 6000);
                break;
            case 409:
                 errTbl(document.querySelector(".tblSct"), "Ya existe este Reunión", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "records/reunions/update", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Función para llamar el servicio de eliminar, se ejecuta al confirmar el boton
function deleteAPI(id) {
    var par = {};
    par.id = id;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.id != null && data.id != undefined) {
                    listAPI();
                    //Mostramos mensaje de eliminado con éxito
                    successMsgShow("Reunión eliminado con éxito");
                }
                //Cerramos el popup
                closePopups();
                break;
            case 204:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Registro no encontrado", 6000);
                break;
            case 304:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Existen dependencias que no permiten ejecutar esta acción", 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Error de privilegios - prohibido
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "records/reunions/delete", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) })
}
//Función retorna la inforación detallada del usuario
function entryAPI(id) {
    return new Promise((resolve, reject) => {
        var par = {};
        par.id = id;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("GET", "records/reunions/entry", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Se realizan las validaciones de privilegios de front, se inactivan y muestran los mensajes correspondientes
//1 Reuniones, 2 Llamados
function privValidations(rsp, type = 1) {
    console.log(rsp);
    return new Promise((resolve, reject) => {
        /**REUNIONES */
        if (type == 1) {
            //ELIMINAR
            let popupdelBtn = document.getElementById("popupDelFrm").querySelector(".saveBtn");
            //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
            if (popupdelBtn) {
                if (!rsp.delete) {
                    popupdelBtn.setAttribute("inactive", "");
                } else {
                    popupdelBtn.removeAttribute("inactive");
                }
            }
            //AÑADIR
            /*
            let tbladdBtn = document.querySelector(".addBtn");
            if (tbladdBtn) {
                if (!rsp.create) {
                    tbladdBtn.setAttribute("disabled", "");
                } else {
                    tbladdBtn.removeAttribute("disabled");
                }
            } */           
            //Editar y eliminar en row
        }
        else if (type == 2) {//LLAMADOS
            //CREAR 
            if (!rsp.create) {
                document.querySelectorAll(".newcall").forEach(e=>e.setAttribute("disabled", ""));
            } else {
                document.querySelectorAll(".newcall").forEach(e=>e.removeAttribute("disabled"));
            }
            //Procesar 
            if (!rsp.process) {
                document.querySelectorAll(".opencall").forEach(e =>e.setAttribute("process", "inactive"));
            } else {
                document.querySelectorAll(".opencall").forEach(e=>e.removeAttribute("process"));
            }
            //Revertir 
            if (!rsp.open) {
                document.querySelectorAll(".opencall").forEach(e =>e.setAttribute("revert", "inactive"));
            } else {
                document.querySelectorAll(".opencall").forEach(e=>e.removeAttribute("revert"));
            }
            //CREAR 
            if (!rsp.close) {
                document.querySelectorAll(".openarrive").forEach(e=>e.setAttribute("close", "inactive"));
            } else {
                document.querySelectorAll(".openarrive").forEach(e=>e.removeAttribute("close"));
            }
            //CREAR 
            if (!rsp.unclose) {
                document.querySelectorAll(".openarrive").forEach(e=>e.setAttribute("open", "inactive"));
            } else {
                document.querySelectorAll(".openarrive").forEach(e=>e.removeAttribute("open"));
            }
        }


        /**LLAMADOS**/
        resolve();
    });

}
//Se requiere invocar el listado de "estados" para el select del filtro y el insertar nuevo
function listHeadqueartersAPI(selected = "") {
    return new Promise((resolve, reject) => {
        var par = {};
        par.filter = "";
        par.order = 1;
        par.offset = 0;
        par.numofrec = 9999;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                                        
                    //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                    let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                    disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });

                    //Data del filtro de la tabla
                    drawSelect(data.records, document.getElementById("racecoursesTbl"), 'id', 'name', 'Todos los hipódromos', selected);
                    
                    resolve();                    

                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    resolve();
                    //errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "hippodromes/racecourses/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
    
}
//Función para llamar los valores de la lista de llamados
function listForecastAPI(meetingid) {
    return new Promise((resolve, reject) => { 
        var par = {};
        par.reunionid = meetingid;
        par.filter = "";
        par.order = 1;
        par.offset = 0;
        par.numofrec = 9999;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);     
                    console.log(data);
                    await privValidations(data.privileges,2);
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los pronósticos");                    
                    reject();
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "records/forecasts/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para pintar la respuesta de la lista en la tabla - requiere modelo base en html
let orders = ["1ra", "2da", "3ra", "4ta", "5ta", "6ta", "7ma"];
function listDrawForecasts(row, rsp) {
    let list = rsp.records;

    let tbl = row.querySelector("tbody");    
    tbl.addEventListener("scroll",function(e){
        this.previousElementSibling.querySelector(".scrollTbl .tbody").scrollTop = this.scrollTop;
    });
    let ele = tbl.children[0].cloneNode(true);
    
    let thead = row.querySelector("thead").children[0];
    let tblPHd = thead.children[3].querySelector(".thead");
    let tlbPBdy = thead.children[3].querySelector(".tbody");
    tlbPBdy.addEventListener("scroll",function(e){
        this.parentElement.parentElement.parentElement.parentElement.parentElement.nextElementSibling.dispatchEvent(new Event("scroll"));
    });
    let bodyRw = tlbPBdy.children[0].cloneNode(true);
    if (list.length > 0) {
        //Blanqueamos los registros
        tbl.innerHTML = "";
        //Creamos el header de las magazines a partir del primer registro
        let headRw = tblPHd.children[0].cloneNode(true);
        let cellHd = headRw.children[0].cloneNode(true);
        tblPHd.innerHTML = "";
        headRw.innerHTML = "";
        list[0].magazines.forEach(m => {
            var cellCln = cellHd.cloneNode(true);
            cellCln.innerText = m.name;
            headRw.appendChild(cellCln);
        });        
        //Data del filtro de la tabla
        if (list[0].magazines.length > 0) {
            drawSelect(list[0].magazines, document.getElementById("updMagazines"), 'id', 'name', '', (document.getElementById("updMagazines").value != "" ? document.getElementById("updMagazines").value : list[0].magazines[0].id));
        } else {
            drawSelect([], document.getElementById("updMagazines"), 'id', 'name', '', "");
        }
        
        tblPHd.appendChild(headRw);
        tlbPBdy.innerHTML = "";
        for (var i = 0; i < list.length; i++) {
            var data = list[i];
            
            var clone = ele.cloneNode(true);
            clone.addEventListener("click", function (e) {
                editableForm("popupUpdFrm", false, [".popInpt,input[type='checkbox']"]);
                document.getElementById("popupUpdFrm").setAttribute("editable", 0);
                e.stopPropagation();
                if (document.getElementById("updMagazines").options.length > 0) {
                    document.getElementById("updMagazines").value = document.getElementById("updMagazines").options[0].getAttribute("value");
                    entryForecastsAPI(this.getAttribute("itemid")).then((rsp) => {
                        setFrm(rsp.entry, this.getAttribute("itemid"));   
                        document.getElementById("updMagazines").removeAttribute("disabled");
                        document.getElementById("updMagazines").removeAttribute("readonly");
                        document.getElementById("updMagazines").setAttribute("raceid", this.getAttribute("itemid"));
                        //Seteamos el titulo
                        document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Pronósticos";
                        document.getElementById("popupUpdFrm").querySelector(".saveBtn").innerText = "Guardar";
                        document.getElementById("popupUpdFrm").querySelector(".backBtn").innerText = "Salir";
                        showPopup("popupUpdFrm");
                    });
                } else errTbl(document.querySelector(".tblSct"), "No tiene revistas asignadas para visualizar pronósticos");
                
            });

            clone.style.display = "";
            clone.setAttribute("itemid", data.raceid);

            var celda = clone.children[0];
            celda.setAttribute("data", data.order.id);
            celda.innerHTML = data.order.name;

            var celda = clone.children[1];
            celda.setAttribute("data", data.number);
            celda.innerHTML = data.number;

            var celda = clone.children[2];
            if (data.isvalid > 0) {
                let pos = tbl.querySelectorAll("[name='validrace']").length;
                celda.setAttribute("name", "validrace");
                if (pos > -1) celda.innerHTML = orders[data.isvalid-1] + " Válida";
            } else {
                celda.innerHTML = "No Válida";
            }

            //row.querySelector(".scrollTbl").style.width = (rsp.magazines.length * 20) + "%";
            let pRow = bodyRw.cloneNode(true);
            let cellBdy = pRow.children[0].cloneNode(true);
            pRow.innerHTML = "";
            pRow.style.display = "";
            data.magazines.forEach(m => {                
                let cellCln = cellBdy.cloneNode(true);
                cellCln.innerText = m.top3 + " | " + m.top4;
                pRow.appendChild(cellCln);

            });
            tlbPBdy.appendChild(pRow);
            /*
            var celda = clone.children[2];
            let magtbl = celda.querySelector(".thead").firstElementChild;
            let magcol = celda.querySelector(".thead").firstElementChild.children[0].cloneNode(true);
            magtbl.innerHTML = "";
            celda.querySelector(".scrollTbl").style.width = (data.magazines.length * 20) + "%";
            data.magazines.forEach(m => {
                let newcol = magcol.cloneNode(true);
                newcol.innerText = m.name;
                magtbl.appendChild(newcol);
            });*/


            var celda = clone.children[4].lastElementChild;//Botonera secundaria, aceptar/cancelar
            celda.setAttribute("itemid", data.raceid);
            celda.querySelectorAll(".tblbtnIc")[0].style.display = "";
            if (rsp.privileges.update) {
                if (data.status.id == 1) {
                    celda.querySelectorAll(".tblbtnIc")[0].addEventListener("click", function (e) {
                        document.getElementById("popupUpdFrm").setAttribute("editable", 1);
                        editableForm("popupUpdFrm", true, [".popInpt"]);
                        e.stopPropagation();
                        if (document.getElementById("updMagazines").options.length > 0) {
                            document.getElementById("updMagazines").value = document.getElementById("updMagazines").options[0].getAttribute("value");
                            entryForecastsAPI(this.parentElement.getAttribute("itemid")).then((rsp) => {
                                setFrm(rsp.entry, this.parentElement.getAttribute("itemid"));
                                document.getElementById("updMagazines").setAttribute("raceid", this.parentElement.getAttribute("itemid"));
                                //Seteamos el titulo
                                document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Editar Pronósticos";
                                document.getElementById("popupUpdFrm").querySelector(".backBtn").innerText = "Salir";
                                showPopup("popupUpdFrm");
                            });
                        } else errTbl(document.querySelector(".tblSct"), "No tiene revistas asignadas para visualizar pronósticos");
                        
                    });
                } else if (data.status.id == 2) {
                    celda.querySelectorAll(".tblbtnIc")[0].style.display = "none";
                }
            } else {
                celda.querySelectorAll(".tblbtnIc")[0].setAttribute("disabled","");
            }
            /*
            if (rsp.privileges.delete) {
                celda.querySelectorAll(".tblbtnIc")[1].addEventListener("click", function (e) {
                    e.stopPropagation();
                    //Se muestra el popup de confirmación
                    let lbl = this.parentElement.getAttribute("itemlbl");
                    document.querySelector(".poupDelItemLbl").innerText = lbl;
                    //Asignamos el id que va a ser eliminado al boton guardar de la confirmación del delete
                    let delpop = document.getElementById("popupDelFrm");
                    delpop.querySelector(".saveBtn").setAttribute("type", "race");
                    delpop.querySelector(".saveBtn").setAttribute("delid", this.parentElement.getAttribute("itemid"));
                    document.getElementById("delLbl").innerText = "carrera";
                    //Mostramos el popup de confirmación
                    showPopup("popupDelFrm");
                });
            } else {
                celda.querySelectorAll(".tblbtnIc")[1].setAttribute("disabled","");
            }*/

            tbl.appendChild(clone);

        }
    } else {
        let headRw = tblPHd.children[0].cloneNode(true);
        tblPHd.innerHTML = "";
        tblPHd.appendChild(headRw);
        let bodyRw = tlbPBdy.children[0].cloneNode(true);
        tlbPBdy.innerHTML = "";
        tlbPBdy.appendChild(bodyRw);
    }
}
function setFrm(rsp, raceid) {
    document.getElementById("popupUpdFrm").querySelector(".saveBtn").setAttribute("upid", raceid);
    let isValid = "No Válida";
    if (rsp.race.valid > 0) {
        isValid = orders[rsp.race.valid-1] + " Válida";
    } 
    document.getElementById("popupUpdFrm").querySelectorAll(".meetingInf")[0].innerHTML = "<span>" + rsp.reunion.racecourse.name + "</span> - R." + rsp.reunion.number + " - " + rsp.reunion.status.formatted + " - <span>" + rsp.reunion.date.dayofweek + " " + rsp.reunion.date.formatted + "</span>";
    document.getElementById("popupUpdFrm").querySelectorAll(".meetingInf")[1].innerHTML = "<span>" + rsp.race.order.name + " - " + rsp.race.distance.name + " - Carrera " + rsp.race.number + " - " + isValid + "</span>";//+ rsp.reunion.status.formatted;
    document.getElementById("popupUpdFrm").querySelectorAll(".meetingInf")[2].innerHTML = "Record: <span>" + rsp.record.jockey.name + "</span> " + rsp.record.jockey.weight + " - " + rsp.record.time + " - " + rsp.record.date.formatted;//+ rsp.reunion.status.formatted;
    listDrawRacers(rsp.racers, (document.getElementById("popupUpdFrm").getAttribute("editable") != '1'));
    console.log(rsp);
}

function forecastValidCompare() {
    let pop = document.getElementById("popupUpdFrm");
    let horses = Array.from(pop.querySelectorAll(".processCheck")).filter(e => e.checked);
    if (horses.length > 1) {
        pop.querySelector(".fixedBotMsg").setAttribute("active","");
        document.getElementById("horsesSel").innerText = horses.length;
    } else {
        pop.querySelector(".fixedBotMsg").style.display = "";
        pop.querySelector(".fixedBotMsg").removeAttribute("active");
    }
}

//Función retorna la inforación detallada del usuario
function entryForecastsAPI(id) {
    return new Promise((resolve, reject) => {
        var par = {};
        par.raceid = id;
        par.magazineid = document.getElementById("updMagazines").value;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("GET", "records/forecasts/entry", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para llamar el servicio que inserta o modifica un usuario.
function updateForecastsAPI(raceid) {
    var par = {};
    par.raceid = raceid;
    par.magazineid = document.getElementById("updMagazines").value;
    let horsessel = (Array.from(document.getElementById("popupUpdFrm").querySelectorAll(".horsePronCnt[fc]")).map(e => {
        return e.parentElement.parentElement.parentElement.parentElement;//Retornamos el contenedor
    }));
    //Filtramos los pronosticos menores que la 4ta posición y armmamos el string con los numeros de los caballos
    let cnttop3 = horsessel.filter(cnt => {
        return (cnt.querySelector(".horsePronCnt[fc]").getAttribute("fc") < 4);
    });
    let cnttop6 = horsessel.filter(cnt => {
        return (cnt.querySelector(".horsePronCnt[fc]").getAttribute("fc") > 3);
    });
    let top3 = [];
    for (var i = 0; i < 3; i++){
        let fc = cnttop3.find(e=>(e.querySelector(".horsePronCnt[fc]").getAttribute("fc") == (i+1)));
        top3.push((fc != undefined && fc != null) ? fc.getAttribute("horsenumber") : "");
    }
    par.top3 = top3.join("-");

    let top6 = [];
    for (var i = 0; i < 3; i++){
        let fc = cnttop6.find(e=>(e.querySelector(".horsePronCnt[fc]").getAttribute("fc") == (i+4)));
        top6.push((fc != undefined && fc != null) ? fc.getAttribute("horsenumber") : "");
    }
    par.top6 = top6.join("-");
    //Armamos los comentarios
    par.comments = Array.from(document.getElementById("popupUpdFrm").querySelectorAll(".trCnt textarea[name='updComment']")).map(c => c.value).join("|");
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.raceid != null && data.raceid != undefined) {
                    //Como definimos función flecha podemos leer los parametros para determinar si era nuevo y mostrar mensaje exitoso correcto
                    successMsgShow((par.raceid == 0) ? "Pronóstico guardado con éxito" : "Pronóstico guardado con éxito");
                    refreshMeets();
                }
                
                //Cerramos el popup
                //closePopups();
                break;
            case 400:
                data = JSON.parse(rsp.response);
                errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), data.msg, 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Error de privilegios - prohibido
                errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
                break;
            case 409:
                errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "Ya existe este Pronóstico", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "records/forecasts/update", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Se requiere invocar el listado de "estados" para el select del filtro y el insertar nuevo
function listMagazinesAPI(selected = "") {
    return new Promise((resolve, reject) => {
        var par = {};
        par.filter = "";
        par.order = 1;
        par.offset = 0;
        par.numofrec = 9999;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                                        
                    //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                    let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                    disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });

                    //Data del filtro de la tabla
                    drawSelect(data.records, document.getElementById("updMagazines"), 'id', 'name', '', selected);
                    
                    resolve();                    

                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    resolve();
                    //errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "hippodromes/racecourses/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
    
}
//Función para pintar la respuesta de la lista en la tabla - requiere modelo base en html
function listDrawRacers(rsp,readonly = false) {
    console.log(rsp);
    let tbl = document.getElementById("popupUpdFrm").querySelector(".tblSct").querySelector(".tbody");
    let list = rsp;
    let ele = tbl.children[0].cloneNode(true);
    if (list.length > 0) {
        tbl.innerHTML = "";
        for (var i = 0; i < list.length; i++) {
            var cnt = ele.cloneNode(true);
            cnt.removeAttribute("horsenumber");
            cnt.removeAttribute("active");
            if (!readonly) {
                cnt.addEventListener("mouseover", function (e) {
                    let tbl = document.getElementById("popupUpdFrm").querySelector(".tblSct").querySelector(".tbody");
                    tbl.querySelector(".trCnt[active]")?.removeAttribute("active");
                    e.currentTarget.setAttribute("active", "");
                });
                cnt.addEventListener("mouseout", function (e) {
                    let tbl = document.getElementById("popupUpdFrm").querySelector(".tblSct").querySelector(".tbody");
                    tbl.querySelector(".trCnt[active]")?.removeAttribute("active");
                });
            }
            
            //Tabla de data row
            var clone = cnt.children[0];
            clone.style.display = "";

            let data = list[i];
            cnt.setAttribute("horsenumber", data.number);

            //Blanqueamos los textos anteriores
            Array.from(clone.children).forEach((e, i) => {
                if(i>0) e.innerText = "";
            });

            //Data del horse
            clone.children[0].querySelector(".processCheck").checked = false;
            clone.children[0].querySelector(".processCheck").addEventListener("click", function () {
                forecastValidCompare();
            });
            clone.children[0].querySelector(".horseNum").innerText = data.number;
            let name = document.createElement("span"); name.innerText = data.horse.name;
            name.style.fontSize = ".85rem";
            //Resaltar en negritas el ejemplar que ganó
            console.log(data.arrivalposition);
            if (data.arrivalposition == 1) {
                clone.children[0].querySelector(".horseInf").parentElement.style.fontWeight = "900";
            } else {
                clone.children[0].querySelector(".horseInf").parentElement.style.fontWeight = "";
            }
            clone.children[0].querySelector(".horseInf").innerHTML = "";
            clone.children[0].querySelector(".horseInf").appendChild(name);
            let jockey = document.createElement("span"); jockey.innerText = data.jockey.name+" - "+data.jockey.weight;
            clone.children[0].querySelector(".horseInf").appendChild(jockey);
            let trainer = document.createElement("span"); trainer.innerText = data.trainner.name;
            clone.children[0].querySelector(".horseInf").appendChild(trainer);
            clone.children[0].querySelector(".horsePronCnt").removeAttribute("fc");
            if(data.forecast>0)clone.children[0].querySelector(".horsePronCnt").setAttribute("fc",data.forecast);
            clone.children[0].querySelector(".horsePronCnt").innerText = data.forecast;

            


            let insertdata = (cell,data) => {
                var rowcnt = document.createElement("span");
                var row = document.createElement("div");
                row.classList.add("td");
                row.innerText = data;
                rowcnt.appendChild(row);
                cell.appendChild(rowcnt);
            }
            if (data.records.length > 0) {
                data.records.forEach(r => {
                    //Fecha
                    insertdata(clone.children[1], r.date.formatted);
                    //HIpodromo
                    insertdata(clone.children[2], r.racecourse.abbr+r.racenumber.formatted);
                    //Peso del ejemplar
                    insertdata(clone.children[3], r.weight.formatted);
                    //Distancia                
                    insertdata(clone.children[4], r.distance.name);
                    //Posición                
                    insertdata(clone.children[5], r.position);
                    //Pos 400 y 800                
                    insertdata(clone.children[6], r.pos400.number);
                    insertdata(clone.children[7], r.pos800.number);
                    //Llegada        
                    clone.children[8].style.fontWeight = "bold";
                    insertdata(clone.children[8], r.arrivalposition);
                
                    //Jinete                
                    insertdata(clone.children[9], r.jockey.name);
                    //Peso del jinete                
                    insertdata(clone.children[10], r.jockey.weight);
                    //Dividendos                
                    insertdata(clone.children[11], r.dividends.formatted);
                    //Ganador                
                    insertdata(clone.children[12], r.winner.name);
                    //Cuerpos                
                    insertdata(clone.children[13], r.bodies.abbr);
                    //Serie
                    insertdata(clone.children[14], r.serie);
                    //T gran               
                    insertdata(clone.children[15], r.winner.time.formatted);
                    //T Ejem
                    clone.children[16].style.fontWeight = "bold";
                    insertdata(clone.children[16], r.finishtime.formatted);
                    //#ejemeplares            
                    insertdata(clone.children[17], r.numberofhorses);

                });
            } else {
                var row = document.createElement("div");
                row.classList.add("newHorseMsg");
                row.innerText = data.horse.obs;
                clone.children[1].appendChild(row);
            }

            //En el segundo row ubicamos el textarea y le aadimos los comentarios
            cnt.children[1].querySelector("textarea").value = data.comment;
            cnt.children[1].querySelector("textarea").addEventListener("keyup", function (e) {
                if (this.value != "") this.value = fieldFormat(limitSize(this.value,35), 'name');
            });

            tbl.appendChild(cnt);
        }
        forecastValidCompare();
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        tbl.innerHTML = "";
        tbl.appendChild(clone);
    }

}

//Función para pintar la respuesta de la lista en la tabla - requiere modelo base en html
function listDrawCompare(rsp) {
    console.log(rsp);
    let tbl = document.getElementById("popupCmprFrm").querySelector(".tblSct").querySelector(".tbody");
    let list = rsp;
    let ele = tbl.children[0].cloneNode(true);
    if (list.length > 0) {
        tbl.innerHTML = "";
        for (var i = 0; i < list.length; i++) {

            let cnt = list[i].cloneNode(true);
            cnt.removeAttribute("active");
            cnt.addEventListener("mouseover", function (e) {
                let tbl = document.getElementById("popupCmprFrm").querySelector(".tblSct").querySelector(".tbody");
                tbl.querySelector(".trCnt[active]")?.removeAttribute("active");
                e.currentTarget.setAttribute("active", "");
            });
            cnt.addEventListener("mouseout", function (e) {
                let tbl = document.getElementById("popupCmprFrm").querySelector(".tblSct").querySelector(".tbody");
                tbl.querySelector(".trCnt[active]")?.removeAttribute("active");
            });
            cnt.querySelector(".processCheck").style.display = "none";

            tbl.appendChild(cnt);
        }
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        tbl.innerHTML = "";
        tbl.appendChild(clone);
    }

}

//Llamada inicial
document.addEventListener("DOMContentLoaded", function () {
    prognosticationsInit();
    //Evento para ocultar los select de busqueda
    document.body.addEventListener("click", function (e) {
        setTimeout(function () {
            document.querySelectorAll(".optList").forEach(obj => {
                if (e.target != obj && e.target != obj.previousElementSibling) obj.innerHTML = "";
            })
        }, 300);
    });
    //Esto va a permitir el manejo de números en los pronosticos cuando se encuentre abierto el popup
    document.addEventListener("keyup", function (e) {
        let pop = document.getElementById("popupUpdFrm");
        if (pop.style.display != "" && pop.getAttribute("editable") == '1') {
            //Luego de que validamos que está abierto vemos si existe
            let active = pop.querySelector(".tblSct").querySelector(".tbody").querySelector(".trCnt[active]");
            if (active != null && active != undefined) {
                //Si tenemos uno activo validamos que el key en efecto sea un número
                if ((/^[1-6]/).test(e.key)) {
                    let oldfcval = active.querySelector(".horsePronCnt").getAttribute("fc");
                    let oldele = pop.querySelector(".tblSct").querySelector(".tbody").querySelector(".horsePronCnt[fc='" + e.key + "']")?.parentElement.parentElement.parentElement.parentElement;
                    Array.from(pop.querySelectorAll(".horsePronCnt[fc='" + e.key + "']")).forEach(e => {
                        e.innerText = 0;
                        e.removeAttribute("fc");
                    });
                    
                    let lbls = ["Primer", "Segundo", "Tercer"];
                    if (oldfcval != e.key) {
                        active.querySelector(".horsePronCnt").setAttribute("fc", e.key);
                        active.querySelector(".horsePronCnt").innerText = e.key;
                        if(parseInt(e.key) > 0 && parseInt(e.key) < 4)
                            active.querySelector("[name='updComment']").value = lbls[(e.key - 1)] + " favorito";
                        else if (parseInt(e.key) > 3)
                            active.querySelector("[name='updComment']").value = "";

                        if(oldele != null)oldele.querySelector("[name='updComment']").value = "";
                    } else {
                        oldele.querySelector("[name='updComment']").value = "";
                    }
                } else if (e.key == 0) {
                    if (active.querySelector(".horsePronCnt[fc]") != undefined && active.querySelector("[name='updComment']") != undefined) {
                        active.querySelector(".horsePronCnt[fc]").innerText = 0;
                        active.querySelector(".horsePronCnt[fc]").removeAttribute("fc");
                        active.querySelector("[name='updComment']").value = "";
                    }
                }
            } 
        }
        let compPop = document.getElementById("popupCmprFrm");
        if (compPop.style.display != "") {            
            //Luego de que validamos que está abierto vemos si existe
            let active = compPop.querySelector(".tblSct").querySelector(".tbody").querySelector(".trCnt[active]");
            if (active != null && active != undefined) {
                //Si tenemos uno activo validamos que el key en efecto sea un número
                if ((/^[1-6]/).test(e.key)) {
                    let oldfcval = active.querySelector(".horsePronCnt").getAttribute("fc");
                    let oldele = compPop.querySelector(".tblSct").querySelector(".tbody").querySelector(".horsePronCnt[fc='" + e.key + "']")?.parentElement.parentElement.parentElement.parentElement;
                    Array.from(compPop.querySelectorAll(".horsePronCnt[fc='" + e.key + "']")).forEach(e => {
                        e.innerText = 0;
                        e.removeAttribute("fc");
                    });
                    let oldeleEdit = pop.querySelector(".tblSct").querySelector(".tbody").querySelector(".horsePronCnt[fc='" + e.key + "']")?.parentElement.parentElement.parentElement.parentElement;
                    Array.from(pop.querySelectorAll(".horsePronCnt[fc='" + e.key + "']")).forEach(e => {
                        e.innerText = 0;
                        e.removeAttribute("fc");
                    });
                    if(oldeleEdit != null)oldeleEdit.querySelector("[name='updComment']").value = "";

                    let lbls = ["Primer", "Segundo", "Tercer"];
                    if (oldfcval != e.key) {
                        active.querySelector(".horsePronCnt").setAttribute("fc", e.key);
                        active.querySelector(".horsePronCnt").innerText = e.key;
                        if(parseInt(e.key) > 0 && parseInt(e.key) < 4)
                            active.querySelector("[name='updComment']").value = lbls[(e.key - 1)] + " favorito";
                        else if (parseInt(e.key) > 3)
                            active.querySelector("[name='updComment']").value = "";

                        if(oldele != null)oldele.querySelector("[name='updComment']").value = "";
                    } else {
                        oldele.querySelector("[name='updComment']").value = "";
                    }
                } else if (e.key == 0) {
                    if (active.querySelector(".horsePronCnt[fc]") != undefined && active.querySelector("[name='updComment']") != undefined) {
                        active.querySelector(".horsePronCnt[fc]").innerText = 0;
                        active.querySelector(".horsePronCnt[fc]").removeAttribute("fc");
                        active.querySelector("[name='updComment']").value = "";
                    }
                }
            }
        }
    });
});