//Función incial se llama una vez cargado el modulo acá se asignan los eventos iniciales
function hdquartersInit() {
    //Evento mostrar popup de insertar usuario
    document.querySelector(".addBtn").addEventListener("click", function () {
        //Validamos si tiene el privilegio de aadir o no para "inhabilitar el boton"
        let btnsave = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        if (btnsave.getAttribute("add") == "inactive") btnsave.setAttribute("inactive", "");
        else btnsave.removeAttribute("inactive");

        //Blanquemoas la data y el id cuando entramos por añadir
        document.getElementById("popupUpdFrm").querySelector(".saveBtn").removeAttribute("upid");
        blankForm("popupUpdFrm", ["input", "select", ".popupDateLbl"]);
        drawSelect([], document.getElementById("municipalityId"), 'id', 'name', 'Seleccione un municipio', '');
        headqDistances = [];
        distancesDraw(headqDistances);
        editableForm("popupUpdFrm", true, ["input", "select"]);
        //Seteamos por default la fecha de distancia y tiempo nuevo a "ahora"
        document.getElementById("addTimeDate").value = dateForInpt(new Date());
        document.getElementById("addTimeDate").setAttribute("disabled", "");
        document.getElementById("addTimeBase").setAttribute("disabled", "");

        
        //Se asigna el titulo y se muestra el formulario
        document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Crear Hipódromos";
        document.getElementById("popupUpdFrm").querySelector(".popupMsgSct").innerText = "";
        showPopup("popupUpdFrm").then(() => {
            document.getElementById("popupUpdFrm").querySelectorAll(".popupHMenuOpt")[0].dispatchEvent(new Event("click"));
            //Validamos si no tiene privilegios para ver estados, ver distancias y lo marcamos
            hasPrivileges("stateId", "No tiene privilegios para visualizar los estados");
            hasPrivileges("addTimeDist", "No tiene privilegios para visualizar las distancias");
            document.getElementById("addTimeBtn").removeAttribute("disabled");
            document.querySelectorAll(".minusBtn").forEach((e) => {
                e.removeAttribute("disabled");
            });
        });
    });

    document.getElementById("addTimeDate").setAttribute("max", dateForInpt(globmaxdate));
    document.getElementById("addTimeDate").setAttribute("min", dateForInpt(globmindate));

    let refreshlist = () => {
        //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
        let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        if (selpag != null) selpag.removeAttribute("selected");
        listAPI();
    }

    //EVENTO REFRESCAR TABLA EN EL AL HACER BUSQUEDA CON ENTER
    document.getElementById("searchTbl").addEventListener("keyup", function (e) {
        if (this.value != "") this.value = fieldFormat(this.value, "search");
        //Si le da al enter, refrescamos el listadol.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            refreshlist();
        }
    });

    document.getElementById("statusFilt").addEventListener("change", refreshlist);
    //EVENTOS A CAMPOS DEL FORMULARIO DE CREAR / MODIFICAR

    //Asignamos evento al introducir texto al campo name formulari
    document.getElementById("hdquartersName").addEventListener("keyup", function (e) {
        if (this.value != "") {
            errBlank("hdquartersName");
            this.value = fieldFormat(this.value, "name");
        }
        //Si le da al enter, focus en email.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            document.getElementById("hdquartersAbbr").focus();
        }
    });

    //Asignamos evento al introducir texto al campo abreviatura del formulario
    document.getElementById("hdquartersAbbr").addEventListener("keyup", function (e) {
        if (this.value != "") this.value = fieldFormat(limitSize(this.value,5), "abbr");
        //Si le da al enter, focus en email.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            document.getElementById("stateId").focus();
        }
    });

    //Evento al select de estado, si cambia refrescamos los municipios
    document.getElementById("stateId").addEventListener("change", function (e) {
        if (this.value != "") {
            errBlank("stateId");
            listMunicipalityAPI(this.value);
        } else {
            drawSelect([], document.getElementById("municipalityId"), 'id', 'name', 'Seleccione un municipio', '');
        }
    });

    //Asignamos al enter en el status
    document.getElementById("hdquartersStatus").addEventListener("keyup", function (e) {
        //Enter en status y que esté activo el wait, guardamos
        var wait = document.getElementById("waitScreen");
        if (e.key != null && (e.key).toLowerCase() == 'enter' && wait == null) {
            //Si no tiene el atributo inactivo se intenta guardar
            if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
                errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
            } else {
                let btn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
                updateAPI((btn.getAttribute("upid") != undefined && btn.getAttribute("upid") != null) ? btn.getAttribute("upid") : 0).then((itemid) => {
                    //Cargamos el entry
                    entryAPI(itemid).then(async (rsp) => {
                        await setFrm(rsp.entry);
                    });
                });
            }
        }
    });

    //-------//

    //EVENTOS DE BOTONES GUARDAR Y CANCELAR

    //Popup "CREAR/EDITAR"
    let updpop = document.getElementById("popupUpdFrm");
    //Evento al guardar el crear/editar el
    updpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            updateAPI((this.getAttribute("upid") != undefined && this.getAttribute("upid") != null) ? this.getAttribute("upid") : 0).then((itemid) => {
                //Cargamos el entry
                entryAPI(itemid).then(async (rsp) => {
                    await setFrm(rsp.entry);
                });
            });
        }
    });
    //Evento al guardar el crear/editar el
    updpop.querySelector(".saveExitBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        let btn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        if (btn.getAttribute("inactive") != null && btn.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {            
            //Acá se intenta el guardar
            updateAPI((btn.getAttribute("upid") != undefined && btn.getAttribute("upid") != null) ? btn.getAttribute("upid") : 0).then(() => {
                //Cerramos el popup
                closePopups();
            });
        }
    });
    //Evento cancela popup crear/editar
    updpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    //EVENTOS A LAS PESTAÑAS DEL HEADER EN EL POPUP UPDATE
    updpop.querySelectorAll(".popupHMenuOpt").forEach((opt, idx) => {
        opt.addEventListener("click", function () {
            let left = idx * -100;
            document.getElementById("popupUpdViewCnt").style.left = left + "%";
            //Quitamos la opción seleccionada del header y marcamos la nueva
            document.getElementById("popupUpdFrm").querySelector(".popupHMenuOpt[selected]").removeAttribute("selected");

            let widthBar = this.offsetWidth;
            let leftBar = this.offsetLeft;
            document.getElementById("popupUpdFrm").querySelector(".popupBarHead").style.width = widthBar + "px";
            document.getElementById("popupUpdFrm").querySelector(".popupBarHead").style.left = leftBar + "px";

            this.setAttribute("selected", 1);
        });
    });

    //EVENTO PARA RESTRINGIR VALORES EN TIEMPO
    document.getElementById("addTimeBase").addEventListener("keyup", function (e) {
        //Si la coma se está poniendo o es el último caracter evitamos validar el formato
        if (e.key != 'Backspace' && e.key != ',' && e.key != '.') {
            this.value = fieldFormat(this.value, "validtime");
        }
    });


    //EVENTO AÑADIR TIEMPO DISTANCIA A SEDES
    document.getElementById("addTimeBtn").addEventListener("click", function () {
        if(this.getAttribute("disabled") != "")distancesAdd();
    });

    //Asignamos evento al change de los input/select dentro de aadir un tiempo para activar el botón una vez se pueda insertar
    document.getElementById("addRowCnt").querySelectorAll(".popInpt").forEach((e) => {
        e.addEventListener("change", function () {
            let distance = {
                id: document.getElementById("addTimeDist").value,
                besttime: document.getElementById("addTimeBase").value,
                recorddate: document.getElementById("addTimeDate").value,
                status: 0
            }
            //Validamos que todos los valores estén seteados, si no retornamos error
            isDistanceValid(distance, "");
        });
    });

    //HASTA ACÁ POPUP DE UPDATE-----------

    //Popup "ELIMINAR usuario"
    let delpop = document.getElementById("popupDelFrm");
    //Evento al guardar el crear/editar el usuario
    delpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            deleteAPI(this.getAttribute("delid"));
        }
    });

    //Evento cancela popup 
    delpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    //INICIALIZAMOS LOS EVENTOS DE ORDENAMIENTO, CON ESTE FORMATO SE PUEDEN PASAR PARAMETROS A LA FUNCIÓN
    initOrders(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    //IINICIALIZAMOS LOS EVENTOS DE LAS FLECHAS DEL PAGINADO SI EXISTE
    initPagsEvent(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    //Lamamos el servicio que carga el listado
    listAPI();

    //Cargamos el listado de estados
    listStatesAPI();

    //Cargamos el listado de distancias para el popup de mejores tiempos
    listDistancesAPI();
}
//Función para llamar al sevicio de la lista
function listAPI() {
    var par = {};
    par.filter = document.getElementById("searchTbl").value;
    let order = document.querySelector(".pgSctTbl").querySelector(".orderCol[selected]");
    par.order = (order == null || order == undefined) ? -1 : order.getAttribute("colval");
    let actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
    par.offset = (actpage != null) ? (actpage.innerHTML * 10) - 10 : 0;
    par.statusid = document.getElementById("statusFilt").value;
    par.numofrec = 10;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                console.log(data);
                //Validamos los privilegios
                await privValidations(data.privileges);
                //Si obtenemos y se setean los privilegios correctamente pintamos la tabla
                listDraw(data,data.privileges);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Si no tiene privilegios se muestra el mensaje de error
                errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros", 0);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "hippodromes/racecourses/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Función para pintar la respuesta de la lista en la tabla
function listDraw(rsp,privileges) {
    let tbl = document.getElementById("pgTbl").querySelector("tbody");
    let list = rsp.records;
    let ele = tbl.children[0].cloneNode(true);
    if (list.length > 0) {
        tbl.innerHTML = "";
        for (var i = 0; i < list.length; i++) {
            var clone = ele.cloneNode(true);
            clone.style.display = "";

            var data = list[i];
            //Evento del readonly al row
            clone.setAttribute("itemid", data.id);
            clone.addEventListener("click", function () {
                blankForm("popupUpdFrm", ["input", "select", ".popupDateLbl"]);
                //drawSelect([], document.getElementById("municipalityId"), 'id', 'name', 'Seleccione un municipio', '');
                headqDistances = [];
                distancesDraw(headqDistances);
                //Cargamos el entry
                entryAPI(this.getAttribute("itemid")).then(async (rsp) => {
                    //Desactivamos los campos
                    editableForm("popupUpdFrm", false, ["input", "select"]);
                    await setFrm(rsp.entry, true);
                    document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Hipódromos";
                    showPopup("popupUpdFrm").then(() => {                            
                        //Quitamos la opción seleccionada del header y marcamos la nueva
                        document.getElementById("popupUpdFrm").querySelectorAll(".popupHMenuOpt")[0].dispatchEvent(new Event("click"));
                        //Validamos si no tiene privilegios para ver estados, ver distancias y lo marcamos
                        hasPrivileges("stateId", "No tiene privilegios para visualizar los estados");
                        hasPrivileges("addTimeDist", "No tiene privilegios para visualizar las distancias");
                        
                        document.getElementById("addTimeBtn").setAttribute("disabled", "");
                        /*
                        document.querySelectorAll(".minusBtn").forEach((e) => {
                            e.setAttribute("disabled", "");
                        });*/
                    });
                });
            });

            var celda = clone.children[0];
            celda.innerText = data.name;

            var celda = clone.children[1];
            celda.innerText = data.state.name + ", " + data.municipality.name;

            var celda = clone.children[2];
            celda.innerText = data.status.name;

            var celda = clone.children[3].firstElementChild;
            //Atributos para eventos de los botones
            celda.setAttribute("usrid", data.id);
            celda.setAttribute("itemlbl", data.name);

            //Editar Btn
            if (privileges.update) {
                celda.children[0].addEventListener("click", function (e) {                
                    e.stopPropagation();
                    //Cargamos el entry
                    entryAPI(this.parentElement.getAttribute("usrid")).then(async (rsp) => {
                        //Validamos los privilegios
                        await privValidations(rsp.privileges);
                        //Validamos antes si tiene el privilegio y desactivamos el boton si no
                        let btnsave = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
                        if (btnsave.getAttribute("edit") == "inactive") btnsave.setAttribute("inactive", "");
                        else btnsave.removeAttribute("inactive");

                        blankForm("popupUpdFrm", ["input", "select", ".popupDateLbl"]);
                        editableForm("popupUpdFrm", true, ["input", "select"]);
                        
                        document.getElementById("addTimeDate").setAttribute("disabled", "");
                        document.getElementById("addTimeBase").setAttribute("disabled", "");
                        //Si obtenemos una respuesta exitosa del servicio en este caso seteamos el formulario de edición
                        await setFrm(rsp.entry);
                        //Una vez que se cargó la data mostramos el poup
                        document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Editar Hipódromos";
                        showPopup("popupUpdFrm").then(() => {                            
                            //Quitamos la opción seleccionada del header y marcamos la nueva
                            document.getElementById("popupUpdFrm").querySelectorAll(".popupHMenuOpt")[0].dispatchEvent(new Event("click"));
                            //Validamos si no tiene privilegios para ver estados, ver distancias y lo marcamos
                            hasPrivileges("stateId", "No tiene privilegios para visualizar los estados");
                            hasPrivileges("addTimeDist", "No tiene privilegios para visualizar las distancias");  
                            document.getElementById("addTimeBtn").removeAttribute("disabled");
                        });
                    });
                });
            } else {
                celda.children[0].setAttribute("disabled","");
            }

            //Eliminar Btn
            if (privileges.delete) {
                celda.children[1].addEventListener("click", function (e) {                
                    e.stopPropagation();
                    //Se muestra el popup de confirmación
                    let usr = this.parentElement.getAttribute("itemlbl");
                    document.querySelector(".poupDelItemLbl").innerText = usr;
                    //Asignamos el id que va a ser eliminado al boton guardar de la confirmación del delete
                    let delpop = document.getElementById("popupDelFrm");
                    delpop.querySelector(".saveBtn").setAttribute("delid", this.parentElement.getAttribute("usrid"));
                    //Mostramos el popup de confirmación
                    showPopup("popupDelFrm");
                });
            } else {
                celda.children[1].setAttribute("disabled","");
            }

            tbl.appendChild(clone);

        }
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        tbl.innerHTML = "";
        tbl.appendChild(clone);
    }
    //SE PINTA EL PAGINADO LUEGO DE PINTAR LA TABLA
    var actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
    actpage = (actpage != null && actpage != undefined) ? (actpage.innerHTML) : 1;
    drawPags(document.querySelector(".pgSctTbl"), rsp.numofrecords, 10, actpage, listAPI);
    
}
//Función para llamar el servicio que inserta o modifica un usuario.
function updateAPI(id) {
    return new Promise(async (resolve, reject) => {
        var par = {};
        par.id = id;
        par.name = (document.getElementById("hdquartersName").value).trim();
        par.municipalityid = document.getElementById("municipalityId").value;
        par.abbr = (document.getElementById("hdquartersAbbr").value).trim();;
        par.status = (document.getElementById("hdquartersStatus").checked) ? 1 : 0;
        par.sessionid = localStorage.getItem("sessionid");
        var distancesid = [];
        var besttimes = [];
        var recorddates = [];
    
        //Hacemos las validaciones
        var haserror = false;
        //En este caso de doble vista en el popup llevamos a la pestaña de datos que se valida 
        let frmopts = document.querySelectorAll(".popupHMenuOpt");
        //VALIDAMOS LOS DATOS DE LAS PESTAÑA 1
        //Que el nombre no esté vacío
        if (!(par.name !== undefined && par.name !== null && par.name !== "")) {
            errInpt("hdquartersName", "Introduzca un nombre válido", 6000);
            haserror = true;
        }
        //Que el municipio no esté vacío
        if (!(par.municipalityid !== undefined && par.municipalityid !== null && par.municipalityid !== "")) {
            if (document.getElementById("stateId").value == "") errInpt("stateId", "Seleccion un estado", 6000);
            errInpt("municipalityId", "Seleccione un municipio", 6000);
            haserror = true;
        }
        //Que el municipio no esté vacío
        if (!(par.abbr !== undefined && par.abbr !== null && par.abbr !== "")) {
            errInpt("hdquartersAbbr", "Abreviatura Inválida", 6000);
            haserror = true;
        }
        //Si tiene errores detenemos la llamada al servicio
        if (haserror) {
            if (frmopts.length > 0) frmopts[0].dispatchEvent(new Event("click"));
            return;
        }

        //Validamos los datos de la segunda pestaña
        let promises = [];
        headqDistances.forEach(async (d, idx) => {
            distancesid.push(d.id);
            besttimes.push((d.besttime != "") ? d.besttime : 1);
            recorddates.push((d.recorddate).replace(/-/g, ""));
        });
        /*
        headqDistances.forEach(async (d, idx) => {
            distancesid.push(d.id);
            /*
            if (d.besttime == undefined || d.besttime == null || d.besttime == "") {
                errInpt(document.getElementById("tblTimesCnt").querySelectorAll("input[lbl='besttime']")[idx].parentElement, "Introduzca un tiempo válido", 6000);
                haserror = true;
            } else besttimes.push(d.besttime);
            if (d.recorddate == undefined || d.recorddate == null || d.recorddate == "") {
                errInpt(document.getElementById("tblTimesCnt").querySelectorAll("input[lbl='recorddate']")[idx].parentElement, "Introduzca una fecha válida", 6000);
                haserror = true;
            } else {
                promises.push(validDateRange(d.recorddate).then(() => {
                    errBlank(document.getElementById("tblTimesCnt").querySelectorAll("input[lbl='recorddate']")[idx].parentElement);
                    recorddates.push((d.recorddate).replace(/-/g, ""));                        
                }).catch(() => {
                    msg = "Fecha inválida";
                    haserror = true;
                    errInpt(document.getElementById("tblTimesCnt").querySelectorAll("input[lbl='recorddate']")[idx].parentElement, "Introduzca una fecha válida", 6000);
                }));
            }
        });
        */
        await Promise.all(promises);

        if (distancesid.length > 0) par.distancesid = distancesid.join("-");
        if (besttimes.length > 0) par.besttimes = besttimes.join("-");
        if (recorddates.length > 0) par.recorddates = recorddates.join("-");

        if (haserror) {
            if (frmopts.length > 0) frmopts[1].dispatchEvent(new Event("click"));
            return;
        }
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    //Si obtenemos un id insertado/modificado refrescamos la tabla
                    if (data.id != null && data.id != undefined) {
                        //Llevaos el ordenamiento por "id" y cargamos el listado
                        resetOrder(document.querySelector(".pgSctTbl")).then(() => { listAPI(); });
                        //Como definimos función flecha podemos leer los parametros para determinar si era nuevo y mostrar mensaje exitoso correcto
                        successMsgShow((par.id == 0) ? "Sede creada con éxito" : "Sede modificada con éxito");

                        resolve(data.id);
                    }
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Error de privilegios - prohibido
                    errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
                    reject();
                    break;
                case 409:
                    let frmopts = document.querySelectorAll(".popupHMenuOpt");
                    if (frmopts.length > 0) frmopts[0].dispatchEvent(new Event("click"));
                    errInpt("hdquartersAbbr", "", 6000);
                    errInpt("hdquartersName", "Sede o abreviatura duplicados", 6000);
                    reject();
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "hippodromes/racecourses/update", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para llamar el servicio de eliminar, se ejecuta al confirmar el boton
function deleteAPI(id) {
    var par = {};
    par.id = id;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.id != null && data.id != undefined) {
                    listAPI();
                    //Mostramos mensaje de eliminado con éxito
                    successMsgShow("Sede eliminada con éxito");
                }
                //Cerramos el popup
                closePopups();
                break;
            case 204:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Registro no encontrado", 6000);
                break;
            case 304:
                //Error de privilegios - prohibido
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Existen dependencias que no permiten ejecutar esta acción", 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Error de privilegios - prohibido
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "hippodromes/racecourses/delete", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) })
}
//Función retorna la inforación detallada del usuario
function entryAPI(id) {
    return new Promise((resolve, reject) => {
        var par = {};
        par.id = id;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("GET", "hippodromes/racecourses/entry", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para rellenar el formulario de edición
function setFrm(rsp, readonly = false) {
    return new Promise((resolve, reject) => {
        document.getElementById("stateId").value = rsp.state.id;
        listMunicipalityAPI(rsp.state.id, rsp.municipality.id);
        headqDistances = (rsp.distances != null) ? rsp.distances : [];
        distancesDraw(headqDistances, readonly);
        document.getElementById("hdquartersName").value = rsp.name;
        document.getElementById("hdquartersAbbr").value = rsp.abbr;
        document.getElementById("hdquartersStatus").checked = (rsp.status.id == 1) ? true : false;
        //Seteamos por default la fecha de distancia y tiempo nuevo a "ahora"
        document.getElementById("addTimeDate").value = dateForInpt(new Date());
        document.getElementById("popupUpdFrm").querySelector(".saveBtn").setAttribute("upid", rsp.id);
        document.getElementById("popupUpdFrm").querySelector(".popupMsgSct").innerText = rsp.name + " (" + rsp.abbr + ")";
        document.getElementById("creationLbl").innerText = "Creado: " + rsp.created.formatted;
        if (rsp.created.date != rsp.modified.date)
            document.getElementById("updatedLbl").innerText = "Modificado: " + rsp.modified.formatted;
        else
            document.getElementById("updatedLbl").innerText = "";
        setTimeout(function () { resolve("cargado") }, 100);
    });
}
//Se realizan las validaciones de privilegios de front, se inactivan y muestran los mensajes correspondientes
function privValidations(rsp) {
    return new Promise((resolve, reject) => {
        //ELIMINAR
        let popupdelBtn = document.getElementById("popupDelFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupdelBtn) {
            if (!rsp.delete) {
                popupdelBtn.setAttribute("inactive", "");
            } else {
                popupdelBtn.removeAttribute("inactive");
            }
        }

        //EDITAR
        let popupeditBtn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupeditBtn) {
            if (!rsp.update) {
                popupeditBtn.setAttribute("edit", "inactive");
            } else {
                popupeditBtn.removeAttribute("edit");
            }
        }

        //CREAR
        let popupaddBtn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupaddBtn) {
            if (!rsp.create) {
                popupaddBtn.setAttribute("add", "inactive");
            } else {
                popupaddBtn.removeAttribute("add");
            }
        }
        let tbladdBtn = document.querySelector(".addBtn");
        if (tbladdBtn) {
            if (!rsp.create) {
                tbladdBtn.setAttribute("disabled", "");
            } else {
                tbladdBtn.removeAttribute("disabled");
            }
        }
        resolve();
    });

}
//Se requiere invocar el listado de "estados" para el select del filtro y el insertar nuevo
function listStatesAPI(selected = "") {
    var par = {};
    par.filter = "";
    par.order = 2;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Asignamos el atributo disabled a los que traigan el status cómo inactivo para que el "drawSelect" deshabilite las opciones que corresponden
                let disInactives = (data.records).map((r) => {
                    if (r.status.id == 0) r.disabled = true;
                    return r;
                });
                drawSelect(disInactives, document.getElementById("stateId"), 'id', 'name', 'Seleccione un estado', selected);

                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                document.getElementById("stateId").setAttribute("privileges", -1);
                //Si no tiene privilegios se muestra el mensaje de error
                //errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "addresses/states/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Se requiere invocar el listado de "estados" para el select del filtro y el insertar nuevo
function listMunicipalityAPI(stateid, selected = "") {
    var par = {};
    par.stateid = stateid;
    par.filter = "";
    par.order = 1;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Asignamos el atributo disabled a los que traigan el status cómo inactivo para que el "drawSelect" deshabilite las opciones que corresponden
                let disInactives = (data.records).map((r) => {
                    if (r.status.id == 0) r.disabled = true;
                    return r;
                });
                drawSelect(disInactives, document.getElementById("municipalityId"), 'id', 'name', 'Seleccione un municipio', selected);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Si no tiene privilegios se muestra el mensaje de error
                errInpt("municipalityId", "No tiene privilegios para visualizar los municipios", 0);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "addresses/municipalities/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Se requiere invocar el listado de "estados" para el select del filtro y el insertar nuevo
let dataDistances = [];
function listDistancesAPI(selected = "") {
    var par = {};
    par.filter = "";
    par.order = 1;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Asignamos el atributo disabled a los que traigan el status cómo inactivo para que el "drawSelect" deshabilite las opciones que corresponden
                let disInactives = (data.records).map((r) => {
                    if (r.status.id == 0) r.disabled = true;
                    return r;
                });
                console.log(data);
                drawSelect(disInactives, document.getElementById("addTimeDist"), 'id', 'name', 'Distancia', selected);
                dataDistances = disInactives;
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                document.getElementById("addTimeDist").setAttribute("privileges", -1);
                //errInpt("addTimeDist", "No tiene privilegios para visualizar las distancias", 0);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "hippodromes/distances/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Pintamos las distancias por sede al cargar el entry
let headqDistances = [];
function distancesDraw(distances, readonly = false) {
    let tbl = document.getElementById("tblTimesCnt");
    let ele = tbl.children[0].cloneNode(true);
    dataDistances.forEach(dd => {
        if (distances.find((d) => d.id == dd.id) != null || dd.status.id == 0) dd.disabled = true;
        else dd.disabled = false;
    });
    drawSelect(dataDistances, document.getElementById("addTimeDist"), 'id', 'name', 'Distancia', '');
    if (distances.length > 0) {
        tbl.innerHTML = "";
        for (var i = 0; i < distances.length; i++) {
            var clone = ele.cloneNode(true);
            clone.style.display = "";
            clone.removeAttribute("disabled");
            clone.setAttribute("idx", i);
            clone.querySelectorAll("input,select").forEach((e) => {
                e.removeAttribute("disabled");
            });

            var data = distances[i];
            var celda = clone.children[0];
            errBlank(celda.querySelector("select").parentElement);
            drawSelect(dataDistances, celda.querySelector("select"), 'id', 'name', '', data.id);
            celda.querySelector("select").setAttribute("lbl", "id");
            if((data.deletable != undefined) && (!data.deletable || readonly))celda.querySelector("select").setAttribute("disabled", "");

            var celda = clone.children[1];
            errBlank(celda.querySelector("input").parentElement);
            celda.querySelector("input").value = (data.besttime != "") ? number_format(validDecimals(data.besttime),2) : "";
            celda.querySelector("input").addEventListener("keyup", function (e) {
                this.value = fieldFormat(this.value, "validtime");
            });            
            if ((data.deletable != undefined) && (!data.deletable || readonly)) celda.querySelector("input").setAttribute("disabled", "");
            else celda.querySelector("input").setAttribute("disabled", "");
            celda.querySelector("input").setAttribute("lbl", "besttime");

            var celda = clone.children[2];
            errBlank(celda.querySelector("input").parentElement);
            celda.querySelector("input").value = data.recorddate;
            celda.querySelector("input").setAttribute("lbl", "recorddate");
            celda.querySelector("input").setAttribute("min", dateForInpt(globmindate));
            celda.querySelector("input").setAttribute("max", dateForInpt(new Date()));
            if ((data.deletable != undefined) && (!data.deletable || readonly)) celda.querySelector("input").setAttribute("disabled", "");
            else celda.querySelector("input").setAttribute("disabled", "");

            var celda = clone.children[3];
            celda.querySelector(".minusBtn").setAttribute("idx", i);
            celda.querySelector(".minusBtn").removeAttribute("disabled");
            celda.querySelector(".minusBtn").removeAttribute("readonly");
            celda.querySelector(".minusBtn").removeAttribute("deletable");
            if (data.deletable != undefined) {
                celda.querySelector(".minusBtn").setAttribute("deletable", (data.deletable) ? "1" : "0");
                if (!data.deletable || readonly) celda.querySelector(".minusBtn").setAttribute("disabled", "");
                if (readonly) celda.querySelector(".minusBtn").setAttribute("readonly", "");
            }
            celda.querySelector(".minusBtn").addEventListener("click", function () {
                if (this.getAttribute("deletable") == 0 && this.getAttribute("readonly") != "") {                    
                    errTbl(document.getElementById("popupUpdViewCnt").querySelector(".grpTblFrm"), "Existen dependencias que no permiten eliminar esta distancia", 6000);
                }else{
                    if (this.getAttribute("disabled") != "") {
                        headqDistances.splice(this.getAttribute("idx"), 1);
                        distancesDraw(headqDistances);
                    }
                }
            });

            let onrowchange = function () {
                let idx = this.parentElement.parentElement.parentElement.getAttribute("idx");
                headqDistances[idx][this.getAttribute("lbl")] = (this.getAttribute("lbl") == 'besttime') ? validDecimals(this.value) : this.value;
                distancesDraw(headqDistances);
            }
            clone.querySelectorAll("select").forEach(e => e.addEventListener("change", onrowchange));
            clone.querySelectorAll("input").forEach(e => e.addEventListener("change", onrowchange));

            tbl.appendChild(clone);

        }
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        tbl.innerHTML = "";
        tbl.appendChild(clone);
    }
}
function validDecimals(value) {
    var numero = (value.toString()).trim();
    // Verificar si el número tiene dos decimales
    if ((/^[\d]+[\.\,]{0,1}[\d]{0,2}$/).test(numero)) {
        numero = getNum(numero);
    }
    
    // Actualizar el valor del campo de entrada
    return (!isNaN(numero)?numero:"");
}
//Creamos una función para insertar una distancia nueva
async function distancesAdd() {
    let distance = {
        id: document.getElementById("addTimeDist").value,
        besttime: document.getElementById("addTimeBase").value == "" ? 1 : validDecimals(document.getElementById("addTimeBase").value),
        recorddate: document.getElementById("addTimeDate").value,
        status: 0
    }
    //Validamos que todos los valores estén seteados, si no retornamos error
    if (await isDistanceValid(distance)) return;
    //Se valida que no se esté intentando insertar un registro que ya existe
    if (headqDistances.find(d => d.id == distance.id) != null) {
        errTbl(document.getElementById("popupUpdViewCnt").querySelector(".grpTblFrm"), "Ya existe esta distancia", 6000);
    } else {
        headqDistances.unshift(distance);
        //Pintamos la lista con el tiempo insertado
        distancesDraw(headqDistances);
        //Blanqueamos el formulario de "insertar new time"
        blankForm("addRowCnt", ["input", "select"]);
        errTblBlank(document.getElementById("popupUpdViewCnt").querySelector(".grpTblFrm"));
        document.getElementById("addTimeBtn").removeAttribute("active");
        //Seteamos por default la fecha del tiempo a "ahora"
        document.getElementById("addTimeDate").value = dateForInpt(new Date());
    }
}
//Función que muestra activo / desactivado el boton de insertar un tiempo en una sede
async function isDistanceValid(distance, msg = "Faltan campos obligatorios") {
    //Hacemos las validaciones
    var haserror = false;
    //Que el nombre no esté vacío
    if (!(distance.id !== undefined && distance.id !== null && distance.id !== "")) {
        if (msg != "") errInpt("addTimeDist", "", 6000);
        haserror = true;
    } else {
        errBlank("addTimeDist");
    }
    //Que el tiempo no esté vacío
    /*
    if (!(distance.besttime !== undefined && distance.besttime !== null && distance.besttime !== "")) {
        if (msg != "") errInpt("addTimeBase", "", 6000);
        haserror = true;
    } else {
        errBlank("addTimeBase");
    }
    //Que la fecha no esté vacío
    if (!(distance.recorddate !== undefined && distance.recorddate !== null && distance.recorddate !== "")) {
        if (msg != "") errInpt("addTimeDate", "", 6000);
        haserror = true;
    } */
    //Si tiene errores detenemos la ejecución de la función
    if (haserror) {
        document.getElementById("addTimeBtn").removeAttribute("active");
        if (msg != "") errTbl(document.getElementById("popupUpdViewCnt").querySelector(".grpTblFrm"), msg, 6000);

        return haserror;
    }
    
    //Validación nueva de la fecha
    //let splited = distance.recorddate.split("-");
    //let date = new Date(splited[0], (splited[1] - 1), splited[2]);
    await validDateRange(distance.recorddate).then(() => {
        errBlank("addTimeDate");
    }).catch(() => {
        msg = "Fecha inválida";
        haserror = true;
        errInpt("addTimeDate", "", 6000);
    });

    //Si tiene errores detenemos la ejecución de la función
    if (haserror) {
        document.getElementById("addTimeBtn").removeAttribute("active");
        if (msg != "") errTbl(document.getElementById("popupUpdViewCnt").querySelector(".grpTblFrm"), msg, 6000);
    } else {
        errTblBlank(document.getElementById("popupUpdViewCnt").querySelector(".grpTblFrm"));
        document.getElementById("addTimeBtn").setAttribute("active", "");
    }

    return haserror;
}

//Llamada inicial
document.addEventListener("DOMContentLoaded", function () {
    hdquartersInit();
});