const pwderrormsg = "La clave debe tener un mínimo de 8 caracteres, solo letras, números o caracteres especiales (._-#$)";
//Función incial se llama una vez cargado el modulo acá se asignan los eventos iniciales
function usersInit() {
    //Evento mostrar popup de insertar usuario
    document.querySelector(".addBtn").addEventListener("click", function () {
        //Validamos si tiene el privilegio de aadir o no para "inhabilitar el boton"
        let btnsave = document.getElementById("popupUsrFrm").querySelector(".saveBtn");
        if (btnsave.getAttribute("add") == "inactive") btnsave.setAttribute("inactive", "");
        else btnsave.removeAttribute("inactive");

        //Blanquemoas la data y el id cuando entramos por añadir
        document.getElementById("popupUsrFrm").querySelector(".saveBtn").removeAttribute("upid");
        blankForm("popupUsrFrm", ["input", ".popupDateLbl"]);        
        document.getElementById("updMagazinesid").enable();
        document.getElementById("updMagazinesid").reset();
        editableForm("popupUsrFrm", true, ["input"]);
        //Se asigna el titulo y se muestra el formulario
        document.getElementById("popupUsrFrm").querySelector(".popupTit").innerText = "Crear Usuarios";
        showPopup("popupUsrFrm");
    });

    let refreshlist = () => {
        //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
        let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        if (selpag != null) selpag.removeAttribute("selected");
        listAPI();
    }
    //EVENTO REFRESCAR TABLA EN EL AL HACER BUSQUEDA CON ENTER
    document.getElementById("searchTbl").addEventListener("keyup", function (e) {
        if (this.value != "") this.value = fieldFormat(this.value, "search");
        //Si le da al enter, refrescamos el listadol.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            refreshlist();
        }
    });
    //EVENTO REFRESCAR TABLA EN EL AL HACER BUSQUEDA CON ENTER
    document.getElementById("statusTbl").addEventListener("change", function () {
        refreshlist();
    });


    //EVENTOS A CAMPOS DEL FORMULARIO DE USUARIO CREAR / MODIFICAR

    //Asignamos evento al introducir texto al campo usr formulario de usuarios
    document.getElementById("usrName").addEventListener("keyup", function (e) {
        if (this.value != "") {
            errBlank("usrName");
            this.value = fieldFormat(this.value, "name");
        }
        //Si le da al enter, focus en email.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            document.getElementById("usrEmail").focus();
        }
    });

    //Asignamos al enter en el password para hacer el submit
    document.getElementById("usrEmail").addEventListener("keyup", function (e) {
        //Validamos que tenga formato de email
        if (this.value != "" && !hasFormat(this.value, 'email')) {
            errInpt("usrEmail", "Formato de correo inválido", 0);
            return;
        } else {
            errBlank("usrEmail");
        }
        //Si le da al enter, focus en email.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            document.getElementById("pwdFrm").focus();
        }
    });

    //Asignamos al enter en el password para hacer el submit
    document.getElementById("usrStatus").addEventListener("keyup", function (e) {
        //Enter en status y que esté activo el wait, guardamos
        var wait = document.getElementById("waitScreen");
        if (e.key != null && (e.key).toLowerCase() == 'enter' && wait == null) {
            //Si no tiene el atributo inactivo se intenta guardar
            if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
                errInpt("usrName", "", 6000);
                errInpt("usrEmail", "No tiene privilegios para ejecutar esta acción", 6000);
            } else {
                let btn = document.getElementById("popupUsrFrm").querySelector(".saveBtn");
                updateAPI((btn.getAttribute("upid") != undefined && btn.getAttribute("upid") != null) ? btn.getAttribute("upid") : 0);
            }
        }
    });

    document.getElementById("pwdFrm").addEventListener("keyup", function (e) {
        //Validamos que tenga formato de email
        if (this.value != "" && !hasFormat(this.value, 'password')) {
            errInpt("pwdFrm", pwderrormsg, 0);
            return;
        } else {
            errBlank("pwdFrm");
        }
        //Si le da al enter, focus en email.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            document.getElementById("pwdCnfFrm").focus();
        }
    });
    document.getElementById("pwdCnfFrm").addEventListener("keyup", function (e) {
        //Validamos que tenga formato de email
        if (this.value != "" && !hasFormat(this.value, 'password')) {
            errInpt("pwdCnfFrm", pwderrormsg, 0);
            return;
        } else {
            errBlank("pwdCnfFrm");
        }
        //Si le da al enter, focus en email.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            let btn = document.getElementById("popupUsrFrm").querySelector(".saveBtn");
            if (btn.getAttribute("inactive") != null && btn.getAttribute("inactive") != undefined) {
                errInpt(document.getElementById("popupUsrFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
            } else {
                updateAPI((btn.getAttribute("upid") != undefined && btn.getAttribute("upid") != null) ? btn.getAttribute("upid") : 0);
            }
        }
    });
    //Asignamos el evento a los iconos de "ver password" de todos los formularios
    document.querySelectorAll(".readPwd").forEach((e) => {
        e.addEventListener("click", function () {
            let inpt = e.previousElementSibling;
            let ic = this.firstElementChild;
            //Validamos que exista el inpt al que hace referencia el "ver contraseña"
            if (inpt != null) {
                if (inpt.getAttribute("type") == 'password') {
                    inpt.setAttribute("type", "text");
                    ic.classList.remove("fa-eye");
                    ic.classList.add("fa-eye-slash");
                } else {
                    inpt.setAttribute("type", "password");
                    ic.classList.remove("fa-eye-slash");
                    ic.classList.add("fa-eye");
                }
            }
        });
    });

    //-------//

    //Popup "CREAR/EDITAR usuario"
    let usrpop = document.getElementById("popupUsrFrm");
    //Evento al guardar el crear/editar el usuario
    usrpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt("usrName", "", 6000);
            errInpt("usrEmail", "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            updateAPI((this.getAttribute("upid") != undefined && this.getAttribute("upid") != null) ? this.getAttribute("upid") : 0);
        }
    });
    //Evento cancela popup crear/editar usuarios
    usrpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    //Popup "ELIMINAR usuario"
    let delpop = document.getElementById("popupDelFrm");
    //Evento al guardar eliminar
    delpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            deleteAPI(this.getAttribute("delid"));
        }
    });
    //Evento cancela popup 
    delpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    //Popup "PRIVILEGIOS usuario"
    let privpop = document.getElementById("popupPrivTbl");
    //Evento al guardar el crear/editar el usuario
    privpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errTbl(privpop.querySelector(".usrprivTblSct"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            updatePrivilegesAPI(this.getAttribute("upid"));
        }

    });
    //Evento cancela popup 
    privpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    //INICIALIZAMOS LOS EVENTOS DE ORDENAMIENTO, CON ESTE FORMATO SE PUEDEN PASAR PARAMETROS A LA FUNCIÓN
    initOrders(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    //IINICIALIZAMOS LOS EVENTOS DE LAS FLECHAS DEL PAGINADO SI EXISTE
    initPagsEvent(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    //Lamamos el servicio que carga el listado
    listAPI();

    //Listado de revistas para crear/añadir usuarios
    listMagazinesAPI();
}
//Función para llamar al sevicio de la lista
function listAPI() {
    var par = {};
    par.filter = document.getElementById("searchTbl").value;
    par.statusid = document.getElementById("statusTbl").value;
    let order = document.querySelector(".pgSctTbl").querySelector(".orderCol[selected]");
    par.order = (order == null || order == undefined) ? -1 : order.getAttribute("colval");
    let actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
    par.offset = (actpage != null) ? (actpage.innerHTML * 10) - 10 : 0;
    par.numofrec = 10;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Pintamos los privilegios
                await privValidations(data.privileges);
                //Si obtenemos la respuesta pintamos la tabla
                listDraw(data, data.privileges);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Si no tiene privilegios se muestra el mensaje de error
                errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "users/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Función para pintar la respuesta de la lista en la tabla
function listDraw(rsp, privileges) {
    let tbl = document.getElementById("pgTbl").querySelector("tbody");
    let list = rsp.records;
    let ele = tbl.children[0].cloneNode(true);
    if (list.length > 0) {
        tbl.innerHTML = "";
        for (var i = 0; i < list.length; i++) {
            var clone = ele.cloneNode(true);
            clone.style.display = "";

            var data = list[i];
            //Evento del readonly al row
            clone.setAttribute("itemid", data.id);
            clone.addEventListener("click", function () {
                blankForm("popupUsrFrm", ["input", ".popupDateLbl"]);
                //Cargamos el entry
                entryAPI(this.getAttribute("itemid")).then(async (rsp) => {
                    //Desactivamos los campos
                    editableForm("popupUsrFrm", false, ["input"]);
                    document.getElementById("updMagazinesid").disable();

                    //Validamos los privilegios
                    await privValidations(rsp.privileges);
                    //Si obtenemos una respuesta exitosa del servicio en este caso seteamos el formulario de edición
                    await setUsrFrm(rsp.entry);
                    
                    //Una vez que se cargó la data mostramos el poup
                    document.getElementById("popupUsrFrm").querySelector(".popupTit").innerText = "Usuarios";
                    showPopup("popupUsrFrm");
                });
            });

            var celda = clone.children[0];
            celda.innerText = data.name;

            var celda = clone.children[1];
            celda.innerText = data.email;

            var celda = clone.children[2];
            celda.innerText = data.status.dsc;
            
            var celda = clone.children[3];
            celda.innerText = data.doblecheck ? "Activo" : "Inactivo";

            var celda = clone.children[4].firstElementChild;
            //Atributos para eventos de los botones
            celda.setAttribute("usrid", data.id);
            celda.setAttribute("itemname", data.name);
            celda.setAttribute("itemlbl", data.email);

            //Editar Btn
            if (privileges.update) {
                celda.children[0].addEventListener("click", function (e) {
                    e.stopPropagation();
                    //Cargamos el entry
                    entryAPI(this.parentElement.getAttribute("usrid")).then(async (rsp) => {
                        //blanqueamos el formulario que vamos a mostrar de datos y errores
                        blankForm("popupUsrFrm", ["input"]);
                        editableForm("popupUsrFrm", true, ["input"]);
                        document.getElementById("updMagazinesid").enable();

                        //Validamos los privilegios
                        await privValidations(rsp.privileges);
                        //Validamos antes si tiene el privilegio y desactivamos el boton si no
                        let btnsave = document.getElementById("popupUsrFrm").querySelector(".saveBtn");
                        if (btnsave.getAttribute("edit") == "inactive") btnsave.setAttribute("inactive", "");
                        else btnsave.removeAttribute("inactive");

                        //Si obtenemos una respuesta exitosa del servicio en este caso seteamos el formulario de edición
                        await setUsrFrm(rsp.entry);
                        //Una vez que se cargó la data mostramos el poup
                        document.getElementById("popupUsrFrm").querySelector(".popupTit").innerText = "Editar Usuarios";
                        showPopup("popupUsrFrm");
                    });
                });

                //Editar Privilegios Btn
                celda.children[1].addEventListener("click", function (e) {
                    e.stopPropagation();
                    //Cargamos el entry
                    entryPrivilegesAPI(this.parentElement.getAttribute("usrid")).then((rsp) => {
                        //Blanqueamos los errores de la tabla de privilegios
                        errTblBlank(document.getElementById("popupPrivTbl").querySelector(".usrprivTblSct"));
                        //Asignamos el userid que se está cargando al botón de guardar privilegios
                        document.getElementById("popupPrivTbl").querySelector(".saveBtn").setAttribute("upid", this.parentElement.getAttribute("usrid"));
                        //Asignamos el nombre y correo al label
                        document.getElementById("popupPrivTbl").querySelector(".popupMsgSct").innerHTML = this.parentElement.getAttribute("itemname") + " - " + this.parentElement.getAttribute("itemlbl");
                        //Si obtenemos la respuesta pintamos la tabla
                        privilegesDraw(rsp);
                        //Si obtenemos una respuesta exitosa del servicio en este caso seteamos la tabla de privilegios
                        showPopup("popupPrivTbl");
                    });
                });
            } else {
                celda.children[0].setAttribute("disabled", "");
                celda.children[1].setAttribute("disabled", "");
            }

            //Eliminar Btn
            if (privileges.delete) {
                celda.children[2].addEventListener("click", function (e) {
                    e.stopPropagation();
                    //Se muestra el popup de confirmación
                    let usr = this.parentElement.getAttribute("itemlbl");
                    document.querySelector(".poupDelItemLbl").innerText = usr;
                    //Asignamos el id que va a ser eliminado al boton guardar de la confirmación del delete
                    let delpop = document.getElementById("popupDelFrm");
                    delpop.querySelector(".saveBtn").setAttribute("delid", this.parentElement.getAttribute("usrid"));
                    //Mostramos el popup de confirmación
                    showPopup("popupDelFrm");
                });
            } else {
                celda.children[2].setAttribute("disabled", "");
            }

            tbl.appendChild(clone);

        }
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        tbl.innerHTML = "";
        tbl.appendChild(clone);
    }
    //SE PINTA EL PAGINADO LUEGO DE PINTAR LA TABLA
    var actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
    actpage = (actpage != null && actpage != undefined) ? parseFloat(actpage.innerHTML) : 1;
    drawPags(document.querySelector(".pgSctTbl"), rsp.numofrec, 10, actpage, listAPI);
    
}
//Función para llamar el servicio que inserta o modifica un usuario.
function updateAPI(id) {
    var par = {};
    par.id = id;
    par.usr = document.getElementById("usrEmail").value;
    par.name = (document.getElementById("usrName").value).trim();
    par.status = (document.getElementById("usrStatus").checked) ? 1 : 0;
    let magazineids = document.getElementById("updMagazinesid").value;
    par.magazineids = magazineids.length > 0 ? magazineids.join("-") : "";
    par.sessionid = localStorage.getItem("sessionid");
    par.doblecheck = (document.getElementById("usr2FA").checked) ? 1 : 0;
    //Dfinimos los valores de los parametros
    var pwd = document.getElementById("pwdFrm").value;
    var pwd2 = document.getElementById("pwdCnfFrm").value;
    //Validaciones locales antes de enviar
    var haserror = false;
    //qSi el pw 
    if ((pwd !== undefined && pwd !== null && pwd !== "")) {
        if (!hasFormat(pwd, 'password')) {
            errInpt("pwdFrm", pwderrormsg, 6000);
            haserror = true;
        }
        if (!(pwd2 !== undefined && pwd2 !== null && pwd2 !== "")) {
            errInpt("pwdCnfFrm", "Confirme su contraseña", 6000);
            haserror = true;
        }
        if (!hasFormat(pwd2, 'password')) {
            errInpt("pwdCnfFrm", pwderrormsg, 6000);
            haserror = true;
        }
        //Si no coinciden las claves y no está ninguna vacía
        if (pwd != pwd2 && !haserror) {
            errInpt("pwdFrm", "", 6000);
            errInpt("pwdCnfFrm", "No coinciden las contraseñas", 6000);
            haserror = true;
        }
        if (!haserror) par.pwd = MD5(pwd);
    }
    
    //Que el nombre no esté vacío
    if (!(par.name !== undefined && par.name !== null && par.name !== "")) {
        errInpt("usrName", "Introduzca un nombre válido", 6000);
        haserror = true;
    }
    //Si tiene errores detenemos la llamada al servicio
    if (haserror) return;
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.id != null && data.id != undefined) {
                    //Llevaos el ordenamiento por "id" y cargamos el listado
                    resetOrder(document.querySelector(".pgSctTbl")).then(() => { listAPI(); });

                    //Como definimos función flecha podemos leer los parametros para determinar si era nuevo y mostrar mensaje exitoso correcto
                    successMsgShow((par.id == 0) ? "Usuario creado con éxito" : "Usuario modificado con éxito");

                }
                //Cerramos el popup
                closePopups();
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Error de privilegios - prohibido
                errInpt("usrEmail", "No tiene privilegios para ejecutar esta acción", 6000);
                break;
            case 409:
                errInpt("usrEmail", "Ya existe un usuario registrado con este correo", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "users/update", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Función para llamar el servicio de eliminar, se ejecuta al confirmar el boton
function deleteAPI(id) {
    var par = {};
    par.id = id;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.id != null && data.id != undefined) {
                    listAPI();
                    //Mostramos mensaje de eliminado con éxito
                    successMsgShow("Usuario eliminado con éxito");
                }
                //Cerramos el popup
                closePopups();
                break;
            case 304:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No se puede ejecutar esta acción", 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Error de privilegios - prohibido
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "users/delete", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) })
}
//Función retorna la inforación detallada del usuario
function entryAPI(id) {
    return new Promise((resolve, reject) => {
        var par = {};
        par.id = id;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("GET", "users/entry", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para rellenar el formulario de edición
function setUsrFrm(rsp) {
    return new Promise((resolve, reject) => {
        document.getElementById("usrName").value = rsp.name;
        document.getElementById("usrEmail").value = rsp.email;
        document.getElementById("usrStatus").checked = (rsp.status.id == 1) ? true : false;
        document.getElementById("usr2FA").checked = (rsp.doblecheck == 1) ? true : false;
        document.getElementById("popupUsrFrm").querySelector(".saveBtn").setAttribute("upid", rsp.id);
        document.getElementById("updMagazinesid").setValue(rsp.magazines.map(mz => mz.id));
        document.getElementById("creationLbl").innerText = "Creado: " + rsp.created.formatted;
        if (rsp.created.date != rsp.modified.date)
            document.getElementById("updatedLbl").innerText = "Modificado: " + rsp.modified.formatted;
        else
            document.getElementById("updatedLbl").innerText = "";
        setTimeout(function () { resolve("cargado") }, 100);
    });
}
//Función para carga el listado de privilegios recibe el userid
function entryPrivilegesAPI(userid) {
    return new Promise((resolve, reject) => {
        var par = {};
        par.userid = userid;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "users/privileges/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });

    });
}
//Función que pinta la tabla de privilegios 
function privilegesDraw(rsp) {
    let tbl = document.getElementById("privilegesTbl").querySelector("tbody");
    let list = rsp;
    let ele = tbl.children[0].cloneNode(true);
    let colsname = ["Ver", "Insertar", "Modificar", "Eliminar"];
    if (list.length > 0) {
        tbl.innerHTML = "";
        //Modelo A
        /*
        list.forEach(data => {
            //Validamos si es formato crud o no
            if (data.crud) {
                var clone = ele.cloneNode(true);
                clone.style.display = "";

                var celda = clone.children[0];
                celda.innerText = data.name;

                var celda = clone.children[1];
                celda.innerText = "-";

                //Recorremos las columnas y si encontramos en los privilegios validamos si lo tiene activo o no
                for (var i = 0; i < colsname.length; i++) {
                    var celda = clone.children[2 + i];
                    celda.children[0].style.display = "";
                    var hasaccess = (data.privileges).find((e) => e.dsc == colsname[i]);
                    if (hasaccess > 0) {
                        celda.querySelector("input").checked = hasaccess[0].access;
                        celda.querySelector("input").setAttribute("privid", hasaccess[0].id);
                    }
                }
                //Insertamos un solo row
                tbl.appendChild(clone);
            } else {
                //Recorremos todos los privilegios y se manejan cómo "lineas cada uno"
                for (var i = 0; i < data.privileges.length; i++) {

                    var clone = ele.cloneNode(true);
                    clone.style.display = "";

                    var celda = clone.children[0];
                    celda.innerText = data.name;

                    var celda = clone.children[1];
                    celda.innerText = data.privileges[i].dsc;

                    var celda = clone.children[2];
                    celda.querySelector("input").checked = data.privileges[i].access;
                    celda.querySelector("input").setAttribute("privid", data.privileges[i].id);

                    for (var x = 1; x < colsname.length; x++) {
                        var celda = clone.children[2 + x];
                        celda.children[0].style.display = "none";
                    }

                    //Insertamos cada privilegio cómo un row
                    tbl.appendChild(clone);
                }
            }



        });
        */
        //Modelo B separamos primero los arreglos y aplicamos el mismo procedimiento del modela a pero por separado

        //Filtramos los menus que no son tipo crud y los pintamos primero
        let notCrudArr = list.filter((e) => !e.crud);
        notCrudArr.forEach(data => {
            //Recorremos todos los privilegios y se manejan cómo "lineas cada uno"
            for (var i = 0; i < data.privileges.length; i++) {

                var clone = ele.cloneNode(true);
                clone.style.display = "";

                var celda = clone.children[0];
                celda.innerText = data.name;

                var celda = clone.children[1];
                celda.innerText = data.privileges[i].dsc;

                var celda = clone.children[2];
                celda.querySelector("input").checked = data.privileges[i].access;
                celda.querySelector("input").setAttribute("privid", data.privileges[i].id);

                for (var x = 1; x < colsname.length; x++) {
                    var celda = clone.children[2 + x];
                    celda.children[0].style.display = "none";
                }

                //Insertamos cada privilegio cómo un row
                tbl.appendChild(clone);
            }
        });
        //Filtramos los que si son crud y los pintamos
        let crudsArr = list.filter((e) => e.crud);
        crudsArr.forEach(data => {
            var clone = ele.cloneNode(true);
            clone.style.display = "";

            var celda = clone.children[0];
            celda.innerText = "-";

            var celda = clone.children[1];
            celda.innerText = data.name;

            //Recorremos las columnas y si encontramos en los privilegios validamos si lo tiene activo o no
            for (var i = 0; i < colsname.length; i++) {
                var celda = clone.children[2 + i];
                celda.children[0].style.display = "";
                var hasaccess = (data.privileges).find((e) => e.dsc == colsname[i]);
                if (hasaccess != null) {
                    celda.querySelector("input").checked = hasaccess.access;
                    celda.querySelector("input").setAttribute("privid", hasaccess.id);
                }
            }
            //Insertamos un solo row
            tbl.appendChild(clone);
        });
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        tbl.innerHTML = "";
        tbl.appendChild(clone);
    }
}
//Función que llama el servicio que guarda los privilegios del usuario que se está modificando
function updatePrivilegesAPI(userid) {
    //Extraemos los switch validos de la tabla de privilegios
    let priv = document.getElementById("privilegesTbl").querySelectorAll(".switch > input[privid]");
    //Armamos el strin que se envía en los parametros
    var privstring = "";
    priv.forEach((e) => { if (e.checked) privstring += e.getAttribute("privid") + "-" });
    //Quitamos la última coma
    privstring = privstring.substring(0, privstring.length - 1);
    if (privstring == "") {
        //Si no asigna ningún privilegio mostramos error
        errTbl(document.getElementById("popupPrivTbl").querySelector(".usrprivTblSct"), "Debe asignar al menos un privilegio para continuar", 6000);
        //evitamos que se llame el servicio
        return;
    }
    //Definimos los parametros
    let par = {};
    par.privileges = privstring;
    par.userid = userid;
    par.sessionid = localStorage.getItem("sessionid");

    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.userid != null && data.userid != undefined) {
                    //listAPI();
                    //Refrescamos el menú lateral porque esta accion de modificar los privilegios puede afectarlo
                    menuAPI();
                    //Mostramos mensaje de eliminado con éxito
                    successMsgShow("Privilegios modificados con éxito");
                }
                //Cerramos el popup
                closePopups();
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 409:
                errInpt("usrEmail", "Ya existe un usuario registrado con este correo", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "users/privileges/update", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });

}

//Se realizan las validaciones de privilegios de front, se inactivan y muestran los mensajes correspondientes
function privValidations(rsp) {
    return new Promise((resolve, reject) => {
        //ELIMINAR
        let popupdelBtn = document.getElementById("popupDelFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupdelBtn) {
            if (!rsp.delete) {
                popupdelBtn.setAttribute("inactive", "");
            } else {
                popupdelBtn.removeAttribute("inactive");
            }
        }

        //EDITAR
        let popupeditBtn = document.getElementById("popupUsrFrm").querySelector(".saveBtn");
        let popupprivBtn = document.getElementById("popupPrivTbl").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupeditBtn) {
            if (!rsp.update) {
                popupeditBtn.setAttribute("edit", "inactive");
            } else {
                popupeditBtn.removeAttribute("edit");
            }
        }
        if (popupprivBtn) {
            if (!rsp.update) {
                popupprivBtn.setAttribute("inactive", "");
            } else {
                popupprivBtn.removeAttribute("inactive");
            }
        }

        //CREAR
        let popupaddBtn = document.getElementById("popupUsrFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupaddBtn) {
            if (!rsp.create) {
                popupeditBtn.setAttribute("add", "inactive");
            } else {
                popupeditBtn.removeAttribute("add");
            }
        }
        let tbladdBtn = document.querySelector(".addBtn");
        if (tbladdBtn) {
            if (!rsp.create) {
                tbladdBtn.setAttribute("disabled", "");
            } else {
                tbladdBtn.removeAttribute("disabled");
            }
        }
        resolve();
    });

}
//Se requiere invocar el listado de "estados" para el select del filtro y el insertar nuevo
function listMagazinesAPI(selected = []) {
    var par = {};
    par.filter = "";
    par.order = 1;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Asignamos el atributo disabled a los que traigan el status cómo inactivo para que el "drawSelect" deshabilite las opciones que corresponden
                let disInactives = (data.records).map((r) => {
                    if (r.status.id == 0) r.disabled = true;
                    return r;
                });
                //drawSelect(disInactives, document.getElementById("stateId"), 'id', 'name', 'Seleccione un estado', selected);
                //let selectedImp = ((data != undefined) ? data.implements.map(i => i.id) : []);
                let implementOptSelect = {
                    ele: document.getElementById("updMagazinesid"),
                    //Le damos el formato que corresponde al arreglo
                    labelKey: 'abbr',
                    valueKey: 'id',
                    aliasKey:'dsc',
                    labelRenderer: (opt) => {
                        return opt.alias;
                    },
                    options: disInactives,
                    disabledOptions: disInactives.filter(r=>r.disabled).map(i=>i.id),
                    placeholder: 'Seleccione una revista',
                    hideClearButton: false,
                    autoSelectFirstOption: false,
                    silentInitialValueSet: false,
                    multiple: true,
                    search: false,
                    optionHeight:'35px',
                    disableAllOptionsSelectedText: true,
                    noOptionsText: 'No hay opciones',
                    selectAllText: 'Todas',//Label de la opción para escoger todos
                    allOptionsSelectedText: 'Todas ',//Texto que se muestra en el campo cuando están marcados todos 'Todos'+num
                    maxWidth: (document.getElementById("updMagazinesid").offsetWidth-3)+"px",
                    dropboxWidth: "100%",
                    optionSelectedText: 'Opción Seleccionada',
                    optionsSelectedText: 'Opciones Seleccionadas',
                    silentInitialValueSet: false,
                    hideClearButton:true,
                    additionalClasses: "popInpt",
                    selectedValue: selected,
                    alwaysShowSelectedOptionsLabel: true,            
                    dropboxWrapper:'.boxscroll'

                }        
                //Inicializamos el select de las opciones
                VirtualSelect.init(implementOptSelect)

                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                document.getElementById("stateId").setAttribute("privileges", -1);
                //Si no tiene privilegios se muestra el mensaje de error
                //errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "magazines/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}

//Llamada inicial
document.addEventListener("DOMContentLoaded", function () {
    usersInit();
});