async function magazinesInit() {
    //Cargamos la lista de hipodromos y revistas
    let promises = [listRacecoursesAPI(), listMagazinesAPI()];
    await Promise.all(promises);

    
    let refreshMets = async (racecourseid = document.getElementById("racecoursesSel").value) => {
        if (racecourseid != "") {
            await listMeetingsAPI(racecourseid);
            refreshRaces(document.getElementById("meetingsSince").value);
        } else {
            drawSelect([], document.getElementById("meetingsSince"), 'id', 'number', '', '');
        }
    }
    refreshMets();

    document.getElementById("racecoursesSel").addEventListener("change", function () {
        refreshMets(this.value);
    });

    
    let refresFormats = async (magazineid = document.getElementById("magazinesSel").value) => {
        if (magazineid != "") {
            await listFormatsAPI(magazineid);
        } else {
            drawSelect([], document.getElementById("formatsSel"), 'id', 'number', '', '');
        }
    }
    refresFormats();

    document.getElementById("magazinesSel").addEventListener("change", function () {
        refresFormats(this.value);
    });

    //Cuando se le da click al download armamos una llamada api especial
    document.getElementById("downloadBtn").addEventListener("click", function () {
        let format = document.getElementById("formatsSel");
        let meetingid = document.getElementById("meetingsSince").value;
        let magazineid = document.getElementById("magazinesSel").value;
        if (magazineid == "") {
            errTbl(document.querySelector(".tblSct"), "Seleccione una revista válida", 6000);
        }else if (meetingid == "" && format.value == "") {
            errTbl(document.querySelector(".tblSct"), "Seleccione una reunión y formato válidos", 6000);
            return;
        } else if (meetingid == "") {
            errTbl(document.querySelector(".tblSct"), "Seleccione una reunión válida", 6000);
            return;
        } else if (format.value == "") {
            errTbl(document.querySelector(".tblSct"), "Seleccione un formato válido", 6000);
            return;
        } else if (!validraces()) {
            return;
        }
        let parms = {
            'reunionid': meetingid,
            'sessionid': localStorage.getItem("sessionid"),
            'magazineid': magazineid,
            'format': document.getElementById("formatdwnldSel").value,
            'raceidfrom': document.getElementById("racesSince").value != null ? document.getElementById("racesSince").value : "",
            'raceidto': document.getElementById("racesUntil").value != null ? document.getElementById("racesUntil").value : ""
        }
        let url = globalurl+"api/" + format.value;
        download(url, parms, format.options[format.selectedIndex].innerText).then(() => {            
            document.getElementById("hiddenlink").click();
            document.body.removeChild(document.getElementById("hiddenlink"));
        });
    });

    

    
    //La primera vez cargamos los listados de reuniones vacios hasta que se escoja un hipodromo filtro
    let refreshRaces = async (meetingid = document.getElementById("meetingsSince").value) => {
        if (meetingid != "") {
            let races = [listRacesAPI(document.getElementById("meetingsSince").value, 1), listRacesAPI(document.getElementById("meetingsSince").value, 2)];
            await Promise.all(races);
        } else {
            drawSelect([], document.getElementById("racesSince"), 'id', 'number', '', '');
            drawSelect([], document.getElementById("racesUntil"), 'id', 'number', '', '');
        }
    }   

    //Se refreshRaces una primera vez en blanco
    refreshRaces();
    
    document.getElementById("meetingsSince").addEventListener("change", function () {
        refreshRaces(this.value);
    });

    let validraces = () => {
        let metsince = document.getElementById("racesSince");  
        let metuntil = document.getElementById("racesUntil");
        if (metsince.options.length > 0 && metuntil.options.length > 0) {
            if (getNum(metsince.options[metsince.selectedIndex].innerText) > getNum(metuntil.options[metuntil.selectedIndex].innerText)) {
                errInpt(document.querySelector(".errmsgSct"), "Seleccione un rango de carreras válido", 8000);
                errInpt(document.getElementById("racesSince").parentElement, "", 8000);
                errInpt(document.getElementById("racesUntil").parentElement, "", 8000);
                return false;
            }
        }
        return true;
    }

    document.getElementById("racesSince").addEventListener("change", async function () {
        validraces();
    });
    document.getElementById("racesUntil").addEventListener("change", async function () {
        validraces();
    });
    
    /*
    let validmeets = () => {
        let metsince = document.getElementById("meetingsSince");  
        let metuntil = document.getElementById("meetingsUntil");
        if (getNum(metsince.options[metsince.selectedIndex].innerText) > getNum(metuntil.options[metuntil.selectedIndex].innerText)) {
            drawSelect([], document.getElementById("racesUntil"), 'id', 'number', 'Seleccione una reunión', '');
            errInpt(document.querySelector(".errmsgSct"), "Seleccione un rango de uniones válido", 8000);
            errInpt(document.getElementById("meetingsSince").parentElement, "", 8000);
            errInpt(document.getElementById("meetingsUntil").parentElement, "", 8000);
        }
    }

    //Eventos de selectes, si escoge un hipodromo cambian las reuniones y blanqueamos las carreras
    document.getElementById("meetingsSince").addEventListener("change", async function () {
        await listRacesAPI(this.value, 1);
        validmeets();
    });
    document.getElementById("meetingsUntil").addEventListener("change", async function () {
        await listRacesAPI(this.value, 2);
        validmeets();
    });*/
/*
    let validraces = () => {
        let metsince = document.getElementById("racesSince");  
        let metuntil = document.getElementById("racesUntil");
        if (getNum(metsince.options[metsince.selectedIndex].innerText) > getNum(metuntil.options[metuntil.selectedIndex].innerText)) {
            errInpt(document.querySelector(".errmsgSct"), "Seleccione un rango de carreras válido", 8000);
            errInpt(document.getElementById("racesSince").parentElement, "", 8000);
            errInpt(document.getElementById("racesUntil").parentElement, "", 8000);

        }
    }
    document.getElementById("racesSince").addEventListener("change", async function () {
        validraces();
    });
    document.getElementById("racesUntil").addEventListener("change", async function () {
        validraces();
    });
*/

}
function download(url, parms, name) {    
    return new Promise((resolve, reject) => {
        var parsedPars = Object.keys(parms).map(function (k) {
            return encodeURIComponent(k) + "=" + encodeURIComponent(parms[k]);
        }).join("&");
        let fullurl = url + "?" + parsedPars;
        const a = document.createElement('a');
        a.href = fullurl;
        a.download = name.trim() + '.docx';
        a.target = '_blank';
        a.style.display = "none";
        a.setAttribute("id", "hiddenlink");
        document.body.appendChild(a);
        resolve();
    });
}
//Se requiere invocar el listado de "hipodromos" para el select del filtro 
function listRacecoursesAPI(selected = "") {
    return new Promise((resolve, reject) => { 
        var par = {};
        par.filter = "";
        par.order = 2;
        par.offset = 0;
        par.numofrec = 9999;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                                        
                    //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                    let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                    disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });

                    //Data del filtro de la tabla
                    drawSelect(data.records, document.getElementById("racecoursesSel"), 'id', 'name', 'Seleccione un hipódromo', selected);
                    
                    resolve();
                    

                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    resolve();
                    //errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "hippodromes/racecourses/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
    
}
//Se requiere invocar el listado de "Revistas" para el select del filtro 
function listMagazinesAPI(selected = "") {
    return new Promise((resolve, reject) => {
        var par = {};
        par.filter = "";
        par.order = 1;
        par.offset = 0;
        par.numofrec = 9999;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                                        
                    //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                    let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                    disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });

                    //Data del filtro de la tabla
                    drawSelect(data.records, document.getElementById("magazinesSel"), 'id', 'dsc', 'Seleccione una revista', selected);
                    
                    resolve();                    

                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    resolve();
                    //errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "magazines/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
    
}
//Se requiere invocar el listado de "Reuniones" para el select del filtro 
function listMeetingsAPI(racecourseid) {
    return new Promise((resolve, reject) => {
        var par = {};
        par.filter = "";
        par.order = -3;
        par.statusid = 0;
        par.racecourseid = racecourseid;
        par.datefrom = "";
        par.dateto = "";
        par.offset = 0;
        par.numofrec = 9999;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                    let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                    disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });

                    //Data del filtro de la tabla
                    drawSelect(data.records, document.getElementById("meetingsSince"), 'id', 'number+ - +date.formatted', '', data.records[0].id);
                    //drawSelect(data.records, document.getElementById("meetingsUntil"), 'id', 'number', '', data.records[data.records.length-1].id);
                    resolve();
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                    reject();
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    reject();
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "records/reunions/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Se requiere invocar el listado de "Carreras" para el select del filtro 
function listRacesAPI(meetingid,type) {
    return new Promise((resolve, reject) => { 
        var par = {};
        par.reunionid = meetingid;
        par.filter = "";
        par.order = 1;
        par.offset = 0;
        par.numofrec = 9999;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);                    
                    //Data del filtro de la tabla
                    let validasLbl = ["1ª", "2ª", "3ª", "4ª", "5ª", "6ª"];
                    let select = null;
                    if (type == 1) {
                        select = document.getElementById("racesSince");
                        drawSelect(data.records, document.getElementById("racesSince"), 'id', 'number', '', (data.records.length > 0) ? data.records[0].id : "");
                    }
                    else if (type == 2) {
                        select = document.getElementById("racesUntil");
                        drawSelect(data.records, document.getElementById("racesUntil"), 'id', 'number', '', (data.records.length > 0) ? data.records[data.records.length - 1].id : "");  
                    }
                    if (select != null) {
                        let validas = (data.records).filter(opt => opt.isvalid);
                        let validcounter = 0;
                        (data.records).forEach((option) => {
                            let optEle = select.querySelector("option[value='" + option.id + "'");
                            if ((validcounter + 1) <= validas.length && option.isvalid) {
                                optEle.innerText = optEle.innerText + "(" + validasLbl[validcounter] + ")";
                                validcounter++;
                            }
                        });
                    }
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar las carreras");                    
                    reject();
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "records/races/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Se requiere invocar el listado de "Formatos" para el select del filtro 
function listFormatsAPI(magazineid) {
    return new Promise((resolve, reject) => {
        var par = {};
        par.magazineid = magazineid;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                    //let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                    //disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });

                    //Data del filtro de la tabla
                    drawSelect(data.records, document.getElementById("formatsSel"), 'call', 'dsc', '', (data.records.length>0)?data.records[0].call:'');
                    //drawSelect(data.records, document.getElementById("meetingsUntil"), 'id', 'number', '', data.records[data.records.length-1].id);
                    resolve();
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                    reject();
                    break;
                case 404:
                    //Si no tiene privilegios se muestra el mensaje de error
                    data = JSON.parse(rsp.response);
                    let msg = (data.msg != undefined) ? data.msg : "No se pudo determinar el error";
                    errTbl(document.querySelector(".tblSct"), msg, 6000);
                    reject();
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    reject();
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "formats/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Llamada inicial
document.addEventListener("DOMContentLoaded", function () {
    magazinesInit();
});