//Función incial se llama una vez cargado el modulo acá se asignan los eventos iniciales
async function horsesInit() {
    //Evento mostrar popup de insertar usuario
    document.querySelector(".addBtn").addEventListener("click", function () {
        //Validamos si tiene el privilegio de aadir o no para "inhabilitar el boton"
        let btnsave = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        if (btnsave.getAttribute("add") == "inactive") btnsave.setAttribute("inactive", "");
        else btnsave.removeAttribute("inactive");

        //Blanquemoas la data y el id cuando entramos por añadir
        document.getElementById("popupUpdFrm").querySelector(".saveBtn").removeAttribute("upid");
        blankForm("popupUpdFrm", ["input", "select","textarea", ".popupDateLbl", ".errmsgSct"]);
        blankSummarie();
        document.getElementById("updObs").style.height = "";
        editableForm("popupUpdFrm", true, ["input", "select","textarea"]);
        //Se asigna el titulo y se muestra el formulario
        document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Crear Ejemplares";
        //QBlanqueamos el subtitulo donde mostramos al ejemplar editandose
        document.getElementById("popupUpdFrm").querySelector(".popupMsgSct").innerText = "";
        //Remuevo el atributo de horseid del father y mother
        document.getElementById("updFatherName").removeAttribute("horseid");
        document.getElementById("updMotherName").removeAttribute("horseid");
        
        showPopup("popupUpdFrm").then(() => {            
            //Quitamos la opción seleccionada del header y marcamos la nueva
            document.getElementById("popupUpdFrm").querySelectorAll(".popupHMenuOpt")[0].dispatchEvent(new Event("click"));
            //Validamos si no tiene privilegios para ver algun select y mostramos el mensaje
            hasPrivileges("updFursid", "No tiene privilegios para visualizar pelajes");
            hasPrivileges("updHarasid", "No tiene privilegios para visualizar haras");
            hasPrivileges("stDistFilt", "No tiene privilegios para visualizar distancias");
            hasPrivileges("stHeadqFilt", "No tiene privilegios para visualizar sedes");
        });
        //Blanqueamos el listado de carreras del lado de la tabla
        listRacesDraw({'history':[]});
    });


    let refreshlist = () => {
        //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
        let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        if (selpag != null) selpag.removeAttribute("selected");
        listAPI();
    }
    //EVENTO REFRESCAR TABLA EN EL AL HACER BUSQUEDA CON ENTER
    document.getElementById("searchTbl").addEventListener("keyup", function (e) {
        if (this.value != "") this.value = fieldFormat(this.value, "search");

        //Si le da al enter, refrescamos el listadol.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            refreshlist();
        }
    });

    //EVENTO REFRESCAR TABLA AL HACER CAMBIO EN FILTROS
    document.getElementById("genderFilt").addEventListener("change", refreshlist);
    document.getElementById("fursFilt").addEventListener("change", refreshlist);
    document.getElementById("harasFilt").addEventListener("change", refreshlist);
    document.getElementById("statusFilt").addEventListener("change", refreshlist);

    //EVENTOS A CAMPOS DEL FORMULARIO DE USUARIO CREAR / MODIFICAR

    //Asignamos evento al introducir texto al campo name formulari
    document.getElementById("updName").addEventListener("keyup", function (e) {
        if (this.value != "") {
            errBlank(this.getAttribute("id"));
            this.value = fieldFormat((this.value).toUpperCase(), 'specialname');
        }
        //Si le da al enter, focus en email.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            document.getElementById("updAbbr").focus();
        }
    });
    //Asignamos evento al introducir texto al campo abbr formulari
    document.getElementById("updAbbr").addEventListener("keyup", function (e) {
        if (this.value != "") {
            errBlank(this.getAttribute("id"));
            this.value = fieldFormat(limitSize(this.value, 15), 'abbr');
        }
        //Si le da al enter, focus en email.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            document.getElementById("updStateid").focus();
        }
    });
    //Validación de que no sea fecha superior a la actual atributo de html y evento change
    document.getElementById("updBirthdate").addEventListener("change", async function (e) {
        let birth = (new Date((this.value).split("-"))).getTime();
        let now = (new Date()).getTime();
        if (birth > now) errInpt(this.getAttribute("id"), "Fecha de nacimiento inválida", 6000);
        else errBlank(this.getAttribute("id"));
    });
    document.getElementById("updBirthdate").setAttribute("min", dateForInpt(globmindate));
    document.getElementById("updBirthdate").setAttribute("max", dateForInpt(new Date()));
    //Asignamos al enter en el status
    document.getElementById("updStatus").addEventListener("keyup", function (e) {
        //Enter en status y que esté activo el wait, guardamos
        var wait = document.getElementById("waitScreen");
        if (e.key != null && (e.key).toLowerCase() == 'enter' && wait == null) {
            //Si no tiene el atributo inactivo se intenta guardar
            let btn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
            if (btn.getAttribute("inactive") != null && btn.getAttribute("inactive") != undefined) {
                errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
            } else {
                updateAPI((btn.getAttribute("upid") != undefined && btn.getAttribute("upid") != null) ? btn.getAttribute("upid") : 0).then((itemid) => {
                    //Cargamos el entry
                    entryAPI(itemid).then(async (rsp) => {
                        await setFrm(rsp.entry);
                    });
                });
            }
        }
    });
    document.getElementById("updObs").addEventListener("keyup", function (e) {
        if (this.value != "") {                        
            //let cnt = document.querySelector(".frmHeadBox[active]").parentElement;
            //cnt.querySelector(".popupFrmCnt").style.height = "max-content";
            let spaces = this.value.split("\n");
            if (spaces.length > 5) {
                // Unir las palabras con un solo salto de línea
                spaces = spaces.slice(0,5);
                let modifiedText = spaces.join("\n");
                this.value = modifiedText;
            }
            this.value = fieldFormat(limitSize(this.value, 500), 'uniquereplace', (limitSize(this.value, 500)).replace(/[^a-zA-Z0-9áéíóúñüÁÉÍÓÚÑÜ@$&  \"\'\`.,:\-()+*\//\n]/g,""));

            errBlank(this.getAttribute("id"));
            document.getElementById("updObs").style.height = "";
            //Luego de que insertamos hacemos un resize del campo.
            document.getElementById("updObs").style.height = (document.getElementById("updObs").scrollHeight - 17) + "px";
        }
    });
    //Eventos de busqueda en linaje, si tiene más de 3 el tamaño del campo, y deja de escribir por 1s realiza una busqueda
    var delay = null;
    document.getElementById("updFatherName").addEventListener("keyup", function (e) {
        if (this.value != "") this.value = fieldFormat(this.value, 'specialname');
        clearTimeout(delay);
        if (this.value.length >= 3) {
            delay = setTimeout(() => {
                listHorsesAPI(this.nextElementSibling, this.value);
            }, 500);
        }
    });
    document.getElementById("updMotherName").addEventListener("keyup", function (e) {
        if (this.value != "") this.value = fieldFormat(this.value, 'specialname');
        clearTimeout(delay);
        if (this.value.length >= 3) {
            delay = setTimeout(() => {
                listHorsesAPI(this.nextElementSibling, this.value);
            }, 500);
        }
    });

    let linajeids = ["updFathGFName", "updFathGMName", "updFatherObs", "updFathGFObs", "updFathGMObs", "updMothGFName", "updMothGMName",
        "updMotherObs", "updMothGFObs", "updMothGMObs"];
    linajeids.forEach(element => {
        document.getElementById(element).addEventListener("keyup", function (e) {
            if (this.value != "") {                
                if ((this.getAttribute("id")).indexOf("Obs") > -1) this.value = limitSize(this.value, 500);
                if ((this.getAttribute("id")).indexOf("Name") > -1) this.value = fieldFormat(this.value, 'specialname');
                else this.value = fieldFormat(this.value, 'name');
            }
        });
    });

    //EVENTOS DE FILTROS PARA CARRERAS
    document.getElementById("stHeadqFilt").addEventListener("change", async function () {
        let distances = distanceData;
        if (this.value != "") {
            await listHeadqEntryAPI(this.value).then((data) => {
                distances = data.entry.distances;
            });
        }        
        drawSelect(distances, document.getElementById("stDistFilt"), 'id', 'name', 'Todas las distancias', '');
        
        entryAPI(this.getAttribute("itemid")).then(async (rsp) => {
            setFrm(rsp.entry);
        });
    });
    document.getElementById("stDistFilt").addEventListener("change", function () {
        entryAPI(this.getAttribute("itemid")).then(async (rsp) => {
            setFrm(rsp.entry);
        });
    });
    //-------//

    //EVENTOS DE BOTONES GUARDAR Y CANCELAR
    //Popup "CREAR/EDITAR"
    let updpop = document.getElementById("popupUpdFrm");
    //EVENTOS A LAS PESTAÑAS DEL HEADER EN EL POPUP UPDATE
    updpop.querySelectorAll(".popupHMenuOpt").forEach((opt, idx) => {
        opt.addEventListener("click", function () {
            let left = idx * -100;
            document.getElementById("popupUpdViewCnt").style.left = left + "%";
            let popupupd = document.getElementById("popupUpdFrm");
            //Quitamos la opción seleccionada del header y marcamos la nueva
            popupupd.querySelector(".popupHMenuOpt[selected]").removeAttribute("selected");

            let widthBar = this.offsetWidth;
            let leftBar = this.offsetLeft;
            popupupd.querySelector(".popupBarHead").style.width = widthBar + "px";
            popupupd.querySelector(".popupBarHead").style.left = leftBar + "px";

            /*if (idx == 2) popupupd.querySelector(".popupBtnSct").style.visibility = "hidden";
            else popupupd.querySelector(".popupBtnSct").style.visibility = "";*/

            this.setAttribute("selected", 1);
        });
    });
    //Evento al guardar el crear/editar el
    updpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            updateAPI((this.getAttribute("upid") != undefined && this.getAttribute("upid") != null) ? this.getAttribute("upid") : 0).then((itemid) => {
                //Cargamos el entry
                entryAPI(itemid).then(async (rsp) => {
                    await setFrm(rsp.entry);
                });
            });
        }
    });
     //Evento al guardar el crear/editar el
    updpop.querySelector(".saveExitBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        let btn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        if (btn.getAttribute("inactive") != null && btn.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {            
            //Acá se intenta el guardar
            updateAPI((btn.getAttribute("upid") != undefined && btn.getAttribute("upid") != null) ? btn.getAttribute("upid") : 0).then(() => {
                //Cerramos el popup
                closePopups();
            });
        }
    });
    //Evento cancela popup crear/editar
    updpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    //Popup "ELIMINAR usuario"
    let delpop = document.getElementById("popupDelFrm");
    //Evento al guardar el crear/editar el usuario
    delpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            deleteAPI(this.getAttribute("delid"));
        }
    });

    //Evento cancela popup 
    delpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    //INICIALIZAMOS LOS EVENTOS DE ORDENAMIENTO, CON ESTE FORMATO SE PUEDEN PASAR PARAMETROS A LA FUNCIÓN
    initOrders(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    //IINICIALIZAMOS LOS EVENTOS DE LAS FLECHAS DEL PAGINADO SI EXISTE
    initPagsEvent(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    //Cargamos los estados
    await Promise.all([listFursAPI(), listHarasAPI()]);
    //Lamamos el servicio que carga el listado
    listAPI();
    //Cargamos los filtros para las sub tabla dentro del detalle del caballo no necesario para mostrar el listado
    await Promise.all([listHeadqAPI(), listDistancesAPI()]);


}
//Funcion para blaquear el summaries
function blankSummarie() {
    //Cuando se crea uno nuevo colocamos todo el summary en 0
    document.querySelectorAll(".summPlace,.summRace,.summWinamo").forEach(e => {
        e.querySelector("span").innerText = 0;
    }); 
}

//Función para llamar al sevicio de la lista
function listAPI() {
    var par = {};
    par.filter = document.getElementById("searchTbl").value;
    let order = document.querySelector(".pgSctTbl").querySelector(".orderCol[selected]");
    par.order = (order == null || order == undefined) ? -1 : order.getAttribute("colval");
    let actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
    par.statusid = document.getElementById("statusFilt").value;
    par.genderid = document.getElementById("genderFilt").value;
    par.furid = document.getElementById("fursFilt").value;
    par.harasid = document.getElementById("harasFilt").value;
    par.offset = (actpage != null) ? (actpage.innerHTML * 10) - 10 : 0;
    par.numofrec = 10;
    par.fullsearch = 1;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                console.log(data);
                //Validamos los privilegios
                await privValidations(data.privileges);
                //Si obtenemos y se setean los privilegios correctamente pintamos la tabla
                listDraw(data,data.privileges);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Si no tiene privilegios se muestra el mensaje de error
                errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "horses/horses/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Función para pintar la respuesta de la lista en la tabla - requiere modelo base en html
function listDraw(rsp, privileges) {
    let tbl = document.getElementById("pgTbl").querySelector("tbody");
    let list = rsp.records;
    let ele = tbl.children[0].cloneNode(true);
    if (list.length > 0) {
        tbl.innerHTML = "";
        for (var i = 0; i < list.length; i++) {
            var clone = ele.cloneNode(true);
            clone.style.display = "";

            var data = list[i];
            clone.setAttribute("itemid", data.id);
            clone.addEventListener("click", function () {
                entryAPI(this.getAttribute("itemid")).then(async (rsp) => {
                    //Blanqueamos los errores antes de abrir
                    blankForm("popupUpdFrm", ["input", "select","textarea", ".popupDateLbl", ".errmsgSct"]);
                    blankSummarie();
                    editableForm("popupUpdFrm", false, ["input", "textarea", "select"]);
                    //Remuevo el atributo de horseid del father y mother
                    document.getElementById("updFatherName").removeAttribute("horseid");
                    document.getElementById("updMotherName").removeAttribute("horseid");
                    //Cuando se crea uno nuevo colocamos todo el summary en 0
                    document.querySelectorAll(".summPlace,.summRace,.summWinamo").forEach(e => {
                        e.querySelector("span").innerText = 0;
                    });
                    
                    document.getElementById("stHeadqFilt").removeAttribute("disabled");
                    document.getElementById("stHeadqFilt").removeAttribute("readonly");
                    document.getElementById("stDistFilt").removeAttribute("disabled");
                    document.getElementById("stDistFilt").removeAttribute("readonly");
                    //Si obtenemos una respuesta exitosa del servicio en este caso seteamos el formulario de edición
                    await setFrm(rsp.entry);
                    //Una vez que se cargó la data mostramos el poup
                    document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Ejemplares";

                    showPopup("popupUpdFrm").then(() => {                        
                        //Quitamos la opción seleccionada del header y marcamos la nueva
                        document.getElementById("popupUpdFrm").querySelectorAll(".popupHMenuOpt")[0].dispatchEvent(new Event("click"));
                        //Resize del campo condiciones si tiene valores y editamos
                        document.getElementById("updObs").dispatchEvent(new Event("keyup"));
                        //Validamos si no tiene privilegios para ver algun select y mostramos el mensaje
                        hasPrivileges("updFursid", "No tiene privilegios para visualizar pelajes");
                        hasPrivileges("updHarasid", "No tiene privilegios para visualizar haras");
                        hasPrivileges("stDistFilt", "No tiene privilegios para visualizar distancias");
                        hasPrivileges("stHeadqFilt", "No tiene privilegios para visualizar sedes");

                    });
                });
            });

            var celda = clone.children[0];
            celda.innerText = data.id;

            var celda = clone.children[1];
            celda.innerText = data.name;

            var celda = clone.children[2];
            celda.innerText = data.abbr;

            var celda = clone.children[3];
            celda.innerText = data.age;

            var celda = clone.children[4];
            celda.innerText = data.gender.name;

            var celda = clone.children[5];
            celda.innerText = data.fur.name;

            var celda = clone.children[6];
            celda.innerText = data.origin;

            var celda = clone.children[7];
            celda.innerText = data.haras.name;

            var celda = clone.children[8];
            celda.innerText = data.status.name;

            var celda = clone.children[9].firstElementChild;
            //Atributos para eventos de los botones
            celda.setAttribute("itemid", data.id);
            celda.setAttribute("itemlbl", data.name);

            //Editar Btn
            if(privileges.update){
                celda.children[0].addEventListener("click", function (e) {
                    e.stopPropagation();
                    //Cargamos el entry
                    entryAPI(this.parentElement.getAttribute("itemid")).then(async (rsp) => {
                        //Validamos los privilegios
                        await privValidations(rsp.privileges);
                        //Validamos antes si tiene el privilegio y desactivamos el boton si no
                        let btnsave = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
                        if (btnsave.getAttribute("edit") == "inactive") btnsave.setAttribute("inactive", "");
                        else btnsave.removeAttribute("inactive");

                        //Blanqueamos los errores antes de abrir
                        blankForm("popupUpdFrm", ["input", "select","textarea",".popupDateLbl", ".errmsgSct"]);
                        blankSummarie();
                        editableForm("popupUpdFrm", true, ["input", "textarea", "select"]);
                        //Remuevo el atributo de horseid del father y mother
                        document.getElementById("updFatherName").removeAttribute("horseid");
                        document.getElementById("updMotherName").removeAttribute("horseid");
                        //Cuando se crea uno nuevo colocamos todo el summary en 0
                        document.querySelectorAll(".summPlace,.summRace,.summWinamo").forEach(e => {
                            e.querySelector("span").innerText = 0;
                        });
                        //Si obtenemos una respuesta exitosa del servicio en este caso seteamos el formulario de edición
                        await setFrm(rsp.entry);
                        //Una vez que se cargó la data mostramos el poup
                        document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Editar Ejemplares";

                        showPopup("popupUpdFrm").then(() => {                        
                            //Quitamos la opción seleccionada del header y marcamos la nueva
                            document.getElementById("popupUpdFrm").querySelectorAll(".popupHMenuOpt")[0].dispatchEvent(new Event("click"));
                            //Resize del campo condiciones si tiene valores y editamos
                            document.getElementById("updObs").dispatchEvent(new Event("keyup"));
                            //Validamos si no tiene privilegios para ver algun select y mostramos el mensaje
                            hasPrivileges("updFursid", "No tiene privilegios para visualizar pelajes");
                            hasPrivileges("updHarasid", "No tiene privilegios para visualizar haras");
                            hasPrivileges("stDistFilt", "No tiene privilegios para visualizar distancias");
                            hasPrivileges("stHeadqFilt", "No tiene privilegios para visualizar sedes");

                        });


                    });
                });
            } else {
                celda.children[0].setAttribute("disabled","");
            }

            //Eliminar Btn
            if (privileges.delete) {
                celda.children[1].addEventListener("click", function (e) {
                    e.stopPropagation();
                    //Se muestra el popup de confirmación
                    let usr = this.parentElement.getAttribute("itemlbl");
                    document.querySelector(".poupDelItemLbl").innerText = usr;
                    //Asignamos el id que va a ser eliminado al boton guardar de la confirmación del delete
                    let delpop = document.getElementById("popupDelFrm");
                    delpop.querySelector(".saveBtn").setAttribute("delid", this.parentElement.getAttribute("itemid"));
                    //Mostramos el popup de confirmación
                    showPopup("popupDelFrm");
                });
            } else {
                celda.children[1].setAttribute("disabled","");
            }
            tbl.appendChild(clone);

        }
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        tbl.innerHTML = "";
        tbl.appendChild(clone);
    }
    //SE PINTA EL PAGINADO LUEGO DE PINTAR LA TABLA
    var actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
    actpage = (actpage != null && actpage != undefined) ? (actpage.innerHTML) : 1;
    drawPags(document.querySelector(".pgSctTbl"), rsp.numofrecords, 10, actpage, listAPI);
    
}
//Función para llamar el servicio que inserta o modifica un usuario.
function updateAPI(id) {
    return new Promise(async (resolve, reject) => {
        let basicvalidations = [
            {
                "key": "name",
                "id": "updName",
                "msg": "Introduzca un nombre válido"
            },
            {
                "key": "abbr",
                "id": "updAbbr",
                "msg": "Introduzca una abreviatura válida"
            },
            {
                "key": "gender",
                "id": "updGender",
                "msg": "Introduzca un genero válido"
            },
            {
                "key": "birthdate",
                "id": "updBirthdate",
                "msg": "Introduzca una fecha válida"
            },
            {
                "key": "furid",
                "id": "updFursid",
                "msg": "Introduzca un pelaje válido"
            },
            {
                "key": "harasid",
                "id": "updHarasid",
                "msg": "Introduzca un haras válido"
            },
            {
                "key": "origin",
                "id": "updOrigin",
                "msg": "Introduzca un origen válido"
            },
        ]

        var par = {};
        par.id = id;
        //Basic section
        par.name = (document.getElementById("updName").value.replaceAll("'","/*.*/")).replaceAll("`","/*:*/");
        par.abbr = document.getElementById("updAbbr").value;
        par.gender = document.getElementById("updGender").value;
        par.furid = document.getElementById("updFursid").value;
        par.birthdate = document.getElementById("updBirthdate").value;
        par.harasid = document.getElementById("updHarasid").value;
        par.origin = document.getElementById("updOrigin").value;
        par.obs = (document.getElementById("updObs").value.replaceAll("'","/*.*/")).replaceAll("`","/*:*/").replaceAll('"',"/*-*/");
        par.status = (document.getElementById("updStatus").checked) ? 1 : 0;
        //Linaje section
        let fatherid = document.getElementById("updFatherName").getAttribute("horseid")
        if (fatherid != "" && fatherid != undefined && fatherid != null) par.fatherid = fatherid;
        par.fathername = (document.getElementById("updFatherName").value.replaceAll("'","/*.*/")).replaceAll("`","/*:*/");
        par.fathergfname = (document.getElementById("updFathGFName").value.replaceAll("'","/*.*/")).replaceAll("`","/*:*/");
        par.fathergmname = (document.getElementById("updFathGMName").value.replaceAll("'","/*.*/")).replaceAll("`","/*:*/");
        par.fatherobs = document.getElementById("updFatherObs").value;
        par.fathergfobs = document.getElementById("updFathGFObs").value;
        par.fathergmobs = document.getElementById("updFathGMObs").value;

        let motherid = document.getElementById("updMotherName").getAttribute("horseid")
        if (motherid != "" && motherid != undefined && motherid != null) par.motherid = motherid;
        par.mothername = (document.getElementById("updMotherName").value.replaceAll("'","/*.*/")).replaceAll("`","/*:*/");
        par.mothergfname = (document.getElementById("updMothGFName").value.replaceAll("'","/*.*/")).replaceAll("`","/*:*/");
        par.mothergmname = (document.getElementById("updMothGMName").value.replaceAll("'","/*.*/")).replaceAll("`","/*:*/");
        par.motherobs = document.getElementById("updMotherObs").value;
        par.mothergfobs = document.getElementById("updMothGFObs").value;
        par.mothergmobs = document.getElementById("updMothGMObs").value;

        par.sessionid = localStorage.getItem("sessionid");

        //Hacemos las validaciones
        var haserror = false;
        //Cómo son muchos campos simplificamos con un arreglo que contiene los campos a verificar
        basicvalidations.forEach((e) => {
            //Que el nombre no esté vacío
            if (!(par[e.key] !== undefined && par[e.key] !== null && par[e.key] !== "")) {
                errInpt(e.id, e.msg, 6000);
                haserror = true;
            }
        });

        //Validación de que no sea fecha superior a la actual atributo de html y evento change
        let splited = (par.birthdate).split("-");
        let birth = (new Date(splited[0],(parseFloat(splited[1])-1),splited[2])).getTime();
        let now = (new Date()).getTime();
        if (birth > now) {
            haserror = true;
            errInpt("updBirthdate", "Fecha de nacimiento inválida", 6000);
        }

        await validDateRange(par.birthdate).then().catch(() => {
            haserror = true;
            errInpt("updBirthdate", "Fecha de nacimiento inválida", 6000);
        });
        
        //Si tiene errores detenemos la llamada al servicio y enviamos a la pestaña de basico
        if (haserror) {
            //En este caso de doble vista en el popup llevamos a la pestaña de datos que se valida 
            let frmopts = document.querySelectorAll(".popupHMenuOpt");
            if (frmopts.length > 0) frmopts[0].dispatchEvent(new Event("click"));
            return;
        }
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    //Si obtenemos un id insertado/modificado refrescamos la tabla
                    if (data.id != null && data.id != undefined) {
                        //Llevaos el ordenamiento por "id" y cargamos el listado
                        resetOrder(document.querySelector(".pgSctTbl")).then(() => { listAPI(); });
                        //Como definimos función flecha podemos leer los parametros para determinar si era nuevo y mostrar mensaje exitoso correcto
                        successMsgShow((par.id == 0) ? "Ejemplar creado con éxito" : "Ejemplar modificado con éxito");
                        
                        resolve(data.id);
                    }
                    break;
                case 400:
                    data = JSON.parse(rsp.response);
                    errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), data.msg, 6000);
                    
                    resolve();
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});                    
                    reject();
                    break;
                case 403:
                    //Error de privilegios - prohibido
                    errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
                    reject();
                    break;
                case 409:
                    let frmopts = document.querySelectorAll(".popupHMenuOpt");
                    if (frmopts.length > 0) frmopts[0].dispatchEvent(new Event("click"));
                    //errInpt("updName", "", 6000);
                    errInpt("updAbbr", "", 6000);
                    errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "Ya existe este Ejemplar", 6000);
                    reject();
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "horses/horses/update", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para llamar el servicio de eliminar, se ejecuta al confirmar el boton
function deleteAPI(id) {
    var par = {};
    par.id = id;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.id != null && data.id != undefined) {
                    listAPI();
                    //Mostramos mensaje de eliminado con éxito
                    successMsgShow("Ejemplar eliminado con éxito");
                }
                //Cerramos el popup
                closePopups();
                break;
            case 204:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Registro no encontrado", 6000);
                break;
            case 304:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Existen dependencias que no permiten ejecutar esta acción", 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Error de privilegios - prohibido
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "horses/horses/delete", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) })
}
//Función retorna la inforación detallada del usuario
function entryAPI(id) {
    return new Promise((resolve, reject) => {
        var par = {};
        par.id = id;
        par.sessionid = localStorage.getItem("sessionid");
        par.racecourseid = document.getElementById("stHeadqFilt").value;
        par.distanceid = document.getElementById("stDistFilt").value;
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("GET", "horses/horses/entry", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para rellenar el formulario de edición
function setFrm(rsp) {
    return new Promise((resolve, reject) => {
        document.getElementById("updCod").value = rsp.id;
        //Una asignamos el subtitulo que es el nombre (abriviatura) - pelaje - genero
        document.getElementById("popupUpdFrm").querySelector(".popupMsgSct").innerText = rsp.name + " (" + rsp.abbr + ") - " + rsp.fur.name + " - " + rsp.gender.name;
        document.getElementById("updName").value = rsp.name;
        document.getElementById("updAbbr").value = rsp.abbr;
        document.getElementById("updGender").value = rsp.gender.id;
        document.getElementById("updFursid").value = rsp.fur.id;
        document.getElementById("updBirthdate").value = rsp.birthdate.date;
        document.getElementById("updHarasid").value = rsp.haras.id;
        document.getElementById("updOrigin").value = rsp.origin;
        document.getElementById("updLastTrainer").value = rsp.lasttrainer.name;
        document.getElementById("updLastJockey").value = rsp.lastjockey.name;
        document.getElementById("updLastWeight").value = rsp.lastjockeyweight;
        document.getElementById("updLastStud").value = rsp.laststud.name;
        document.getElementById("updObs").value = rsp.obs;
        document.getElementById("updStatus").checked = (rsp.status.id == 1) ? true : false;
        //Datos del linaje
        if (rsp.lineage.father.id > 0) {
            document.getElementById("updFatherName").setAttribute("horseid", rsp.lineage.father.id);
        }
        document.getElementById("updFatherName").value = rsp.lineage.father.name;
        document.getElementById("updFathGFName").value = rsp.lineage.father.lineage.father.name;
        document.getElementById("updFathGMName").value = rsp.lineage.father.lineage.mother.name;
        document.getElementById("updFatherObs").value = rsp.lineage.father.obs;
        document.getElementById("updFathGFObs").value = rsp.lineage.father.lineage.father.obs;
        document.getElementById("updFathGMObs").value = rsp.lineage.father.lineage.mother.obs;

        if (rsp.lineage.mother.id > 0) {
            document.getElementById("updMotherName").setAttribute("horseid", rsp.lineage.mother.id);
        }
        document.getElementById("updMotherName").value = rsp.lineage.mother.name;
        document.getElementById("updMothGFName").value = rsp.lineage.mother.lineage.father.name;
        document.getElementById("updMothGMName").value = rsp.lineage.mother.lineage.mother.name;
        document.getElementById("updMotherObs").value = rsp.lineage.mother.obs;
        document.getElementById("updMothGFObs").value = rsp.lineage.mother.lineage.father.obs;
        document.getElementById("updMothGMObs").value = rsp.lineage.mother.lineage.mother.obs;
        //Se pintan las carreras del historial
        listRacesDraw(rsp.races);
        //Añadimos el sumario
        document.querySelectorAll(".summPlace")[0].querySelector("span").innerText = rsp.races.summaries.positions.first;
        document.querySelectorAll(".summPlace")[1].querySelector("span").innerText = rsp.races.summaries.positions.second;
        document.querySelectorAll(".summPlace")[2].querySelector("span").innerText = rsp.races.summaries.positions.third;
        document.querySelectorAll(".summPlace")[3].querySelector("span").innerText = rsp.races.summaries.positions.fourth;
        document.querySelectorAll(".summPlace")[4].querySelector("span").innerText = rsp.races.summaries.positions.fifth;
        document.querySelectorAll(".summPlace")[5].querySelector("span").innerText = rsp.races.summaries.positions.noappear;
        //Añadimos las cantidades al sumario
        document.querySelectorAll(".summRace")[0].querySelector("span").innerText = rsp.races.summaries.qty.total;
        document.querySelectorAll(".summRace")[1].querySelector("span").innerText = rsp.races.summaries.qty.win;
        document.querySelectorAll(".summRace")[2].querySelector("span").innerText = rsp.races.summaries.qty.nowin;
        document.querySelectorAll(".summRace")[3].querySelector("span").innerText = number_format(rsp.races.summaries.stats.efectiveness,0);
        document.querySelectorAll(".summRace")[4].querySelector("span").innerText = number_format(rsp.races.summaries.stats.performance,2);
        //Añadimos el acumulado en premios
        document.querySelectorAll(".summWinamo")[0].querySelector("span").innerText = rsp.races.summaries.prices.usd.formatted;
        document.querySelectorAll(".summWinamo")[1].querySelector("span").innerText = rsp.races.summaries.prices.bs.formatted;

        
        document.getElementById("stHeadqFilt").setAttribute("itemid", rsp.id);
        document.getElementById("stDistFilt").setAttribute("itemid", rsp.id);



        document.getElementById("popupUpdFrm").querySelector(".saveBtn").setAttribute("upid", rsp.id);
        document.getElementById("creationLbl").innerText = "Creado: " + rsp.created.formatted;
        if (rsp.created.date != rsp.modified.date)
            document.getElementById("updatedLbl").innerText = "Modificado: " + rsp.modified.formatted;
        else
            document.getElementById("updatedLbl").innerText = "";

        if (document.getElementById("popupUpdFrm").offsetHeight > window.innerHeight) {
            document.getElementById("popupUpdFrm").style.alignItems = "flex-start";
        }
        setTimeout(function () { resolve("cargado") }, 100);
    });
}
//Se realizan las validaciones de privilegios de front, se inactivan y muestran los mensajes correspondientes
function privValidations(rsp) {
    return new Promise((resolve, reject) => {
        //ELIMINAR
        let popupdelBtn = document.getElementById("popupDelFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupdelBtn) {
            if (!rsp.delete) {
                popupdelBtn.setAttribute("inactive", "");
            } else {
                popupdelBtn.removeAttribute("inactive");
            }
        }

        //EDITAR
        let popupeditBtn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupeditBtn) {
            if (!rsp.update) {
                popupeditBtn.setAttribute("edit", "inactive");
            } else {
                popupeditBtn.removeAttribute("edit");
            }
        }

        //CREAR
        let popupaddBtn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupaddBtn) {
            if (!rsp.create) {
                popupaddBtn.setAttribute("add", "inactive");
            } else {
                popupaddBtn.removeAttribute("add");
            }
        }
        let tbladdBtn = document.querySelector(".addBtn");
        if (tbladdBtn) {
            if (!rsp.create) {
                tbladdBtn.setAttribute("disabled", "");
            } else {
                tbladdBtn.removeAttribute("disabled");
            }
        }
        resolve();
    });

}
//Se requiere invocar el listado de pelajes
async function listFursAPI() {
    var par = {};
    par.filter = "";
    par.order = 1;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    par.statusid = "";
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                //Filtro de listado
                drawSelect(data.records, document.getElementById("fursFilt"), 'id', 'name', 'Todos los pelajes', '');
                drawSelect(disInactives, document.getElementById("updFursid"), 'id', 'name', 'Seleccione un pelaje', '');


                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Mostramos el error en el filtro y manejamos para mostrarlo en el popup del update
                errInpt("fursFilt", "No tiene privilegios para ver pelajes", 0);
                document.getElementById("updFursid").setAttribute("privileges", -1);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    return callWS("POST", "horses/furs/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Se requiere invocar el listado de pelajes
async function listHarasAPI() {
    var par = {};
    par.filter = "";
    par.order = 1;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    par.statusid = "";
    par.stateid = "";
    par.statusid = "";
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                //Filtro de listado
                drawSelect(data.records, document.getElementById("harasFilt"), 'id', 'name', 'Todos los haras', '');
                //Select del update
                drawSelect(disInactives, document.getElementById("updHarasid"), 'id', 'name', 'Seleccione un haras', '');
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Mostramos el error en el filtro y manejamos para mostrarlo en el popup del update
                errInpt("harasFilt", "No tiene privilegios para ver haras", 0);
                document.getElementById("updHarasid").setAttribute("privileges", -1);

                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    return callWS("POST", "horses/haras/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Se requiere invocar el listado de pelajes
let distanceData = [];
async function listDistancesAPI() {
    var par = {};
    par.filter = "";
    par.order = 1;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                //Seteamos la data porque si está vacío cargamos todas
                distanceData = data.records;
                //Filtro de listado
                drawSelect(data.records, document.getElementById("stDistFilt"), 'id', 'name', 'Todas las distancias', '');
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Mostramos el error en el filtro y manejamos para mostrarlo en el popup del update
                document.getElementById("stDistFilt").setAttribute("privileges", -1);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    return callWS("POST", "hippodromes/distances/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Se requiere invocar el listado de pelajes
let headqData = [];
async function listHeadqAPI() {
    var par = {};
    par.filter = "";
    par.order = 1;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                //Se teamos la data global para calcular las distancias en el change
                headqData = data.records;
                //Filtro de listado
                drawSelect(data.records, document.getElementById("stHeadqFilt"), 'id', 'name', 'Todas las sedes', '');
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Mostramos el error en el filtro y manejamos para mostrarlo en el popup del update
                document.getElementById("stHeadqFilt").setAttribute("privileges", -1);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    return callWS("POST", "hippodromes/racecourses/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
function listHeadqEntryAPI(id) {
    return new Promise((resolve, reject) => {
        var par = {};
        par.id = id;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data)
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Mostramos el error en el filtro y manejamos para mostrarlo en el popup del update
                    document.getElementById("stHeadqFilt").setAttribute("privileges", -1);
                    reject();
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("GET", "hippodromes/racecourses/entry", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Se requiere adicionalmente llamar el mismo listado de horses pero cargando las opciones para el linaje, aplica busqueda y trae siempre todos los registros
function listHorsesAPI(box, srch) {
    var par = {};
    par.filter = (srch.replaceAll("'","/*.*/")).replaceAll("`","/*:*/");
    par.order = 3;
    par.statusid = "";
    par.genderid = "";
    par.furid = "";
    par.harasid = "";
    par.offset = 0;
    par.numofrec = 999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                let bxid = (box.previousElementSibling.getAttribute("id") == "updFatherName") ? 'father' : 'mother';
                var onclick = null;
                if (bxid == 'father') {
                    document.getElementById("updFatherName").removeAttribute("horseid");
                    //Función onclick para las opciones del listado de busqueda de caballos linage
                    onclick = async (opt) => {
                        await entryAPI(opt.getAttribute("value")).then(async (rsp) => {
                            document.getElementById("updFathGFName").value = rsp.entry.lineage.father.name;
                            document.getElementById("updFathGMName").value = rsp.entry.lineage.mother.name;
                        });
                        document.getElementById("updFatherName").value = opt.innerText;
                        document.getElementById("updFatherName").setAttribute("horseid", opt.getAttribute("value"));
                        if (opt.parentElement != null) opt.parentElement.innerHTML = "";
                    }
                } else {
                    document.getElementById("updMotherName").removeAttribute("horseid");
                    //Función onclick para las opciones del listado de busqueda de caballos linage
                    onclick = async (opt) => {
                        await entryAPI(opt.getAttribute("value")).then(async (rsp) => {
                            document.getElementById("updMothGFName").value = rsp.entry.lineage.father.name;
                            document.getElementById("updMothGMName").value = rsp.entry.lineage.mother.name;
                        });
                        document.getElementById("updMotherName").value = opt.innerText;
                        document.getElementById("updMotherName").setAttribute("horseid", opt.getAttribute("value"));
                        if (opt.parentElement != null) opt.parentElement.innerHTML = "";
                    }
                }
                let btn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
                let hideAct = data.records;
                if (btn.getAttribute("upid") != null && btn.getAttribute("upid") != undefined && btn.getAttribute("upid") != 0) {
                    hideAct = (data.records).filter(h => !(h.id == btn.getAttribute("upid")));
                } 
                drawSrchSelect(hideAct, box, 'id', 'name+ (+id+)', undefined, '', onclick);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Si no tiene privilegios se muestra el mensaje de error
                errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "horses/horses/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Función para pintar la respuesta de la lista en la tabla - requiere modelo base en html
function listRacesDraw(rsp) {
    let tbl = document.getElementById("racesTbl").querySelector("tbody");
    let list = rsp.history;
    let ele = tbl.children[0].cloneNode(true);
    if (list.length > 0) {
        tbl.innerHTML = "";
        for (var i = 0; i < list.length; i++) {
            var clone = ele.cloneNode(true);
            clone.style.display = "";

            var data = list[i];

            var celda = clone.children[0];
            celda.innerText = data.hippodrome.name;

            var celda = clone.children[1];
            celda.innerText = data.date.formatted;

            var celda = clone.children[2];
            celda.innerText = data.racenumber;

            var celda = clone.children[3];
            celda.innerText = data.jockey.abbr + " ("+data.jockey.id +")";

            var celda = clone.children[4];
            celda.innerText = data.trainner.abbr + " ("+data.trainner.id +")";

            var celda = clone.children[5];
            celda.innerText = data.weight;

            var celda = clone.children[6];
            celda.innerText = data.distance.name;

            var celda = clone.children[7];
            celda.innerText = data.finishtime;

            var celda = clone.children[8];
            celda.innerText = number_format(Math.round(((data.speedrating).replaceAll(".","")).replace(",",".")),0);

            var celda = clone.children[9];
            celda.innerText = data.position;

            var celda = clone.children[10];
            celda.innerText = data.arrivalposition;

            tbl.appendChild(clone);

        }
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        tbl.innerHTML = "";
        tbl.appendChild(clone);
    }
}


//Llamada inicial
document.addEventListener("DOMContentLoaded", function () {
    horsesInit();
    //Evento para ocultar los select de busqueda
    document.body.addEventListener("click", function (e) {
        setTimeout(function () {
            document.querySelectorAll(".optList").forEach(obj => {
                if (e.target != obj && e.target != obj.previousElementSibling) obj.innerHTML = "";
            })
        }, 300);
    });

});