//Función incial se llama una vez cargado el modulo acá se asignan los eventos iniciales
function harasInit() {
    //Evento mostrar popup de insertar usuario
    document.querySelector(".addBtn").addEventListener("click", function () {
        //Validamos si tiene el privilegio de aadir o no para "inhabilitar el boton"
        let btnsave = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        if (btnsave.getAttribute("add") == "inactive") btnsave.setAttribute("inactive", "");
        else btnsave.removeAttribute("inactive");

        //Blanquemoas la data y el id cuando entramos por añadir
        document.getElementById("popupUpdFrm").querySelector(".saveBtn").removeAttribute("upid");
        blankForm("popupUpdFrm", ["input", "select", ".popupDateLbl", ".errmsgSct"]);
        drawSelect([], document.getElementById("updMunid"), 'id', 'name', 'Seleccione un municipio', '');
        document.getElementById("popupUpdFrm").querySelectorAll("input[readonly]").forEach(e => {
            e.removeAttribute("datanumber");
        });
        editableForm("popupUpdFrm", true, ["input", "select"]);
        //Se asigna el titulo y se muestra el formulario
        document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Crear Haras";
        document.getElementById("popupUpdFrm").querySelector(".popupMsgSct").innerText = "";
        showPopup("popupUpdFrm").then(() => {            
            //Quitamos la opción seleccionada del header y marcamos la nueva
            document.getElementById("popupUpdFrm").querySelectorAll(".popupHMenuOpt")[0].dispatchEvent(new Event("click"));
            //Validamos si no tiene privilegios para ver estados, ver distancias y lo marcamos
            hasPrivileges("updStateid", "No tiene privilegios para visualizar los estados");
            hasPrivileges("updMunid", "No tiene privilegios para visualizar los municipios");
        });
    });

    let refreshlist = () => {
        //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
        let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        if (selpag != null) selpag.removeAttribute("selected");
        listAPI();
    }
    //EVENTO REFRESCAR TABLA EN EL AL HACER BUSQUEDA CON ENTER
    document.getElementById("searchTbl").addEventListener("keyup", function (e) {
        if (this.value != "") this.value = fieldFormat(this.value, "search");

        //Si le da al enter, refrescamos el listadol.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            refreshlist();
        }
    });

    //EVENTO REFRESCAR TABLA EN EL AL HACER FILTRO DE LA TABLA POR STATUS Y GENERO
    document.getElementById("statusTbl").addEventListener("change", refreshlist);
    document.getElementById("stateFilt").addEventListener("change", refreshlist);

    //EVENTOS A CAMPOS DEL FORMULARIO DE USUARIO CREAR / MODIFICAR

    //PESTAÑA DE PREMIOS
    formatAmount(document.getElementById("updIniBs"));
    document.getElementById("updIniBs").addEventListener("change", function (e) {
        let acum = document.getElementById("updAcumBs").getAttribute("datanumber");
        var tot = getNum(this.getAttribute("datanum"));
        if (acum != null && acum != undefined) tot += getNum(acum);
        else document.getElementById("updAcumBs").value = number_format(0, 2);
        document.getElementById("updTotBs").value = number_format(tot, 2);
    });
    //Asignamos eventos de números a los montos
    formatAmount(document.getElementById("updIniUsd"));
    document.getElementById("updIniUsd").addEventListener("change", function (e) {
        let acum = document.getElementById("updAcumUsd").getAttribute("datanumber");
        var tot = getNum(this.getAttribute("datanum"));
        if (acum != null && acum != undefined) tot += getNum(acum);
        else document.getElementById("updAcumUsd").value = number_format(0, 2);
        document.getElementById("updTotUsd").value = number_format(tot, 2);
    });
    //Asignamos eventos de números
    formatAmount(document.getElementById("updCantRc"), 0);
    document.getElementById("updCantRc").addEventListener("keyup", function (e) {
        if (this.value != "") this.value = fieldFormat(this.value, "intnumber");
    });
    document.getElementById("updCantRc").addEventListener("change", function (e) {
        let acum = document.getElementById("updAcumRc").getAttribute("datanumber");
        var tot = getNum(this.getAttribute("datanum"));
        if (acum != null && acum != undefined) tot += parseFloat(acum);
        else document.getElementById("updAcumRc").value = 0;
        document.getElementById("updTotRc").value = number_format(tot, 0);
    });
    //Asignamos eventos de números
    formatAmount(document.getElementById("updCantRcWin"), 0);
    document.getElementById("updCantRcWin").addEventListener("keyup", function (e) {
        if (this.value != "") this.value = fieldFormat(this.value, "intnumber");
    });
    document.getElementById("updCantRcWin").addEventListener("change", function (e) {
        let acum = document.getElementById("updAcumRcWin").getAttribute("datanumber");
        var tot = getNum(this.getAttribute("datanum"));
        if (acum != null && acum != undefined) tot += parseFloat(acum);
        else document.getElementById("updAcumRcWin").value = 0;
        document.getElementById("updTotRcWin").value = number_format(tot, 0);
    });

    //PESTAÑA FORMULARIO BÁSICO
    //Asignamos evento al introducir texto al campo name formulari
    document.getElementById("updName").addEventListener("keyup", function (e) {
        if (this.value != "") {
            errBlank(this.getAttribute("id"));
            this.value = fieldFormat(this.value, 'name');
        }
        //Si le da al enter, focus en email.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            document.getElementById("updAbbr").focus();
        }
    });
    //Asignamos evento al introducir texto al campo abbr formulari
    document.getElementById("updAbbr").addEventListener("keyup", function (e) {
        if (this.value != "") {
            errBlank(this.getAttribute("id"));
            this.value = fieldFormat(limitSize(this.value, 15), 'abbr');
        }
        //Si le da al enter, focus en email.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            document.getElementById("updStateid").focus();
        }
    });
    //Asignamos al enter en el status
    document.getElementById("updStatus").addEventListener("keyup", function (e) {
        //Enter en status y que esté activo el wait, guardamos
        var wait = document.getElementById("waitScreen");
        if (e.key != null && (e.key).toLowerCase() == 'enter' && wait == null) {
            //Si no tiene el atributo inactivo se intenta guardar
            let btn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
            if (btn.getAttribute("inactive") != null && btn.getAttribute("inactive") != undefined) {
                errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
            } else {
                updateAPI((btn.getAttribute("upid") != undefined && btn.getAttribute("upid") != null) ? btn.getAttribute("upid") : 0).then((itemid) => {
                    //Cargamos el entry
                    entryAPI(itemid).then(async (rsp) => {
                        await setFrm(rsp.entry);
                    });
                });
            }
        }
    });
    //Evento al select de estado, si cambia refrescamos los municipios
    document.getElementById("updStateid").addEventListener("change", function (e) {
        if (this.value != "") {
            errBlank("updStateid");
            listMunicipalityAPI(this.value);
        } else {
            drawSelect([], document.getElementById("updMunid"), 'id', 'name', 'Seleccione un municipio', '');
        }
    });

    //-------//

    //EVENTOS DE BOTONES GUARDAR Y CANCELAR
    //Popup "CREAR/EDITAR"
    let updpop = document.getElementById("popupUpdFrm");
    //EVENTOS A LAS PESTAÑAS DEL HEADER EN EL POPUP UPDATE
    updpop.querySelectorAll(".popupHMenuOpt").forEach((opt, idx) => {
        opt.addEventListener("click", function () {
            let left = idx * -100;
            document.getElementById("popupUpdViewCnt").style.left = left + "%";
            //Quitamos la opción seleccionada del header y marcamos la nueva
            document.getElementById("popupUpdFrm").querySelector(".popupHMenuOpt[selected]").removeAttribute("selected");

            let widthBar = this.offsetWidth;
            let leftBar = this.offsetLeft;
            document.getElementById("popupUpdFrm").querySelector(".popupBarHead").style.width = widthBar + "px";
            document.getElementById("popupUpdFrm").querySelector(".popupBarHead").style.left = leftBar + "px";

            this.setAttribute("selected", 1);
        });
    });
    //Evento al guardar el crear/editar el
    updpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            updateAPI((this.getAttribute("upid") != undefined && this.getAttribute("upid") != null) ? this.getAttribute("upid") : 0).then((itemid) => {
                //Cargamos el entry
                entryAPI(itemid).then(async (rsp) => {
                    await setFrm(rsp.entry);
                });
            });
        }
    });

    //Evento al guardar el crear/editar el
    updpop.querySelector(".saveExitBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        let btn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        if (btn.getAttribute("inactive") != null && btn.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {            
            //Acá se intenta el guardar
            updateAPI((btn.getAttribute("upid") != undefined && btn.getAttribute("upid") != null) ? btn.getAttribute("upid") : 0).then(() => {                
                //Cerramos el popup
                closePopups();
            });
        }
    });

    //Evento cancela popup crear/editar
    updpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    //Popup "ELIMINAR usuario"
    let delpop = document.getElementById("popupDelFrm");
    //Evento al guardar el crear/editar el usuario
    delpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            deleteAPI(this.getAttribute("delid"));
        }
    });

    //Evento cancela popup 
    delpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    //INICIALIZAMOS LOS EVENTOS DE ORDENAMIENTO, CON ESTE FORMATO SE PUEDEN PASAR PARAMETROS A LA FUNCIÓN
    initOrders(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    //IINICIALIZAMOS LOS EVENTOS DE LAS FLECHAS DEL PAGINADO SI EXISTE
    initPagsEvent(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    //Cargamos los estados
    listStatesAPI();
    //Lamamos el servicio que carga el listado
    listAPI();
}
//Función para llamar al sevicio de la lista
function listAPI() {
    var par = {};
    par.filter = document.getElementById("searchTbl").value;
    let order = document.querySelector(".pgSctTbl").querySelector(".orderCol[selected]");
    par.order = (order == null || order == undefined) ? -1 : order.getAttribute("colval");
    let actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
    par.statusid = document.getElementById("statusTbl").value;
    par.stateid = document.getElementById("stateFilt").value;
    par.offset = (actpage != null) ? (actpage.innerHTML * 10) - 10 : 0;
    par.numofrec = 10;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Validamos los privilegios
                await privValidations(data.privileges);
                //Si obtenemos y se setean los privilegios correctamente pintamos la tabla
                listDraw(data, data.privileges);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Si no tiene privilegios se muestra el mensaje de error
                errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "horses/haras/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Función para pintar la respuesta de la lista en la tabla - requiere modelo base en html
function listDraw(rsp, privileges) {
    let tbl = document.getElementById("pgTbl").querySelector("tbody");
    let list = rsp.records;
    let ele = tbl.children[0].cloneNode(true);
    if (list.length > 0) {
        tbl.innerHTML = "";
        for (var i = 0; i < list.length; i++) {
            var clone = ele.cloneNode(true);
            clone.style.display = "";

            var data = list[i];
            clone.setAttribute("itemid", data.id);
            clone.addEventListener("click", function () {
                entryAPI(this.getAttribute("itemid")).then(async (rsp) => {
                    //Blanqueamos los errores antes de abrir
                    blankForm("popupUpdFrm", ["input", "select", ".popupDateLbl", ".errmsgSct"]);
                    document.getElementById("popupUpdFrm").querySelectorAll("input[readonly]").forEach(e => {
                        e.removeAttribute("datanumber");
                    });
                    editableForm("popupUpdFrm", false, ["input","select"]);
                    //Si obtenemos una respuesta exitosa del servicio en este caso seteamos el formulario de edición
                    await setFrm(rsp.entry);
                    //Una vez que se cargó la data mostramos el poup
                    document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Haras";
                    showPopup("popupUpdFrm").then(() => {
                        let widthBar = document.getElementById("popupUpdFrm").querySelector(".popupHMenuOpt[selected]").offsetWidth;
                        document.getElementById("popupUpdFrm").querySelector(".popupBarHead").style.width = widthBar + "px";
                        //Validamos si no tiene privilegios para ver estados, ver distancias y lo marcamos
                        hasPrivileges("updStateid", "No tiene privilegios para visualizar los estados");
                        hasPrivileges("updMunid", "No tiene privilegios para visualizar los municipios");
                    });
                });
            });

            var celda = clone.children[0];
            celda.innerText = data.id;

            var celda = clone.children[1];
            celda.innerText = data.name;

            var celda = clone.children[2];
            celda.innerText = data.abbr;

            var celda = clone.children[3];
            celda.innerText = data.state.name + " - " + data.municipality.name;

            var celda = clone.children[4];
            celda.innerText = data.status.name;

            var celda = clone.children[5].firstElementChild;
            celda.parentElement.classList.add("cell10");
            //Atributos para eventos de los botones
            celda.setAttribute("itemid", data.id);
            celda.setAttribute("itemlbl", data.name);

            //Editar Btn
            if (privileges.update) {
                celda.children[0].addEventListener("click", function (e) {
                    e.stopPropagation();
                    //Cargamos el entry
                    entryAPI(this.parentElement.getAttribute("itemid")).then(async (rsp) => {
                        //Validamos los privilegios
                        await privValidations(rsp.privileges);
                        //Validamos antes si tiene el privilegio y desactivamos el boton si no
                        let btnsave = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
                        if (btnsave.getAttribute("edit") == "inactive") btnsave.setAttribute("inactive", "");
                        else btnsave.removeAttribute("inactive");

                        //Blanqueamos los errores antes de abrir
                        blankForm("popupUpdFrm", ["input", "select", ".popupDateLbl", ".errmsgSct"]);
                        editableForm("popupUpdFrm", true, ["input", "select"]);
                        document.getElementById("popupUpdFrm").querySelectorAll("input[readonly]").forEach(e => {
                            e.removeAttribute("datanumber");
                        });

                        //Si obtenemos una respuesta exitosa del servicio en este caso seteamos el formulario de edición
                        await setFrm(rsp.entry);
                        //Una vez que se cargó la data mostramos el poup
                        document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Editar Haras";
                        document.getElementById("popupUpdFrm").querySelectorAll(".popupHMenuOpt")[0].dispatchEvent(new Event("click"));
                        showPopup("popupUpdFrm").then(() => {
                            let widthBar = document.getElementById("popupUpdFrm").querySelector(".popupHMenuOpt[selected]").offsetWidth;
                            document.getElementById("popupUpdFrm").querySelector(".popupBarHead").style.width = widthBar + "px";
                            //Validamos si no tiene privilegios para ver estados, ver distancias y lo marcamos
                            hasPrivileges("updStateid", "No tiene privilegios para visualizar los estados");
                            hasPrivileges("updMunid", "No tiene privilegios para visualizar los municipios");
                        });


                    });
                });
            } else {
                celda.children[0].setAttribute("disabled","");
            }

            //Eliminar Btn
            if (privileges.delete) {
                //Eliminar Btn
                celda.children[1].addEventListener("click", function (e) {
                    e.stopPropagation();
                    //Se muestra el popup de confirmación
                    let usr = this.parentElement.getAttribute("itemlbl");
                    document.querySelector(".poupDelItemLbl").innerText = usr;
                    //Asignamos el id que va a ser eliminado al boton guardar de la confirmación del delete
                    let delpop = document.getElementById("popupDelFrm");
                    delpop.querySelector(".saveBtn").setAttribute("delid", this.parentElement.getAttribute("itemid"));
                    //Mostramos el popup de confirmación
                    showPopup("popupDelFrm");
                });
            } else {
                celda.children[1].setAttribute("disabled","");
            }
            tbl.appendChild(clone);

        }
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        tbl.innerHTML = "";
        tbl.appendChild(clone);
    }
    //SE PINTA EL PAGINADO LUEGO DE PINTAR LA TABLA
    var actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
    actpage = (actpage != null && actpage != undefined) ? (actpage.innerHTML) : 1;
    drawPags(document.querySelector(".pgSctTbl"), rsp.numofrecords, 10, actpage, listAPI);
    
}
//Función para llamar el servicio que inserta o modifica un usuario. 
function updateAPI(id) {
    return new Promise((resolve, reject) => {
        var par = {};
        par.id = id;
        par.name = document.getElementById("updName").value;
        par.abbr = document.getElementById("updAbbr").value;
        par.municipalityid = document.getElementById("updMunid").value;
        par.initialpricesbs = getNum(document.getElementById("updIniBs").getAttribute("datanum"));
        par.initialpricesusd = getNum(document.getElementById("updIniUsd").getAttribute("datanum"));
        par.initialraces = getNum(document.getElementById("updCantRc").getAttribute("datanum"));
        par.initialwinraces = getNum(document.getElementById("updCantRcWin").getAttribute("datanum"));
        par.status = (document.getElementById("updStatus").checked) ? 1 : 0;
        par.sessionid = localStorage.getItem("sessionid");
        console.log(par);
        //Hacemos las validaciones
        var haserror = false;
        //Que el nombre no esté vacío
        if (!(par.name !== undefined && par.name !== null && par.name !== "")) {
            errInpt("updName", "Introduzca un nombre válido", 6000);
            haserror = true;
        }
        //Que el municipio no esté vacío
        if (!(par.municipalityid !== undefined && par.municipalityid !== null && par.municipalityid !== "")) {
            if (document.getElementById("updStateid").value == "") errInpt("updStateid", "Seleccion un estado", 6000);
            errInpt("updMunid", "Seleccione un municipio", 6000);
            haserror = true;
        }
        //Que el municipio no esté vacío
        if (!(par.abbr !== undefined && par.abbr !== null && par.abbr !== "")) {
            errInpt("updAbbr", "Abreviatura Inválida", 6000);
            haserror = true;
        }
        //Si tiene errores detenemos la llamada al servicio
        if (haserror) {
            //En este caso de doble vista en el popup llevamos a la pestaña de datos que se valida 
            let frmopts = document.querySelectorAll(".popupHMenuOpt");
            if (frmopts.length > 0) frmopts[0].dispatchEvent(new Event("click"));
            return;
        }

        //Que el inicial en bs no esté vacío
        if (!(par.initialpricesbs !== undefined && par.initialpricesbs !== null && par.initialpricesbs !== "")) {
            errInpt("updIniBs", "Introduzca un monto válido", 6000);
            haserror = true;
        }
        //Que el inicial en usd no esté vacío
        if (!(par.initialpricesusd !== undefined && par.initialpricesusd !== null && par.initialpricesusd !== "")) {
            errInpt("updIniUsd", "Introduzca un monto válido", 6000);
            haserror = true;
        }
        //Que el inicial en usd no esté vacío
        if (!(par.initialraces !== undefined && par.initialraces !== null && par.initialraces !== "")) {
            errInpt("updCantRc", "Introduzca una cantidad válida", 6000);
            haserror = true;
        }
        //Que el inicial en usd no esté vacío
        if (!(par.initialwinraces !== undefined && par.initialwinraces !== null && par.initialwinraces !== "")) {
            errInpt("updCantRcWin", "Introduzca una cantidad válida", 6000);
            haserror = true;
        }
        //Si tiene errores detenemos la llamada al servicio
        if (haserror) {
            //En este caso de doble vista en el popup llevamos a la pestaña de datos que se valida 
            let frmopts = document.querySelectorAll(".popupHMenuOpt");
            if (frmopts.length > 1) frmopts[1].dispatchEvent(new Event("click"));
            return;
        }


        //Si tiene errores detenemos la llamada al servicio
        if (haserror) return;
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    //Si obtenemos un id insertado/modificado refrescamos la tabla
                    if (data.id != null && data.id != undefined) {
                        //Llevaos el ordenamiento por "id" y cargamos el listado
                        resetOrder(document.querySelector(".pgSctTbl")).then(() => { listAPI(); });
                        //Como definimos función flecha podemos leer los parametros para determinar si era nuevo y mostrar mensaje exitoso correcto
                        successMsgShow((par.id == 0) ? "Haras creado con éxito" : "Haras modificado con éxito");

                        resolve(data.id);
                    }
                    break;
                case 400:
                    data = JSON.parse(rsp.response);
                    errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), data.msg, 6000);
                    reject();
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Error de privilegios - prohibido
                    errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
                    reject();
                    break;
                case 409:
                    let frmopts = document.querySelectorAll(".popupHMenuOpt");
                    if (frmopts.length > 0) frmopts[0].dispatchEvent(new Event("click"));
                    errInpt("updName", "", 6000);
                    errInpt("updAbbr", "", 6000);
                    errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "Ya existe este Haras", 6000);
                    reject();
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "horses/haras/update", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para llamar el servicio de eliminar, se ejecuta al confirmar el boton
function deleteAPI(id) {
    var par = {};
    par.id = id;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.id != null && data.id != undefined) {
                    listAPI();
                    //Mostramos mensaje de eliminado con éxito
                    successMsgShow("Haras eliminado con éxito");
                }
                //Cerramos el popup
                closePopups();
                break;
            case 204:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Registro no encontrado", 6000);
                break;
            case 304:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Existen dependencias que no permiten ejecutar esta acción", 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Error de privilegios - prohibido
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "horses/haras/delete", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) })
}
//Función retorna la inforación detallada del usuario
function entryAPI(id) {
    return new Promise((resolve, reject) => {
        var par = {};
        par.id = id;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    break;
                default:                    
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("GET", "horses/haras/entry", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para rellenar el formulario de edición
function setFrm(rsp) {
    return new Promise((resolve, reject) => {
        document.getElementById("updCod").value = rsp.id;
        document.getElementById("updName").value = rsp.name;
        document.getElementById("updAbbr").value = rsp.abbr;
        document.getElementById("updStateid").value = rsp.state.id;
        listMunicipalityAPI(rsp.state.id, rsp.municipality.id);
        document.getElementById("updIniBs").value = rsp.initialpricesbs.formatted;
        if (rsp.initialpricesbs.number > 0) document.getElementById("updIniBs").setAttribute("datanum", rsp.initialpricesbs.number);
        document.getElementById("updAcumBs").value = rsp.acumulatedpricesbs.formatted;
        document.getElementById("updAcumBs").setAttribute("datanumber", rsp.acumulatedpricesbs.number);
        document.getElementById("updTotBs").value = number_format((rsp.initialpricesbs.number + rsp.acumulatedpricesbs.number), 2);
        document.getElementById("updIniUsd").value = rsp.initialpricesusd.formatted;
        if (rsp.initialpricesusd.number > 0) document.getElementById("updIniUsd").setAttribute("datanum", rsp.initialpricesusd.number);
        document.getElementById("updAcumUsd").value = rsp.acumulatedpricesusd.formatted;
        document.getElementById("updAcumUsd").setAttribute("datanumber", rsp.acumulatedpricesusd.number);
        document.getElementById("updTotUsd").value = number_format((rsp.initialpricesusd.number + rsp.acumulatedpricesusd.number), 2);
        document.getElementById("updCantRc").value = number_format(rsp.initialraces.number,0);    
        if (rsp.initialraces.number > 0) document.getElementById("updCantRc").setAttribute("datanum", rsp.initialraces.number);
        document.getElementById("updAcumRc").value = rsp.acumulatedraces.formatted;
        document.getElementById("updAcumRc").setAttribute("datanumber", rsp.acumulatedraces.number);
        document.getElementById("updTotRc").value = number_format((rsp.initialraces.number + rsp.acumulatedraces.number), 0);        
        document.getElementById("updCantRcWin").value = number_format(rsp.initialwinraces.number,0);    
        if (rsp.initialwinraces.number > 0) document.getElementById("updCantRcWin").setAttribute("datanum", rsp.initialwinraces.number);
        document.getElementById("updAcumRcWin").value = rsp.acumulatedwinraces.formatted;
        document.getElementById("updAcumRcWin").setAttribute("datanumber", rsp.acumulatedwinraces.number);
        document.getElementById("updTotRcWin").value = number_format((rsp.initialwinraces.number + rsp.acumulatedwinraces.number), 0);

        document.getElementById("popupUpdFrm").querySelector(".saveBtn").setAttribute("upid", rsp.id);
        document.getElementById("updStatus").checked = (rsp.status.id == 1) ? true : false;
        document.getElementById("popupUpdFrm").querySelector(".popupMsgSct").innerText = rsp.name + " (" + rsp.abbr + ")";
        document.getElementById("creationLbl").innerText = "Creado: " + rsp.created.formatted;
        if (rsp.created.date != rsp.modified.date)
            document.getElementById("updatedLbl").innerText = "Modificado: " + rsp.modified.formatted;
        else
            document.getElementById("updatedLbl").innerText = "";
        setTimeout(function () { resolve("cargado") }, 100);
    });
}
//Se realizan las validaciones de privilegios de front, se inactivan y muestran los mensajes correspondientes
function privValidations(rsp) {
    return new Promise((resolve, reject) => {
        //ELIMINAR
        let popupdelBtn = document.getElementById("popupDelFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupdelBtn) {
            if (!rsp.delete) {
                popupdelBtn.setAttribute("inactive", "");
            } else {
                popupdelBtn.removeAttribute("inactive");
            }
        }

        //EDITAR
        let popupeditBtn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupeditBtn) {
            if (!rsp.update) {
                popupeditBtn.setAttribute("edit", "inactive");
            } else {
                popupeditBtn.removeAttribute("edit");
            }
        }

        //CREAR
        let popupaddBtn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupaddBtn) {
            if (!rsp.create) {
                popupaddBtn.setAttribute("add", "inactive");
            } else {
                popupaddBtn.removeAttribute("add");
            }
        }
        let tbladdBtn = document.querySelector(".addBtn");
        if (tbladdBtn) {
            if (!rsp.create) {
                tbladdBtn.setAttribute("disabled", "");
            } else {
                tbladdBtn.removeAttribute("disabled");
            }
        }
        resolve();
    });

}
//Se requiere invocar el listado de "estados" para el select del filtro y el insertar nuevo
function listStatesAPI() {
    var par = {};
    par.filter = "";
    par.order = 2;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                drawSelect(disInactives, document.getElementById("updStateid"), 'id', 'name', 'Seleccione un estado', '');
                drawSelect(data.records, document.getElementById("stateFilt"), 'id', 'name', 'Todos los estados', '');


                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Mostramos el error en el filtro y manejamos para mostrarlo en el popup del update
                errInpt("stateFilt", "No tiene privilegios para ver estados", 0);
                document.getElementById("updStateid").setAttribute("privileges", -1);

                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "addresses/states/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Se requiere invocar el listado de "estados" para el select del filtro y el insertar nuevo
function listMunicipalityAPI(stateid, selected = "") {
    var par = {};
    par.stateid = stateid;
    par.filter = "";
    par.order = 1;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Asignamos el atributo disabled a los que traigan el status cómo inactivo para que el "drawSelect" deshabilite las opciones que corresponden
                let disInactives = (data.records).map((r) => {
                    if (r.status.id == 0) r.disabled = true;
                    return r;
                });
                drawSelect(disInactives, document.getElementById("updMunid"), 'id', 'name', 'Seleccione un municipio', selected);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Si no tiene privilegios se muestra el mensaje de error
                errInpt("updMunid", "No tiene privilegios para visualizar los municipios", 0);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "addresses/municipalities/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Llamada inicial
document.addEventListener("DOMContentLoaded", function () {
    harasInit();
});