<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../settings/dbconn.php");
    include("../../settings/utils.php");
    
    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));
    
    // parametros obligatorios
    $parmsob = array("id", "sessionid", "name", "usr", "status", "doblecheck");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $name = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["name"]);
    $usr = preg_replace("/[^a-zA-Z0-9@.]+/", "", $_REQUEST["usr"]);
    $status = intval($_REQUEST["status"]);
    $doblecheck = intval($_REQUEST["doblecheck"]);
    
    // parametros opcionales
    $pwd = "";
    if (isset($_REQUEST["pwd"])){
        $pwd = preg_replace("/[^a-zA-Z0-9_$\-\#.]+/", "", $_REQUEST["pwd"]);
    }
    // parametros opcionales
    $magazineids = "";
    if (isset($_REQUEST["magazineids"])){
        $magazineids = str_replace("-", ",", preg_replace("/[^0-9\-]+/", "", $_REQUEST["magazineids"]));
    }

    if($status!=0 && $status!=1)
        badEnd("400", array("msg"=>"El parámetro status puede ser 0 o 1"));

    isSessionValid($db, $sessionid);
    
    if ($id==0){    // incluir registro
        if (!tienePrivilegio($db, $sessionid, 102, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
        
        if ($pwd == "")
            $sql =  "INSERT INTO users " .
                    "       (usr, name, status, doblecheck, magazineids) " .
                    "VALUES (" .
                    "        '" . $usr . "'," .
                    "        '" . $name . "'," .
                    "        '" . $status . "', " .
                    "        '" . $doblecheck . "', " .
                    "        '" . $magazineids . "' " .
                    "        )";
        else
            $sql =  "INSERT INTO users " .
                    "       (usr, name, pwd, status, doblecheck, magazineids) " .
                    "VALUES (" .
                    "        '" . $usr . "'," .
                    "        '" . $name . "'," .
                    "        '" . $pwd . "'," .
                    "        '" . $status . "', " .
                    "        '" . $doblecheck . "', " .
                    "        '" . $magazineids . "' " .
                    "        )";
        if (!$db->query($sql)){
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("msg"=>$db->error));
            }
        }

        $id = $db->insert_id;
        
        setAudit($db, "Usuarios", $sessionid, "Se incluyó el usuario \'" . $usr . "\' (" . $id . ")");
    }else{          // modificar registro
        if (!tienePrivilegio($db, $sessionid, 101, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        if ($pwd == "")
            $sql =  "UPDATE users " .
                    "SET    usr = '" . $usr . "'," .
                    "       name = '" . $name . "'," .
                    "       status = '" . $status . "', " .
                    "       doblecheck = '" . $doblecheck . "', " .
                    "       magazineids = '" . $magazineids . "' " .
                    "WHERE  id=" . $id;
        else
            $sql =  "UPDATE users " .
                    "SET    usr = '" . $usr . "'," .
                    "       name = '" . $name . "'," .
                    "       pwd = '" . $pwd . "'," .
                    "       status = '" . $status . "', " .
                    "       doblecheck = '" . $doblecheck . "', " .
                    "       magazineids = '" . $magazineids . "' " .
                    "WHERE  id=" . $id;
        if (!$db->query($sql))
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
            }
            
        setAudit($db, "Usuarios", $sessionid, "Se actualizó el usuario \'" . $usr . "\' (" . $id . ")");

    }

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();

?>