<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../settings/dbconn.php");
    include("../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));
    
    // parametros obligatorios
    $parmsob = array("offset","numofrec","order","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
        
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    //$filpar = preg_replace("/[^a-zA-Z0-9 áéíóúÚñÁÉÍÓÚÑÜ@.]+/", "", $_REQUEST["filter"]);
    $offset = intval($_REQUEST["offset"]);
    $numofrec = intval($_REQUEST["numofrec"]);
    $orderpar = intval($_REQUEST["order"]);

    // parametros opcionales
    $filpar = "";
    if (isset($_REQUEST["filter"])){
        $filpar = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["filter"]);
    }
    $statusid = 0;
    if (isset($_REQUEST["statusid"])){
        $statusid = intval($_REQUEST["statusid"]);
    }

    // validar el order
    $order = "";
    switch (abs($orderpar)){
        case 1:
            $order = "U.createdat";
            break;
        case 2:
            $order = "U.name";
            break;
        case 3:
            $order = "U.usr";
            break;
        case 4:
            $order = "U.status";
            break;
    }

    if (strlen($order) > 0){
        if ($orderpar < 0)
            $order = str_replace(",", " DESC,", $order) . " DESC ";
        $order = " ORDER BY " . $order;
    }

    $filter = "";
    if (strlen($filpar)){
        $filter .= "(";
        $filter .= "U.usr LIKE '%" . $filpar . "%' OR ";
        $filter .= "U.name LIKE '%" . $filpar . "%' OR ";
        $filter .= "IF(U.status=1,'Activo','Inactivo') LIKE '" . $filpar . "%' ";
        $filter .= ")";        
    }
    // filtro de status
    if ($statusid != 0){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " U.status = " . ($statusid == 1 ? "1" : "0");
    }
    if (strlen($filter) > 0){
        $filter = " WHERE " . $filter;
    }
    
    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 100, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    $sql =  "SELECT     U.id, U.usr, U.name, U.doblecheck, " .
            "           U.status,   CASE U.status  " .
            "                       WHEN 1 THEN 'Activo' " .
            "                       ELSE 'Inactivo' " .
            "                       END statusdsc " .
            "FROM       users U " .
            $filter .
            $order;

    // calcular numero de registros
    if (!$rs = $db->query("SELECT COUNT(*) cnt FROM (" . $sql . ") A "))
        badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
    $row = $rs->fetch_assoc();
    $out = new stdClass;
    $out->sql = $sql;
    $out->numofrec = (integer) $row["cnt"];
    
    // limitar número de
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $offset . "," . $numofrec;
    if (!$rs = $db->query($sql))
        badEnd("500", array(errlog=>2, "msg"=>$db->error));
    
    $records = array();
    while ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id = (integer) $row["id"];
        $record->name = nvl($row["name"],"");
        $record->doblecheck = nvl($row["doblecheck"],"0")<>"0";
        $record->email = nvl($row["usr"],"");
        $record->status = new stdClass;
        $record->status->id = (integer) $row["status"];
        $record->status->dsc = nvl($row["statusdsc"],"");
        
        $records[] = $record;
    }
    $out->records = $records;
    
    $access = array();
    $access["create"] = tienePrivilegio($db, $sessionid, 102);
    $access["delete"] = tienePrivilegio($db, $sessionid, 103);
    $access["update"] = tienePrivilegio($db, $sessionid, 101);
    $access["read"] =   tienePrivilegio($db, $sessionid, 100);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();

?>