<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../settings/dbconn.php");
    include("../../settings/utils.php");
    
    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));
    
    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios id,sessionid"));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    
    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 100, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    $sql =      "SELECT     U.id, U.usr, U.name, U.doblecheck, " .
                "           U.status,   CASE U.status  " .
                "                       WHEN 1 THEN 'Activo' " .
                "                       ELSE 'Inactivo' " .
                "                       END statusdsc, " .
                "           IF(LENGTH(IFNULL(U.magazineids,''))=0, '0', U.magazineids) magazineids, " .
                "           U.createdat created, DATE_FORMAT(U.createdat, '%d/%m/%Y %h:%i %p') createdfmt, " .
                "           IF(U.modifiedat > IFNULL(UP.modifiedat, '2000-01-01'), U.modifiedat, UP.modifiedat) modified, " .
                "           DATE_FORMAT(IF(U.modifiedat > IFNULL(UP.modifiedat, '2000-01-01'), U.modifiedat, UP.modifiedat), '%d/%m/%Y %h:%i %p') modifiedfmt " .
                "FROM       users U " .
                "LEFT JOIN  (SELECT userid, MAX(modifiedat) modifiedat FROM userprivileges GROUP BY userid) UP " .
                "ON         U.id=UP.userid " .
                "WHERE      U.id=" . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $out = new stdClass;
    if ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id = (integer) $row["id"];
        $record->name = nvl($row["name"],"");
        $record->doblecheck = nvl($row["doblecheck"],"0")<>"0";
        $record->email = nvl($row["usr"],"");
        $record->status = new stdClass;
        $record->status->id = (integer) $row["status"];
        $record->status->dsc = nvl($row["statusdsc"],"");
        $record->created = new stdClass;
        $record->created->date = $row["created"];
        $record->created->formatted = $row["createdfmt"];
        $record->modified = new stdClass;
        $record->modified->date = $row["modified"];
        $record->modified->formatted = $row["modifiedfmt"];

        // calcular revistas
        $magazines = array();
        $sql2 = "SELECT id, dsc, status FROM magazines WHERE id IN (" . $row["magazineids"] . ")";
        if (!$rs2 = $db->query($sql2))
            badEnd("500", array("msg"=>$db->error));
        while ($row2 = $rs2->fetch_assoc()){
            $magazine = new stdClass;
            $magazine->id = (integer) $row2["id"];
            $magazine->name = $row2["dsc"];
            $magazine->active = (boolean) $row2["status"]=="1";
            $magazines[] = $magazine;
        }
        $record->magazines = $magazines;
        
        $out->entry = $record;
    }else{
        badEnd("402", array("msg"=>"No encontrado"));
    }
    
    $access = array();
    $access["create"] = tienePrivilegio($db, $sessionid, 102);
    $access["delete"] = tienePrivilegio($db, $sessionid, 103);
    $access["update"] = tienePrivilegio($db, $sessionid, 101);
    $access["read"] =   tienePrivilegio($db, $sessionid, 100);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();

?>
