<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../settings/dbconn.php");
    include("../../settings/utils.php");
    require_once ('../../hooks/PHPMailer-6.9.1/src/PHPMailer.php');
    require_once ('../../hooks/PHPMailer-6.9.1/src/SMTP.php');
    require_once ('../../hooks/PHPMailer-6.9.1/src/Exception.php');
    
    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

        // parametros obligatorios
    $parmsob = array("usr","pwd");
    if (!parametrosValidos($_REQUEST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    $usr = strtoupper(preg_replace("/[^a-zA-Z0-9@.]+/", "", $_REQUEST["usr"]));
    $pwd = preg_replace("/[^a-zA-Z0-9_$\-\#.]+/", "", $_REQUEST["pwd"]);
    
    $sessid = randomString(32);
    
    // destruir cualquier sesion anterior existente
    $sql =  "UPDATE users " .
            "SET    sessionid = '" . $sessid . "',".
            "       validthru = DATE_ADD(NOW(), INTERVAL 1 DAY), ".
            "       lastsession = NOW(),".
            "       fails=0 " .
            "WHERE  UPPER(usr)='".$usr."' ".
            "AND    pwd='".$pwd."' " .
            "AND    status<>0";
    if (!$db->query($sql)){
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    
    if ($db->affected_rows == 0){
        // se incrementa los reintentos y se desactiva la cuenta en caso de llegar al maxfails
        $sql =  "UPDATE users " .
                "       SET fails = " .
                "             CASE WHEN fails < maxfails THEN " .
                "               fails + 1 " .
                "             ELSE " .
                "               fails " .
                "             END, " .
                "           status = " .
                "             CASE WHEN fails >= maxfails THEN " .
                "               0 " .
                "             ELSE " .
                "               status " .
                "             END " .
                "WHERE  UPPER(usr)=UPPER('" . $usr . "') " .
                "AND    fails < maxfails";
        if (!$db->query($sql)){
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        }

        setAudit($db, "Seguridad", "", "Intento fallido de ingreso con usuario " . $usr);
        
        badEnd("401", array("msg"=>"Usuario/Clave Inválidos"));
    }
    
    $sql =  "SELECT  id, usr, name, sessionid, DATE_FORMAT(validthru, '%Y%m%d%H%i%s') vt, name, doblecheck ".
            "FROM    users ".
            "WHERE   UPPER(usr)='".$usr."' ".
            "AND     pwd='".$pwd."'";
    
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    
    $row = $rs->fetch_assoc();
    if ($doblecheck = (boolean) $row["doblecheck"]<>"0"){
        // calcular pin
        $pin = randomString(5);
        $sql = "UPDATE users SET dblchkpin='" . md5($pin) . "' WHERE id=" . $row["id"];
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        // enviar correo
        $email = $row["usr"];
        $username = $row["name"];
        $subject = "Clave de confirmación";
        $body = 
            "<html>" .
            "<head>" .
            "<title></title>" .
            "</head>" .
            "<body style='font-family:sans-serif'>" .
            "<div style='padding:20px;width:100%;background-color:gray'>" .
            "<div style='padding:10px;background-color:white;max-width:600px;width:95%;margin-left:auto;margin-right:auto;border-radius:4px'>" .
            "<div style='display:table;border-spacing:30px;width:95%;margin-left:auto;margin-right:auto'>" .
            "<div style='display:table-row'>" .
            "<div style='display:table-cell;text-align:center'><img style='max-width:50%' src='".$homeurl."/img/logo.png' /></div>" .
            "</div>" .
            "<div style='display:table-row'>" .
            "<div style='text-align:center;display:table-cell;font-size:200%;font-weight:bold'>" .
            "<br/>Clave de confirmación<br/>&nbsp;" .
            "</div>" .
            "</div>" .
            "<div style='display:table-row'>" .
            "<div style='display:table-cell;font-size:120%;text-align:center'>Hola <b>".$username."</b>, indica el código de abajo en el portal de ingreso para poder acceder al sistema</div>" .
            "</div>" .
            "<div style='display:table-row'>" .
            "<div style='display:table-cell'>" .
            "<div style='font-size:120%;font-weight:bold;margin-left:auto;margin-right:auto;border-radius:12px;cursor: pointer;margin-top: 50px;margin-bottom: 50px;color: white;line-height: 50px;text-align:center;background-color: #0092D5;height: 50px;width: 320px;border: none;transition: all ease 300ms;'>" . $pin . "</div>" .
            "</div>" .
            "</div>" .
            "<div style='display:table-row'>" .
            "<div style='display:table-cell'>Gracias de antemano<br />" .
            "Gaceta Hípica</div>" .
            "</div>" .
            "</div>" .
            "</div>" .
            "</div>" .
            "</body>" .
            "</html>";

        
        $altbody = "Hola ".$username.", para acceder al sistema coloca la clave indicada a continuación:\n\n".
                $pin."\n\n".
                "Gracias de antemano\n" .
                "Gaceta Hípica";
        enviarCorreo("no-responder@correo.com", $email, $subject, $body, $altbody);
    }

    $out = new stdClass;
    $out->id = (integer) $row["id"];
    if (!$doblecheck)
        $out->sessionid = $row["sessionid"];
    else
        $out->sessionid = "";
    $out->doblecheck = $doblecheck;
    $out->validthru = $row["vt"];
    $out->name = $row["name"];
    
    setAudit($db, "Seguridad", $sessid, "Ingreso al sistema");

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>