<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);

    // parametros opcionales
    $filtro = "";
    if (isset($_REQUEST["filter"])){
        $filtro = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["filter"]);
    }

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 110, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    // busqueda
    $filter = "";
    if (strlen($filtro) > 0){
        $filter .= "(";
        $filter .= "    module like '%" . $filtro . "%' ";
        $filter .= ")";
    }
    if (strlen($filter) > 0){
        $filter = " WHERE " . $filter;
    }

    $sql =  "SELECT     module " .
            "FROM       audit " .
            $filter .
            "GROUP BY   module " .
            "ORDER BY   module ";

    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>2, "msg"=>$db->error));

    $out = new stdClass;

    $out->records = array();
    while ($row = $rs->fetch_assoc()){
        $records = new stdClass;
        $records->name = $row["module"];

        $out->records[] = $records;
    }

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>