<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("id", "racecourseid", "sessionid", "horseid", "distanceid", "date", "time", "finishtime", "obs");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $racecourseid = intval($_REQUEST["racecourseid"]);
    $horseid = intval($_REQUEST["horseid"]);
    $distanceid = intval($_REQUEST["distanceid"]);
    $date = preg_replace("/[^0-9\-]+/", "", $_REQUEST["date"]);
    $time = str_replace("|", "** ", preg_replace("/[^0-9|]+/", "", $_REQUEST["time"])) . "";
    $finishtime = str_replace("|", "** ", preg_replace("/[^0-9|]+/", "", $_REQUEST["finishtime"])) . "";
    $obs = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["obs"]);

    isSessionValid($db, $sessionid);

    // corregir decodificar apóstrofes y comillas en el nombre
    $obs = str_replace("/*.*/", "\'", $obs);
    $obs = str_replace("/*:*/", "\`", $obs);



    if ($id==0){    // incluir registro
        if (!tienePrivilegio($db, $sessionid, 632, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "INSERT INTO traqueos " .
                "       (horseid, racecourseid, distanceid, date, time, finishtime, obs) " .
                "VALUES (" .
                "        '" . $horseid . "'," .
                "        '" . $racecourseid . "'," .
                "        '" . $distanceid . "'," .
                "        '" . $date . "'," .
                "        REPLACE(REPLACE('" . $time . "', '**', '\"'), '*', '\''), " .
                "        REPLACE(REPLACE('" . $finishtime . "', '**', '\"'), '*', '\''), " .
                "        '" . $obs . "' " .
                "        )";
        if (!$db->query($sql)){
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("msg"=>$db->error));
            }
        }

        $id = $db->insert_id;
        
        setAudit($db, "Traqueos", $sessionid, "Se incluyó el Traqueo del caballo \'" . $horseid . "\' (" . $id . ")");
    }else{          // modificar registro
        if (!tienePrivilegio($db, $sessionid, 631, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "UPDATE traqueos " .
                "SET    horseid = '" . $horseid . "'," .
                "       racecourseid = '" . $racecourseid . "', " .
                "       distanceid = '" . $distanceid . "', " .
                "       date = '" . $date . "', " .
                "       time = REPLACE(REPLACE('" . $time . "', '**', '\"'), '*', '\''), " .
                "       finishtime = REPLACE(REPLACE('" . $finishtime . "', '**', '\"'), '*', '\''), " .
                "       obs = '" . $obs . "' " .
                "WHERE  id=" . $id;
        if (!$db->query($sql))
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
            }
            
        setAudit($db, "Traqueos", $sessionid, "Se actualizó el Traqueo del caballo \'" . $horseid . "\' (" . $id . ")");

    }

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>