<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("order", "offset", "numofrec", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $orderpar = intval($_REQUEST["order"]);
    $offset = intval($_REQUEST["offset"]);
    $numofrec = intval($_REQUEST["numofrec"]);

    // parametros opcionales
    $filtro = "";
    if (isset($_REQUEST["filter"])){
        $filtro = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["filter"]);
    }
    $datefrom = "";
    if (isset($_REQUEST["datefrom"])){
        $datefrom = preg_replace("/[^0-9\-]+/", "", $_REQUEST["datefrom"]);
    }
    $dateto = "";
    if (isset($_REQUEST["dateto"])){
        $dateto = preg_replace("/[^0-9\-]+/", "", $_REQUEST["dateto"]);
    }

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 630, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    // busqueda
    $filter = "";
    if (strlen($filtro) > 0){
        $filter .= "(";
        $filter .= "    H.dsc like '%" . $filtro . "%' ";
        $filter .= "OR  D.dsc like '%" . $filtro . "%' ";
        $filter .= "OR  T.obs like '%" . $filtro . "%' ";
        $filter .= "OR  T.time like '%" . $filtro . "%' ";
        $filter .= "OR  T.finishtime like '%" . $filtro . "%' ";
        $filter .= ")";
    }

    // filtro de fecha desde
    if ($datefrom != ""){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " T.date >= '" . $datefrom . "'";
    }
    // filtro de fecha hasta
    if ($dateto != ""){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " T.date <= '" . $dateto . "'";
    }

    if (strlen($filter) > 0){
        $filter = " WHERE " . $filter;
    }

    // orden
    $order = "";
    switch (abs($orderpar)){
        case 1:
            $order = " T.createdat ";
            break;
        case 2:
            $order = " T.modifiedat ";
            break;
        case 4:
            $order = " H.dsc ";
            break;
        case 5:
            $order = " D.dsc ";
            break;
        case 6:
            $order = " T.obs ";
            break;
        case 7:
            $order = " T.time ";
            break;
        case 8:
            $order = " T.finishtime ";
            break;
        case 9:
            $order = " T.date ";
            break;
    }
    if (strlen($order) > 0){
        if ($orderpar < 0)
            $order = str_replace(",", " DESC,", $order) . " DESC ";
        $order = " ORDER BY " . $order;
    }

    $sql =  "SELECT     T.id, H.id horseid, H.dsc horsename, D.id distanceid, D.dsc distancename, " .
            "           T.date, T.obs, R.id racecourseid, R.dsc racecoursename, " .  
            "           DATE_FORMAT(T.date, '%d/%m/%Y') datefmt, " .  
            "           T.time, T.finishtime, T.createdat, T.modifiedat " .
            "FROM       traqueos T " .
            "INNER JOIN racecourses R " . 
            "ON         T.racecourseid=R.id " .
            "INNER JOIN horses H " .
            "ON         T.horseid=H.id " .
            "INNER JOIN distances D " . 
            "ON         T.distanceid=D.id " .
            $filter .
            $order;
    // calcular numero de registros
    if (!$rs = $db->query("SELECT COUNT(*) cnt FROM (" . $sql . ") A "))
        badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
    $row = $rs->fetch_assoc();
    $out = new stdClass;
    $out->numofrecords = (integer) $row["cnt"];

    // limitar número de
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $offset . "," . $numofrec;
    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>2, "msg"=>$db->error));

    $out->records = array();
    while ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id = (integer) $row["id"];
        $record->horse = new stdClass;
        $record->horse->id = (integer) $row["horseid"];
        $record->horse->name = $row["horsename"];
        $record->racecourse = new stdClass;
        $record->racecourse->id = (integer) $row["racecourseid"];
        $record->racecourse->name = $row["racecoursename"];
        $record->distance = new stdClass;
        $record->distance->id = (integer) $row["distanceid"];
        $record->distance->name = $row["distancename"];
        $record->date = new stdClass;
        $record->date->date = $row["date"];
        $record->date->formatted = $row["datefmt"];
        $record->time = $row["time"];
        $record->finishtime = $row["finishtime"];
        $record->obs = $row["obs"];

        $out->records[] = $record;
    }

    $access = array();
    $access["read"] = tienePrivilegio($db, $sessionid, 630);
    $access["update"] = tienePrivilegio($db, $sessionid, 631);
    $access["create"] = tienePrivilegio($db, $sessionid, 632);
    $access["delete"] =   tienePrivilegio($db, $sessionid, 633);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>