<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));

    // parametros obligatorios
    $parmsob = array("id", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 630, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    $sql =  "SELECT     T.id, H.id horseid, H.dsc horsename, D.id distanceid, D.dsc distancename, " .
            "           T.date, T.obs, R.id racecourseid, R.dsc racecoursename, " .  
            "           DATE_FORMAT(T.date, '%d/%m/%Y') datefmt, " .  
            "           T.time, T.finishtime, " .
            "           T.createdat created, DATE_FORMAT(T.createdat, '%d/%m/%Y %h:%i %p') createdfmt, " .
            "           T.modifiedat modified, DATE_FORMAT(T.modifiedat, '%d/%m/%Y %h:%i %p') modifiedfmt " .
            "FROM       traqueos T " .
            "INNER JOIN racecourses R " . 
            "ON         T.racecourseid=R.id " .
            "INNER JOIN horses H " .
            "ON         T.horseid=H.id " .
            "INNER JOIN distances D " . 
            "ON         T.distanceid=D.id " .
            "WHERE      T.id = " . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    if ($row = $rs->fetch_assoc()){
        $entry = new stdClass;
        $entry->id = (integer) $row["id"];
        $entry->horse = new stdClass;
        $entry->horse->id = (integer) $row["horseid"];
        $entry->horse->name = $row["horsename"];
        $entry->racecourse = new stdClass;
        $entry->racecourse->id = (integer) $row["racecourseid"];
        $entry->racecourse->name = $row["racecoursename"];
        $entry->distance = new stdClass;
        $entry->distance->id = (integer) $row["distanceid"];
        $entry->distance->name = $row["distancename"];
        $entry->date = new stdClass;
        $entry->date->date = $row["date"];
        $entry->date->formatted = $row["datefmt"];
        $entry->time = $row["time"];
        $entry->finishtime = $row["finishtime"];
        $entry->obs = $row["obs"];
        $entry->created = new stdClass;
        $entry->created->date = $row["created"];
        $entry->created->formatted = $row["createdfmt"];
        $entry->modified = new stdClass;
        $entry->modified->date = $row["modified"];
        $entry->modified->formatted = $row["modifiedfmt"];
    }else{
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }

    $out = new stdClass;
    $out->entry = $entry;

    $access = array();
    $access["read"] = tienePrivilegio($db, $sessionid, 630);
    $access["update"] = tienePrivilegio($db, $sessionid, 631);
    $access["create"] = tienePrivilegio($db, $sessionid, 632);
    $access["delete"] =   tienePrivilegio($db, $sessionid, 633);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>