<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("order", "offset", "numofrec", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $orderpar = intval($_REQUEST["order"]);
    $offset = intval($_REQUEST["offset"]);
    $numofrec = intval($_REQUEST["numofrec"]);

    // parametros opcionales
    $filtro = "";
    if (isset($_REQUEST["filter"])){
        $filtro = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["filter"]);
    }
    $racecourseid = 0;
    if (isset($_REQUEST["racecourseid"])){
        $racecourseid = intval($_REQUEST["racecourseid"]);
    }
    $statusid = 0;
    if (isset($_REQUEST["statusid"])){
        $statusid = intval($_REQUEST["statusid"]);
    }
    $forecaststatusid = 0;
    if (isset($_REQUEST["forecaststatusid"])){
        $forecaststatusid = intval($_REQUEST["forecaststatusid"]);
    }
    $datefrom = "";
    if (isset($_REQUEST["datefrom"])){
        $datefrom = preg_replace("/[^0-9\-]+/", "", $_REQUEST["datefrom"]);
    }
    $dateto = "";
    if (isset($_REQUEST["dateto"])){
        $dateto = preg_replace("/[^0-9\-]+/", "", $_REQUEST["dateto"]);
    }

    $userid = isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 610, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    // cargar acceso a revistas
    $magazineids = "";
    $sql = "select magazineids FROM users WHERE id=" . $userid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if ($row = $rs->fetch_assoc())
        $magazineids = nvl($row["magazineids"], '');

    if ($magazineids == "") $magazineids = "0";

    // busqueda
    $filter = "";
    if (strlen($filtro) > 0){
        $filter .= "(";
        $filter .= "    number like '%" . $filtro . "%' ";
        $filter .= " OR C.dsc like '%" . $filtro . "%' ";
        $filter .= ")";
    }
    // filtro de status
    /*
    if ($statusid != 0){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        switch ($statusid){
            case 1: // solo abiertas
                $filter .= " IFNULL(RA.stcnt,0)=0 ";
                break;
            case 2: // solo procesadas
                $filter .= " IFNULL(RA.stcnt,0)>0 AND IFNULL(RA.stcnt,0)<IFNULL(RA.racescnt,0)*2 ";
                break;
            case 3: // solo cerradas
                $filter .= " IFNULL(RA.stcnt,0)=IFNULL(RA.racescnt,0)*2 AND IFNULL(RA.stcnt,0)<>0 ";
                break;
            case 4: // solo procesadas o cerradas
                $filter .= " (IFNULL(RA.stcnt,0)>0 AND IFNULL(RA.stcnt,0)<IFNULL(RA.racescnt,0)*2 ";
                $filter .= " OR IFNULL(RA.stcnt,0)=IFNULL(RA.racescnt,0)*2 AND IFNULL(RA.stcnt,0)<>0) ";
                break;
        }
    }
    */
    // filtro de status del pronóstico
    if ($forecaststatusid != 0){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        switch ($forecaststatusid){
            case 1: // solo abiertas
                $filter .= " ((F.fcnt=F.rcnt AND F.magcnt<>" . $activemagazines . ") AND " .
                            "(!(IFNULL(RA.stcnt,0)=IFNULL(RA.racescnt,0)*2 AND IFNULL(RA.stcnt,0)<>0))) ";
                break;
            case 2: // solo procesadas
                $filter .= " ((F.fcnt=F.rcnt AND F.magcnt=" . $activemagazines . ") AND " . 
                            "(!(IFNULL(RA.stcnt,0)=IFNULL(RA.racescnt,0)*2 AND IFNULL(RA.stcnt,0)<>0))) ";
                break;
            case 3: // solo cerradas
                $filter .= " (IFNULL(RA.stcnt,0)=IFNULL(RA.racescnt,0)*2 AND IFNULL(RA.stcnt,0)<>0) ";
                break;
        }
    }
    // filtro de hipódromo
    if ($racecourseid != 0){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " racecourseid = '" . $racecourseid . "' ";
    }
    // filtro de fecha desde
    if ($datefrom != ""){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " date >= '" . $datefrom . "' ";
    }
    // filtro de fecha hasta
    if ($dateto != ""){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " date <= '" . $dateto . "' ";
    }
    if (strlen($filter) > 0){
        $filter = " WHERE " . $filter;
    }

    // orden
    $order = "";
    switch (abs($orderpar)){
        case 1:
            $order = " id ";
            break;
        case 2:
            $order = " C.dsc ";
            break;
        case 3:
            $order = " R.date ";
            break;
        case 4:
            $order = " FLOOR(ABS(V.variante)) ";
            break;
        case 5:
            $order = " IFNULL(RA.racescnt,0) ";
            break;
        case 6:
            $order = " IF(IFNULL(RA.stcnt,0)=0,'Abierta',IF(IFNULL(RA.stcnt,0)=IFNULL(RA.racescnt,0)*2,'Cerrada','Procesada')) ";
            break;
        case 7:
            $order = " (R.number*1) ";
            break;
        case 88:
            $order =    " IF(IF(IFNULL(RA.stcnt, 0)=0, 'Abierta', IF(IFNULL(RA.stcnt, 0)=IFNULL(RA.racescnt, 0)*2, 'Cerrada', 'Procesada')) = 'Cerrada', 'Cerrados', " . 
                        "   IF(F.fcnt=F.rcnt AND magcnt=" . $activemagazines . ", 'Procesados', 'Abiertos') ";

            break;
    }
    if (strlen($order) > 0){
        if ($orderpar < 0)
            $order = str_replace(", ", " DESC,", $order) . " DESC ";
        $order = " ORDER BY " . $order;
    }

    $out = new stdClass;

    $sql =  "SELECT COUNT(*) cnt FROM magazines WHERE status<>0 AND id IN (" . $magazineids . ")";
    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
    $row = $rs->fetch_assoc();
    $activemagazines = $row["cnt"];


    $sql =  "SELECT     R.id, R.date, R.number, " . 
            "           DATE_FORMAT(R.date, '%d/%m/%Y') datefmt, FLOOR(ABS(IFNULL(V.variante,0))) variante, " .
            "           C.id racecourseid, C.dsc racecoursedsc, " . 
            "           IF(IFNULL(RA.stcnt, 0)=0, 'Abierta', IF(IFNULL(RA.stcnt, 0)=IFNULL(RA.racescnt, 0)*2, 'Cerrada', 'Procesada')) status, " .
            "           IFNULL(RA.racescnt, 0) racescnt, " .
            "           IF(IF(IFNULL(RA.stcnt, 0)=0, 'Abierta', IF(IFNULL(RA.stcnt, 0)=IFNULL(RA.racescnt, 0)*2, 'Cerrada', 'Procesada')) = 'Cerrada', 'Cerrados', " . 
            "               IF(F.fcnt=F.rcnt AND magcnt=" . $activemagazines . ", 'Procesados', 'Abiertos') " . 
            //"               IF(F.magcnt=" . $activemagazines . ", 'Procesados', 'Abiertos') " . 
            "           ) forestatus " . 
            "FROM       reunions R " .
            "LEFT JOIN  wrk_variante V " . 
            "ON         R.id = V.reunionid " . 
            "LEFT JOIN  (" . // esta tabla F calcula las carreras vs los pronósticos
            "SELECT		reunionid, SUM(IF(raceid IS NULL, -1, 1)) fcnt, MAX(magcnt) magcnt, COUNT(raceid) rcnt " .
            "FROM		( " .
            "           SELECT		MIN(reunionid) reunionid, R.id raceid, IFNULL(F.magcnt,0) magcnt " .
            "           FROM		races R " .
            "           LEFT JOIN  	(SELECT raceid, COUNT(*) magcnt FROM forecasts GROUP BY raceid) F " .
            "           ON			R.id=F.raceid " .
            "           GROUP BY 	R.id, F.magcnt " .
            "                       ) A " .
            "           GROUP BY	reunionid            "  . 
            "           ) F " . 
            "ON         R.id=F.reunionid " . 
            "INNER JOIN racecourses C " .
            "ON         R.racecourseid=C.id " .
            "LEFT JOIN  (SELECT reunionid, COUNT(*) racescnt, SUM(status) stcnt FROM races GROUP BY reunionid) RA " . 
            "ON         R.id = RA.reunionid " . 
            $filter .
            $order;
    // calcular numero de registros
    if (!$rs = $db->query("SELECT COUNT(*) cnt FROM (" . $sql . ") A "))
        badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
    $row = $rs->fetch_assoc();
    $out->numofrecords = (integer) $row["cnt"];

    // limitar número de
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $offset . "," . $numofrec;
    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>2, "msg"=>$db->error));
 
//die($sql);
    $out->records = array();
    while ($row = $rs->fetch_assoc()){
        $reunion = new stdClass;
        $reunion->id = (integer) $row["id"];
//die ($row["id"]);
        $reunion->number = $row["number"];
        $reunion->racescnt = (integer) $row["racescnt"];
        $reunion->variant = new stdClass;
        $reunion->variant->number = (float) $row["variante"];
        $reunion->variant->formatted = number_format($reunion->variant->number,0,",");
        $reunion->racecourse = new stdClass;
        $reunion->racecourse->id = (integer) $row["racecourseid"];
        $reunion->racecourse->name = $row["racecoursedsc"];
        $reunion->date = new stdClass;
        $reunion->date->date = $row["date"];
        $reunion->date->formatted = $row["datefmt"];
        $reunion->status = new stdClass;
        $reunion->status->id = (integer) 0;
        $reunion->status->name = $row["status"];
        $reunion->forecast = $row["forestatus"];

        $out->records[] = $reunion;
    }

    // calcular ultimos numero de reuniones or hipodromo
    $sql =  "SELECT     H.id racecourseid, MAX(1*IFNULL(R.number,0)) maxnumber " . 
            "FROM       racecourses H  " . 
            "LEFT JOIN  reunions R " . 
            "ON         H.id = R.racecourseid " .
            "GROUP BY   H.id";
    // calcular numero de registros
    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
    $lastreunionnumbers = array();
    while($row = $rs->fetch_assoc()){
        $lastreunionnumbers[] = array("id"=>(integer) $row["racecourseid"], "lastnumber"=>(integer) $row["maxnumber"]);
    }
    $out->lastreunionnumbers = $lastreunionnumbers;

    $access = array();
    $access["read"] = tienePrivilegio($db, $sessionid, 610);
    $access["update"] = tienePrivilegio($db, $sessionid, 611);
    $access["create"] = tienePrivilegio($db, $sessionid, 612);
    $access["delete"] = tienePrivilegio($db, $sessionid, 613);
    $access["forecasts"] = tienePrivilegio($db, $sessionid, 810);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>