<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("id","finishtime","times400","racecoursetypeid","betprices","bethorses",
                    "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $finishtime = floatval($_REQUEST["finishtime"]);
    $times400 = preg_replace("/[^0-9\-\.]+/", "", $_REQUEST["times400"]);
    $racecoursetypeid = intval($_REQUEST["racecoursetypeid"]);
    $betprices = preg_replace("/[^0-9\-\.\|]+/", "", $_REQUEST["betprices"]);
    $bethorses = preg_replace("/[^0-9\-\|]+/", "", $_REQUEST["bethorses"]);

    if ($bethorses == "|")
        $bethorses = "";

    isSessionValid($db, $sessionid);

    // armar apuestas
    $sql =  "SELECT     bets, number " . 
            "FROM       races " . 
            "WHERE      id = ". $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("204", array("msg"=>"No se encontró la carrera"));
    $bets = json_decode($row["bets"]);
    $number = $row["number"];

    // verificar si no se recibe el 5y6 incluirlo (CHAPUZA)
    $inc = true;
    foreach($bets as $bet){
        if ($bet->id == 1)
        $inc = false;
    }
    if ($inc){
        $betarr = array();
        $betarr[] = (object) array( "id"=>1,
                    "name"=>"5 y 6",
                    "reportpricecnt"=>1,
                    "reporthorsescnt"=>0,
                    "exntensible"=>false);
        foreach($bets as $bet){
            $betarr[] = (object) array( "id"=>$bet->id,
                "name"=>$bet->name,
                "reportpricecnt"=>$bet->reportpricecnt,
                "reporthorsescnt"=>$bet->reporthorsescnt,
                "exntensible"=>$bet->exntensible);
        }
        $bets = (object) $betarr;
    }
    //print_r($bets);
    //print_r(count((array)$bets));
    //die();

    $betpriceslst = explode("-", $betprices);
    $bethorseslst = explode("-", $bethorses);
    if (count((array)$bets) != count($betpriceslst) || count((array)$bets) != count($bethorseslst))
        badEnd("400", array("msg"=>"betprices o bethorses no tiene suficientes valores, se esperan " . count((array)$bets)));

    $betsout = array();
    foreach($bets as $i=>$bet){
        // validar que existan los premios correctos
        if ($bet->reportpricecnt>1 && $bet->reportpricecnt <> count(explode("|",$betpriceslst[$i])))
            badEnd("400", array("msg"=>"El número de precios necesario para la apuesta " . $bet->name . " debe ser de " . $bet->reportpricecnt));
        // validar que existan los caballos correctos
        if ($bet->reporthorsescnt>1 && $bet->reporthorsescnt <> count(explode("|",$bethorseslst[$i])))
            badEnd("400", array("msg"=>"El número de caballos necesario para la apuesta " . $bet->name . 
                                        " debe ser de " . $bet->reporthorsescnt . " y estás enviando " . 
                                        count(explode("|",$bethorseslst[$i])) . " >> " . $bethorseslst[$i]));

        $betsout[] = array( "id"=>$bet->id,
                            "name"=>$bet->name,
                            "prices"=>explode("|",$betpriceslst[$i]),
                            "horses"=>explode("|",$bethorseslst[$i])
        );
    }

    // armar tiempos
    $timeslst = explode("-", $times400);
    $distances = array();
    for ($i=1; $i<count($timeslst); $i++){
        $distances[] = array("".($i*400).""=>(float)$timeslst[$i-1]
        );
    }
    $timesout = array("distances"=>$distances, "finalsprint"=>(float)$timeslst[count($timeslst)-1]);

    if (!tienePrivilegio($db, $sessionid, 621, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
        
    $sql =  "UPDATE races " .
            "SET    finishtime = '" . $finishtime . "'," .
            "       racecoursetypeid = '" . $racecoursetypeid . "', " .
            "       times400 = '" . json_encode($timesout) . "', " .
            "       betprices = '" . json_encode($betsout) . "' " .
            "WHERE  id=" . $id;
    if (!$db->query($sql))
        if ($db->errno == 1062){
            badEnd("409", array("msg"=>"Registro Duplicado"));
        }else{
            badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
        }
        
    setAudit($db, "Carreras", $sessionid, "Se actualizó el final de la carrera \'" . $number . "\' (" . $id . ")");

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>