<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("reunionid", "order", "offset", "numofrec", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $reunionid = intval($_REQUEST["reunionid"]);
    $orderpar = intval($_REQUEST["order"]);
    $offset = intval($_REQUEST["offset"]);
    $numofrec = intval($_REQUEST["numofrec"]);

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 620, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    // busqueda
    $filter = " R.reunionid=" . $reunionid . " ";

    if (strlen($filter) > 0){
        $filter = " WHERE " . $filter;
    }

    // orden
    $order = "";
    switch (abs($orderpar)){
        case 1:
            $order = " R.ord ";
            break;
        case 2:
            $order = " R.number ";
            break;
        case 3:
            $order = " R.call ";
            break;
        case 4:
            $order = " R.time ";
            break;
        case 5:
            $order = " CAST(D.dsc AS DECIMAL) ";
            break;
        case 6:
            $order = " R.serie ";
            break;
        case 7:
            $order = " IF(R.status=0,'Abierta',IF(R.status=1,'Procesada','Cerrada')) ";
            break;
    }
    if (strlen($order) > 0){
        if ($orderpar < 0)
            $order = str_replace(", ", " DESC,", $order) . " DESC ";
        $order = " ORDER BY " . $order;
    }

    $sql =  "SELECT     R.id, R.ord, R.number, R.call, R.time, R.serie, R.mainprice, R.valid, R.racetypeid, " .
            "           REPLACE(REPLACE(DATE_FORMAT(R.time, '%h:%i%p'), 'AM', 'am'), 'PM', 'pm') timefmt, " .
            "           D.id distanceid, D.dsc distancedsc, R.status, R.mainpricecurr, R.extrapricecurr " .
            "FROM       races R " .
            "INNER JOIN racetypes T " .
            "ON         R.racetypeid = T.id " . 
            "INNER JOIN distances D " .
            "ON         R.distanceid = D.id " . 
            $filter .
            $order;
    // calcular numero de registros
    if (!$rs = $db->query("SELECT COUNT(*) cnt FROM (" . $sql . ") A "))
        badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
    $row = $rs->fetch_assoc();
    $out = new stdClass;
    $out->numofrecords = (integer) $row["cnt"];

    // limitar número de
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $offset . "," . $numofrec;
    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>2, "msg"=>$db->error));

    $orderdsc = array("1ra", "2da", "3ra", "4ta", "5ta", "6ta", "7ma", "8va", "9na", "10ma", "11va", "12va", "13va", "14va", "15va");

    $out->records = array();
    while ($row = $rs->fetch_assoc()){
        $records = new stdClass;
        $records->id = (integer) $row["id"];
        $records->status = new stdClass;
        $records->status->id = (integer) $row["status"];
        $records->status->name = $records->status->id==0 ? "Abierto" : ($records->status->id==1 ? "Procesado" : "Cerrado");
        $records->order = new stdClass;
        $records->order->id = (integer) $row["ord"];
        $records->order->name = $orderdsc[$records->order->id-1];
        $records->number = (integer) $row["number"];
        $records->call = (integer) $row["call"];
        $records->time = new stdClass;
        $records->time->time = $row["time"];
        $records->time->formatted = $row["timefmt"];
        $records->distance = new stdClass;
        $records->distance->id = (integer) $row["distanceid"];
        $records->distance->name = $row["distancedsc"];
        $records->serie = $row["serie"];
        $records->mainprice = new stdClass;
        $records->mainprice->currency = $row["mainpricecurr"];
        $records->mainprice->number = (float) $row["mainprice"];
        $records->mainprice->formatted = number_format((float) $row["mainprice"], 2, ",", ".");
        $records->isvalid = (boolean) $row["valid"] != 0;
        $records->isclassic = (boolean) ($row["racetypeid"] != "-1");

        $out->records[] = $records;
    }

    // obtener ultimo número de carrera registrada para el hipodromo actual
    // buscar el hipódromo actual
    $sql =  "SELECT     R.racecourseid " . 
            "FROM       reunions R " . 
            "WHERE      R.id=" . $reunionid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    $racecourseid = 0;
    if ($row = $rs->fetch_assoc())
        $racecourseid = $row["racecourseid"];

    $sql =  "SELECT     MAX(R.number) maxnumber " .
            "FROM       races R " . 
            "INNER JOIN reunions RE " . 
            "ON         R.reunionid=RE.id " .
            "WHERE      R.status=2 " . 
            "AND        RE.racecourseid=" . $racecourseid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    $lastracenumber = 0;
    if ($row = $rs->fetch_assoc())
        $lastracenumber = (integer) $row["maxnumber"];

    $out->minimalracenumber = $lastracenumber;


    // obtener ultimos precios asignados por default
    $sql =  "SELECT     `firstplace`, `secondplace`, `thirdplace`, `fourthplace`, `fifthplace` " .
            "FROM       races " . 
            "WHERE      id = (SELECT MAX(id) FROM races)";
        // calcular numero de registros
    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
    if ($row = $rs->fetch_assoc()){
        $number = new stdClass;
        $number->number = (float) $row["firstplace"];
        $number->formatted = number_format($number->number, 2, ",", ".");
        $firstplace = $number;
        $number = new stdClass;
        $number->number = (float) $row["secondplace"];
        $number->formatted = number_format($number->number, 2, ",", ".");
        $secondplace = $number;
        $number = new stdClass;
        $number->number = (float) $row["thirdplace"];
        $number->formatted = number_format($number->number, 2, ",", ".");
        $thirdplace = $number;
        $number = new stdClass;
        $number->number = (float) $row["fourthplace"];
        $number->formatted = number_format($number->number, 2, ",", ".");
        $fourthplace = $number;
        $number = new stdClass;
        $number->number = (float) $row["fifthplace"];
        $number->formatted = number_format($number->number, 2, ",", ".");
        $fifthplace = $number;
    }else{
        $number = new stdClass;
        $number->number = (float) 0;
        $number->formatted = number_format($number->number, 2, ",", ".");
        $firstplace = $number;
        $secondplace = $number;
        $thirdplace = $number;
        $fourthplace = $number;
        $fifthplace = $number;
    }
    $lastbetsdistribution = array();
    $lastbetsdistribution["firstplace"] = nvl($firstplace, 0);
    $lastbetsdistribution["secondplace"] = nvl($secondplace, 0);
    $lastbetsdistribution["thirdplace"] = nvl($thirdplace, 0);
    $lastbetsdistribution["fourthplace"] = nvl($fourthplace, 0);
    $lastbetsdistribution["fifthplace"] = nvl($fifthplace, 0);
    $out->lastbetsdistribution = $lastbetsdistribution;

    $access = array();
    $access["create"] =  tienePrivilegio($db, $sessionid, 622);
    $access["delete"] =  tienePrivilegio($db, $sessionid, 623);
    $access["update"] =  tienePrivilegio($db, $sessionid, 621);
    $access["read"] =    tienePrivilegio($db, $sessionid, 620);
    $access["process"] = tienePrivilegio($db, $sessionid, 624);
    $access["open"] =    tienePrivilegio($db, $sessionid, 625);
    $access["close"] =   tienePrivilegio($db, $sessionid, 626);
    $access["unclose"] = tienePrivilegio($db, $sessionid, 627);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>