<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga con GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));

    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $id = (integer) $_REQUEST["id"];
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 620, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
        $sql =  "SELECT     R.id, R.ord, R.number, R.call, R.time, R.serie, R.mainprice, R.valid, R.racetypeid, " .
                "           REPLACE(REPLACE(DATE_FORMAT(R.time, '%h:%i%p'), 'AM', 'am'), 'PM', 'pm') timefmt, " .
                "           D.id distanceid, D.dsc distancedsc, R.status, R.mainpricecurr, R.extrapricecurr, " .
                "           R.extraprice, R.conditionid1, R.conditionid2, R.conditiondsc, " .
                "           R.firstplace, R.secondplace, R.thirdplace, R.fourthplace, R.fifthplace, " .
                "           R.additionalprice, R.additionalprice2, R.pricesformat, " .
                "           T.dsc racetypedsc, R.bets, R.finishtime, R.times400, R.betprices, " .
                "           IFNULL(RT.id, 0) racecoursetypeid, IFNULL(RT.dsc, '') racecoursetypedsc, " .
                "           R.createdat created, DATE_FORMAT(R.createdat, '%d/%m/%Y %h:%i %p') createdfmt, " .
                "           R.modifiedat modified, DATE_FORMAT(R.modifiedat, '%d/%m/%Y %h:%i %p') modifiedfmt " .
                "FROM       races R " .
                "INNER JOIN racetypes T " .
                "ON         R.racetypeid = T.id " . 
                "INNER JOIN distances D " .
                "ON         R.distanceid = D.id " . 
                "LEFT JOIN  racecoursetypes RT " .
                "ON         R.racecoursetypeid = RT.id " . 
                "WHERE      R.id=" . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    $orderdsc = array("1ra", "2da", "3ra", "4ta", "5ta", "6ta", "7ma", "8va", "9na", "10ma", "11va", "12va", "13va", "14va", "15va");

    $out = new stdClass;
    if ($row = $rs->fetch_assoc()){
        $entry = new stdClass;
        $entry->id = (integer) $row["id"];
        $entry->status = new stdClass;
        $entry->status->id = (integer) $row["status"];
        $entry->status->name = $entry->status->id==0 ? "Abierto" : ($entry->status->id==1 ? "Procesado" : "Cerrado");
        $entry->order = new stdClass;
        $entry->order->id = (integer) $row["ord"];
        $entry->order->name = $orderdsc[$entry->order->id-1];
        $entry->number = (integer) $row["number"];
        $entry->call = (integer) $row["call"];
        $entry->time = new stdClass;
        $entry->time->time = $row["time"];
        $entry->time->formatted = $row["timefmt"];
        //$entry->bets = new stdClass;
        $entry->bets = json_decode($row["bets"]);
        $entry->distance = new stdClass;
        $entry->distance->id = (integer) $row["distanceid"];
        $entry->distance->name = $row["distancedsc"];
        $entry->serie = $row["serie"];
        $entry->mainprice = new stdClass;
        $entry->mainprice->currency = $row["mainpricecurr"];
        $entry->mainprice->number = (float) $row["mainprice"];
        $entry->mainprice->formatted = number_format((float) $row["mainprice"], 2, ",", ".");
        $entry->extraprice = new stdClass;
        $entry->extraprice->currency = $row["extrapricecurr"];
        $entry->extraprice->number = (float) $row["extraprice"];
        $entry->extraprice->formatted = number_format((float) $row["extraprice"], 2, ",", ".");
        $entry->valid = (integer) $row["valid"];
        $entry->racetype = new stdClass;
        $entry->racetype->id = (integer) $row["racetypeid"];
        $entry->racetype->name = $row["racetypedsc"];
        $entry->conditions = new stdClass;
        $entry->conditions->conditionid1 = (integer) $row["conditionid1"];
        $entry->conditions->conditionid2 = (integer) $row["conditionid2"];
        $entry->conditions->conditiondsc = $row["conditiondsc"];
        $entry->placedivs = new stdClass;
        $entry->placedivs->pricesformat = (int) $row["pricesformat"];
        $entry->placedivs->first = new stdClass;
        $entry->placedivs->first->number = (float) $row["firstplace"];
        $entry->placedivs->first->formatted = number_format($entry->placedivs->first->number, 2, ",", ".") . "%";
        $entry->placedivs->second = new stdClass;
        $entry->placedivs->second->number = (float) $row["secondplace"];
        $entry->placedivs->second->formatted = number_format($entry->placedivs->second->number, 2, ",", ".") . "%";
        $entry->placedivs->third = new stdClass;
        $entry->placedivs->third->number = (float) $row["thirdplace"];
        $entry->placedivs->third->formatted = number_format($entry->placedivs->third->number, 2, ",", ".") . "%";
        $entry->placedivs->fourth = new stdClass;
        $entry->placedivs->fourth->number = (float) $row["fourthplace"];
        $entry->placedivs->fourth->formatted = number_format($entry->placedivs->fourth->number, 2, ",", ".") . "%";
        $entry->placedivs->fifth = new stdClass;
        $entry->placedivs->fifth->number = (float) $row["fifthplace"];
        $entry->placedivs->fifth->formatted = number_format($entry->placedivs->fifth->number, 2, ",", ".") . "%";
        $entry->placedivs->additional = new stdClass;
        $entry->placedivs->additional->number = (float) $row["additionalprice"];
        $entry->placedivs->additional->formatted = number_format($entry->placedivs->additional->number, 2, ",", ".") . "%";
        $entry->placedivs->additional2 = new stdClass;
        $entry->placedivs->additional2->number = (float) $row["additionalprice2"];
        $entry->placedivs->additional2->formatted = number_format($entry->placedivs->additional2->number, 2, ",", ".") . "%";
        $times400 = nvl(json_decode(($row["times400"] != null ? $row["times400"] : '')), (object) array("finalsprint"=>0,"distances"=>array()));
        $entry->times = new stdClass;
        $entry->times->finish = new stdClass;
        $entry->times->finish->number = (double) $row["finishtime"];
        $entry->times->finish->formatted = number_format($entry->times->finish->number,2,",",".");
        $entry->times->finalsprint = new stdClass;
        $entry->times->finalsprint->number = (double) $times400->finalsprint;
        $entry->times->finalsprint->formatted = number_format($entry->times->finalsprint->number,2,",",".");
        $each400 = $times400->distances;
        $entry->times->each400 = $each400;
        $entry->racecoursetype = new stdClass;
        $entry->racecoursetype->id = (integer) $row["racecoursetypeid"];
        $entry->racecoursetype->name = $row["racecoursetypedsc"];
        $entry->betprices = nvl(json_decode($row["betprices"] != null ? $row["betprices"] : ''), array());
        $entry->created = new stdClass;
        $entry->created->date = $row["created"];
        $entry->created->formatted = $row["createdfmt"];
        $entry->modified = new stdClass;
        $entry->modified->date = $row["modified"];
        $entry->modified->formatted = $row["modifiedfmt"];
    }else{
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }

    $out->entry = $entry;

    $access = array();
    $access["create"] =  tienePrivilegio($db, $sessionid, 622);
    $access["delete"] =  tienePrivilegio($db, $sessionid, 623);
    $access["update"] =  tienePrivilegio($db, $sessionid, 621);
    $access["read"] =    tienePrivilegio($db, $sessionid, 620);
    $access["process"] = tienePrivilegio($db, $sessionid, 624);
    $access["open"] =    tienePrivilegio($db, $sessionid, 625);
    $access["close"] =   tienePrivilegio($db, $sessionid, 626);
    $access["unclose"] = tienePrivilegio($db, $sessionid, 627);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>