<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
$tt = "";

    // forzar a que se haga con GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));

    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $id = (integer) $_REQUEST["id"];
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);

    isSessionValid($db, $sessionid);

    // verificar el estatus actual
    $sql =  "SELECT     status, number, reunionid " .
            "FROM       races " . 
            "WHERE      id=" . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    $status = $row["status"];
    $number = $row["number"];
    $reunionid = $row["reunionid"];

    if ($status != "1" && $status != "2")
        badEnd("417", array("msg"=>"Solo se puede llamar a este servicio para cerrar o revertir el cierre de una carrera"));

    $newstatus = -1;
    if ($status == "1"){
        if (!tienePrivilegio($db, $sessionid, 626, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));

        // Validar que haya caballos cargados
        $sql =  "SELECT     count(*) cnt " . 
                "FROM       racers " . 
                "WHERE      raceid=" . $id . " " . 
                "AND        ( " .
                "           arrivalposition IS NULL " .
                "OR         finishtime IS NULL " .
                "OR         dividends IS NULL " .
                "           ) ";
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if (!$row = $rs->fetch_assoc())
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        if ($row["cnt"]!="0")
            badEnd("417", array("msg"=>"Deben completarse los valores de llegada de los ejemplares cargados para cerrar la carrera"));

        // REGISTRO DE ESTADISTICAS
        set_records_hipdst($id);
        set_records_hipdstseriesexo($id);

        // actualizar la variante de la reunión
        $sql =  "UPDATE		reunions R  " . 
                "LEFT JOIN  wrk_variante V  " . 
                "ON			R.id=V.reunionid " . 
                //"SET		R.variant=IF(IFNULL(V.variante,0)<=0,0,IFNULL(V.variante,0)) " . 
                "SET		R.variant=IFNULL(V.variante,0) " . 
                "WHERE      R.id=" . $reunionid;        
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

        // actualizar speedratings de la carrera
        $sql =  "UPDATE 	racers R  " .
                "INNER JOIN	wrk_tiemposcalculados T  " .
                "ON			R.id=T.racerid " .
                "SET		R.speedr=IFNULL(T.tiempocalc,0) " .
                "WHERE		R.raceid = " . $id; /* . " " . 
                "AND        R.speedr IS NULL";*/
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

        //if ($id==9237)
        //    $tt = $sql;

        $newstatus = 2;
    }
    if ($status == "2"){
        if (!tienePrivilegio($db, $sessionid, 627, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));

        // REGISTRO DE ESTADISTICAS
        unset_records_hipdst($id);
        unset_records_hipdstseriesexo($id);

        $newstatus = 1;
    }
    if ($newstatus != -1){
        $sql =  "UPDATE     races " .
                "SET        status=" . $newstatus . " " .
                "WHERE      id=" . $id;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

        if ($newstatus == 2)
            setAudit($db, "Carreras", $sessionid, "Se cerró la carrera \'" . $number . "\' (" . $id . ")");
        else
            setAudit($db, "Carreras", $sessionid, "Se revirtió el cierre de la carrera \'" . $number . "\' (" . $id . ")");

    }

    $out = new stdClass;
    $out->id = $id;
    $out->tt = $tt;
    $out->newstatus = $newstatus;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    //////////////////////////////////////////////////


    function set_records_hipdst($raceid){
        global $db;
        // calculo del mejor de tiempo para una distancia en un hipodromo
        // obtener datos de la carrera actual
        $sql =  "SELECT     RE.racecourseid, RA.distanceid, R.finishtime, RE.date, R.jockeyweight, " . 
                "           H.dsc horsename, CONCAT(J.names, ' ', J.lastnames) jockeyname, R.id racerid " . 
                "FROM       racers R " . 
                "INNER JOIN jockeys J " . 
                "ON         R.jockeyid=J.id " . 
                "INNER JOIN horses H " . 
                "ON         R.horseid=H.id " . 
                "INNER JOIN races RA " . 
                "ON         R.raceid=RA.id " .
                "INNER JOIN reunions RE " . 
                "ON         RA.reunionid=RE.id " . 
                "WHERE      RA.id=" . $raceid . " " . 
                "AND        R.retirementid IS NULL " . 
                "AND        R.arrivalposition=1 " .
                "ORDER BY   R.finishtime";
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if ($row = $rs->fetch_assoc()){
            $finishtime = $row["finishtime"];
            $racerid = $row["racerid"];
            $racecourseid = $row["racecourseid"];
            $distanceid = $row["distanceid"];
            $racedate = $row["date"];
            $horsename = $row["horsename"];
            $jockeyname = $row["jockeyname"];
            $jockeyweight = $row["jockeyweight"];
            // verificar que este tiempo sea mejor que el registrado
            $sql =  "UPDATE records_hipdst " . 
                    "SET    deleted = NOW() " . 
                    "WHERE  deleted IS NULL " . 
                    "AND    racecourseid=" . $racecourseid . " " . 
                    "AND    distanceid=" . $distanceid . " " . 
                    "AND    basetime>" . $finishtime;
            if (!$rs = $db->query($sql))
                badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
            // si hubo cambio se intserta el nuevo mejor tiempo
            $insertrecord = false;
            if ($db->affected_rows){
                $insertrecord = true;
            }else{          // se verifica si no hay record, se incluye
                $sql =  "SELECT 1 " . 
                        "FROM   records_hipdst " . 
                        "WHERE  racecourseid=" . $racecourseid . " " . 
                        "AND    distanceid=" . $distanceid . " " . 
                        "LIMIT 1";
                if (!$rs = $db->query($sql))
                    badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
                if (!$row = $rs->fetch_assoc()){         // si no se consiguio record se incluye
                    $insertrecord = true;
                }
            }
            if ($insertrecord){
                $sql =  "INSERT INTO    records_hipdst (racecourseid, distanceid, basetime, date, " . 
                        "                               horsename, jockeyname, jockeyweight, raceid, racerid) " . 
                        "VALUES         (" . $racecourseid . "," . $distanceid . "," . $finishtime . ",'" . $racedate . "'," .
                        "               '" . $horsename . "','" . $jockeyname . "'," . $jockeyweight . "," . $raceid . "," . $racerid . ")";
                if (!$rs = $db->query($sql))
                    badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
            }
        }
    }
      
    function set_records_hipdstseriesexo($raceid){
        global $db;
        // calculo del mejor de tiempo para una distancia en un hipodromo por serie y sexo
        // obtener datos de la carrera actual
        $sql =  "SELECT     RE.racecourseid, RA.distanceid, R.finishtime, RE.date, " . 
                //"           H.gender, C.serie, R.id racerid " . 
                "           H.gender, C.cat, R.id racerid " . 
                "FROM       racers R " . 
                "INNER JOIN horses H " . 
                "ON         R.horseid=H.id " . 
                "INNER JOIN races RA " . 
                "ON         R.raceid=RA.id " .
                "INNER JOIN conditions C " . 
                "ON         RA.conditionid1=C.id " .
                "INNER JOIN reunions RE " . 
                "ON         RA.reunionid=RE.id " . 
                "WHERE      RA.id=" . $raceid . " " . 
                "AND        R.retirementid IS NULL " . 
                "AND        R.arrivalposition=1 " . 
                "ORDER BY   R.finishtime ";
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if ($row = $rs->fetch_assoc()){
            $finishtime = $row["finishtime"];
            $racerid = $row["racerid"];
            $racecourseid = $row["racecourseid"];
            $distanceid = $row["distanceid"];
            $racedate = $row["date"];
            $horsegender = $row["gender"];
            $cat = $row["cat"];
            // verificar que este tiempo sea mejor que el registrado
            $sql =  "UPDATE records_hipdstseriesexo " . 
                    "SET    deleted = NOW() " . 
                    "WHERE  deleted IS NULL " . 
                    "AND    racecourseid=" . $racecourseid . " " . 
                    "AND    distanceid=" . $distanceid . " " . 
                    "AND    cat='" . $cat . "' " . 
                    "AND    gender='" . $horsegender . "' " . 
                    "AND    basetime>" . $finishtime;
            if (!$rs = $db->query($sql))
                badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
            // si hubo cambio se intserta el nuevo mejor tiempo
            $insertrecord = false;
            if ($db->affected_rows){
                $insertrecord = true;
            }else{          // se verifica si no hay record, se incluye
                $sql =  "SELECT 1 " . 
                        "FROM   records_hipdstseriesexo " . 
                        "WHERE  racecourseid=" . $racecourseid . " " . 
                        "AND    distanceid=" . $distanceid . " " . 
                        "AND    cat='" . $cat . "' " . 
                        "AND    gender='" . $horsegender . "' ";
                if (!$rs = $db->query($sql))
                    badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
                if (!$row = $rs->fetch_assoc()){         // si no se consiguio record se incluye
                    $insertrecord = true;
                }
            }
            if ($insertrecord){
                $sql =  "INSERT INTO    records_hipdstseriesexo (racecourseid, distanceid, basetime, date, " . 
                        "                               cat, gender, raceid) " . 
                        "VALUES         (" . $racecourseid . "," . $distanceid . "," . $finishtime . ",'" . $racedate . "'," .
                        "               '" . $cat . "','" . $horsegender . "'," . $raceid . ")";
                if (!$rs = $db->query($sql))
                    badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
            }
        }
    }

    function unset_records_hipdst($raceid){
        global $db;
        // buscar a ver si tiene algun record
        $sql =  "SELECT     IFNULL(deleted,'') deleted, racecourseid, distanceid " . 
                "FROM       records_hipdst " . 
                "WHERE      raceid=" . $raceid;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if ($row = $rs->fetch_assoc()){
            $racecourseid = $row["racecourseid"];
            $distanceid = $row["distanceid"];
            if ($row["deleted"]!=""){   // se trata de un record intermedio se borra
                $revert = false;
            }else{                      // record vivo, se revierte
                $revert = true;
            }
            // se borra el record
            $sql =  "DELETE FROM records_hipdst WHERE raceid=" . $raceid;
            if (!$rs = $db->query($sql))
                badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
            if ($revert){       // revertir record más reciente
                $sql =  "SELECT     MAX(deleted) maxdate " . 
                        "FROM       records_hipdst " . 
                        "WHERE      racecourseid=" . $racecourseid . " " .
                        "AND        distanceid=" . $distanceid . " " . 
                        "AND        deleted IS NOT NULL " . 
                        "GROUP BY   racecourseid, distanceid"; 
                if (!$rs = $db->query($sql))
                    badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
                if ($row = $rs->fetch_assoc()){         // si consigui uno lo recupera, sino se pierde ese record
                    $sql =  "UPDATE records_hipdst SET deleted = NULL " . 
                            "WHERE  racecourseid=" . $racecourseid . " " . 
                            "AND    distanceid=" . $distanceid . " " .
                            "AND    deleted='" . $row["maxdate"] . "'";
                if (!$rs = $db->query($sql))
                    badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
                }
            }
        }
    }

    function unset_records_hipdstseriesexo($raceid){
        global $db;
        // buscar a ver si tiene algun record
        $sql =  "SELECT     IFNULL(deleted,'') deleted, racecourseid, distanceid, gender, cat " . 
                "FROM       records_hipdstseriesexo " . 
                "WHERE      raceid=" . $raceid;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if ($row = $rs->fetch_assoc()){
            $racecourseid = $row["racecourseid"];
            $distanceid = $row["distanceid"];
            $gender = $row["gender"];
            $cat = $row["cat"];
            if ($row["deleted"]!=""){   // se trata de un record intermedio se borra
                $revert = false;
            }else{                      // record vivo, se revierte
                $revert = true;
            }
            // se borra el record
            $sql =  "DELETE FROM records_hipdstseriesexo WHERE raceid=" . $raceid;
            if (!$rs = $db->query($sql))
                badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
            if ($revert){       // revertir record más reciente
                $sql =  "SELECT     MAX(deleted) maxdate " . 
                        "FROM       records_hipdstseriesexo " . 
                        "WHERE      racecourseid=" . $racecourseid . " " .
                        "AND        distanceid=" . $distanceid . " " . 
                        "AND        gender='" . $gender . "' " . 
                        "AND        cat='" . $cat . "' " . 
                        "AND        deleted IS NOT NULL " . 
                        "GROUP BY   racecourseid, distanceid, gender, cat"; 

                if (!$rs = $db->query($sql))
                    badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
                if ($row = $rs->fetch_assoc()){         // si consigui uno lo recupera, sino se pierde ese record
                    $sql =  "UPDATE records_hipdstseriesexo SET deleted = NULL " . 
                            "WHERE  racecourseid=" . $racecourseid . " " . 
                            "AND    distanceid=" . $distanceid . " " .
                            "AND    deleted='" . $row["maxdate"] . "'" .
                            "AND    gender='" . $gender . "' " . 
                            "AND    cat='" . $cat . "' ";
                    if (!$rs = $db->query($sql))
                        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
                }
            }
        }
    }
?>