<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("magazineid","raceid","top3","top6","comments","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $magazineid = intval($_REQUEST["magazineid"]);
    $raceid = intval($_REQUEST["raceid"]);
    $top3par = preg_replace("/[^0-9\-]+/", "", $_REQUEST["top3"]);
    $top6par = preg_replace("/[^0-9\-]+/", "", $_REQUEST["top6"]);
    $commentspar = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ\|]+/", "", $_REQUEST["comments"]);

    isSessionValid($db, $sessionid);

    // validar top3
    $top3 = explode("-", $top3par);
    if (count($top3)!=3)
        badEnd("400", array("msg"=>"top3 inválidos Recibidos " . count($top3) . " se esperaban 3"));
    if ($top3[0]=="" || $top3[1]=="" || $top3[2]=="")
        badEnd("400", array("msg"=>"Todos los valores top3 con obligatorios"));
    // validar top6
    $top6 = explode("-", $top6par);
    if (count($top6)!=3)
        badEnd("400", array("msg"=>"top6 inválidos Recibidos " . count($top6) . " se esperaban 3"));

    // validar comentarios
    $sql =  "SELECT     count(*) cnt " . 
            "FROM       racers " . 
            "WHERE      raceid=" . $raceid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>2, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("400", array("sql"=>$sql,"msg"=>$db->error));
    $comments = explode("|", ($commentspar));
    if (count($comments)!=$row["cnt"])
        badEnd("400", array("msg"=>"numero de comentarios incorrectos Recibidos " . count($comments) . " se esparaban " . $row["cnt"]));

    // armar campos racers de la tabla forecasts
    $racers = array();
    $sql =  "SELECT     id, number, IFNULL(arrivalposition, 0) arrivalposition " . 
            "FROM       racers " . 
            "WHERE      raceid=" . $raceid . " " .
            "ORDER BY   number";
    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>2, "msg"=>$db->error));
    $i = 0;
    while ($row = $rs->fetch_assoc()){
        $forecast = 0;
        if ($top3[0]==$row["number"])
            $forecast = 1;
        if ($top3[1]==$row["number"])
            $forecast = 2;
        if ($top3[2]==$row["number"])
            $forecast = 3;
        if ($top6[0]==$row["number"])
            $forecast = 4;
        if ($top6[1]==$row["number"])
            $forecast = 5;
        if ($top6[2]==$row["number"])
            $forecast = 6;
        $racers[] = array(  "id"=>(integer)$row["id"],
                            "number"=>(integer)$row["number"],
                            "arrivalposition"=>$row["arrivalposition"],
                            "forecast"=>$forecast,
                            "comment"=>$comments[$i]
        );
        $i++;
    }

    if (!tienePrivilegio($db, $sessionid, 811, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));

    // se borra cualquier pronóstico anterior
    $sql =  "DELETE FROM    forecasts " . 
            "WHERE          raceid=" . $raceid . " " . 
            "AND            magazineid=" . $magazineid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("msg"=>$db->error));

    // Insertar nuevo forecast
    $sql =  "INSERT INTO    forecasts " . 
            "               (raceid, magazineid, top3, top6, racers) " . 
            "VALUES         (" . 
            "               " . $raceid . ", " . 
            "               " . $magazineid . ", " . 
            "               '" . $top3par . "', " . 
            "               '" . $top6par . "', " . 
            "               '" . json_encode($racers, JSON_UNESCAPED_UNICODE) . "') ";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    // conseguir información para los pronósticos
    $sql = "SELECT number from races WHERE id=" . $raceid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("500", badEnd("500", array("msg"=>$db->error)));
    $racenumber = $row["number"];
    $sql = "SELECT dsc from magazines WHERE id=" . $magazineid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("500", badEnd("500", array("msg"=>$db->error)));
    $magnam = $row["dsc"];
        
    setAudit($db, "Pronósticos", $sessionid, "Se actualizó la carrera \'" . $racenumber . "\' de la revista \'" . $magnam . "\'");

    $out = new stdClass;
    $out->raceid = $raceid;
    $out->magazineid = $magazineid;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>