<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("order", "offset", "numofrec", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $orderpar = intval($_REQUEST["order"]);
    $offset = intval($_REQUEST["offset"]);
    $numofrec = intval($_REQUEST["numofrec"]);

    // parametros opcionales
    $filtro = "";
    if (isset($_REQUEST["filter"])){
        $filtro = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["filter"]);
    }
    $typeid = "";
    if (isset($_REQUEST["typeid"])){
        $typeid = preg_replace("/[^IM]+/", "", $_REQUEST["typeid"]);
    }
    $statusid = 0;
    if (isset($_REQUEST["statusid"])){
        $statusid = intval($_REQUEST["statusid"]);
    }

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 510, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    // busqueda
    $filter = "";
    if (strlen($filtro) > 0){
        $filter .= "(";
        $filter .= "    I.abbr like '%" . $filtro . "%' ";
        $filter .= " OR I.dsc like '%" . $filtro . "%' ";
        $filter .= " OR IF(I.status='1', ' Activo', ' Inactivo') like '% " . $filtro . "%' ";
        $filter .= " OR IF(I.type='I', 'Implemento', 'Medicamento') like '%" . $filtro . "%' ";
        $filter .= ")";
    }
    // filtro de status
    if ($statusid != 0){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " I.status = " . ($statusid == 1 ? "1" : "0");
    }
    // filtro de tipo
    if ($typeid != ""){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " I.type = '" . $typeid . "'";
    }
    if (strlen($filter) > 0){
        $filter = " WHERE " . $filter;
    }

    // orden
    $order = "";
    switch (abs($orderpar)){
        case 1:
            $order = " I.createdat ";
            break;
        case 2:
            $order = " I.modifiedat ";
            break;
        case 3:
            $order = " I.dsc ";
            break;
        case 4:
            $order = " I.abbr ";
            break;
        case 5:
            $order = " I.status ";
            break;
        case 6:
            $order = " I.type ";
            break;
    }
    if (strlen($order) > 0){
        if ($orderpar < 0)
            $order = str_replace(",", " DESC,", $order) . " DESC ";
        $order = " ORDER BY " . $order;
    }

    $sql =  "SELECT     I.id, I.dsc, I.abbr, I.status, I.type " .
            "FROM       implements I " .
            $filter .
            $order;

    // calcular numero de registros
    if (!$rs = $db->query("SELECT COUNT(*) cnt FROM (" . $sql . ") A "))
        badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
    $row = $rs->fetch_assoc();
    $out = new stdClass;
    $out->numofrecords = (integer) $row["cnt"];
    // limitar número de
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $offset . "," . $numofrec;
    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>2, "msg"=>$db->error));

    $out->records = array();
    while ($row = $rs->fetch_assoc()){
        $records = new stdClass;
        $records->id = (integer) $row["id"];
        $records->name = $row["dsc"];
        $records->abbr = $row["abbr"];
        $records->type = new stdClass;
        $records->type->id = $row["type"];
        $records->type->name = $records->type->id=="I" ? "Implemento" : "Medicamento";
        $records->status = new stdClass;
        $records->status->id = (integer) $row["status"];
        $records->status->name = $records->status->id==0 ? "Inactivo" : "Activo";

        $out->records[] = $records;
    }

    $access = array();
    $access["create"] = tienePrivilegio($db, $sessionid, 512);
    $access["delete"] = tienePrivilegio($db, $sessionid, 513);
    $access["update"] = tienePrivilegio($db, $sessionid, 511);
    $access["read"] =   tienePrivilegio($db, $sessionid, 510);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>