<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga con GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));

    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $id = (integer) $_REQUEST["id"];
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 550, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
        $sql =  "SELECT     R.id, R.dsc, R.status, R.minvariant, R.maxvariant, " . 
                "           R.createdat created, DATE_FORMAT(R.createdat, '%d/%m/%Y %h:%i %p') createdfmt, " .
                "           R.modifiedat modified, DATE_FORMAT(R.modifiedat, '%d/%m/%Y %h:%i %p') modifiedfmt " .
                "FROM       racecoursetypes R " .
                "WHERE      R.id=  " . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    $out = new stdClass;
    if ($row = $rs->fetch_assoc()){
        $entry = new stdClass;
        $entry->id = (integer) $row["id"];
        $entry->name = $row["dsc"];
        $entry->variant = new stdClass;
        $entry->variant->min = new stdClass;
        $entry->variant->min->number = (float) $row["minvariant"];
        $entry->variant->min->formatted = number_format($entry->variant->min->number, 0, ",", ".");
        $entry->variant->max = new stdClass;
        $entry->variant->max->number = (float) $row["maxvariant"];
        $entry->variant->max->formatted = number_format($entry->variant->max->number, 0, ",", ".");
        $entry->status = new stdClass;
        $entry->status->id = (integer) $row["status"];
        $entry->status->name = $entry->status->id==0 ? "Inactivo" : "Activo";
        $entry->created = new stdClass;
        $entry->created->date = $row["created"];
        $entry->created->formatted = $row["createdfmt"];
        $entry->modified = new stdClass;
        $entry->modified->date = $row["modified"];
        $entry->modified->formatted = $row["modifiedfmt"];
    }else{
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }

    $out->entry = $entry;

    $access = array();
    $access["create"] = tienePrivilegio($db, $sessionid, 552);
    $access["delete"] = tienePrivilegio($db, $sessionid, 553);
    $access["update"] = tienePrivilegio($db, $sessionid, 551);
    $access["read"] =   tienePrivilegio($db, $sessionid, 550);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>