<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga con GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));

    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $id = (integer) $_REQUEST["id"];
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 520, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
        $sql =  "SELECT     C.id, C.code, C.dsc, C.abbr, C.status, C.typeid, C.serie, " . 
                "           H.id horsetypeid, H.dsc horsetypedsc, C.cat, " .
                "           C.createdat created, DATE_FORMAT(C.createdat, '%d/%m/%Y %h:%i %p') createdfmt, " .
                "           C.modifiedat modified, DATE_FORMAT(C.modifiedat, '%d/%m/%Y %h:%i %p') modifiedfmt " .
                "FROM       conditions C " .
                "INNER JOIN horsetypes H " .
                "ON         C.horsetypeid=H.id " .
                "WHERE      C.id=  " . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    $out = new stdClass;
    if ($row = $rs->fetch_assoc()){
        $entry = new stdClass;
        $entry->id = (integer) $row["id"];
        $entry->code = $row["code"];
        $entry->name = $row["dsc"];
        $entry->abbr = $row["abbr"];
        $entry->serie = $row["serie"];
        $entry->category = $row["cat"];
        $entry->horsetype = new stdClass;
        $entry->horsetype->id = (integer) $row["horsetypeid"];
        $entry->horsetype->name =  $row["horsetypedsc"];
        $entry->type = new stdClass;
        $entry->type->id = (integer) $row["typeid"];
        $entry->type->name = $entry->type->id==1 ? "Tipo 1" : "Tipo 2";
        $entry->status = new stdClass;
        $entry->status->id = (integer) $row["status"];
        $entry->status->name = $entry->status->id==0 ? "Inactivo" : "Activo";
        $entry->created = new stdClass;
        $entry->created->date = $row["created"];
        $entry->created->formatted = $row["createdfmt"];
        $entry->modified = new stdClass;
        $entry->modified->date = $row["modified"];
        $entry->modified->formatted = $row["modifiedfmt"];
    }else{
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }

    $out->entry = $entry;

    $access = array();
    $access["create"] = tienePrivilegio($db, $sessionid, 522);
    $access["delete"] = tienePrivilegio($db, $sessionid, 523);
    $access["update"] = tienePrivilegio($db, $sessionid, 521);
    $access["read"] =   tienePrivilegio($db, $sessionid, 520);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>