<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("id", "sessionid", "dsc", "abbr", "value", "statusid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $dsc = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["dsc"]);
    $abbr = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["abbr"]);
    $value = floatval($_REQUEST["value"]);
    $statusid = intval($_REQUEST["statusid"]);

    if($statusid!=0 && $statusid!=1)
        badEnd("400", array("msg"=>"El parámetro statusid puede ser 0 o 1"));

    isSessionValid($db, $sessionid);

    if ($id==0){    // incluir registro
        if (!tienePrivilegio($db, $sessionid, 562, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "INSERT INTO bodies " .
                "       (dsc, abbr, value, status) " .
                "VALUES (" .
                "        '" . $dsc . "'," .
                "        '" . $abbr . "'," .
                "        '" . $value . "'," .
                "        '" . $statusid . "' " .
                "        )";
        if (!$db->query($sql)){
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("msg"=>$db->error));
            }
        }

        $id = $db->insert_id;

        $dsc = substr($dsc, 0, 20);
        if (strlen($dsc) == 20)
            $dsc = substr($dsc, 0, 17) . "...";
        
        setAudit($db, "Cuerpos", $sessionid, "Se incluyó el cuerpo \'" . $dsc . "\' (" . $id . ")");
    }else{          // modificar registro
        if (!tienePrivilegio($db, $sessionid, 561, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "UPDATE bodies " .
                "SET    dsc = '" . $dsc . "'," .
                "       abbr = '" . $abbr . "', " .
                "       value = '" . $value . "', " .
                "       status = '" . $statusid . "' " .
                "WHERE  id=" . $id;
        if (!$db->query($sql))
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
            }
            
        $dsc = substr($dsc, 0, 20);
        if (strlen($dsc) == 20)
            $dsc = substr($dsc, 0, 17) . "...";

        setAudit($db, "Cuerpos", $sessionid, "Se actualizó el cuerpo \'" . $dsc . "\' (" . $id . ")");

    }

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>