<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

    require '../../../hooks/autoload.php';
    use \PhpOffice\PhpWord\PhpWord;
    use \PhpOffice\PhpWord\SimpleType\Border;
    use \PhpOffice\PhpWord\Style\Font;
    use \PhpOffice\PhpWord\Style\TablePosition;

    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));
    // parametros obligatorios
    $parmsob = array("reunionid", "magazineid", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $reunionid = intval($_REQUEST["reunionid"]);
    $magazineid = intval($_REQUEST["magazineid"]);

    // parametros opcionales
    $outputformat = "docx";
    if (isset($_REQUEST["format"]))
        $outputformat = preg_replace("/[^docxpf]+/", "", strtolower($_REQUEST["format"]));
    if ($outputformat != "docx" && $outputformat != "pdf" )
        badEnd("500", array("msg"=>"Los formatos validos son 'pdf' y 'docx"));
    $racefilter = "";
    if (isset($_REQUEST["raceidfrom"]) && isset($_REQUEST["raceidto"])){
        $raceidfrom = intval($_REQUEST["raceidfrom"]);
        $raceidto = intval($_REQUEST["raceidto"]);
        $sql = "SELECT number FROM races WHERE id=" . $raceidfrom;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if (!$row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Reunion desde no encontrada"));
        $racenumberfrom = $row["number"];
        $sql = "SELECT number FROM races WHERE id=" . $raceidto;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if (!$row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Reunion hasts no encontrada"));
        $racenumberto = $row["number"];
        $racefilter = " AND RA.number BETWEEN '" . $racenumberfrom . "' AND '" . $racenumberto . "' ";
    }
    isSessionValid($db, $sessionid);

    // medidas
    $pulgada = 1440;
    $height = 7.28*$pulgada;  // 1440 twip = 1 pulgada
    //$width = 4.8*$pulgada;
    $width = 3.268*$pulgada;
    $numberwidth = $pulgada/5;
    $top = 0;
    $bottom = 0;
    $left = 0;
    $right = 0;
    $columnspaces = 0;
    $blank = chr(194) . chr(160);

    $C1 = $width * 0.03; //No
    $C2 = $width * 0.23; //nombre
    $C3 = $width * 0.07; //peso
    $C4 = $width * 0.15; //monta
    $C5 = $width * 0.07; //ult3
    $C6 = $width * 0.14; //entrena
    $C7 = $width * 0.07; //pp
    $C8 = $width * 0.14; //div ant
    $C9 = $width * 0.10; //tpo prob

    // conseguir fecha e hipodromo de la reunión
    $sql =  "SELECT 	R.date, R.racecourseid, H.dsc, H.abbr rcabbr " .
            "FROM 		reunions R " .
            "INNER JOIN racecourses H " .
            "ON         R.racecourseid = H.id " .
            "WHERE      R.id = " . $reunionid . " ";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $date = $row["date"];
    $reuniondate = $row["date"];
    $racecourseid = $row["racecourseid"];
    $racecourse = $row["dsc"];
    $rcabbr = $row["rcabbr"];
    $ordinal = ["Primera", "Segunda", "Tercera", "Cuarta", "Quinta", "Sexta", "Séptima", "Octava", "Novena", "Décima", "Undécima", "Duodécima", "Décimatercera", "Décimacuarta"];
    $dow = ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"];

    //obtener primera carrera de la reunión para efectos del nombre
    $sql =  "SELECT LPAD(MIN(number), 3, '0') num FROM races WHERE reunionid=" . $reunionid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $filename = "SPHM" . $rcabbr  . "C" . $row["num"] . "." . $outputformat;

    $datefrom = date('Y-m-d', strtotime('first day of January '. date('Y', strtotime($date)) ));
    // calcular inicio del cuatrimestre
    $actualmonth = intval(date('m', strtotime($date)));
    if ($actualmonth <= 4)
        $datefrom4 = "01";
    else if ($actualmonth <= 8)
        $datefrom4 = "05";
    else if ($actualmonth <= 12)
        $datefrom4 = "09";
    $datefrom4 = date('Y', strtotime($date)) . "-" . $datefrom4 . "-01";
    // SOlo para Caracas
    if ($racecourseid == 2)
        $datefrom = $datefrom4;
    $dateto =   date('Y-m-d', strtotime('-1 day', strtotime($date)));
    $sql =  "SELECT     C.id horseid, R.id racerid, H.dsc racecourse, RA.extraprice, CU1.symbol pricecurr, CU2.symbol extrapricecurr, DATE_FORMAT(RE.date, '%d/%m/%y') fecha, " .
            "           H.id racecourseid, RA.id raceid, RA.ord raceord, RA.number racenumber, RA.mainprice, RA.firstplace, RA.secondplace, RA.thirdplace, RA.fourthplace, RA.fifthplace, " .
            "           R.finishtime, R.number horsenumber, R.position horseposition, C.gender, FU.abbr furabbr, CEILING(DATEDIFF(RE.date, CONCAT(YEAR(C.birthdate), '-12-31'))/365.25) age, R.jockeyweight, RA.valid, " .
            "           RE.date reuniondate, D.id distid, D.dsc distancia, RT.id racetypeid, RT.dsc racetypedsc, " .
            "           UPPER(DATE_FORMAT(RA.time, '%h:%i %p')) hora, DAYOFWEEK(RE.date) dow, " .
            "           CO1.code condcode1, CO1.dsc condicion1, CO2.dsc condicion2, CO2.code condcode2, RA.conditiondsc, " .
            "           RH.horsename recordhorse, RH.jockeyname recordjockey, RH.jockeyweight recordweight, RH.basetime recordtime,  " .
            "           DATE_FORMAT(RH.date, '%d/%m/%y') recorddate, " .
            "           S.dsc studname, S.abbr studabbr, " .
            "           C.obs horseobs, C.dsc horsename, C.mothergfname horsegfather, C.fathername horsefather, C.mothername horsemother, DATE_FORMAT(C.birthdate, '%d/%m/%y') horsebirth, " .
            "           J.abbr jockeyname, T.abbr trainername, ROUND(IF(SJ.jockeytotal<>0, SJ.jockeyfirst/SJ.jockeytotal*100,0),0) xx, ROUND(SJ.rend,0) jockeyef, " . 
            "           ROUND(IF(ST.trainertotal<>0, ST.trainerfirst/ST.trainertotal*100,0),0) xxx, ROUND(ST.rend,0) traineref, " . 
            "           IFNULL(R.implementstypeM, '') medicaments, IFNULL(R.implementstypeI,'') implements, " .
            "           IFNULL(F.racers,'') forecastracers, F.top3, F.top6, " .
            "           SA.harasname, SA.pricesbs harasbs " .
            "FROM       racers R  " .
            "INNER JOIN races RA  " .
            "ON         R.raceid=RA.id " .
            "INNER JOIN racetypes RT " . 
            "ON         RA.racetypeid=RT.id " .
            "INNER JOIN reunions RE  " .
            "ON         RA.reunionid=RE.id " .
            "INNER JOIN racecourses H  " .
            "ON         RE.racecourseid=H.id " .
            "INNER JOIN conditions CO1 " .
            "ON         RA.conditionid1=CO1.id " .
            "INNER JOIN conditions CO2 " .
            "ON         RA.conditionid2=CO2.id " .
            "INNER JOIN distances D  " .
            "ON         RA.distanceid=D.id " .
            "LEFT JOIN	(SELECT * FROM records_hipdst WHERE deleted IS NULL) RH " .
            "ON			RE.racecourseid=RH.racecourseid " .
            "AND		RA.distanceid=RH.distanceid " .
            "LEFT JOIN  (SELECT * FROM forecasts WHERE magazineid=" . $magazineid . ") F " .
            "ON         RA.id=F.raceid " .
            "INNER JOIN studs S  " .
            "ON			R.studid=S.id " .
            "INNER JOIN horses C  " .
            "ON			R.horseid=C.id " .
            "INNER JOIN furs FU " . 
            "ON         C.furid=FU.id " .
            "INNER JOIN stats_haras SA " .
            "ON         C.harasid=SA.harasid " .
            "INNER JOIN jockeys J  " .
            "ON			R.jockeyid=J.id " .
            "INNER JOIN	trainers T  " .
            "ON			R.trainerid=T.id " .
            "INNER JOIN currencies CU1 " .
            "ON         RA.mainpricecurr=CU1.code " .
            "INNER JOIN currencies CU2 " .
            "ON         RA.extrapricecurr=CU2.code " .
            "LEFT JOIN  (SELECT J.jockeyid, J.racecourseid, J.totalraces jockeytotal, J.firstplace jockeyfirst, J.rend FROM (select @df:='" . $datefrom . "' f, @dt:='" . $dateto . "' t) a, stats_jockeys J) SJ " . 
            "ON         R.jockeyid=SJ.jockeyid " . 
            "AND        RE.racecourseid=SJ.racecourseid " .
            "LEFT JOIN  (SELECT T.trainerid, T.racecourseid, T.totalraces trainertotal, T.firstplace trainerfirst, T.rend FROM (select @df:='" . $datefrom . "' f, @dt:='" . $dateto . "' t) a, stats_trainers T) ST " . 
            "ON         R.trainerid=ST.trainerid " . 
            "AND        RE.racecourseid=ST.racecourseid " .
            "WHERE      RE.id=" . $reunionid . " " .
            $racefilter .
            "ORDER BY   RA.ord, R.number";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    $phpWord = new PhpWord();
    $phpWord->getCompatibility()->setOoxmlVersion(15);

    // Estilos de Celdas
    $defaultCellStyle = [
        "borderSize" => 0,
        "borderStyle" => Border::NONE
    ];
    $raceNumberCellStyle = [
        "valign" => "top",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
        //"bgColor" => "d4d4d4",
    ];
    $raceDatCellStyle = [
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $favDatCellStyle = [
        "gridSpan"=> 2,
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $horseGridCellStyle = [
        "gridSpan"=> 2,
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $horseFootCellStyle = [
        "gridSpan"=> 2,
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
        "bgColor" => "FFFFFF"
    ];
    $horseFootInvCellStyle = [
        "gridSpan"=> 2,
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
        "bgColor" => "000000"
    ];
    $hgCellHdrStyle = [
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $hgCellStyle = [
        "borderBottomSize" => 6,
        "borderBottomColor" => "000000",
        "borderTopSize" => 0,
        "borderTopStyle" => Border::NONE,
        "borderLeftSize" => 0,
        "borderLeftStyle" => Border::NONE,
        "borderRightSize" => 0,
        "borderRightStyle" => Border::NONE,
    ];

    // Estilos de Tablas
    $defaultTableFullWidthStyle = "defaultTableFullWidthStyle";
    $phpWord->addTableStyle($defaultTableFullWidthStyle,[
            "width" => $width,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
        ], $defaultCellStyle, $defaultCellStyle);

    // Estilos de Textos
    // cintillo superior de premio en dolares
    $raceNumberText = "raceNumberText";
    $phpWord->addFontStyle($raceNumberText, [
        "name"=>"Univers 75 Black",
        "size"=>9,
        "italic"=>false,
        "bold"=>false,
        "color"=>"000000",
        //"bgColor"=>$fondo
    ]);
    $raceNumberPar = "raceNumberPar";
    $phpWord->addParagraphStyle($raceNumberPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "shading"=>["fill"=>"d4d4d4"],
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $raceCondText = "raceCondText";
    $phpWord->addFontStyle($raceCondText, [
        "name"=>"Univers 65",
        "size"=>6,
        "spacing"=>-10,
        "allCaps"=>true,
        "italic"=>false,
        "bold"=>false,
        "color"=>"000000",
        //"bgColor"=>$fondo
    ]);
    $raceCondPar = "raceCondPar";
    $phpWord->addParagraphStyle($raceCondPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        //"shading"=>["fill"=>$fondo],
        "spacing"=> -40,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $favDatText = "favDatText";
    $phpWord->addFontStyle($favDatText, [
        "name"=>"Univers 55",
        "size"=>7,
        "allCaps"=>false,
        "italic"=>false,
        "bold"=>false,
        "color"=>"000000",
        //"bgColor"=>$fondo
    ]);
    $favDatBoldText = "favDatBoldText";
    $phpWord->addFontStyle($favDatBoldText, [
        "name"=>"Univers 65",
        "size"=>7,
        "allCaps"=>true,
        "italic"=>false,
        "bold"=>false,
        "color"=>"000000",
        //"bgColor"=>$fondo
    ]);
    $favDatPar = "favDatPar";
    $phpWord->addParagraphStyle($favDatPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=> -40,
        "spaceBefore"=>50,
        "spaceAfter"=>50,
    ]);
    $hgHdrText = "hgHdrText";
    $phpWord->addFontStyle($hgHdrText, [
        "name"=>"Univers 55",
        "size"=>6,
        "scale"=>70,
        "spacing"=>-10,
    ]);
    $hgText = "hgText";
    $phpWord->addFontStyle($hgText, [
        "name"=>"Univers 55",
        "size"=>7,
        "scale"=>70,
        "spacing"=>-10,
    ]);
    $hgPar = "hgPar";
    $phpWord->addParagraphStyle($hgPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=> -50,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $hgRightPar = "hgRightPar";
    $phpWord->addParagraphStyle($hgRightPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT,
        "spacing"=> -50,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);

    $section = $phpWord->addSection([
        "marginTop"=>$top,
        "marginBottom"=>$bottom,
        "marginLeft"=>$left,
        "marginRight"=>$right,
        "pageSizeH"=>$height,
        "pageSizeW"=>$width,
    ]);

    $actualrace = "";
    while ($row = $rs->fetch_assoc()){

        // inicio carrera
        $maintable = $section->addTable([$defaultTableFullWidthStyle]);

            if ($row["racenumber"] != $actualrace){
                // impresion del pie
                if ($actualrace != ""){
                    $maintable->addRow();
                    $cell = $maintable->addCell($width, $horseFootInvCellStyle);
                    $cell->addText($blank, $raceCondText, $raceCondPar);
                    $maintable->addRow();
                    $cell = $maintable->addCell($width, $horseFootCellStyle);
                    $cell->addText($blank, $raceCondText, $raceCondPar);
                }
            

                $actualrace = $row["racenumber"];
                // Encabezado Carrera
                $maintable->addRow();
                    // Número de carrera
                    $cell = $maintable->addCell($numberwidth, $raceNumberCellStyle);
                    $cell->addText($row["raceord"],
                                    $raceNumberText,
                                    $raceNumberPar
                    );

                    // Datos Carrera
                    // ver si hay clásico
                    $classic = "";
                    if ($row["racetypeid"] != -1)
                        $classic = $row["racetypedsc"];
        
                    $cell = $maintable->addCell($width-$numberwidth, $raceDatCellStyle);
                    $cell->addText( $dow[$row["dow"]-1] . " " . $row["hora"] . " - " . $row["distancia"] . " - " .
                                    $row["pricecurr"] . ". " . number_format($row["mainprice"], 2, ",", ".") . " " .
                                    $row["condcode1"] . " / " . $row["condcode2"] . " / " . $row["condicion1"] . " / " . $classic
                                    ,   $raceCondText,
                                        $raceCondPar
                    );

                // Datos Favorito
                $maintable->addRow();
                    // buscar favoritos
                    $racersfc = array();
                    if (strlen($row["forecastracers"]))
                        $racersfc = json_decode($row["forecastracers"]);
                    $favoritos = array("","","");
                    $comentarios = array("","","");
                    foreach($racersfc as $pron){
                        if ($pron->forecast > 0 && $pron->forecast < 4) {
                            $sql = "SELECT H.dsc FROM racers R INNER JOIN horses H ON R.horseid=H.id WHERE R.id=" . $pron->id;
                            if (!$rs2 = $db->query($sql))
                                badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
                            if (!$row2 = $rs2->fetch_assoc())
                                badEnd("409", array("msg"=>"Caballo desde no encontrado"));
                            $favoritos[$pron->forecast-1] = $row2["dsc"];
                            $comentarios[$pron->forecast-1] = $pron->comment;
                        }
                    }
                    $cell = $maintable->addCell($width, $favDatCellStyle);
                    $cell->addText( $blank, $favDatText, $favDatPar);
                    $textRun = $cell->addTextRun($favDatPar);
                    $textRun->addText( $favoritos[0] . " ", $favDatBoldText, $favDatPar);
                    $textRun->addText( $comentarios[0] . ". ", $favDatText, $favDatPar);
                    $textRun->addText( $favoritos[1] . " ", $favDatBoldText, $favDatPar);
                    $textRun->addText( $comentarios[1] . ". ", $favDatText, $favDatPar);
                    $textRun->addText( $favoritos[2] . " ", $favDatBoldText, $favDatPar);
                    $textRun->addText( $comentarios[2] . ". ", $favDatText, $favDatPar);
                    $cell->addText( $blank, $favDatText, $favDatPar);

                // header de la tabla
                $maintable->addRow($width/2);
                    $cell = $maintable->addCell($width, $horseGridCellStyle);
                    $horsegrid = $cell->addTable([$defaultTableFullWidthStyle]);
                    $horsegrid->addRow();
                    $horsecell = $horsegrid->addCell($C1, $hgCellHdrStyle);
                    $horsecell->addText("Nº", $hgHdrText, $hgPar);
                    $horsecell = $horsegrid->addCell($C2, $hgCellHdrStyle);
                    $horsecell->addText("NOMBRE", $hgHdrText, $hgPar);
                    $horsecell = $horsegrid->addCell($C3, $hgCellHdrStyle);
                    $horsecell->addText("PESO", $hgHdrText, $hgPar);
                    $horsecell = $horsegrid->addCell($C4, $hgCellHdrStyle);
                    $horsecell->addText("MONTA", $hgHdrText, $hgPar);
                    $horsecell = $horsegrid->addCell($C5, $hgCellHdrStyle);
                    $horsecell->addText("ULT3", $hgHdrText, $hgPar);
                    $horsecell = $horsegrid->addCell($C6, $hgCellHdrStyle);
                    $horsecell->addText("ENTRENA", $hgHdrText, $hgPar);
                    $horsecell = $horsegrid->addCell($C7, $hgCellHdrStyle);
                    $horsecell->addText("PP", $hgHdrText, $hgPar);
                    $horsecell = $horsegrid->addCell($C8, $hgCellHdrStyle);
                    $horsecell->addText("DIV ANT", $hgHdrText, $hgPar);
                    $horsecell = $horsegrid->addCell($C9, $hgCellHdrStyle);
                    $horsecell->addText("TPO PROB", $hgHdrText, $hgRightPar);                    
            }

            // calcular ultimas 3 llegadas, ultimo dividendo, ultimo peso del jinete, ultimo tiempo en la distancia
            $sql =  "SELECT     R.arrivalposition ultpos, R.dividends, R.jockeyweight, RA.distanceid, R.finishtime " . 
                    "FROM       racers R " . 
                    "INNER JOIN races RA " .
                    "ON         R.raceid=RA.id " . 
                    "INNER JOIN reunions RE " . 
                    "ON         RA.reunionid=RE.id " . 
                    "WHERE      R.horseid=" . $row["horseid"] . " " . 
                    "AND        RE.date < '" . $reuniondate . "' " .
                    "AND        R.arrivalposition <> 0 " .
                    "ORDER BY   RE.date DESC ";
            if (!$rs2 = $db->query($sql))
                badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
            $ult3 = "";
            $cnt = 0;
            $dividend = "-";
            $jockeyweight = "-";
            $lastfinishtime = 0;
            while (($row2 = $rs2->fetch_assoc())){
                if ($dividend == "-") $dividend = number_format($row2["dividends"], 2, ",", ".");
                if ($jockeyweight == "-") $jockeyweight = $row2["jockeyweight"];
                if ($cnt < 3){
                    if (strlen($ult3)) $ult3 .="-";
                    $ult3 .= $row2["ultpos"];
                }
                if ($lastfinishtime == 0)
                    if ($row2["distanceid"] == $row["distid"])
                        $lastfinishtime = $row2["finishtime"]*1;
                $cnt++;
            }

            // renglones
            $horsegrid->addRow();
            $horsecell = $horsegrid->addCell($C1, $hgCellStyle);
            $horsecell->addText($row["horsenumber"], $hgText, $hgPar);
            $horsecell = $horsegrid->addCell($C2, $hgCellStyle);
            $horsecell->addText($row["horsename"], $hgText, $hgPar);
            $horsecell = $horsegrid->addCell($C3, $hgCellStyle);
            //$horsecell->addText($jockeyweight, $hgText, $hgPar);
            $horsecell->addText($row["jockeyweight"], $hgText, $hgPar);
            $horsecell = $horsegrid->addCell($C4, $hgCellStyle);
            $horsecell->addText($row["jockeyname"], $hgText, $hgPar);
            $horsecell = $horsegrid->addCell($C5, $hgCellStyle);
            $horsecell->addText($ult3, $hgText, $hgPar);
            $horsecell = $horsegrid->addCell($C6, $hgCellStyle);
            $horsecell->addText($row["trainername"], $hgText, $hgPar);
            $horsecell = $horsegrid->addCell($C7, $hgCellStyle);
            $horsecell->addText($row["horseposition"], $hgText, $hgPar);
            $horsecell = $horsegrid->addCell($C8, $hgCellStyle);
            $horsecell->addText($dividend, $hgText, $hgPar);
            $horsecell = $horsegrid->addCell($C9, $hgCellStyle);
            $horsecell->addText(number_format($lastfinishtime, 1, "."), $hgText, $hgRightPar);
            //$horsecell->addText(number_format($row["finishtime"]*1, 1, "."), $hgText, $hgRightPar);

    }    
    // ultimo pie
    if ($actualrace != ""){
        $maintable->addRow();
        $cell = $maintable->addCell($width, $horseFootInvCellStyle);
        $cell->addText($blank, $raceCondText, $raceCondPar);
        $maintable->addRow();
        $cell = $maintable->addCell($width, $horseFootCellStyle);
        $cell->addText($blank, $raceCondText, $raceCondPar);
}

    switch ($outputformat){
        case "pdf":
            $domPdfPath = realpath(__DIR__ . '/../../../hooks/Dompdf/Dompdf');
            \PhpOffice\PhpWord\Settings::setPdfRendererPath($domPdfPath);
            \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
            
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord , 'PDF');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        case "docx":
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        default:
            die ("FORMATO DE SALIDA INVALIDO");
    }

    header("Content-Disposition: attachment; filename=" . $filename);
    readfile($temp_file); // or echo file_get_contents($temp_file);
    unlink($temp_file);

    function getHorseForecasts($racerid, $json){
        $salida = json_decode(json_encode(["id"=>0, "number"=>0, "arrivalposition"=>0, "forecast"=>0, "comment"=>"--"]));

        foreach($json as $pron){
            if ($pron->id == $racerid){
                $salida = $pron;
            }
        }
        return($salida);
    }
    function clnprn($valor){
        return (trim(preg_replace("/[^a-zA-Z0-9 \"\'.,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", str_replace("&", "y", $valor))));
    }
?>