<?php
    require '../../../hooks/autoload.php';
    use \PhpOffice\PhpWord\PhpWord;

    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));
    // parametros obligatorios
    $parmsob = array("reunionid", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $reunionid = intval($_REQUEST["reunionid"]);

    $outputformat = "docx";
    if (isset($_REQUEST["format"]))
        $outputformat = preg_replace("/[^docxpf]+/", "", strtolower($_REQUEST["format"]));
    if ($outputformat != "docx" && $outputformat != "pdf" )
        badEnd("500", array("msg"=>"Los formatos validos son 'pdf' y 'docx"));

    isSessionValid($db, $sessionid);

    // conseguir fecha e hipodromo de la reunión
    $sql =  "SELECT 	R.date, LPAD(MIN(R.number), 3, '0') num, R.racecourseid, H.dsc, H.abbr rcabbr " .
            "FROM 		reunions R " .
            "INNER JOIN racecourses H " .
            "ON         R.racecourseid = H.id " .
            "WHERE      R.id = " . $reunionid . " ";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $date = $row["date"];
    $racecourseid = $row["racecourseid"];
    $racecourse = $row["dsc"];
    $rcabbr = $row["rcabbr"];

    //obtener primera carrera de la reunión para efectos del nombre
    $filename = "S" . $rcabbr . "TR" . $row["num"] . "." . $outputformat;

    $sql =  "SELECT     H.dsc horsename, D.dsc distance, T.time, T.finishtime, T.obs " . 
            "FROM       traqueos T " . 
            "INNER JOIN horses H " . 
            "ON         T.horseid=H.id " .
            "INNER JOIN distances D " . 
            "ON         T.distanceid=D.id " .  
            "WHERE      T.date BETWEEN DATE_ADD('" . $date . "', INTERVAL -7 DAY) AND '" . $date . "' " .
            "AND        T.racecourseid = " . $racecourseid . " " . 
            "ORDER BY   H.abbr";

    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    // Creating the new document...
    $phpWord = new PhpWord();

    $pulgada = 1440;
    $width = 4.8*$pulgada;
    $height = 7.28*$pulgada;  // 1440 twip = 1 pulgada
    $top = 0;
    $bottom = 0;
    $left = 50;
    $right = 50;
    $columnspaces = 100;

    $cyan = "00AEEF";
    $cyanlight = "C1EFFF";
    $bgGray = "CECECE";
    $blank = chr(194) . chr(160);

    // Título
    $section = $phpWord->addSection([
        "marginTop"=>$top,
        "marginBottom"=>$bottom,
        "marginLeft"=>$left,
        "marginRight"=>$right,
        "pageSizeH"=>$height,
        "pageSizeW"=>$width,
        "breakType"=>"continuous"
    ]);

    $section->addText("TRAQUEOS " . $racecourse,
                    [
                        "name"=>"Times New Roman",
                        "scale"=>90,
                        //"spacing"=>-5,
                        "size"=>16,
                        "allCaps"=>true,
                        "bold"=>false,
                        "italic"=>true,
                        "color"=>"000000"
                    ],
                    [
                        "spacing"=>1,
                        "spaceAfter"=>0,
                        'alignment' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER, 
                        //"shading"=>["fill"=>$cyan]
                    ]
    );

    // Traqueos
    $section = $phpWord->addSection([
        "marginTop"=>$top,
        "marginBottom"=>$bottom,
        "marginLeft"=>$left,
        "marginRight"=>$right,
        "pageSizeH"=>$height,
        "pageSizeW"=>$width,
        "breakType"=>"continuous",
        "colsNum"=>2,
        "colsSpace"=>$columnspaces,
        "gutter"=>0
    ]);
    $lastletter = "";
    while ($row = $rs->fetch_assoc()){
        if ($lastletter != substr($row["horsename"],0, 1)){
            $lastletter = substr($row["horsename"],0, 1);
            $section->addText('"' . $lastletter . '"', [
                "name"=>"Helvetica",
                "scale"=>90,
                "spacing"=>-4,
                "size"=>6,
                "bold"=>false,
                "color"=>"000000"
            ],
            [
                'alignment' => \PhpOffice\PhpWord\SimpleType\Jc::LEFT, 
                "spacing"=>1,
                "spaceBefore"=>0,
                "spaceAfter"=>0,
                "keepNext"=>true 
            ]
            );
        }
        $section->addText(mb_strtoupper($row["horsename"]) . "\t" . number_format($row["distance"], 0, ",", ".") . " en " . $row["time"] . " (" . $row["finishtime"] . "), " . $row["obs"], [
                "name"=>"Helvetica",
                "scale"=>90,
                "spacing"=>-10,
                "size"=>6,
                "allCaps"=>false,
                "bold"=>false,
                "color"=>"000000"
            ],
            [
                "spacing"=>1,
                "spaceAfter"=>0,
                "tabs" => [
                            new \PhpOffice\PhpWord\Style\Tab('left', ($width/2-($columnspaces/2))/3, 'dot')
                ]
            ]
        );
    }

    switch ($outputformat){
        case "pdf":
            $domPdfPath = realpath(__DIR__ . '/../../../hooks/Dompdf/Dompdf');
            \PhpOffice\PhpWord\Settings::setPdfRendererPath($domPdfPath);
            \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
            \PhpOffice\PhpWord\Settings::setPdfRendererOptions([
                'font' => 'Helvetica',
            ]);
            
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord , 'PDF');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        case "docx":
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        default:
            die ("FORMATO DE SALIDA INVALIDO");
    }

    header("Content-Disposition: attachment; filename=" . $filename);
    readfile($temp_file); // or echo file_get_contents($temp_file);
    unlink($temp_file);
?>